/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;

public class CliUserInteraction
extends ConsoleApplication
implements UserInteraction {
    private static final Logger LOG = Logger.getLogger(CliUserInteraction.class.getName());

    public CliUserInteraction() {
        super(System.in, (OutputStream)System.out, (OutputStream)System.err);
    }

    public CliUserInteraction(PrintStream out, PrintStream err, InputStream in) {
        super(in, (OutputStream)out, (OutputStream)err);
    }

    public Object confirm(Message summary, Message details, Message title, UserInteraction.MessageType type, Message[] options, Message def) {
        return this.confirm(summary, details, null, title, type, options, def, null);
    }

    public Object confirm(Message summary, Message details, Message fineDetails, Message title, UserInteraction.MessageType type, Message[] options, Message def, Message viewDetailsOption) {
        MenuBuilder builder = new MenuBuilder((ConsoleApplication)this);
        MessageBuilder b = new MessageBuilder();
        b.append(summary);
        b.append(Constants.LINE_SEPARATOR);
        b.append(details);
        builder.setPrompt(b.toMessage());
        int defInt = -1;
        for (int i = 0; i < options.length; ++i) {
            builder.addNumberedOption(options[i], MenuResult.success((Object)(i + 1)), new Message[0]);
            if (!options[i].equals(def)) continue;
            defInt = i + 1;
        }
        if (fineDetails != null) {
            Message detailsPrompt = viewDetailsOption;
            if (detailsPrompt == null) {
                detailsPrompt = AdminToolMessages.INFO_CLI_VIEW_DETAILS.get();
            }
            builder.addNumberedOption(detailsPrompt, MenuResult.success((Object)(options.length + 1)), new Message[0]);
        }
        builder.setDefault(Message.raw(String.valueOf(defInt), new Object[0]), MenuResult.success((Object)defInt));
        Menu menu = builder.toMenu();
        Message returnValue = null;
        boolean menuDisplayed = false;
        while (returnValue == null) {
            int respInt = -1;
            try {
                if (menuDisplayed) {
                    this.println();
                    builder.setPrompt(null);
                    menu = builder.toMenu();
                }
                MenuResult m = menu.run();
                menuDisplayed = true;
                if (!m.isSuccess()) {
                    throw new RuntimeException();
                }
                respInt = (Integer)m.getValue();
            }
            catch (CLIException ce) {
                respInt = defInt;
                LOG.log(Level.WARNING, "Error reading input: " + (Object)((Object)ce), ce);
            }
            if (fineDetails != null && respInt == options.length + 1) {
                this.println();
                this.println(String.valueOf(fineDetails));
                continue;
            }
            returnValue = options[respInt - 1];
        }
        return returnValue;
    }

    public String createUnorderedList(List list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            for (Object o : list) {
                sb.append("* ");
                sb.append(o.toString());
                sb.append(Constants.LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    public String promptForString(Message prompt, Message title, String defaultValue) {
        return this.readInput(prompt, defaultValue, LOG);
    }

    private void println(String text) {
        text = Utils.convertHtmlBreakToLineSeparator(text);
        text = Utils.stripHtml(text);
        text = StaticUtils.wrapText((String)text, (int)Utils.getCommandLineMaxLineWidth());
        this.getErrorStream().println(text);
    }

    public boolean isAdvancedMode() {
        return false;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean isMenuDrivenMode() {
        return true;
    }

    public boolean isQuiet() {
        return false;
    }

    public boolean isScriptFriendly() {
        return false;
    }

    public boolean isVerbose() {
        return true;
    }

    public boolean isCLI() {
        return true;
    }
}

