/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.extensions;



import org.opends.messages.MessageBuilder;
import org.opends.server.types.AccountStatusNotification;



/**
 * This class implements a notification message template element that will
 * generate a value using static text.
 */
public class TextNotificationMessageTemplateElement
       extends NotificationMessageTemplateElement
{
  // The static text associated with this element.
  private final String text;



  /**
   * Creates a new text notification message template element from the provided
   * string.
   *
   * @param  text  The string to use as the text for this element.
   */
  public TextNotificationMessageTemplateElement(String text)
  {
    this.text = text;
  }



  /**
   * {@inheritDoc}
   */
  public void generateValue(MessageBuilder buffer,
                            AccountStatusNotification notification)
  {
    buffer.append(text);
  }
}

