/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.cli.CLIException;

public class QuickSetupCli {
    protected Launcher launcher;
    private CliApplication cliApp;
    private UserData userData;
    private static final Logger LOG = Logger.getLogger(QuickSetupCli.class.getName());

    public QuickSetupCli(CliApplication cliApp, Launcher launcher) {
        this.cliApp = cliApp;
        this.launcher = launcher;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public ReturnCode run() {
        ReturnCode returnValue;
        try {
            PlainTextProgressMessageFormatter formatter = new PlainTextProgressMessageFormatter();
            this.cliApp.setProgressMessageFormatter(formatter);
            this.userData = this.cliApp.createUserData(this.launcher);
            if (this.userData != null) {
                this.cliApp.setUserData(this.userData);
                if (!this.userData.isQuiet()) {
                    this.cliApp.addProgressUpdateListener(new ProgressUpdateListener(){

                        public void progressUpdate(ProgressUpdateEvent ev) {
                            Message newLogs = ev.getNewLogs();
                            if (newLogs != null) {
                                System.out.print(StaticUtils.wrapText((Message)newLogs, (int)Utils.getCommandLineMaxLineWidth()));
                            }
                        }
                    });
                }
                Thread appThread = new Thread((Runnable)this.cliApp, "CLI Application");
                LOG.log(Level.INFO, "Launching application");
                appThread.start();
                while (!Thread.State.TERMINATED.equals((Object)appThread.getState())) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                }
                returnValue = this.cliApp.getReturnCode();
                LOG.log(Level.INFO, "Application returnValue: " + returnValue);
                if (returnValue == null) {
                    ApplicationException ue = this.cliApp.getRunError();
                    if (ue != null) {
                        LOG.log(Level.INFO, "Application run error: " + ue, ue);
                        returnValue = ue.getType();
                    } else {
                        returnValue = ReturnCode.SUCCESSFUL;
                    }
                }
            } else {
                returnValue = ReturnCode.CANCELLED;
            }
        }
        catch (UserDataException uude) {
            LOG.log(Level.SEVERE, "UserDataException: " + uude, uude);
            System.err.println();
            System.err.println(StaticUtils.wrapText((String)uude.getLocalizedMessage(), (int)Utils.getCommandLineMaxLineWidth()));
            System.err.println();
            returnValue = uude.getCause() instanceof CLIException ? ReturnCode.USER_INPUT_ERROR : ReturnCode.USER_DATA_ERROR;
        }
        catch (ApplicationException ae) {
            LOG.log(Level.SEVERE, "ApplicationException: " + ae, ae);
            System.err.println();
            System.err.println(ae.getLocalizedMessage());
            System.err.println();
            returnValue = ae.getType();
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Unexpected error: " + t, t);
            returnValue = ReturnCode.UNKNOWN;
        }
        LOG.log(Level.INFO, "returnValue: " + returnValue.getReturnCode());
        return returnValue;
    }
}

