/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ui.CustomHTMLEditorKit;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.WebProxyDialog;
import org.opends.quicksetup.upgrader.RemoteBuildManager;

class BuildListDownloadErrorPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(BuildListDownloadErrorPanel.class.getName());
    private RemoteBuildManager rbm = null;
    private Throwable reason = null;
    private static final long serialVersionUID = 4614415561629811272L;

    public BuildListDownloadErrorPanel(RemoteBuildManager rbm, Throwable reason) {
        this.rbm = rbm;
        this.reason = reason;
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.setLayout(new GridBagLayout());
        String proxyString = QuickSetupMessages.INFO_GENERAL_NONE.get().toString();
        Proxy proxy = this.rbm.getProxy();
        if (proxy != null) {
            SocketAddress addr = proxy.address();
            proxyString = addr.toString();
        }
        String baseContext = QuickSetupMessages.INFO_GENERAL_UNSPECIFIED.get().toString();
        URL url = this.rbm.getBaseContext();
        if (url != null) {
            baseContext = url.toString();
        }
        Message html = QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_BUILD_LIST_ERROR.get(baseContext, this.reason.getLocalizedMessage(), proxyString, baseContext);
        CustomHTMLEditorKit ek = new CustomHTMLEditorKit();
        ek.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Container dlg = SwingUtilities.getAncestorOfClass(Window.class, BuildListDownloadErrorPanel.this);
                BuildListDownloadErrorPanel.this.specifyProxy(dlg);
                BuildListDownloadErrorPanel.this.removeAll();
                BuildListDownloadErrorPanel.this.layoutPanel();
                BuildListDownloadErrorPanel.this.repaint();
                BuildListDownloadErrorPanel.this.validate();
            }
        });
        this.add(UIFactory.makeHtmlPane(html, ek, UIFactory.INSTRUCTIONS_FONT));
    }

    void specifyProxy(final Component parent) {
        Runnable proxySpecifier = new Runnable(){

            public void run() {
                SocketAddress address;
                String host = null;
                Integer port = null;
                Proxy proxy = BuildListDownloadErrorPanel.this.rbm.getProxy();
                if (proxy != null && (address = proxy.address()) instanceof InetSocketAddress) {
                    host = ((InetSocketAddress)address).getHostName();
                    port = ((InetSocketAddress)address).getPort();
                }
                String user = BuildListDownloadErrorPanel.this.rbm.getProxyUserName();
                char[] pw = BuildListDownloadErrorPanel.this.rbm.getProxyPassword();
                WebProxyDialog dlg = parent instanceof Dialog ? new WebProxyDialog((Dialog)parent, host, port, user, pw) : (parent instanceof Frame ? new WebProxyDialog((Frame)parent, host, port, user, pw) : new WebProxyDialog((Frame)null, host, port, user, pw));
                dlg.setVisible(true);
                SocketAddress address2 = dlg.getSocketAddress();
                if (address2 != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, address2);
                    BuildListDownloadErrorPanel.this.rbm.setProxy(proxy);
                    BuildListDownloadErrorPanel.this.rbm.setProxyUserName(dlg.getUserName());
                    BuildListDownloadErrorPanel.this.rbm.setProxyPassword(dlg.getPassword());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            proxySpecifier.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(proxySpecifier);
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "error waiting for event thread", t);
            }
        }
    }
}

