/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.opends.guitools.controlpanel.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomSearchResult
implements Comparable<CustomSearchResult> {
    private Name name;
    private String dn;
    private Map<String, Set<Object>> attributes;
    private SortedSet<String> attrNames;
    private String toString;
    private int hashCode;

    public CustomSearchResult(String dn) {
        this.dn = dn;
        this.attributes = new HashMap<String, Set<Object>>();
        this.attrNames = new TreeSet<String>();
        this.toString = this.calculateToString();
        this.hashCode = this.calculateHashCode();
    }

    public CustomSearchResult(SearchResult sr, String baseDN) throws NamingException {
        String sName = sr.getName();
        if (baseDN != null && baseDN.length() > 0) {
            if (sName != null && sName.length() > 0) {
                this.name = new CompositeName(sName);
                this.name.add(baseDN);
            } else {
                this.name = Utilities.getJNDIName(baseDN);
            }
        } else {
            this.name = new CompositeName(sName);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.name.size(); ++i) {
            String n = this.name.get(i);
            if (buf.length() != 0 && n != null && n.length() > 0) {
                buf.append(",");
            }
            if (n == null || n.length() <= 0) continue;
            buf.append(n);
        }
        this.dn = buf.toString();
        this.attributes = new HashMap<String, Set<Object>>();
        this.attrNames = new TreeSet<String>();
        Attributes attrs = sr.getAttributes();
        if (attrs != null) {
            NamingEnumeration<? extends Attribute> en = attrs.getAll();
            while (en.hasMore()) {
                Attribute attr = en.next();
                String name = attr.getID();
                this.attrNames.add(name);
                HashSet<Object> values = new HashSet<Object>();
                for (int i = 0; i < attr.size(); ++i) {
                    Object v = attr.get(i);
                    if ("".equals(v.toString())) continue;
                    values.add(v);
                }
                this.attributes.put(name.toLowerCase(), values);
            }
        }
        this.toString = this.calculateToString();
        this.hashCode = this.calculateHashCode();
    }

    public String getDN() {
        return this.dn;
    }

    public Set<Object> getAttributeValues(String name) {
        Set<Object> values = this.attributes.get(name.toLowerCase());
        if (values == null) {
            values = Collections.emptySet();
        }
        return values;
    }

    public SortedSet<String> getAttributeNames() {
        return this.attrNames;
    }

    @Override
    public int compareTo(CustomSearchResult o) {
        int compareTo = this.equals(o) ? 0 : this.toString().compareTo(o.toString());
        return compareTo;
    }

    public boolean equals(Object o) {
        boolean equals;
        block3: {
            equals = false;
            if (o == null) break block3;
            boolean bl = equals = o == this;
            if (!equals && o instanceof CustomSearchResult) {
                CustomSearchResult sr = (CustomSearchResult)o;
                equals = this.getDN().equals(sr.getDN());
                if (equals && (equals = this.getAttributeNames().equals(sr.getAttributeNames()))) {
                    String attrName;
                    Iterator i$ = this.getAttributeNames().iterator();
                    while (i$.hasNext() && (equals = ((Object)this.getAttributeValues(attrName = (String)i$.next())).equals(sr.getAttributeValues(attrName)))) {
                    }
                }
            }
        }
        return equals;
    }

    public String toString() {
        return this.toString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void set(String attrName, Set<Object> values) {
        this.attrNames.add(attrName);
        attrName = attrName.toLowerCase();
        this.attributes.put(attrName, values);
        this.toString = this.calculateToString();
        this.hashCode = this.calculateHashCode();
    }

    private String calculateToString() {
        return "dn: " + this.dn + "\nattributes: " + this.attributes;
    }

    private int calculateHashCode() {
        return 23 + this.toString.hashCode();
    }
}

