/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.components.LabelWithHelpIcon;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.Message;

public class CustomCellRenderer
extends LabelWithHelpIcon
implements TableCellRenderer {
    private static final long serialVersionUID = -8604332267021523835L;
    protected static final Border column0Border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, ColorAndFontConstants.gridColor), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    public static final Border defaultBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private static Border defaultFocusBorder;

    public CustomCellRenderer() {
        super(Message.EMPTY, null);
        this.setHelpIconVisible(false);
        this.setFont(ColorAndFontConstants.tableFont);
        this.setOpaque(true);
        this.setBackground(ColorAndFontConstants.treeBackground);
        this.setForeground(ColorAndFontConstants.treeForeground);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof String) {
            String s = (String)value;
            if (s.indexOf("<html>") == 0) {
                value = "<html>" + Utilities.applyFont(s.substring(6), ColorAndFontConstants.tableFont);
            }
            this.setText((String)value);
        } else {
            this.setText(String.valueOf(value));
        }
        if (hasFocus) {
            this.setBorder(CustomCellRenderer.getDefaultFocusBorder(table, value, isSelected, row, column));
        } else if (column == 0) {
            this.setBorder(column0Border);
        } else {
            this.setBorder(defaultBorder);
        }
        return this;
    }

    public String getToolTipText(MouseEvent ev) {
        Rectangle r = new Rectangle();
        r.x = this.label.getPreferredSize().width + 3;
        r.y = 0;
        r.width = this.iconLabel.getPreferredSize().width;
        r.height = this.iconLabel.getPreferredSize().height;
        if (r.contains(ev.getPoint())) {
            return this.getHelpTooltip();
        }
        return null;
    }

    public static Border getDefaultFocusBorder(JTable table, Object value, boolean isSelected, int row, int column) {
        if (defaultFocusBorder == null) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            JComponent comp = (JComponent)renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
            Border border = comp.getBorder();
            defaultFocusBorder = border != null ? border : defaultBorder;
        }
        return defaultFocusBorder;
    }
}

