/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opends.messages.BackendMessages;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.Severity;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.PagedResultsControl;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullBackend
extends Backend {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN[] baseDNs;
    private HashSet<DN> baseDNSet;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private Map<ObjectClass, String> objectClasses;

    public void setBaseDNs(DN[] baseDNs) {
        this.baseDNs = baseDNs;
    }

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        if (config != null) {
            Validator.ensureTrue(config instanceof BackendCfg);
            BackendCfg cfg = (BackendCfg)config;
            DN[] cfgBaseDNs = new DN[cfg.getBaseDN().size()];
            cfg.getBaseDN().toArray(cfgBaseDNs);
            this.setBaseDNs(cfgBaseDNs);
        }
    }

    @Override
    public synchronized void initializeBackend() throws ConfigException, InitializationException {
        this.baseDNSet = new HashSet();
        for (DN dn : this.baseDNs) {
            this.baseDNSet.add(dn);
        }
        this.supportedControls = new HashSet();
        this.supportedControls.add("1.2.840.113556.1.4.805");
        this.supportedControls.add("1.2.840.113556.1.4.319");
        this.supportedControls.add("2.16.840.1.113730.3.4.2");
        this.supportedControls.add("1.2.840.113556.1.4.473");
        this.supportedControls.add("2.16.840.1.113730.3.4.9");
        this.supportedFeatures = new HashSet();
        for (DN dn : this.baseDNs) {
            try {
                DirectoryServer.registerBaseDN(dn, this, false);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(dn.toString(), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        this.objectClasses = new HashMap<ObjectClass, String>();
        String topOCName = "top";
        ObjectClass topOC = DirectoryServer.getObjectClass(topOCName);
        if (topOC == null) {
            throw new InitializationException(Message.raw(Category.BACKEND, Severity.FATAL_ERROR, "Unable to locate " + topOCName + " objectclass in the current server schema", new Object[0]));
        }
        this.objectClasses.put(topOC, topOCName);
        String nulOCName = "nullbackendobject";
        ObjectClass nulOC = DirectoryServer.getDefaultObjectClass(nulOCName);
        try {
            DirectoryServer.registerObjectClass(nulOC, false);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw new InitializationException(de.getMessageObject());
        }
        this.objectClasses.put(nulOC, nulOCName);
        String extOCName = "extensibleobject";
        ObjectClass extOC = DirectoryServer.getObjectClass(extOCName);
        if (extOC == null) {
            throw new InitializationException(Message.raw(Category.BACKEND, Severity.FATAL_ERROR, "Unable to locate " + extOCName + " objectclass in the current server schema", new Object[0]));
        }
        this.objectClasses.put(extOC, extOCName);
    }

    @Override
    public synchronized void finalizeBackend() {
        for (DN dn : this.baseDNs) {
            try {
                DirectoryServer.deregisterBaseDN(dn);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        return -1L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        return true;
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        return -1L;
    }

    @Override
    public Entry getEntry(DN entryDN) {
        return new Entry(null, this.objectClasses, null, null);
    }

    @Override
    public boolean entryExists(DN entryDN) {
        return false;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
    }

    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DirectoryException {
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        PagedResultsControl pageRequest = searchOperation.getRequestControl(PagedResultsControl.DECODER);
        if (pageRequest != null) {
            PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
            searchOperation.getResponseControls().add(control);
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        block5: {
            LDIFWriter ldifWriter;
            try {
                ldifWriter = new LDIFWriter(exportConfig);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = Message.raw(Category.BACKEND, Severity.SEVERE_ERROR, e.getMessage(), new Object[0]);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            try {
                ldifWriter.close();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block5;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        try {
            reader = new LDIFReader(importConfig);
        }
        catch (Exception e) {
            message = Message.raw(Category.BACKEND, Severity.SEVERE_ERROR, e.getMessage(), new Object[0]);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                e = null;
                try {
                    e = reader.readEntry();
                    if (e == null) {
                        ** break;
                    }
                }
                catch (LDIFException le) {
                    if (le.canContinueReading()) continue;
                    message = Message.raw(Category.BACKEND, Severity.SEVERE_ERROR, le.getMessage(), new Object[0]);
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                }
                try {
                    this.addEntry((Entry)e, null);
                }
                catch (DirectoryException de) {
                    reader.rejectLastEntry(de.getMessageObject());
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
lbl26:
            // 1 sources

            e = new LDIFImportResult(reader.getEntriesRead(), reader.getEntriesRejected(), reader.getEntriesIgnored());
            return e;
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            message = Message.raw(Category.BACKEND, Severity.SEVERE_ERROR, e.getMessage(), new Object[0]);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        Message message = Message.raw(Category.BACKEND, Severity.SEVERE_ERROR, "The null backend does not support backup operation", new Object[0]);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        Message message = Message.raw(Category.BACKEND, Severity.SEVERE_ERROR, "The null backend does not support remove backup operation", new Object[0]);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        Message message = Message.raw(Category.BACKEND, Severity.SEVERE_ERROR, "The null backend does not support restore operation", new Object[0]);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported.");
    }
}

