/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexRebuildThread;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

public class RebuildJob {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private RebuildConfig rebuildConfig;
    private RootContainer rootContainer;
    private long progressInterval = 10000L;
    private CopyOnWriteArrayList<IndexRebuildThread> waitingThreads = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<IndexRebuildThread> activeThreads = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<IndexRebuildThread> completedThreads = new CopyOnWriteArrayList();
    private static CopyOnWriteArrayList<RebuildJob> rebuildJobs = new CopyOnWriteArrayList();
    private static ReentrantLock jobsMutex = new ReentrantLock();

    public RebuildJob(RebuildConfig rebuildConfig) {
        this.rebuildConfig = rebuildConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addJob(RebuildJob job) throws DatabaseException, JebException {
        jobsMutex.lock();
        try {
            for (RebuildJob otherJob : rebuildJobs) {
                String conflictIndex = job.rebuildConfig.checkConflicts(otherJob.rebuildConfig);
                if (conflictIndex == null) continue;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("Conflit detected. This job config: %s, That job config: %s.", job.rebuildConfig, otherJob.rebuildConfig);
                }
                Message msg = JebMessages.ERR_JEB_REBUILD_INDEX_CONFLICT.get(conflictIndex);
                throw new JebException(msg);
            }
            rebuildJobs.add(job);
        }
        finally {
            jobsMutex.unlock();
        }
    }

    private static void removeJob(RebuildJob job) {
        jobsMutex.lock();
        rebuildJobs.remove(job);
        jobsMutex.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildBackend(RootContainer rootContainer) throws DirectoryException, DatabaseException, JebException {
        block49: {
            RebuildJob.addJob(this);
            try {
                this.rootContainer = rootContainer;
                EntryContainer entryContainer = rootContainer.getEntryContainer(this.rebuildConfig.getBaseDN());
                ArrayList<String> rebuildList = this.rebuildConfig.getRebuildList();
                if (rebuildList.isEmpty()) break block49;
                for (String index : rebuildList) {
                    Message msg;
                    IndexRebuildThread rebuildThread;
                    String lowerName = index.toLowerCase();
                    if (lowerName.equals("dn2id")) {
                        rebuildThread = new IndexRebuildThread(entryContainer, IndexRebuildThread.IndexType.DN2ID);
                    } else if (lowerName.equals("dn2uri")) {
                        rebuildThread = new IndexRebuildThread(entryContainer, IndexRebuildThread.IndexType.DN2URI);
                    } else if (lowerName.equals("id2children")) {
                        rebuildThread = new IndexRebuildThread(entryContainer, IndexRebuildThread.IndexType.ID2CHILDREN);
                    } else if (lowerName.equals("id2subtree")) {
                        rebuildThread = new IndexRebuildThread(entryContainer, IndexRebuildThread.IndexType.ID2SUBTREE);
                    } else if (lowerName.startsWith("vlv.")) {
                        if (lowerName.length() < 5) {
                            Message msg2 = JebMessages.ERR_JEB_VLV_INDEX_NOT_CONFIGURED.get(lowerName);
                            throw new JebException(msg2);
                        }
                        VLVIndex vlvIndex = entryContainer.getVLVIndex(lowerName.substring(4));
                        if (vlvIndex == null) {
                            msg = JebMessages.ERR_JEB_VLV_INDEX_NOT_CONFIGURED.get(lowerName.substring(4));
                            throw new JebException(msg);
                        }
                        rebuildThread = new IndexRebuildThread(entryContainer, vlvIndex);
                    } else {
                        String[] attrIndexParts = lowerName.split("\\.");
                        if (attrIndexParts.length <= 0) {
                            msg = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                            throw new JebException(msg);
                        }
                        AttributeType attrType = DirectoryServer.getAttributeType(attrIndexParts[0]);
                        if (attrType == null) {
                            Message msg3 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                            throw new JebException(msg3);
                        }
                        AttributeIndex attrIndex = entryContainer.getAttributeIndex(attrType);
                        if (attrIndex == null) {
                            Message msg4 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                            throw new JebException(msg4);
                        }
                        if (attrIndexParts.length > 1) {
                            Index partialAttrIndex = null;
                            if (attrIndexParts[1].equals("presence")) {
                                partialAttrIndex = attrIndex.presenceIndex;
                            } else if (attrIndexParts[1].equals("equality")) {
                                partialAttrIndex = attrIndex.equalityIndex;
                            } else if (attrIndexParts[1].equals("substring")) {
                                partialAttrIndex = attrIndex.substringIndex;
                            } else if (attrIndexParts[1].equals("ordering")) {
                                partialAttrIndex = attrIndex.orderingIndex;
                            } else if (attrIndexParts[1].equals("approximate")) {
                                partialAttrIndex = attrIndex.approximateIndex;
                            }
                            if (partialAttrIndex == null) {
                                Message msg5 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                                throw new JebException(msg5);
                            }
                            rebuildThread = new IndexRebuildThread(entryContainer, partialAttrIndex);
                        } else {
                            rebuildThread = new IndexRebuildThread(entryContainer, attrIndex);
                        }
                    }
                    this.waitingThreads.add(rebuildThread);
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("Created rebuild thread %s", rebuildThread.getName());
                }
                long totalToProcess = 0L;
                for (IndexRebuildThread thread : this.waitingThreads) {
                    totalToProcess += thread.getTotalEntries();
                }
                StringBuilder sb = new StringBuilder();
                for (String index : rebuildList) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(index);
                }
                Message message = JebMessages.NOTE_JEB_REBUILD_START.get(sb.toString(), totalToProcess);
                ErrorLogger.logError(message);
                long startTime = System.currentTimeMillis();
                Timer timer = new Timer();
                ProgressTask progressTask = new ProgressTask();
                timer.scheduleAtFixedRate((TimerTask)progressTask, this.progressInterval, this.progressInterval);
                entryContainer.exclusiveLock.lock();
                try {
                    for (IndexRebuildThread thread : this.waitingThreads) {
                        thread.clearDatabase();
                    }
                }
                finally {
                    if (!this.rebuildConfig.includesSystemIndex()) {
                        entryContainer.exclusiveLock.unlock();
                    }
                }
                if (!this.rebuildConfig.includesSystemIndex()) {
                    entryContainer.sharedLock.lock();
                }
                try {
                    while (!this.waitingThreads.isEmpty()) {
                        this.dispatchThreads();
                        this.joinThreads();
                    }
                }
                finally {
                    timer.cancel();
                    if (this.rebuildConfig.includesSystemIndex()) {
                        entryContainer.exclusiveLock.unlock();
                    } else {
                        entryContainer.sharedLock.unlock();
                    }
                }
                long totalProcessed = 0L;
                long totalRebuilt = 0L;
                long totalDuplicated = 0L;
                long totalSkipped = 0L;
                for (IndexRebuildThread thread : this.completedThreads) {
                    totalProcessed += thread.getProcessedEntries();
                    totalRebuilt += thread.getRebuiltEntries();
                    totalDuplicated += thread.getDuplicatedEntries();
                    totalSkipped += thread.getSkippedEntries();
                }
                long finishTime = System.currentTimeMillis();
                long totalTime = finishTime - startTime;
                float rate = 0.0f;
                if (totalTime > 0L) {
                    rate = 1000.0f * (float)totalProcessed / (float)totalTime;
                }
                message = JebMessages.NOTE_JEB_REBUILD_FINAL_STATUS.get(totalProcessed, totalTime / 1000L, Float.valueOf(rate));
                ErrorLogger.logError(message);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Detailed overall rebuild job stats: rebuilt %d, duplicated %d, skipped %d", totalRebuilt, totalDuplicated, totalSkipped);
                }
            }
            finally {
                RebuildJob.removeJob(this);
            }
        }
    }

    private void dispatchThreads() throws DatabaseException {
        for (IndexRebuildThread t : this.waitingThreads) {
            boolean start = true;
            if (this.rebuildConfig.getMaxRebuildThreads() > 0 && this.activeThreads.size() > this.rebuildConfig.getMaxRebuildThreads()) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Delaying the start of thread %s because the max number of rebuild threads has been reached.");
                }
                start = false;
            }
            if (t.getIndexType() == IndexRebuildThread.IndexType.ID2CHILDREN || t.getIndexType() == IndexRebuildThread.IndexType.ID2SUBTREE) {
                for (IndexRebuildThread t2 : this.waitingThreads) {
                    if (t2.getIndexType() != IndexRebuildThread.IndexType.DN2ID && t2.getIndexType() != IndexRebuildThread.IndexType.DN2URI) continue;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Delaying the start of thread %s because it depends on another index rebuilt to go first.", t.getName());
                    }
                    start = false;
                    break;
                }
                for (IndexRebuildThread t3 : this.activeThreads) {
                    if (t3.getIndexType() != IndexRebuildThread.IndexType.DN2ID && t3.getIndexType() != IndexRebuildThread.IndexType.DN2URI) continue;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Delaying the start of thread %s because it depends on another index being rebuilt to finish.", t.getName());
                    }
                    start = false;
                    break;
                }
            }
            if (!start) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Starting rebuild thread %s.", t.getName());
            }
            this.waitingThreads.remove(t);
            this.activeThreads.add(t);
            t.start();
        }
    }

    private void joinThreads() {
        for (IndexRebuildThread t : this.activeThreads) {
            try {
                t.join();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Rebuild thread %s finished.", t.getName());
                }
                this.activeThreads.remove(t);
                this.completedThreads.add(t);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class ProgressTask
    extends TimerTask {
        private long previousProcessed = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;
        private static final int bytesPerMegabyte = 0x100000;

        public ProgressTask() throws DatabaseException {
            this.prevEnvStats = RebuildJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
        }

        public void run() {
            long latestProcessed;
            long latestTime;
            block8: {
                latestTime = System.currentTimeMillis();
                long deltaTime = latestTime - this.previousTime;
                if (deltaTime == 0L) {
                    return;
                }
                long totalEntries = 0L;
                latestProcessed = 0L;
                ArrayList allThreads = new ArrayList(RebuildJob.this.waitingThreads);
                allThreads.addAll(RebuildJob.this.activeThreads);
                allThreads.addAll(RebuildJob.this.completedThreads);
                for (IndexRebuildThread thread : allThreads) {
                    try {
                        totalEntries += thread.getTotalEntries();
                        latestProcessed += thread.getProcessedEntries();
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugVerbose("Rebuild thread %s stats: total %d processed %d rebuilt %d duplicated %d skipped %d", thread.getTotalEntries(), thread.getProcessedEntries(), thread.getRebuiltEntries(), thread.getDuplicatedEntries(), thread.getSkippedEntries());
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                long deltaCount = latestProcessed - this.previousProcessed;
                float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
                float completed = 0.0f;
                if (totalEntries > 0L) {
                    completed = 100.0f * (float)latestProcessed / (float)totalEntries;
                }
                Message message = JebMessages.NOTE_JEB_REBUILD_PROGRESS_REPORT.get(Float.valueOf(completed), latestProcessed, totalEntries, Float.valueOf(rate));
                ErrorLogger.logError(message);
                try {
                    Runtime runtime = Runtime.getRuntime();
                    long freeMemory = runtime.freeMemory() / 0x100000L;
                    EnvironmentStats envStats = RebuildJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
                    long nCacheMiss = envStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                    float cacheMissRate = 0.0f;
                    if (deltaCount > 0L) {
                        cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                    }
                    message = JebMessages.NOTE_JEB_REBUILD_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                    ErrorLogger.logError(message);
                    this.prevEnvStats = envStats;
                }
                catch (DatabaseException e) {
                    if (!DebugLogger.debugEnabled()) break block8;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            this.previousProcessed = latestProcessed;
            this.previousTime = latestTime;
        }
    }
}

