/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.ConfigMessages;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.DbPreloadComparator;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JECompressedSchema;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.DatabaseEnvironmentMonitor;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.FilePermission;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootContainer
implements ConfigurationChangeListener<LocalDBBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Environment env = null;
    private CheckpointConfig importForceCheckPoint = new CheckpointConfig();
    private LocalDBBackendCfg config;
    private Backend backend;
    private DatabaseEnvironmentMonitor monitor = null;
    private ConcurrentHashMap<DN, EntryContainer> entryContainers;
    private AtomicLong nextid = new AtomicLong(1L);
    private JECompressedSchema compressedSchema;

    public RootContainer(Backend backend, LocalDBBackendCfg config) {
        this.entryContainers = new ConcurrentHashMap();
        this.backend = backend;
        this.config = config;
        this.compressedSchema = null;
        config.addLocalDBChangeListener(this);
        this.importForceCheckPoint.setForce(true);
    }

    public void open(EnvironmentConfig envConfig) throws DatabaseException, ConfigException {
        FilePermission backendPermission;
        File parentDirectory = StaticUtils.getFileForPath(this.config.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.config.getBackendId());
        if (!backendDirectory.exists()) {
            if (!backendDirectory.mkdirs()) {
                Message message = JebMessages.ERR_JEB_CREATE_FAIL.get(backendDirectory.getPath());
                throw new ConfigException(message);
            }
        } else if (!backendDirectory.isDirectory()) {
            Message message = JebMessages.ERR_JEB_DIRECTORY_INVALID.get(backendDirectory.getPath());
            throw new ConfigException(message);
        }
        try {
            backendPermission = FilePermission.decodeUNIXMode(this.config.getDBDirectoryPermissions());
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_BACKEND_MODE_INVALID.get(this.config.dn().toString());
            throw new ConfigException(message);
        }
        if (!(backendPermission.isOwnerWritable() && backendPermission.isOwnerReadable() && backendPermission.isOwnerExecutable())) {
            Message message = ConfigMessages.ERR_CONFIG_BACKEND_INSANE_MODE.get(this.config.getDBDirectoryPermissions());
            throw new ConfigException(message);
        }
        if (FilePermission.canSetPermissions()) {
            try {
                if (!FilePermission.setPermissions(backendDirectory, backendPermission)) {
                    Message message = JebMessages.WARN_JEB_UNABLE_SET_PERMISSIONS.get(backendPermission.toString(), backendDirectory.toString());
                    ErrorLogger.logError(message);
                }
            }
            catch (Exception e) {
                Message message = JebMessages.WARN_JEB_SET_PERMISSIONS_FAILED.get(backendDirectory.toString(), e.toString());
                ErrorLogger.logError(message);
            }
        }
        this.env = new Environment(backendDirectory, envConfig);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("JE (%s) environment opened with the following config: %n%s", JEVersion.CURRENT_VERSION.toString(), this.env.getConfig().toString());
            long heapSize = Runtime.getRuntime().totalMemory();
            long heapMaxSize = Runtime.getRuntime().maxMemory();
            long heapFreeSize = Runtime.getRuntime().freeMemory();
            TRACER.debugInfo("Current size of heap: %d bytes", heapSize);
            TRACER.debugInfo("Max size of heap: %d bytes", heapMaxSize);
            TRACER.debugInfo("Free memory in heap: %d bytes", heapFreeSize);
        }
        this.compressedSchema = new JECompressedSchema(this.env);
        this.openAndRegisterEntryContainers(this.config.getBaseDN());
    }

    public EntryContainer openEntryContainer(DN baseDN, String name) throws DatabaseException, ConfigException {
        String databasePrefix = name == null || name.equals("") ? baseDN.toNormalizedString() : name;
        EntryContainer ec = new EntryContainer(baseDN, databasePrefix, this.backend, this.config, this.env, this);
        ec.open();
        return ec;
    }

    public void registerEntryContainer(DN baseDN, EntryContainer entryContainer) throws DatabaseException {
        EntryContainer ec1 = this.entryContainers.get(baseDN);
        if (ec1 != null) {
            throw new DatabaseException("An entry container named " + ec1.getDatabasePrefix() + " is alreadly registered for base DN " + baseDN.toString());
        }
        this.entryContainers.put(baseDN, entryContainer);
    }

    private void openAndRegisterEntryContainers(Set<DN> baseDNs) throws DatabaseException, ConfigException {
        EntryID highestID = null;
        for (DN baseDN : baseDNs) {
            EntryContainer ec = this.openEntryContainer(baseDN, null);
            EntryID id = ec.getHighestEntryID();
            this.registerEntryContainer(baseDN, ec);
            if (highestID != null && id.compareTo(highestID) <= 0) continue;
            highestID = id;
        }
        this.nextid = new AtomicLong(highestID.longValue() + 1L);
    }

    public EntryContainer unregisterEntryContainer(DN baseDN) {
        return this.entryContainers.remove(baseDN);
    }

    public JECompressedSchema getCompressedSchema() {
        return this.compressedSchema;
    }

    public DatabaseEnvironmentMonitor getMonitorProvider() {
        if (this.monitor == null) {
            String monitorName = this.backend.getBackendID() + " Database Environment";
            this.monitor = new DatabaseEnvironmentMonitor(monitorName, this);
        }
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload(long timeLimit) {
        if (timeLimit > 0L) {
            Message message;
            ArrayList<DatabaseContainer> dbList = new ArrayList<DatabaseContainer>();
            for (EntryContainer ec : this.entryContainers.values()) {
                ec.sharedLock.lock();
                try {
                    ec.listDatabases(dbList);
                }
                finally {
                    ec.sharedLock.unlock();
                }
            }
            Collections.sort(dbList, new DbPreloadComparator());
            try {
                PreloadConfig preloadConfig = new PreloadConfig();
                preloadConfig.setLoadLNs(true);
                message = JebMessages.NOTE_JEB_CACHE_PRELOAD_STARTED.get(this.backend.getBackendID());
                ErrorLogger.logError(message);
                boolean isInterrupted = false;
                long timeEnd = System.currentTimeMillis() + timeLimit;
                for (DatabaseContainer db : dbList) {
                    PreloadStatus preloadStatus;
                    long timeRemaining = timeEnd - System.currentTimeMillis();
                    if (timeRemaining <= 0L) break;
                    preloadConfig.setMaxMillisecs(timeRemaining);
                    PreloadStats preloadStats = db.preload(preloadConfig);
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("file=" + db.getName() + " LNs=" + preloadStats.getNLNsLoaded());
                    }
                    if ((preloadStatus = preloadStats.getStatus()) != PreloadStatus.SUCCESS) {
                        if (preloadStatus == PreloadStatus.EXCEEDED_TIME) {
                            message = JebMessages.NOTE_JEB_CACHE_PRELOAD_INTERRUPTED_BY_TIME.get(this.backend.getBackendID(), db.getName());
                            ErrorLogger.logError(message);
                        } else if (preloadStatus == PreloadStatus.FILLED_CACHE) {
                            message = JebMessages.NOTE_JEB_CACHE_PRELOAD_INTERRUPTED_BY_SIZE.get(this.backend.getBackendID(), db.getName());
                            ErrorLogger.logError(message);
                        } else {
                            message = JebMessages.NOTE_JEB_CACHE_PRELOAD_INTERRUPTED_UNKNOWN.get(this.backend.getBackendID(), db.getName());
                            ErrorLogger.logError(message);
                        }
                        isInterrupted = true;
                        break;
                    }
                    message = JebMessages.NOTE_JEB_CACHE_DB_PRELOADED.get(db.getName());
                    ErrorLogger.logError(message);
                }
                if (!isInterrupted) {
                    message = JebMessages.NOTE_JEB_CACHE_PRELOAD_DONE.get(this.backend.getBackendID());
                    ErrorLogger.logError(message);
                }
                EnvironmentStats stats = this.env.getStats(new StatsConfig());
                long total = stats.getCacheTotalBytes();
                message = JebMessages.NOTE_JEB_CACHE_SIZE_AFTER_PRELOAD.get(total / 0x100000L);
                ErrorLogger.logError(message);
            }
            catch (DatabaseException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message = JebMessages.ERR_JEB_CACHE_PRELOAD.get(this.backend.getBackendID(), e.getCause() != null ? e.getCause().getMessage() : StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
    }

    private void cleanDatabase() throws DatabaseException {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File d, String name) {
                return name.endsWith(".jdb");
            }
        };
        File backendDirectory = this.env.getHome();
        int beforeLogfileCount = backendDirectory.list(filenameFilter).length;
        Message message = JebMessages.NOTE_JEB_CLEAN_DATABASE_START.get(beforeLogfileCount, backendDirectory.getPath());
        ErrorLogger.logError(message);
        int currentCleaned = 0;
        int totalCleaned = 0;
        while ((currentCleaned = this.env.cleanLog()) > 0) {
            totalCleaned += currentCleaned;
        }
        message = JebMessages.NOTE_JEB_CLEAN_DATABASE_MARKED.get(totalCleaned);
        ErrorLogger.logError(message);
        if (totalCleaned > 0) {
            CheckpointConfig force = new CheckpointConfig();
            force.setForce(true);
            this.env.checkpoint(force);
        }
        int afterLogfileCount = backendDirectory.list(filenameFilter).length;
        message = JebMessages.NOTE_JEB_CLEAN_DATABASE_FINISH.get(afterLogfileCount);
        ErrorLogger.logError(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DatabaseException {
        for (DN baseDN : this.entryContainers.keySet()) {
            EntryContainer ec = this.unregisterEntryContainer(baseDN);
            ec.exclusiveLock.lock();
            try {
                ec.close();
            }
            finally {
                ec.exclusiveLock.unlock();
            }
        }
        this.compressedSchema.close();
        this.config.removeLocalDBChangeListener(this);
        if (this.env != null) {
            this.env.close();
            this.env = null;
        }
    }

    public Collection<EntryContainer> getEntryContainers() {
        return this.entryContainers.values();
    }

    public Set<DN> getBaseDNs() {
        return this.entryContainers.keySet();
    }

    public EntryContainer getEntryContainer(DN baseDN) {
        EntryContainer ec = null;
        DN nodeDN = baseDN;
        while (ec == null && nodeDN != null) {
            ec = this.entryContainers.get(nodeDN);
            if (ec != null) continue;
            nodeDN = nodeDN.getParentDNInSuffix();
        }
        return ec;
    }

    public EnvironmentStats getEnvironmentStats(StatsConfig statsConfig) throws DatabaseException {
        return this.env.getStats(statsConfig);
    }

    public LockStats getEnvironmentLockStats(StatsConfig statsConfig) throws DatabaseException {
        return this.env.getLockStats(statsConfig);
    }

    public TransactionStats getEnvironmentTransactionStats(StatsConfig statsConfig) throws DatabaseException {
        return this.env.getTransactionStats(statsConfig);
    }

    public EnvironmentConfig getEnvironmentConfig() throws DatabaseException {
        return this.env.getConfig();
    }

    public LocalDBBackendCfg getConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryCount() throws DatabaseException {
        long entryCount = 0L;
        for (EntryContainer ec : this.entryContainers.values()) {
            ec.sharedLock.lock();
            try {
                entryCount += ec.getEntryCount();
            }
            finally {
                ec.sharedLock.unlock();
            }
        }
        return entryCount;
    }

    public EntryID getNextEntryID() {
        return new EntryID(this.nextid.getAndIncrement());
    }

    public Long getLowestEntryID() {
        return 1L;
    }

    public Long getHighestEntryID() {
        return this.nextid.get() - 1L;
    }

    public void resetNextEntryID() {
        this.nextid.set(1L);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LocalDBBackendCfg cfg, List<Message> unacceptableReasons) {
        Message message;
        boolean acceptable = true;
        File parentDirectory = StaticUtils.getFileForPath(this.config.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.config.getBackendId());
        if (!backendDirectory.exists()) {
            if (!backendDirectory.mkdirs()) {
                message = JebMessages.ERR_JEB_CREATE_FAIL.get(backendDirectory.getPath());
                unacceptableReasons.add(message);
                acceptable = false;
            } else {
                backendDirectory.delete();
            }
        } else if (!backendDirectory.isDirectory()) {
            message = JebMessages.ERR_JEB_DIRECTORY_INVALID.get(backendDirectory.getPath());
            unacceptableReasons.add(message);
            acceptable = false;
        }
        try {
            FilePermission newBackendPermission = FilePermission.decodeUNIXMode(cfg.getDBDirectoryPermissions());
            if (!(newBackendPermission.isOwnerWritable() && newBackendPermission.isOwnerReadable() && newBackendPermission.isOwnerExecutable())) {
                Message message2 = ConfigMessages.ERR_CONFIG_BACKEND_INSANE_MODE.get(cfg.getDBDirectoryPermissions());
                unacceptableReasons.add(message2);
                acceptable = false;
            }
        }
        catch (Exception e) {
            Message message3 = ConfigMessages.ERR_CONFIG_BACKEND_MODE_INVALID.get(cfg.dn().toString());
            unacceptableReasons.add(message3);
            acceptable = false;
        }
        try {
            ConfigurableEnvironment.parseConfigEntry(cfg);
        }
        catch (Exception e) {
            unacceptableReasons.add(Message.raw(e.getLocalizedMessage(), new Object[0]));
            acceptable = false;
        }
        return acceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LocalDBBackendCfg cfg) {
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            if (this.env != null) {
                EnvironmentConfig oldEnvConfig = this.env.getConfig();
                EnvironmentConfig newEnvConfig = ConfigurableEnvironment.parseConfigEntry(cfg);
                Map paramsMap = EnvironmentParams.SUPPORTED_PARAMS;
                SortedSet<String> jeProperties = cfg.getJEProperty();
                for (String jeEntry : jeProperties) {
                    String newValue;
                    String oldValue;
                    StringTokenizer st = new StringTokenizer(jeEntry, "=");
                    if (st.countTokens() != 2) continue;
                    String jePropertyName = st.nextToken();
                    String jePropertyValue = st.nextToken();
                    ConfigParam param = (ConfigParam)paramsMap.get(jePropertyName);
                    if (param.isMutable() || (oldValue = oldEnvConfig.getConfigParam(param.getName())).equalsIgnoreCase(newValue = jePropertyValue)) continue;
                    adminActionRequired = true;
                    messages.add(ConfigMessages.INFO_CONFIG_JE_PROPERTY_REQUIRES_RESTART.get(jePropertyName));
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("The change to the following property will take effect when the component is restarted: " + jePropertyName);
                }
                for (Object o : paramsMap.values()) {
                    String newValue;
                    String oldValue;
                    ConfigParam param = (ConfigParam)o;
                    if (param.isMutable() || (oldValue = oldEnvConfig.getConfigParam(param.getName())).equalsIgnoreCase(newValue = newEnvConfig.getConfigParam(param.getName()))) continue;
                    adminActionRequired = true;
                    String configAttr = ConfigurableEnvironment.getAttributeForProperty(param.getName());
                    if (configAttr != null) {
                        messages.add(JebMessages.NOTE_JEB_CONFIG_ATTR_REQUIRES_RESTART.get(configAttr));
                    } else {
                        messages.add(JebMessages.NOTE_JEB_CONFIG_ATTR_REQUIRES_RESTART.get(param.getName()));
                    }
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("The change to the following property will take effect when the backend is restarted: " + param.getName());
                }
                this.env.setMutableConfig((EnvironmentMutableConfig)newEnvConfig);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo(this.env.getConfig().toString());
                }
            }
            if (!cfg.getDBDirectory().equals(this.config.getDBDirectory())) {
                File parentDirectory = StaticUtils.getFileForPath(this.config.getDBDirectory());
                File backendDirectory = new File(parentDirectory, this.config.getBackendId());
                if (!backendDirectory.exists()) {
                    if (!backendDirectory.mkdirs()) {
                        messages.add(JebMessages.ERR_JEB_CREATE_FAIL.get(backendDirectory.getPath()));
                        ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                        return ccr;
                    }
                } else if (!backendDirectory.isDirectory()) {
                    messages.add(JebMessages.ERR_JEB_DIRECTORY_INVALID.get(backendDirectory.getPath()));
                    ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                    return ccr;
                }
                adminActionRequired = true;
                messages.add(JebMessages.NOTE_JEB_CONFIG_DB_DIR_REQUIRES_RESTART.get(this.config.getDBDirectory(), cfg.getDBDirectory()));
            }
            if (!cfg.getDBDirectoryPermissions().equalsIgnoreCase(this.config.getDBDirectoryPermissions()) || !cfg.getDBDirectory().equals(this.config.getDBDirectory())) {
                FilePermission backendPermission;
                try {
                    backendPermission = FilePermission.decodeUNIXMode(cfg.getDBDirectoryPermissions());
                }
                catch (Exception e) {
                    messages.add(ConfigMessages.ERR_CONFIG_BACKEND_MODE_INVALID.get(this.config.dn().toString()));
                    ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                    return ccr;
                }
                if (!(backendPermission.isOwnerWritable() && backendPermission.isOwnerReadable() && backendPermission.isOwnerExecutable())) {
                    messages.add(ConfigMessages.ERR_CONFIG_BACKEND_INSANE_MODE.get(cfg.getDBDirectoryPermissions()));
                    ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                    return ccr;
                }
                if (FilePermission.canSetPermissions()) {
                    File parentDirectory = StaticUtils.getFileForPath(this.config.getDBDirectory());
                    File backendDirectory = new File(parentDirectory, this.config.getBackendId());
                    try {
                        if (!FilePermission.setPermissions(backendDirectory, backendPermission)) {
                            Message message = JebMessages.WARN_JEB_UNABLE_SET_PERMISSIONS.get(backendPermission.toString(), backendDirectory.toString());
                            ErrorLogger.logError(message);
                        }
                    }
                    catch (Exception e) {
                        Message message = JebMessages.WARN_JEB_SET_PERMISSIONS_FAILED.get(backendDirectory.toString(), e.toString());
                        ErrorLogger.logError(message);
                    }
                }
            }
            this.config = cfg;
        }
        catch (Exception e) {
            messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
            ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
            return ccr;
        }
        ConfigChangeResult ccr = new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        return ccr;
    }

    public void importForceCheckPoint() throws DatabaseException {
        this.env.checkpoint(this.importForceCheckPoint);
    }

    public int cleanedLogFiles() throws DatabaseException {
        int cleaned;
        int totalCleaned = 0;
        while ((cleaned = this.env.cleanLog()) > 0) {
            totalCleaned += cleaned;
        }
        return totalCleaned;
    }
}

