/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.MatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilterType;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawFilter;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPFilter
extends RawFilter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<ByteString> subAnyElements;
    private ArrayList<RawFilter> filterComponents;
    private boolean dnAttributes;
    private ByteString assertionValue;
    private ByteString subFinalElement;
    private ByteString subInitialElement;
    private FilterType filterType;
    private RawFilter notComponent;
    private String attributeType;
    private String matchingRuleID;

    public LDAPFilter(FilterType filterType, ArrayList<RawFilter> filterComponents, RawFilter notComponent, String attributeType, ByteString assertionValue, ByteString subInitialElement, ArrayList<ByteString> subAnyElements, ByteString subFinalElement, String matchingRuleID, boolean dnAttributes) {
        this.filterType = filterType;
        this.filterComponents = filterComponents;
        this.notComponent = notComponent;
        this.attributeType = attributeType;
        this.assertionValue = assertionValue;
        this.subInitialElement = subInitialElement;
        this.subAnyElements = subAnyElements;
        this.subFinalElement = subFinalElement;
        this.matchingRuleID = matchingRuleID;
        this.dnAttributes = dnAttributes;
    }

    public LDAPFilter(SearchFilter filter) {
        this.filterType = filter.getFilterType();
        switch (this.filterType) {
            case AND: 
            case OR: {
                Set<SearchFilter> comps = filter.getFilterComponents();
                this.filterComponents = new ArrayList(comps.size());
                for (SearchFilter f : comps) {
                    this.filterComponents.add(new LDAPFilter(f));
                }
                this.notComponent = null;
                this.attributeType = null;
                this.assertionValue = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case NOT: {
                this.notComponent = new LDAPFilter(filter.getNotComponent());
                this.filterComponents = null;
                this.attributeType = null;
                this.assertionValue = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case EQUALITY: 
            case GREATER_OR_EQUAL: 
            case LESS_OR_EQUAL: 
            case APPROXIMATE_MATCH: {
                this.attributeType = filter.getAttributeType().getNameOrOID();
                this.assertionValue = filter.getAssertionValue().getValue();
                this.filterComponents = null;
                this.notComponent = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case SUBSTRING: {
                this.attributeType = filter.getAttributeType().getNameOrOID();
                ByteString bs = filter.getSubInitialElement();
                this.subInitialElement = bs == null ? null : bs;
                bs = filter.getSubFinalElement();
                this.subFinalElement = bs == null ? null : bs;
                List<ByteString> subAnyStrings = filter.getSubAnyElements();
                this.subAnyElements = subAnyStrings == null ? null : new ArrayList<ByteString>(subAnyStrings);
                this.filterComponents = null;
                this.notComponent = null;
                this.assertionValue = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case PRESENT: {
                this.attributeType = filter.getAttributeType().getNameOrOID();
                this.filterComponents = null;
                this.notComponent = null;
                this.assertionValue = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case EXTENSIBLE_MATCH: {
                this.dnAttributes = filter.getDNAttributes();
                this.matchingRuleID = filter.getMatchingRuleID();
                AttributeType attrType = filter.getAttributeType();
                this.attributeType = attrType == null ? null : attrType.getNameOrOID();
                AttributeValue av = filter.getAssertionValue();
                this.assertionValue = av == null ? null : av.getValue();
                this.filterComponents = null;
                this.notComponent = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
            }
        }
    }

    public static LDAPFilter decode(String filterString) throws LDAPException {
        if (filterString == null) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_STRING_NULL.get();
            throw new LDAPException(2, message);
        }
        try {
            return LDAPFilter.decode(filterString, 0, filterString.length());
        }
        catch (LDAPException le) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_UNCAUGHT_EXCEPTION.get(filterString, String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
    }

    private static LDAPFilter decode(String filterString, int startPos, int endPos) throws LDAPException {
        ByteString value;
        int attrEndPos;
        FilterType filterType;
        char c;
        int length = endPos - startPos;
        if (length <= 0) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_STRING_NULL.get();
            throw new LDAPException(2, message);
        }
        if (1 < filterString.length() && filterString.startsWith("'") && filterString.endsWith("'")) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_ENCLOSED_IN_APOSTROPHES.get(filterString);
            throw new LDAPException(2, message);
        }
        if (filterString.charAt(startPos) == '(') {
            if (filterString.charAt(endPos - 1) == ')') {
                ++startPos;
                --endPos;
            } else {
                Message message = ProtocolMessages.ERR_LDAP_FILTER_MISMATCHED_PARENTHESES.get(filterString, startPos, endPos);
                throw new LDAPException(2, message);
            }
        }
        if ((c = filterString.charAt(startPos)) == '&') {
            return LDAPFilter.decodeCompoundFilter(FilterType.AND, filterString, startPos + 1, endPos);
        }
        if (c == '|') {
            return LDAPFilter.decodeCompoundFilter(FilterType.OR, filterString, startPos + 1, endPos);
        }
        if (c == '!') {
            return LDAPFilter.decodeCompoundFilter(FilterType.NOT, filterString, startPos + 1, endPos);
        }
        int equalPos = -1;
        for (int i = startPos; i < endPos; ++i) {
            if (filterString.charAt(i) != '=') continue;
            equalPos = i;
            break;
        }
        if (equalPos <= startPos) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_NO_EQUAL_SIGN.get(filterString, startPos, endPos);
            throw new LDAPException(2, message);
        }
        switch (filterString.charAt(equalPos - 1)) {
            case '~': {
                filterType = FilterType.APPROXIMATE_MATCH;
                attrEndPos = equalPos - 1;
                break;
            }
            case '>': {
                filterType = FilterType.GREATER_OR_EQUAL;
                attrEndPos = equalPos - 1;
                break;
            }
            case '<': {
                filterType = FilterType.LESS_OR_EQUAL;
                attrEndPos = equalPos - 1;
                break;
            }
            case ':': {
                return LDAPFilter.decodeExtensibleMatchFilter(filterString, startPos, equalPos, endPos);
            }
            default: {
                filterType = FilterType.EQUALITY;
                attrEndPos = equalPos;
            }
        }
        String attrType = filterString.substring(startPos, attrEndPos);
        block46: for (int i = 0; i < attrType.length(); ++i) {
            switch (attrType.charAt(i)) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ';': 
                case '=': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block46;
                }
                default: {
                    Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_CHAR_IN_ATTR_TYPE.get(attrType, String.valueOf(attrType.charAt(i)), i);
                    throw new LDAPException(2, message);
                }
            }
        }
        String valueStr = filterString.substring(equalPos + 1, endPos);
        if (valueStr.length() == 0) {
            return new LDAPFilter(filterType, null, null, attrType, ByteString.empty(), null, null, null, null, false);
        }
        if (valueStr.equals("*")) {
            return new LDAPFilter(FilterType.PRESENT, null, null, attrType, null, null, null, null, null, false);
        }
        if (valueStr.indexOf(42) >= 0) {
            return LDAPFilter.decodeSubstringFilter(filterString, attrType, equalPos, endPos);
        }
        boolean hasEscape = false;
        byte[] valueBytes = StaticUtils.getBytes(valueStr);
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] != 92) continue;
            hasEscape = true;
            break;
        }
        if (hasEscape) {
            ByteStringBuilder valueBuffer = new ByteStringBuilder(valueStr.length());
            for (int i = 0; i < valueBytes.length; ++i) {
                if (valueBytes[i] == 92) {
                    if (i + 2 >= valueBytes.length) {
                        Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                        throw new LDAPException(2, message);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new LDAPException(2, message);
                        }
                    }
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new LDAPException(2, message);
                        }
                    }
                    valueBuffer.append(byteValue);
                    continue;
                }
                valueBuffer.append(valueBytes[i]);
            }
            value = valueBuffer.toByteString();
        } else {
            value = ByteString.wrap(valueBytes);
        }
        return new LDAPFilter(filterType, null, null, attrType, value, null, null, null, null, false);
    }

    private static LDAPFilter decodeCompoundFilter(FilterType filterType, String filterString, int startPos, int endPos) throws LDAPException {
        ArrayList<RawFilter> filterComponents = new ArrayList<RawFilter>();
        if (startPos == endPos) {
            if (filterType == FilterType.NOT) {
                Message message = ProtocolMessages.ERR_LDAP_FILTER_NOT_EXACTLY_ONE.get(filterString, startPos, endPos);
                throw new LDAPException(2, message);
            }
            return new LDAPFilter(filterType, filterComponents, null, null, null, null, null, null, null, false);
        }
        if (filterString.charAt(startPos) != '(' || filterString.charAt(endPos - 1) != ')') {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_COMPOUND_MISSING_PARENTHESES.get(filterString, startPos, endPos);
            throw new LDAPException(2, message);
        }
        int pendingOpens = 0;
        int openPos = -1;
        for (int i = startPos; i < endPos; ++i) {
            char c = filterString.charAt(i);
            if (c == '(') {
                if (openPos < 0) {
                    openPos = i;
                }
                ++pendingOpens;
                continue;
            }
            if (c == ')') {
                if (--pendingOpens == 0) {
                    filterComponents.add(LDAPFilter.decode(filterString, openPos, i + 1));
                    openPos = -1;
                    continue;
                }
                if (pendingOpens >= 0) continue;
                Message message = ProtocolMessages.ERR_LDAP_FILTER_NO_CORRESPONDING_OPEN_PARENTHESIS.get(filterString, i);
                throw new LDAPException(2, message);
            }
            if (pendingOpens > 0) continue;
            Message message = ProtocolMessages.ERR_LDAP_FILTER_COMPOUND_MISSING_PARENTHESES.get(filterString, startPos, endPos);
            throw new LDAPException(2, message);
        }
        if (pendingOpens != 0) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_NO_CORRESPONDING_CLOSE_PARENTHESIS.get(filterString, openPos);
            throw new LDAPException(2, message);
        }
        if (filterType == FilterType.NOT) {
            if (filterComponents.size() != 1) {
                Message message = ProtocolMessages.ERR_LDAP_FILTER_NOT_EXACTLY_ONE.get(filterString, startPos, endPos);
                throw new LDAPException(2, message);
            }
            RawFilter notComponent = filterComponents.get(0);
            return new LDAPFilter(filterType, null, notComponent, null, null, null, null, null, null, false);
        }
        return new LDAPFilter(filterType, filterComponents, null, null, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeSubstringFilter(String filterString, String attrType, int equalPos, int endPos) throws LDAPException {
        ByteString subFinal;
        ByteString subInitial;
        byte[] valueBytes = StaticUtils.getBytes(filterString.substring(equalPos + 1, endPos));
        boolean hasEscape = false;
        LinkedList<Integer> asteriskPositions = new LinkedList<Integer>();
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] == 42) {
                asteriskPositions.add(i);
                continue;
            }
            if (valueBytes[i] != 92) continue;
            hasEscape = true;
        }
        if (asteriskPositions.isEmpty()) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_SUBSTRING_NO_ASTERISKS.get(filterString, equalPos + 1, endPos);
            throw new LDAPException(2, message);
        }
        int firstPos = (Integer)asteriskPositions.removeFirst();
        if (firstPos == 0) {
            subInitial = null;
        } else if (hasEscape) {
            ByteStringBuilder buffer = new ByteStringBuilder(firstPos);
            for (int i = 0; i < firstPos; ++i) {
                if (valueBytes[i] == 92) {
                    if (i + 2 >= valueBytes.length) {
                        Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                        throw new LDAPException(2, message);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new LDAPException(2, message);
                        }
                    }
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new LDAPException(2, message);
                        }
                    }
                    buffer.append(byteValue);
                    continue;
                }
                buffer.append(valueBytes[i]);
            }
            subInitial = buffer.toByteString();
        } else {
            subInitial = ByteString.wrap(valueBytes, 0, firstPos);
        }
        ArrayList<ByteString> subAny = new ArrayList<ByteString>();
        Iterator i$ = asteriskPositions.iterator();
        while (i$.hasNext()) {
            int asteriskPos = (Integer)i$.next();
            int length = asteriskPos - firstPos - 1;
            if (hasEscape) {
                ByteStringBuilder buffer = new ByteStringBuilder(length);
                for (int i = firstPos + 1; i < asteriskPos; ++i) {
                    if (valueBytes[i] == 92) {
                        if (i + 2 >= valueBytes.length) {
                            Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new LDAPException(2, message);
                        }
                        byte byteValue = 0;
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = 16;
                                break;
                            }
                            case 50: {
                                byteValue = 32;
                                break;
                            }
                            case 51: {
                                byteValue = 48;
                                break;
                            }
                            case 52: {
                                byteValue = 64;
                                break;
                            }
                            case 53: {
                                byteValue = 80;
                                break;
                            }
                            case 54: {
                                byteValue = 96;
                                break;
                            }
                            case 55: {
                                byteValue = 112;
                                break;
                            }
                            case 56: {
                                byteValue = -128;
                                break;
                            }
                            case 57: {
                                byteValue = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = -16;
                                break;
                            }
                            default: {
                                Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                                throw new LDAPException(2, message);
                            }
                        }
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = (byte)(byteValue | 1);
                                break;
                            }
                            case 50: {
                                byteValue = (byte)(byteValue | 2);
                                break;
                            }
                            case 51: {
                                byteValue = (byte)(byteValue | 3);
                                break;
                            }
                            case 52: {
                                byteValue = (byte)(byteValue | 4);
                                break;
                            }
                            case 53: {
                                byteValue = (byte)(byteValue | 5);
                                break;
                            }
                            case 54: {
                                byteValue = (byte)(byteValue | 6);
                                break;
                            }
                            case 55: {
                                byteValue = (byte)(byteValue | 7);
                                break;
                            }
                            case 56: {
                                byteValue = (byte)(byteValue | 8);
                                break;
                            }
                            case 57: {
                                byteValue = (byte)(byteValue | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = (byte)(byteValue | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = (byte)(byteValue | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = (byte)(byteValue | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = (byte)(byteValue | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = (byte)(byteValue | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = (byte)(byteValue | 0xF);
                                break;
                            }
                            default: {
                                Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                                throw new LDAPException(2, message);
                            }
                        }
                        buffer.append(byteValue);
                        continue;
                    }
                    buffer.append(valueBytes[i]);
                }
                subAny.add(buffer.toByteString());
                buffer.clear();
            } else {
                subAny.add(ByteString.wrap(valueBytes, firstPos + 1, length));
            }
            firstPos = asteriskPos;
        }
        if (firstPos == valueBytes.length - 1) {
            subFinal = null;
        } else {
            int length = valueBytes.length - firstPos - 1;
            if (hasEscape) {
                ByteStringBuilder buffer = new ByteStringBuilder(length);
                for (int i = firstPos + 1; i < valueBytes.length; ++i) {
                    if (valueBytes[i] == 92) {
                        if (i + 2 >= valueBytes.length) {
                            Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new LDAPException(2, message);
                        }
                        byte byteValue = 0;
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = 16;
                                break;
                            }
                            case 50: {
                                byteValue = 32;
                                break;
                            }
                            case 51: {
                                byteValue = 48;
                                break;
                            }
                            case 52: {
                                byteValue = 64;
                                break;
                            }
                            case 53: {
                                byteValue = 80;
                                break;
                            }
                            case 54: {
                                byteValue = 96;
                                break;
                            }
                            case 55: {
                                byteValue = 112;
                                break;
                            }
                            case 56: {
                                byteValue = -128;
                                break;
                            }
                            case 57: {
                                byteValue = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = -16;
                                break;
                            }
                            default: {
                                Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                                throw new LDAPException(2, message);
                            }
                        }
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = (byte)(byteValue | 1);
                                break;
                            }
                            case 50: {
                                byteValue = (byte)(byteValue | 2);
                                break;
                            }
                            case 51: {
                                byteValue = (byte)(byteValue | 3);
                                break;
                            }
                            case 52: {
                                byteValue = (byte)(byteValue | 4);
                                break;
                            }
                            case 53: {
                                byteValue = (byte)(byteValue | 5);
                                break;
                            }
                            case 54: {
                                byteValue = (byte)(byteValue | 6);
                                break;
                            }
                            case 55: {
                                byteValue = (byte)(byteValue | 7);
                                break;
                            }
                            case 56: {
                                byteValue = (byte)(byteValue | 8);
                                break;
                            }
                            case 57: {
                                byteValue = (byte)(byteValue | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = (byte)(byteValue | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = (byte)(byteValue | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = (byte)(byteValue | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = (byte)(byteValue | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = (byte)(byteValue | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = (byte)(byteValue | 0xF);
                                break;
                            }
                            default: {
                                Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                                throw new LDAPException(2, message);
                            }
                        }
                        buffer.append(byteValue);
                        continue;
                    }
                    buffer.append(valueBytes[i]);
                }
                subFinal = buffer.toByteString();
            } else {
                subFinal = ByteString.wrap(valueBytes, firstPos + 1, length);
            }
        }
        return new LDAPFilter(FilterType.SUBSTRING, null, null, attrType, null, subInitial, subAny, subFinal, null, false);
    }

    private static LDAPFilter decodeExtensibleMatchFilter(String filterString, int startPos, int equalPos, int endPos) throws LDAPException {
        ByteString value;
        String attributeType = null;
        boolean dnAttributes = false;
        String matchingRuleID = null;
        String lowerLeftStr = StaticUtils.toLowerCase(filterString.substring(startPos, equalPos));
        if (filterString.charAt(startPos) == ':') {
            if (lowerLeftStr.startsWith(":dn:")) {
                dnAttributes = true;
                if (startPos + 4 < equalPos - 1) {
                    matchingRuleID = filterString.substring(startPos + 4, equalPos - 1);
                }
            } else {
                matchingRuleID = filterString.substring(startPos + 1, equalPos - 1);
            }
        } else {
            int colonPos = filterString.indexOf(58, startPos);
            if (colonPos < 0) {
                Message message = ProtocolMessages.ERR_LDAP_FILTER_EXTENSIBLE_MATCH_NO_COLON.get(filterString, startPos);
                throw new LDAPException(2, message);
            }
            attributeType = filterString.substring(startPos, colonPos);
            if (colonPos < equalPos - 1) {
                if (lowerLeftStr.startsWith(":dn:", colonPos - startPos)) {
                    dnAttributes = true;
                    if (colonPos + 4 < equalPos - 1) {
                        matchingRuleID = filterString.substring(colonPos + 4, equalPos - 1);
                    }
                } else {
                    matchingRuleID = filterString.substring(colonPos + 1, equalPos - 1);
                }
            }
        }
        byte[] valueBytes = StaticUtils.getBytes(filterString.substring(equalPos + 1, endPos));
        boolean hasEscape = false;
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] != 92) continue;
            hasEscape = true;
            break;
        }
        if (hasEscape) {
            ByteStringBuilder valueBuffer = new ByteStringBuilder(valueBytes.length);
            for (int i = 0; i < valueBytes.length; ++i) {
                if (valueBytes[i] == 92) {
                    if (i + 2 >= valueBytes.length) {
                        Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                        throw new LDAPException(2, message);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new LDAPException(2, message);
                        }
                    }
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            Message message = ProtocolMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new LDAPException(2, message);
                        }
                    }
                    valueBuffer.append(byteValue);
                    continue;
                }
                valueBuffer.append(valueBytes[i]);
            }
            value = valueBuffer.toByteString();
        } else {
            value = ByteString.wrap(valueBytes);
        }
        if (attributeType == null && matchingRuleID == null) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_EXTENSIBLE_MATCH_NO_AD_OR_MR.get(filterString, startPos);
            throw new LDAPException(2, message);
        }
        return new LDAPFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, value, null, null, null, matchingRuleID, dnAttributes);
    }

    @Override
    public FilterType getFilterType() {
        return this.filterType;
    }

    @Override
    public ArrayList<RawFilter> getFilterComponents() {
        return this.filterComponents;
    }

    @Override
    public RawFilter getNOTComponent() {
        return this.notComponent;
    }

    @Override
    public String getAttributeType() {
        return this.attributeType;
    }

    @Override
    public ByteString getAssertionValue() {
        return this.assertionValue;
    }

    @Override
    public ByteString getSubInitialElement() {
        return this.subInitialElement;
    }

    public void setSubInitialElement(ByteString subInitialElement) {
        this.subInitialElement = subInitialElement;
    }

    @Override
    public ArrayList<ByteString> getSubAnyElements() {
        return this.subAnyElements;
    }

    @Override
    public ByteString getSubFinalElement() {
        return this.subFinalElement;
    }

    @Override
    public String getMatchingRuleID() {
        return this.matchingRuleID;
    }

    @Override
    public boolean getDNAttributes() {
        return this.dnAttributes;
    }

    @Override
    public SearchFilter toSearchFilter() throws DirectoryException {
        AttributeValue value;
        HashSet<String> options;
        AttributeType attrType;
        ArrayList<SearchFilter> subComps;
        if (this.filterComponents == null) {
            subComps = null;
        } else {
            subComps = new ArrayList<SearchFilter>(this.filterComponents.size());
            for (RawFilter f : this.filterComponents) {
                subComps.add(f.toSearchFilter());
            }
        }
        SearchFilter notComp = this.notComponent == null ? null : this.notComponent.toSearchFilter();
        if (this.attributeType == null) {
            attrType = null;
            options = null;
        } else {
            int semicolonPos = this.attributeType.indexOf(59);
            if (semicolonPos > 0) {
                String baseName = this.attributeType.substring(0, semicolonPos);
                attrType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(baseName));
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(baseName);
                }
                options = new HashSet<String>();
                StringTokenizer tokenizer = new StringTokenizer(this.attributeType.substring(semicolonPos + 1), ";");
                while (tokenizer.hasMoreTokens()) {
                    options.add(tokenizer.nextToken());
                }
            } else {
                options = null;
                attrType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(this.attributeType));
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(this.attributeType);
                }
            }
        }
        if (this.assertionValue == null) {
            value = null;
        } else if (attrType == null) {
            if (this.matchingRuleID == null) {
                Message message = ProtocolMessages.ERR_LDAP_FILTER_VALUE_WITH_NO_ATTR_OR_MR.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            MatchingRule mr = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
            if (mr == null) {
                Message message = ProtocolMessages.ERR_LDAP_FILTER_UNKNOWN_MATCHING_RULE.get(this.matchingRuleID);
                throw new DirectoryException(ResultCode.INAPPROPRIATE_MATCHING, message);
            }
            ByteString normalizedValue = mr.normalizeValue(this.assertionValue);
            value = AttributeValues.create(this.assertionValue, normalizedValue);
        } else {
            value = AttributeValues.create(attrType, this.assertionValue);
        }
        ArrayList<ByteString> subAnyComps = this.subAnyElements == null ? null : new ArrayList<ByteString>(this.subAnyElements);
        return new SearchFilter(this.filterType, subComps, notComp, attrType, options, value, this.subInitialElement, subAnyComps, this.subFinalElement, this.matchingRuleID, this.dnAttributes);
    }

    @Override
    public void toString(StringBuilder buffer) {
        switch (this.filterType) {
            case AND: {
                buffer.append("(&");
                for (RawFilter f : this.filterComponents) {
                    f.toString(buffer);
                }
                buffer.append(")");
                break;
            }
            case OR: {
                buffer.append("(|");
                for (RawFilter f : this.filterComponents) {
                    f.toString(buffer);
                }
                buffer.append(")");
                break;
            }
            case NOT: {
                buffer.append("(!");
                this.notComponent.toString(buffer);
                buffer.append(")");
                break;
            }
            case EQUALITY: {
                buffer.append("(");
                buffer.append(this.attributeType);
                buffer.append("=");
                LDAPFilter.valueToFilterString(buffer, this.assertionValue);
                buffer.append(")");
                break;
            }
            case SUBSTRING: {
                buffer.append("(");
                buffer.append(this.attributeType);
                buffer.append("=");
                if (this.subInitialElement != null) {
                    LDAPFilter.valueToFilterString(buffer, this.subInitialElement);
                }
                if (this.subAnyElements != null && !this.subAnyElements.isEmpty()) {
                    for (ByteString s : this.subAnyElements) {
                        buffer.append("*");
                        LDAPFilter.valueToFilterString(buffer, s);
                    }
                }
                buffer.append("*");
                if (this.subFinalElement != null) {
                    LDAPFilter.valueToFilterString(buffer, this.subFinalElement);
                }
                buffer.append(")");
                break;
            }
            case GREATER_OR_EQUAL: {
                buffer.append("(");
                buffer.append(this.attributeType);
                buffer.append(">=");
                LDAPFilter.valueToFilterString(buffer, this.assertionValue);
                buffer.append(")");
                break;
            }
            case LESS_OR_EQUAL: {
                buffer.append("(");
                buffer.append(this.attributeType);
                buffer.append("<=");
                LDAPFilter.valueToFilterString(buffer, this.assertionValue);
                buffer.append(")");
                break;
            }
            case PRESENT: {
                buffer.append("(");
                buffer.append(this.attributeType);
                buffer.append("=*)");
                break;
            }
            case APPROXIMATE_MATCH: {
                buffer.append("(");
                buffer.append(this.attributeType);
                buffer.append("~=");
                LDAPFilter.valueToFilterString(buffer, this.assertionValue);
                buffer.append(")");
                break;
            }
            case EXTENSIBLE_MATCH: {
                buffer.append("(");
                if (this.attributeType != null) {
                    buffer.append(this.attributeType);
                }
                if (this.dnAttributes) {
                    buffer.append(":dn");
                }
                if (this.matchingRuleID != null) {
                    buffer.append(":");
                    buffer.append(this.matchingRuleID);
                }
                buffer.append(":=");
                LDAPFilter.valueToFilterString(buffer, this.assertionValue);
                buffer.append(")");
            }
        }
    }
}

