/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ServerStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSInfo {
    private short dsId = (short)-1;
    private short rsId = (short)-1;
    private long generationId = -1L;
    private ServerStatus status = ServerStatus.INVALID_STATUS;
    private boolean assuredFlag = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte safeDataLevel = (byte)-1;
    private List<String> refUrls = new ArrayList<String>(0);
    private byte groupId = (byte)-1;

    public DSInfo(short dsId, short rsId, long generationId, ServerStatus status, boolean assuredFlag, AssuredMode assuredMode, byte safeDataLevel, byte groupId, List<String> refUrls) {
        this.dsId = dsId;
        this.rsId = rsId;
        this.generationId = generationId;
        this.status = status;
        this.assuredFlag = assuredFlag;
        this.assuredMode = assuredMode;
        this.safeDataLevel = safeDataLevel;
        this.groupId = groupId;
        this.refUrls = refUrls;
    }

    public short getDsId() {
        return this.dsId;
    }

    public short getRsId() {
        return this.rsId;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public boolean isAssured() {
        return this.assuredFlag;
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public byte getSafeDataLevel() {
        return this.safeDataLevel;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public List<String> getRefUrls() {
        return this.refUrls;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DSInfo dsInfo = (DSInfo)obj;
            return this.dsId == dsInfo.getDsId() && this.rsId == dsInfo.getRsId() && this.generationId == dsInfo.getGenerationId() && this.status == dsInfo.getStatus() && this.assuredFlag == dsInfo.isAssured() && this.assuredMode == dsInfo.getAssuredMode() && this.safeDataLevel == dsInfo.getSafeDataLevel() && this.groupId == dsInfo.getGroupId() && ((Object)this.refUrls).equals(dsInfo.getRefUrls());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.dsId;
        hash = 73 * hash + this.rsId;
        hash = 73 * hash + (int)(this.generationId ^ this.generationId >>> 32);
        hash = 73 * hash + (this.status != null ? this.status.hashCode() : 0);
        hash = 73 * hash + (this.assuredFlag ? 1 : 0);
        hash = 73 * hash + (this.assuredMode != null ? this.assuredMode.hashCode() : 0);
        hash = 73 * hash + this.safeDataLevel;
        hash = 73 * hash + (this.refUrls != null ? ((Object)this.refUrls).hashCode() : 0);
        hash = 73 * hash + this.groupId;
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DS id: ");
        sb.append(this.dsId);
        sb.append("\nRS id: ");
        sb.append(this.rsId);
        sb.append("\nGeneration id: ");
        sb.append(this.generationId);
        sb.append("\nStatus: ");
        sb.append((Object)this.status);
        sb.append("\nAssured replication: ");
        sb.append(this.assuredFlag);
        sb.append("\nAssured mode: ");
        sb.append((Object)this.assuredMode);
        sb.append("\nSafe data level: ");
        sb.append(this.safeDataLevel);
        sb.append("\nGroup id: ");
        sb.append(this.groupId);
        sb.append("\nReferral URLs: ");
        sb.append(this.refUrls);
        return sb.toString();
    }
}

