/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerState
implements Iterable<Short> {
    private HashMap<Short, ChangeNumber> list;
    private boolean saved = true;

    public ServerState() {
        this.list = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<Short, ChangeNumber> hashMap = this.list;
        synchronized (hashMap) {
            this.list.clear();
        }
    }

    public ServerState(byte[] in, int pos, int endpos) throws DataFormatException {
        try {
            this.list = new HashMap();
            while (endpos > pos) {
                int length = this.getNextLength(in, pos);
                String serverIdString = new String(in, pos, length, "UTF-8");
                short serverId = Short.valueOf(serverIdString);
                pos += length + 1;
                length = this.getNextLength(in, pos);
                String cnString = new String(in, pos, length, "UTF-8");
                ChangeNumber cn = new ChangeNumber(cnString);
                pos += length + 1;
                this.list.put(serverId, cn);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    private int getNextLength(byte[] in, int pos) throws DataFormatException {
        int offset = pos;
        int length = 0;
        while (in[offset++] != 0) {
            if (offset >= in.length) {
                throw new DataFormatException("byte[] is not a valid modify msg");
            }
            ++length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ChangeNumber changeNumber) {
        if (changeNumber == null) {
            return false;
        }
        this.saved = false;
        HashMap<Short, ChangeNumber> hashMap = this.list;
        synchronized (hashMap) {
            Short id = changeNumber.getServerId();
            ChangeNumber oldCN = this.list.get(id);
            if (oldCN == null || changeNumber.newer(oldCN)) {
                this.list.put(id, changeNumber);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reload(ServerState serverState) {
        if (serverState == null) {
            return false;
        }
        boolean result = false;
        HashMap<Short, ChangeNumber> hashMap = this.list;
        synchronized (hashMap) {
            this.clear();
            for (Short id : serverState) {
                ChangeNumber maxChangeNumber = serverState.getMaxChangeNumber(id);
                if (!this.update(maxChangeNumber)) continue;
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> toStringSet() {
        HashSet<String> set = new HashSet<String>();
        HashMap<Short, ChangeNumber> hashMap = this.list;
        synchronized (hashMap) {
            for (Short key : this.list.keySet()) {
                ChangeNumber change = this.list.get(key);
                Date date = new Date(change.getTime());
                set.add(change.toString() + " " + date.toString());
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ByteString> toASN1ArrayList() {
        ArrayList<ByteString> values = new ArrayList<ByteString>(0);
        HashMap<Short, ChangeNumber> hashMap = this.list;
        synchronized (hashMap) {
            for (Short id : this.list.keySet()) {
                ByteString value = ByteString.valueOf(this.list.get(id).toString());
                values.add(value);
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        HashMap<Short, ChangeNumber> hashMap = this.list;
        synchronized (hashMap) {
            for (Short key : this.list.keySet()) {
                ChangeNumber change = this.list.get(key);
                buffer.append(" ");
                buffer.append(change.toStringUI());
            }
        }
        return buffer.toString();
    }

    public ChangeNumber getMaxChangeNumber(short serverId) {
        return this.list.get(serverId);
    }

    private int addByteArray(byte[] tail, byte[] resultByteArray, int pos) {
        int i = 0;
        while (i < tail.length) {
            resultByteArray[pos] = tail[i];
            ++i;
            ++pos;
        }
        resultByteArray[pos++] = 0;
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws UnsupportedEncodingException {
        HashMap<Short, ChangeNumber> hashMap = this.list;
        synchronized (hashMap) {
            int length = 0;
            ArrayList<String> idList = new ArrayList<String>(this.list.size());
            for (short id : this.list.keySet()) {
                String temp = String.valueOf(id);
                idList.add(temp);
                length += temp.length() + 1;
            }
            ArrayList<String> cnList = new ArrayList<String>(this.list.size());
            for (ChangeNumber cn : this.list.values()) {
                String temp = cn.toString();
                cnList.add(temp);
                length += temp.length() + 1;
            }
            byte[] result = new byte[length];
            int pos = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                String str = (String)idList.get(i);
                pos = this.addByteArray(str.getBytes("UTF-8"), result, pos);
                str = (String)cnList.get(i);
                pos = this.addByteArray(str.getBytes("UTF-8"), result, pos);
            }
            return result;
        }
    }

    @Override
    public Iterator<Short> iterator() {
        return this.list.keySet().iterator();
    }

    public boolean cover(ServerState covered) {
        for (ChangeNumber coveredChange : covered.list.values()) {
            ChangeNumber change = this.list.get(coveredChange.getServerId());
            if (change != null && !change.older(coveredChange).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerState duplicate() {
        ServerState newState = new ServerState();
        HashMap<Short, ChangeNumber> hashMap = this.list;
        synchronized (hashMap) {
            for (Short key : this.list.keySet()) {
                ChangeNumber change = this.list.get(key);
                Short id = change.getServerId();
                newState.list.put(id, change);
            }
        }
        return newState;
    }

    public static int diffChanges(ServerState ss1, ServerState ss2) throws IllegalArgumentException {
        if (ss1 == null || ss2 == null) {
            throw new IllegalArgumentException("Null server state(s)");
        }
        int diff = 0;
        for (Short serverId : ss1.list.keySet()) {
            ChangeNumber cn1 = ss1.list.get(serverId);
            if (cn1 == null) continue;
            ChangeNumber cn2 = ss2.list.get(serverId);
            if (cn2 != null) {
                diff += ChangeNumber.diffSeqNum(cn1, cn2);
                continue;
            }
            diff += cn1.getSeqnum();
        }
        return diff;
    }

    public void setSaved(boolean b) {
        this.saved = b;
    }

    public boolean isSaved() {
        return this.saved;
    }
}

