/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AttributeTypeDescriptionAttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTypeSyntax
extends AttributeSyntax<AttributeTypeDescriptionAttributeSyntaxCfg>
implements ConfigurationChangeListener<AttributeTypeDescriptionAttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeTypeDescriptionAttributeSyntaxCfg currentConfig;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    private static boolean stripMinimumUpperBound = false;

    @Override
    public void initializeSyntax(AttributeTypeDescriptionAttributeSyntaxCfg configuration) throws ConfigException, InitializationException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "AttributeTypeDescription");
            throw new InitializationException(message);
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "AttributeTypeDescription");
            throw new InitializationException(message);
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "AttributeTypeDescription");
            throw new InitializationException(message);
        }
        if (configuration == null) {
            return;
        }
        this.currentConfig = configuration;
        this.currentConfig.addAttributeTypeDescriptionChangeListener(this);
        stripMinimumUpperBound = configuration.isStripSyntaxMinUpperBound();
    }

    @Override
    public String getSyntaxName() {
        return "AttributeTypeDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.3";
    }

    @Override
    public String getDescription() {
        return "Attribute Type Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        try {
            AttributeTypeSyntax.decodeAttributeType(value, DirectoryServer.getSchema(), true);
            return true;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }

    public static AttributeType decodeAttributeType(ByteSequence value, Schema schema, boolean allowUnknownElements) throws DirectoryException {
        Message message;
        char c;
        int pos;
        String valueStr = ((Object)value).toString();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            Message message2 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EMPTY_VALUE.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message2);
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            Message message3 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EXPECTED_OPEN_PARENTHESIS.get(valueStr, pos - 1, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message3);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message4 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message4);
        }
        int oidStartPos = pos;
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos)) != ' ' && (c = valueStr.charAt(pos)) != ')') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message5 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_DOUBLE_PERIOD_IN_NUMERIC_OID.get(valueStr, pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message5);
                    }
                    lastWasPeriod = true;
                } else {
                    if (!StaticUtils.isDigit(c)) {
                        Message message6 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message6);
                    }
                    lastWasPeriod = false;
                }
                ++pos;
            }
        } else {
            while (pos < length && (c = valueStr.charAt(pos)) != ' ' && (c = valueStr.charAt(pos)) != ')') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    ++pos;
                    continue;
                }
                Message message7 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_STRING_OID.get(valueStr, String.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message7);
            }
        }
        if (pos >= length) {
            Message message8 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message8);
        }
        String oid = lowerStr.substring(oidStartPos, pos);
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message9 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message9);
        }
        String primaryName = oid;
        LinkedList<String> typeNames = new LinkedList<String>();
        String description = null;
        AttributeType superiorType = null;
        AttributeSyntax syntax = DirectoryServer.getDefaultAttributeSyntax();
        ApproximateMatchingRule approximateMatchingRule = null;
        EqualityMatchingRule equalityMatchingRule = null;
        OrderingMatchingRule orderingMatchingRule = null;
        SubstringMatchingRule substringMatchingRule = null;
        AttributeUsage attributeUsage = AttributeUsage.USER_APPLICATIONS;
        boolean isCollective = false;
        boolean isNoUserModification = false;
        boolean isObsolete = false;
        boolean isSingleValue = false;
        LinkedHashMap<String, List<String>> extraProperties = new LinkedHashMap<String, List<String>>();
        block9: while (true) {
            Message message10;
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = AttributeTypeSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
            String tokenName = tokenNameBuffer.toString();
            String lowerTokenName = StaticUtils.toLowerCase(tokenName);
            if (tokenName.equals(")")) {
                if (pos >= length) break;
                Message message11 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_UNEXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message11);
            }
            if (lowerTokenName.equals("name")) {
                block76: {
                    StringBuilder lowerBuffer;
                    StringBuilder userBuffer;
                    if ((c = valueStr.charAt(pos++)) == '\'') {
                        userBuffer = new StringBuilder();
                        lowerBuffer = new StringBuilder();
                        pos = AttributeTypeSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                        primaryName = userBuffer.toString();
                        typeNames.add(primaryName);
                    } else {
                        if (c == '(') {
                            userBuffer = new StringBuilder();
                            lowerBuffer = new StringBuilder();
                            pos = AttributeTypeSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                            primaryName = userBuffer.toString();
                            typeNames.add(primaryName);
                            while (true) {
                                if (valueStr.charAt(pos) == ')') {
                                    ++pos;
                                    while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
                                        ++pos;
                                    }
                                    break block76;
                                }
                                userBuffer = new StringBuilder();
                                lowerBuffer = new StringBuilder();
                                pos = AttributeTypeSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                                typeNames.add(userBuffer.toString());
                            }
                        }
                        Message message12 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message12);
                    }
                }
                boolean allowExceptions = DirectoryServer.isRunning() ? DirectoryServer.allowAttributeNameExceptions() : true;
                Iterator i$ = typeNames.iterator();
                block12: while (true) {
                    if (!i$.hasNext()) continue block9;
                    String name = (String)i$.next();
                    int index = 0;
                    while (true) {
                        if (index >= name.length()) continue block12;
                        char ch = name.charAt(index);
                        switch (ch) {
                            case '-': {
                                if (index != 0) break;
                                Message msg = SchemaMessages.ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_DASH.get(((Object)value).toString());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, msg);
                            }
                            case '_': {
                                if (index == 0) {
                                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_UNDERSCORE.get(((Object)value).toString(), "ds-cfg-allow-attribute-name-exceptions");
                                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, msg);
                                }
                                if (allowExceptions) break;
                                Message msg = SchemaMessages.ERR_ATTR_SYNTAX_ATTR_ILLEGAL_UNDERSCORE_CHAR.get(((Object)value).toString(), "ds-cfg-allow-attribute-name-exceptions");
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, msg);
                            }
                            default: {
                                if (index == 0 && StaticUtils.isDigit(ch) && !allowExceptions) {
                                    Message message13 = SchemaMessages.ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_DIGIT.get(((Object)value).toString(), Character.valueOf(ch), "ds-cfg-allow-attribute-name-exceptions");
                                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message13);
                                }
                                if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') break;
                                Message msg = SchemaMessages.ERR_ATTR_SYNTAX_ATTR_ILLEGAL_CHAR.get(((Object)value).toString(), Character.valueOf(ch), index);
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, msg);
                            }
                        }
                        ++index;
                    }
                    break;
                }
            }
            if (lowerTokenName.equals("desc")) {
                StringBuilder descriptionBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                description = descriptionBuffer.toString();
                continue;
            }
            if (lowerTokenName.equals("obsolete")) {
                isObsolete = true;
                continue;
            }
            if (lowerTokenName.equals("sup")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readWOID(lowerStr, woidBuffer, pos);
                superiorType = schema.getAttributeType(woidBuffer.toString());
                if (superiorType == null) {
                    if (allowUnknownElements) {
                        superiorType = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                    } else {
                        Message message14 = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUPERIOR_TYPE.get(String.valueOf(oid), String.valueOf(woidBuffer));
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message14);
                    }
                }
                approximateMatchingRule = superiorType.getApproximateMatchingRule();
                equalityMatchingRule = superiorType.getEqualityMatchingRule();
                orderingMatchingRule = superiorType.getOrderingMatchingRule();
                substringMatchingRule = superiorType.getSubstringMatchingRule();
                syntax = superiorType.getSyntax();
                isSingleValue = superiorType.isSingleValue();
                isCollective = superiorType.isCollective();
                isNoUserModification = superiorType.isNoUserModification();
                attributeUsage = superiorType.getUsage();
                continue;
            }
            if (lowerTokenName.equals("equality")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readWOID(lowerStr, woidBuffer, pos);
                EqualityMatchingRule emr = schema.getEqualityMatchingRule(woidBuffer.toString());
                if (emr == null) {
                    message10 = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_EQUALITY_MR.get(String.valueOf(oid), String.valueOf(woidBuffer));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message10);
                }
                equalityMatchingRule = emr;
                continue;
            }
            if (lowerTokenName.equals("ordering")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readWOID(lowerStr, woidBuffer, pos);
                OrderingMatchingRule omr = schema.getOrderingMatchingRule(woidBuffer.toString());
                if (omr == null) {
                    message10 = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_ORDERING_MR.get(String.valueOf(oid), String.valueOf(woidBuffer));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message10);
                }
                orderingMatchingRule = omr;
                continue;
            }
            if (lowerTokenName.equals("substr")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readWOID(lowerStr, woidBuffer, pos);
                SubstringMatchingRule smr = schema.getSubstringMatchingRule(woidBuffer.toString());
                if (smr == null) {
                    message10 = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUBSTRING_MR.get(String.valueOf(oid), String.valueOf(woidBuffer));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message10);
                }
                substringMatchingRule = smr;
                continue;
            }
            if (lowerTokenName.equals("syntax")) {
                boolean inBrace = false;
                boolean lastWasPeriod = false;
                StringBuilder oidBuffer = new StringBuilder();
                while (pos < length) {
                    c = lowerStr.charAt(pos++);
                    if (inBrace) {
                        if (c == '}') {
                            c = lowerStr.charAt(pos);
                            if (c == ' ' || (c = lowerStr.charAt(pos)) == ')') break;
                            Message message15 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message15);
                        }
                        if (StaticUtils.isDigit(c)) continue;
                        Message message16 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message16);
                    }
                    if (StaticUtils.isDigit(c)) {
                        oidBuffer.append(c);
                        lastWasPeriod = false;
                        continue;
                    }
                    if (c == '.') {
                        if (lastWasPeriod) {
                            Message message17 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_DOUBLE_PERIOD_IN_NUMERIC_OID.get(valueStr, pos - 1);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message17);
                        }
                        oidBuffer.append(c);
                        lastWasPeriod = true;
                        continue;
                    }
                    if (c == '{') {
                        inBrace = true;
                        continue;
                    }
                    if (c == ' ') break;
                    if (c == ')') {
                        --pos;
                        break;
                    }
                    Message message18 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message18);
                }
                if ((syntax = schema.getSyntax(oidBuffer.toString())) == null) {
                    Message message19 = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SYNTAX.get(String.valueOf(oid), String.valueOf(oidBuffer));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message19);
                }
                if (approximateMatchingRule == null) {
                    approximateMatchingRule = syntax.getApproximateMatchingRule();
                }
                if (equalityMatchingRule == null) {
                    equalityMatchingRule = syntax.getEqualityMatchingRule();
                }
                if (orderingMatchingRule == null) {
                    orderingMatchingRule = syntax.getOrderingMatchingRule();
                }
                if (substringMatchingRule != null) continue;
                substringMatchingRule = syntax.getSubstringMatchingRule();
                continue;
            }
            if (lowerTokenName.equals("single-value")) {
                isSingleValue = true;
                continue;
            }
            if (lowerTokenName.equals("collective")) {
                isCollective = true;
                continue;
            }
            if (lowerTokenName.equals("no-user-modification")) {
                isNoUserModification = true;
                continue;
            }
            if (lowerTokenName.equals("usage")) {
                String usageStr;
                StringBuilder usageBuffer = new StringBuilder();
                while (pos < length && (c = lowerStr.charAt(pos++)) != ' ') {
                    if (c == ')') {
                        --pos;
                        break;
                    }
                    usageBuffer.append(c);
                }
                if ((usageStr = usageBuffer.toString()).equals("userapplications")) {
                    attributeUsage = AttributeUsage.USER_APPLICATIONS;
                    continue;
                }
                if (usageStr.equals("directoryoperation")) {
                    attributeUsage = AttributeUsage.DIRECTORY_OPERATION;
                    continue;
                }
                if (usageStr.equals("distributedoperation")) {
                    attributeUsage = AttributeUsage.DISTRIBUTED_OPERATION;
                    continue;
                }
                if (usageStr.equals("dsaoperation")) {
                    attributeUsage = AttributeUsage.DSA_OPERATION;
                    continue;
                }
                attributeUsage = AttributeUsage.USER_APPLICATIONS;
                message10 = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_ATTRIBUTE_USAGE.get(String.valueOf(oid), usageStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message10);
            }
            ArrayList<String> valueList = new ArrayList<String>();
            pos = AttributeTypeSyntax.readExtraParameterValues(valueStr, valueList, pos);
            extraProperties.put(tokenName, valueList);
        }
        List approxRules = (List)((HashMap)extraProperties).get("X-APPROX");
        if (approxRules != null && !approxRules.isEmpty()) {
            String ruleName = (String)approxRules.get(0);
            String lowerName = StaticUtils.toLowerCase(ruleName);
            ApproximateMatchingRule amr = schema.getApproximateMatchingRule(lowerName);
            if (amr == null) {
                Message message20 = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_APPROXIMATE_MR.get(String.valueOf(oid), String.valueOf(ruleName));
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message20);
            }
            approximateMatchingRule = amr;
        }
        if (superiorType != null) {
            if (superiorType.getUsage() != attributeUsage) {
                message = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_SUPERIOR_USAGE.get(oid, String.valueOf((Object)attributeUsage), superiorType.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            if (superiorType.isCollective() != isCollective) {
                message = isCollective ? SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_COLLECTIVE_FROM_NONCOLLECTIVE.get(oid, superiorType.getNameOrOID()) : SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_NONCOLLECTIVE_FROM_COLLECTIVE.get(oid, superiorType.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
        }
        if (isCollective && attributeUsage != AttributeUsage.USER_APPLICATIONS) {
            message = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_COLLECTIVE_IS_OPERATIONAL.get(oid);
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (isNoUserModification && attributeUsage == AttributeUsage.USER_APPLICATIONS) {
            message = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_NO_USER_MOD_NOT_OPERATIONAL.get(oid);
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        return new AttributeType(((Object)value).toString(), primaryName, typeNames, oid, description, superiorType, syntax, approximateMatchingRule, equalityMatchingRule, orderingMatchingRule, substringMatchingRule, attributeUsage, isCollective, isNoUserModification, isObsolete, isSingleValue, extraProperties);
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) != ' ' && (c = valueStr.charAt(startPos)) != ')') {
            tokenName.append(c);
            ++startPos;
        }
        if (tokenName.length() == 0 && c == ')') {
            tokenName.append(c);
            ++startPos;
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_DOUBLE_PERIOD_IN_NUMERIC_OID.get(lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_NUMERIC_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_STRING_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        } else {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR.get(lowerStr, String.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, List<String> valueList, int startPos) throws DirectoryException {
        StringBuilder valueBuffer;
        int length = valueStr.length();
        char c = valueStr.charAt(startPos++);
        while (startPos < length && c == ' ') {
            c = valueStr.charAt(startPos++);
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c == '\'') {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != '\'') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        } else if (c == '(') {
            while (true) {
                ++startPos;
                while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                    ++startPos;
                }
                if (startPos >= length) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                if (c != ')') {
                    if (c == '(') {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), startPos);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    startPos = AttributeTypeSyntax.readExtraParameterValues(valueStr, valueList, startPos);
                    continue;
                }
                break;
            }
        } else {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AttributeTypeDescriptionAttributeSyntaxCfg configuration) {
        this.currentConfig = configuration;
        stripMinimumUpperBound = configuration.isStripSyntaxMinUpperBound();
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AttributeTypeDescriptionAttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public static boolean isStripSyntaxMinimumUpperBound() {
        return stripMinimumUpperBound;
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

