/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GetPropSubCommandHandler
extends SubCommandHandler {
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final SubCommand subCommand;

    public static GetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(parser, path.child(r, "DUMMY"), r);
    }

    public static GetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(parser, path.child(r), r);
    }

    public static GetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SetRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(parser, path.child(r), r);
    }

    public static GetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SingletonRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(parser, path.child(r), r);
    }

    private GetPropSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> r) throws ArgumentException {
        this.path = path;
        String name = "get-" + r.getName() + "-prop";
        Message message = DSConfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_GETPROP.get(r.getChildDefinition().getUserFriendlyName());
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, message);
        this.namingArgs = this.createNamingArgs(this.subCommand, path, false);
        this.registerPropertyNameArgument(this.subCommand);
        this.registerRecordModeArgument(this.subCommand);
        this.registerUnitSizeArgument(this.subCommand);
        this.registerUnitTimeArgument(this.subCommand);
        this.addTags(path.getManagedObjectDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.path.getRelationDefinition();
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, ManagementContextFactory factory) throws ArgumentException, ClientException, CLIException {
        TablePrinter printer;
        Collection<PropertyDefinition<?>> pdList;
        MenuResult<ManagedObject<?>> result;
        Set<String> propertyNames = this.getPropertyNames();
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(this.getSizeUnit(), this.getTimeUnit(), app.isScriptFriendly());
        List<String> names = this.getNamingArgValues(app, this.namingArgs);
        this.getCommandBuilder().clearArguments();
        this.setCommandBuilderUseful(false);
        this.updateCommandBuilderWithSubCommand();
        Message ufn = this.path.getRelationDefinition().getUserFriendlyName();
        ManagementContext context = factory.getManagementContext(app);
        try {
            result = this.getManagedObject(app, context, this.path, names);
        }
        catch (AuthorizationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_AUTHZ.get(ufn);
            throw new ClientException(50, msg);
        }
        catch (DefinitionDecodingException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get(ufn, ufn, ufn);
            throw new ClientException(80, msg);
        }
        catch (ManagedObjectDecodingException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get(ufn);
            throw new ClientException(80, msg, e);
        }
        catch (CommunicationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_CE.get(ufn, e.getMessage());
            throw new ClientException(81, msg);
        }
        catch (ConcurrentModificationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_CME.get(ufn);
            throw new ClientException(19, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get(ufn);
            throw new ClientException(32, msg);
        }
        if (result.isQuit()) {
            return MenuResult.quit();
        }
        if (result.isCancel()) {
            return MenuResult.cancel();
        }
        ManagedObject<?> child = result.getValue();
        ManagedObjectDefinition<?, Configuration> d = child.getManagedObjectDefinition();
        if (propertyNames.isEmpty()) {
            pdList = d.getAllPropertyDefinitions();
        } else {
            pdList = new LinkedList();
            for (String name : propertyNames) {
                try {
                    pdList.add(d.getPropertyDefinition(name));
                }
                catch (IllegalArgumentException e) {
                    throw ArgumentExceptionFactory.unknownProperty(d, name);
                }
            }
        }
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_VALUE.get());
        builder.addSortKey(0);
        for (PropertyDefinition<?> pd : pdList) {
            if (pd.hasOption(PropertyOption.HIDDEN) || !app.isAdvancedMode() && pd.hasOption(PropertyOption.ADVANCED) || !propertyNames.isEmpty() && !propertyNames.contains(pd.getName())) continue;
            this.displayProperty(app, builder, child, pd, valuePrinter);
            this.setCommandBuilderUseful(true);
        }
        PrintStream out = app.getOutputStream();
        if (app.isScriptFriendly()) {
            printer = this.createScriptFriendlyTablePrinter(out);
            builder.print(printer);
        } else {
            printer = new TextTablePrinter(out);
            ((TextTablePrinter)printer).setColumnSeparator(":");
            ((TextTablePrinter)printer).setColumnWidth(1, 0);
            builder.print(printer);
        }
        return MenuResult.success(0);
    }

    private <T> void displayProperty(final ConsoleApplication app, TableBuilder builder, ManagedObject<?> mo, PropertyDefinition<T> pd, PropertyValuePrinter valuePrinter) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        if (values.isEmpty()) {
            DefaultBehaviorProviderVisitor visitor = new DefaultBehaviorProviderVisitor<T, Message, Void>(){

                @Override
                public Message visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public Message visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
                    if (app.isVerbose()) {
                        return d.getSynopsis();
                    }
                    return null;
                }

                @Override
                public Message visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public Message visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public Message visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
                    return null;
                }
            };
            builder.startRow();
            builder.appendCell(pd.getName());
            Message content = (Message)pd.getDefaultBehaviorProvider().accept(visitor, null);
            if (content == null) {
                if (app.isScriptFriendly()) {
                    builder.appendCell();
                } else {
                    builder.appendCell("-");
                }
            } else {
                builder.appendCell(content);
            }
        } else if (this.isRecordMode()) {
            for (Object value : values) {
                builder.startRow();
                builder.appendCell(pd.getName());
                builder.appendCell(valuePrinter.print(pd, value));
            }
        } else {
            builder.startRow();
            builder.appendCell(pd.getName());
            if (app.isScriptFriendly()) {
                for (Object value : values) {
                    builder.appendCell(valuePrinter.print(pd, value));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                boolean isFirst = true;
                for (Object value : values) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append(valuePrinter.print(pd, value));
                    isFirst = false;
                }
                builder.appendCell(sb.toString());
            }
        }
    }
}

