/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DebugLogLevel;

public final class ByteStringBuilder
implements ByteSequence {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private byte[] buffer;
    private int length;

    public ByteStringBuilder() {
        this(32);
    }

    public ByteStringBuilder(int capacity) throws IllegalArgumentException {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new byte[capacity];
        this.length = 0;
    }

    public ByteStringBuilder append(byte b) {
        this.ensureAdditionalCapacity(1);
        this.buffer[this.length++] = b;
        return this;
    }

    public ByteStringBuilder append(byte[] b) {
        return this.append(b, 0, b.length);
    }

    public ByteStringBuilder append(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
        ByteString.checkArrayBounds(b, offset, length);
        if (length != 0) {
            this.ensureAdditionalCapacity(length);
            System.arraycopy(b, offset, this.buffer, this.length, length);
            this.length += length;
        }
        return this;
    }

    public ByteStringBuilder append(ByteBuffer buffer, int length) throws IndexOutOfBoundsException {
        if (length < 0 || length > buffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        if (length != 0) {
            this.ensureAdditionalCapacity(length);
            buffer.get(this.buffer, this.length, length);
            this.length += length;
        }
        return this;
    }

    public ByteStringBuilder append(ByteSequence bytes) {
        return bytes.copyTo(this);
    }

    public ByteStringBuilder append(ByteSequenceReader reader, int length) throws IndexOutOfBoundsException {
        if (length < 0 || length > reader.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        if (length != 0) {
            this.ensureAdditionalCapacity(length);
            reader.get(this.buffer, this.length, length);
            this.length += length;
        }
        return this;
    }

    public int append(InputStream stream, int length) throws IndexOutOfBoundsException, IOException {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureAdditionalCapacity(length);
        int bytesRead = stream.read(this.buffer, this.length, length);
        if (bytesRead > 0) {
            this.length += bytesRead;
        }
        return bytesRead;
    }

    public ByteStringBuilder append(short i) {
        this.ensureAdditionalCapacity(2);
        for (int j = this.length + 1; j >= this.length; --j) {
            this.buffer[j] = (byte)(i & 0xFF);
            i = (short)(i >>> 8);
        }
        this.length += 2;
        return this;
    }

    public ByteStringBuilder append(int i) {
        this.ensureAdditionalCapacity(4);
        for (int j = this.length + 3; j >= this.length; --j) {
            this.buffer[j] = (byte)(i & 0xFF);
            i >>>= 8;
        }
        this.length += 4;
        return this;
    }

    public ByteStringBuilder append(long l) {
        this.ensureAdditionalCapacity(8);
        for (int i = this.length + 7; i >= this.length; --i) {
            this.buffer[i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        this.length += 8;
        return this;
    }

    public ByteStringBuilder append(String s) {
        if (s == null) {
            return this;
        }
        int len = s.length();
        this.ensureAdditionalCapacity(len);
        for (int i = 0; i < len; ++i) {
            byte b;
            char c = s.charAt(i);
            if (c != (b = (byte)(c & 0x7F))) {
                try {
                    return this.append(s.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return this.append(s.getBytes());
                }
            }
            this.buffer[this.length + i] = b;
        }
        this.length += len;
        return this;
    }

    public ByteStringBuilder appendBERLength(int length) {
        if ((length & 0x7F) == length) {
            this.ensureAdditionalCapacity(1);
            this.buffer[this.length++] = (byte)(length & 0xFF);
        } else if ((length & 0xFF) == length) {
            this.ensureAdditionalCapacity(2);
            this.buffer[this.length++] = -127;
            this.buffer[this.length++] = (byte)(length & 0xFF);
        } else if ((length & 0xFFFF) == length) {
            this.ensureAdditionalCapacity(3);
            this.buffer[this.length++] = -126;
            this.buffer[this.length++] = (byte)(length >> 8 & 0xFF);
            this.buffer[this.length++] = (byte)(length & 0xFF);
        } else if ((length & 0xFFFFFF) == length) {
            this.ensureAdditionalCapacity(4);
            this.buffer[this.length++] = -125;
            this.buffer[this.length++] = (byte)(length >> 16 & 0xFF);
            this.buffer[this.length++] = (byte)(length >> 8 & 0xFF);
            this.buffer[this.length++] = (byte)(length & 0xFF);
        } else {
            this.ensureAdditionalCapacity(5);
            this.buffer[this.length++] = -124;
            this.buffer[this.length++] = (byte)(length >> 24 & 0xFF);
            this.buffer[this.length++] = (byte)(length >> 16 & 0xFF);
            this.buffer[this.length++] = (byte)(length >> 8 & 0xFF);
            this.buffer[this.length++] = (byte)(length & 0xFF);
        }
        return this;
    }

    public ByteSequenceReader asReader() {
        return new ByteSequenceReader(this);
    }

    public byte byteAt(int index) throws IndexOutOfBoundsException {
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }

    public int compareTo(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
        ByteString.checkArrayBounds(b, offset, length);
        return ByteString.compareTo(this.buffer, 0, this.length, b, offset, length);
    }

    public int compareTo(ByteSequence o) {
        if (this == o) {
            return 0;
        }
        return -o.compareTo(this.buffer, 0, this.length);
    }

    public ByteStringBuilder clear() {
        this.length = 0;
        return this;
    }

    public boolean compress(ByteStringBuilder output, CryptoManager cryptoManager) {
        output.ensureAdditionalCapacity(this.length);
        int compressedSize = cryptoManager.compress(this.buffer, 0, this.length, output.buffer, output.length, output.buffer.length);
        if (compressedSize != -1) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Compression %d/%d%n", compressedSize, this.length);
            }
            output.length += compressedSize;
            return true;
        }
        return false;
    }

    public byte[] copyTo(byte[] b) {
        this.copyTo(b, 0);
        return b;
    }

    public byte[] copyTo(byte[] b, int offset) throws IndexOutOfBoundsException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, 0, b, offset, Math.min(this.length, b.length - offset));
        return b;
    }

    public ByteStringBuilder copyTo(ByteStringBuilder builder) {
        builder.append(this.buffer, 0, this.length);
        return builder;
    }

    public OutputStream copyTo(OutputStream stream) throws IOException {
        stream.write(this.buffer, 0, this.length);
        return stream;
    }

    public ByteStringBuilder ensureAdditionalCapacity(int size) {
        int newCount = this.length + size;
        if (newCount > this.buffer.length) {
            byte[] newbuffer = new byte[Math.max(this.buffer.length << 1, newCount)];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.buffer.length);
            this.buffer = newbuffer;
        }
        return this;
    }

    public boolean equals(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
        ByteString.checkArrayBounds(b, offset, length);
        return ByteString.equals(this.buffer, 0, this.length, b, offset, length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)o;
            return other.equals(this.buffer, 0, this.length);
        }
        return false;
    }

    public byte[] getBackingArray() {
        return this.buffer;
    }

    public int hashCode() {
        return ByteString.hashCode(this.buffer, 0, this.length);
    }

    public int length() {
        return this.length;
    }

    public ByteSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        if (start < 0 || start > end || end > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return new SubSequence(start, end - start);
    }

    public byte[] toByteArray() {
        return this.copyTo(new byte[this.length]);
    }

    public ByteString toByteString() {
        byte[] b = new byte[this.length];
        System.arraycopy(this.buffer, 0, b, 0, this.length);
        return ByteString.wrap(b);
    }

    public String toString() {
        return ByteString.toString(this.buffer, 0, this.length);
    }

    public ByteStringBuilder trimToSize() {
        if (this.buffer.length > this.length) {
            byte[] newBuffer = new byte[this.length];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
            this.buffer = newBuffer;
        }
        return this;
    }

    public boolean uncompress(ByteStringBuilder output, CryptoManager cryptoManager, int uncompressedSize) throws DataFormatException {
        int decompressResult;
        if (uncompressedSize > 0) {
            output.ensureAdditionalCapacity(uncompressedSize);
        }
        if ((decompressResult = cryptoManager.uncompress(this.buffer, 0, this.length, output.buffer, output.length, output.buffer.length)) < 0) {
            output.ensureAdditionalCapacity(-decompressResult);
            decompressResult = cryptoManager.uncompress(this.buffer, 0, this.length, output.buffer, output.length, output.buffer.length);
        }
        if (decompressResult >= 0) {
            output.length += decompressResult;
            return true;
        }
        return false;
    }

    private final class SubSequence
    implements ByteSequence {
        private final int subLength;
        private final int subOffset;

        private SubSequence(int offset, int length) {
            this.subOffset = offset;
            this.subLength = length;
        }

        public ByteSequenceReader asReader() {
            return new ByteSequenceReader(this);
        }

        public byte byteAt(int index) throws IndexOutOfBoundsException {
            if (index >= this.subLength || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            return ByteStringBuilder.this.buffer[this.subOffset + index];
        }

        public int compareTo(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
            ByteString.checkArrayBounds(b, offset, length);
            return ByteString.compareTo(ByteStringBuilder.this.buffer, this.subOffset, this.subLength, b, offset, length);
        }

        public int compareTo(ByteSequence o) {
            if (this == o) {
                return 0;
            }
            return -o.compareTo(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
        }

        public byte[] copyTo(byte[] b) {
            this.copyTo(b, 0);
            return b;
        }

        public byte[] copyTo(byte[] b, int offset) throws IndexOutOfBoundsException {
            if (offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(ByteStringBuilder.this.buffer, this.subOffset, b, offset, Math.min(this.subLength, b.length - offset));
            return b;
        }

        public ByteStringBuilder copyTo(ByteStringBuilder builder) {
            return builder.append(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
        }

        public OutputStream copyTo(OutputStream stream) throws IOException {
            stream.write(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
            return stream;
        }

        public boolean equals(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
            ByteString.checkArrayBounds(b, offset, length);
            return ByteString.equals(ByteStringBuilder.this.buffer, this.subOffset, this.subLength, b, offset, length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ByteSequence) {
                ByteSequence other = (ByteSequence)o;
                return other.equals(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
            }
            return false;
        }

        public int hashCode() {
            return ByteString.hashCode(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
        }

        public int length() {
            return this.subLength;
        }

        public ByteSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
            if (start < 0 || start > end || end > this.subLength) {
                throw new IndexOutOfBoundsException();
            }
            return new SubSequence(this.subOffset + start, end - start);
        }

        public byte[] toByteArray() {
            return this.copyTo(new byte[this.subLength]);
        }

        public ByteString toByteString() {
            byte[] b = new byte[this.subLength];
            System.arraycopy(ByteStringBuilder.this.buffer, this.subOffset, b, 0, this.subLength);
            return ByteString.wrap(b);
        }

        public String toString() {
            return ByteString.toString(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
        }
    }
}

