/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.AbstractIndexPanel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.Schema;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.cli.CommandBuilder;

public class NewIndexPanel
extends AbstractIndexPanel {
    private static final long serialVersionUID = -3516011638125862137L;
    private Component relativeComponent;
    private Schema schema;
    private IndexDescriptor newIndex;

    public NewIndexPanel(String backendName, Component relativeComponent) {
        this.backendName.setText(backendName);
        this.relativeComponent = relativeComponent;
        this.createLayout();
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_INDEX_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.attributes;
    }

    public void update(BackendDescriptor backend) {
        this.backendName.setText(backend.getBackendID());
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        Schema s = desc.getSchema();
        final boolean[] repack = new boolean[]{false};
        final boolean[] error = new boolean[]{false};
        if (s != null) {
            this.schema = s;
            repack[0] = this.attributes.getItemCount() == 0;
            LinkedHashSet<CategorizedComboBoxElement> newElements = new LinkedHashSet<CategorizedComboBoxElement>();
            BackendDescriptor backend = null;
            for (BackendDescriptor b : this.getInfo().getServerDescriptor().getBackends()) {
                if (!b.getBackendID().equalsIgnoreCase(this.backendName.getText())) continue;
                backend = b;
                break;
            }
            TreeSet<String> standardAttrNames = new TreeSet<String>();
            TreeSet<String> configurationAttrNames = new TreeSet<String>();
            TreeSet<String> customAttrNames = new TreeSet<String>();
            for (AttributeType attr : this.schema.getAttributeTypes().values()) {
                String name = attr.getPrimaryName();
                boolean defined = false;
                if (backend != null) {
                    for (IndexDescriptor index : backend.getIndexes()) {
                        if (!index.getName().equalsIgnoreCase(name)) continue;
                        defined = true;
                        break;
                    }
                }
                if (defined) continue;
                if (Utilities.isStandard(attr)) {
                    standardAttrNames.add(name);
                    continue;
                }
                if (Utilities.isConfiguration(attr)) {
                    configurationAttrNames.add(name);
                    continue;
                }
                customAttrNames.add(name);
            }
            if (customAttrNames.size() > 0) {
                newElements.add(new CategorizedComboBoxElement(this.CUSTOM_ATTRIBUTES, CategorizedComboBoxElement.Type.CATEGORY));
                for (String attrName : customAttrNames) {
                    newElements.add(new CategorizedComboBoxElement(attrName, CategorizedComboBoxElement.Type.REGULAR));
                }
            }
            if (standardAttrNames.size() > 0) {
                newElements.add(new CategorizedComboBoxElement(this.STANDARD_ATTRIBUTES, CategorizedComboBoxElement.Type.CATEGORY));
                for (String attrName : standardAttrNames) {
                    newElements.add(new CategorizedComboBoxElement(attrName, CategorizedComboBoxElement.Type.REGULAR));
                }
            }
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.attributes.getModel();
            this.updateComboBoxModel(newElements, model);
        } else {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
            repack[0] = true;
            error[0] = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewIndexPanel.this.setEnabledOK(!error[0]);
                NewIndexPanel.this.errorPane.setVisible(error[0]);
                if (repack[0]) {
                    NewIndexPanel.this.packParentDialog();
                    if (NewIndexPanel.this.relativeComponent != null) {
                        Utilities.centerGoldenMean(Utilities.getParentDialog(NewIndexPanel.this), NewIndexPanel.this.relativeComponent);
                    }
                }
            }
        });
        if (!error[0]) {
            this.updateErrorPaneAndOKButtonIfAuthRequired(desc, AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_NEW_INDEX.get());
        }
    }

    public void okClicked() {
        this.setPrimaryValid(this.lAttribute);
        this.setPrimaryValid(this.lEntryLimit);
        this.setPrimaryValid(this.lType);
        ArrayList<Message> errors = new ArrayList<Message>();
        String attrName = this.getAttributeName();
        if (attrName == null) {
            errors.add(AdminToolMessages.ERR_INFO_CTRL_ATTRIBUTE_NAME_REQUIRED.get());
            this.setPrimaryInvalid(this.lAttribute);
        }
        String v = this.entryLimit.getText();
        try {
            int n = Integer.parseInt(v);
            if (n < this.MIN_ENTRY_LIMIT || n > this.MAX_ENTRY_LIMIT) {
                errors.add(AdminToolMessages.ERR_INFO_CTRL_PANEL_ENTRY_LIMIT_NOT_VALID.get(this.MIN_ENTRY_LIMIT, this.MAX_ENTRY_LIMIT));
                this.setPrimaryInvalid(this.lEntryLimit);
            }
        }
        catch (Throwable t) {
            errors.add(AdminToolMessages.ERR_INFO_CTRL_PANEL_ENTRY_LIMIT_NOT_VALID.get(this.MIN_ENTRY_LIMIT, this.MAX_ENTRY_LIMIT));
            this.setPrimaryInvalid(this.lEntryLimit);
        }
        boolean somethingSelected = false;
        for (JCheckBox type : this.types) {
            boolean bl = somethingSelected = type.isSelected() && type.isVisible();
            if (somethingSelected) break;
        }
        if (!somethingSelected) {
            errors.add(AdminToolMessages.ERR_INFO_ONE_INDEX_TYPE_MUST_BE_SELECTED.get());
            this.setPrimaryInvalid(this.lType);
        }
        ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_NEW_INDEX_TITLE.get(), this.getInfo());
        NewIndexTask newTask = new NewIndexTask(this.getInfo(), dlg);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.size() == 0) {
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_INDEX_SUMMARY.get(attrName), AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_INDEX_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_INDEX_SUCCESSFUL_DETAILS.get(attrName), AdminToolMessages.ERR_CTRL_PANEL_CREATING_NEW_INDEX_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_CREATING_NEW_INDEX_ERROR_DETAILS.get(), null, dlg);
            dlg.setVisible(true);
            Utilities.getParentDialog(this).setVisible(false);
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private String getAttributeName() {
        CategorizedComboBoxElement o = (CategorizedComboBoxElement)this.attributes.getSelectedItem();
        String attrName = o != null ? o.getValue().toString() : null;
        return attrName;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.createBasicLayout(this, gbc, false);
        this.attributes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                String n = NewIndexPanel.this.getAttributeName();
                AttributeType attr = null;
                if (n != null) {
                    attr = NewIndexPanel.this.schema.getAttributeType(n.toLowerCase());
                }
                NewIndexPanel.this.repopulateTypesPanel(attr);
            }
        });
        this.entryLimit.setText(String.valueOf(4000));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NewIndexTask
    extends Task {
        private Set<String> backendSet;
        private String attributeName;
        private int entryLimitValue;
        private SortedSet<LocalDBIndexCfgDefn.IndexType> indexTypes;

        public NewIndexTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
            this.backendSet = new HashSet<String>();
            this.backendSet.add(NewIndexPanel.this.backendName.getText());
            this.attributeName = NewIndexPanel.this.getAttributeName();
            this.entryLimitValue = Integer.parseInt(NewIndexPanel.this.entryLimit.getText());
            this.indexTypes = NewIndexPanel.this.getTypes();
        }

        @Override
        public Task.Type getType() {
            return Task.Type.NEW_INDEX;
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_NEW_INDEX_TASK_DESCRIPTION.get(this.attributeName, NewIndexPanel.this.backendName.getText());
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConfiguration() throws OpenDsException {
            boolean configHandlerUpdated = false;
            try {
                if (!this.isServerRunning()) {
                    configHandlerUpdated = true;
                    this.getInfo().stopPooling();
                    if (this.getInfo().mustDeregisterConfig()) {
                        DirectoryServer.deregisterBaseDN(DN.decode("cn=config"));
                    }
                    DirectoryServer.getInstance().initializeConfiguration(ConfigFileHandler.class.getName(), ConfigReader.configFile);
                    this.getInfo().setMustDeregisterConfig(true);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StringBuilder sb = new StringBuilder();
                            sb.append(NewIndexTask.this.getConfigCommandLineName());
                            List args = NewIndexTask.this.getObfuscatedCommandLineArguments(NewIndexTask.this.getDSConfigCommandLineArguments());
                            args.removeAll(NewIndexTask.this.getConfigCommandLineArguments());
                            for (String arg : args) {
                                sb.append(" " + CommandBuilder.escapeValue(arg));
                            }
                            NewIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_CREATE_INDEX.get() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NewIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_INDEX_PROGRESS.get(NewIndexTask.this.attributeName), ColorAndFontConstants.progressFont));
                    }
                });
                if (this.isServerRunning()) {
                    this.createIndex(this.getInfo().getDirContext());
                } else {
                    this.createIndex();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NewIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    }
                });
            }
            finally {
                if (configHandlerUpdated) {
                    DirectoryServer.getInstance().initializeConfiguration(ConfigReader.configClassName, ConfigReader.configFile);
                    this.getInfo().startPooling();
                }
            }
        }

        private String getIndexLDIF() {
            String dn = Utilities.getRDNString("ds-cfg-backend-id", NewIndexPanel.this.backendName.getText()) + ",cn=Backends,cn=config";
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("dn: " + Utilities.getRDNString("ds-cfg-attribute", this.attributeName) + ",cn=Index," + dn);
            lines.add("objectClass: ds-cfg-local-db-index");
            lines.add("objectClass: top");
            lines.add("ds-cfg-attribute: " + this.attributeName);
            lines.add("ds-cfg-index-entry-limit: " + this.entryLimitValue);
            for (LocalDBIndexCfgDefn.IndexType type : this.indexTypes) {
                lines.add("ds-cfg-index-type: " + type.toString());
            }
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line + ServerConstants.EOL);
            }
            return sb.toString();
        }

        private void createIndex() throws OpenDsException {
            LDIFImportConfig ldifImportConfig = null;
            try {
                Entry backendConfigEntry;
                String ldif = this.getIndexLDIF();
                ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                LDIFReader reader = new LDIFReader(ldifImportConfig);
                while ((backendConfigEntry = reader.readEntry()) != null) {
                    DirectoryServer.getConfigHandler().addEntry(backendConfigEntry, null);
                }
                DirectoryServer.getConfigHandler().writeUpdatedConfig();
            }
            catch (IOException ioe) {
                throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_CONFIGURATION.get(ioe.toString()), (Throwable)ioe);
            }
            finally {
                if (ldifImportConfig != null) {
                    ldifImportConfig.close();
                }
            }
        }

        private void createIndex(InitialLdapContext ctx) throws OpenDsException {
            String ldif = this.getIndexLDIF();
            LDIFImportConfig ldifImportConfig = null;
            try {
                ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                LDIFReader reader = new LDIFReader(ldifImportConfig);
                Entry indexEntry = reader.readEntry();
                BasicAttributes attrs = new BasicAttributes();
                BasicAttribute oc = new BasicAttribute("objectClass");
                Iterator<AttributeValue> it = indexEntry.getObjectClassAttribute().iterator();
                while (it.hasNext()) {
                    oc.add(it.next().getValue().toString());
                }
                attrs.put(oc);
                List<Attribute> odsAttrs = indexEntry.getAttributes();
                for (Attribute odsAttr : odsAttrs) {
                    String attrName = odsAttr.getName();
                    BasicAttribute attr = new BasicAttribute(attrName);
                    it = odsAttr.iterator();
                    while (it.hasNext()) {
                        attr.add(it.next().getValue().toString());
                    }
                    attrs.put(attr);
                }
                StringBuilder sb = new StringBuilder();
                sb.append(this.getConfigCommandLineName());
                List<String> args = this.getObfuscatedCommandLineArguments(this.getDSConfigCommandLineArguments());
                for (String arg : args) {
                    sb.append(" " + CommandBuilder.escapeValue(arg));
                }
                ctx.createSubcontext(indexEntry.getDN().toString(), (Attributes)attrs);
            }
            catch (Throwable t) {
                throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_CONFIGURATION.get(t.toString()), t);
            }
            finally {
                if (ldifImportConfig != null) {
                    ldifImportConfig.close();
                }
            }
        }

        @Override
        protected String getCommandLinePath() {
            return null;
        }

        protected ArrayList<String> getCommandLineArguments() {
            return new ArrayList<String>();
        }

        private String getConfigCommandLineName() {
            if (this.isServerRunning()) {
                return this.getCommandLinePath("dsconfig");
            }
            return null;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                this.updateConfiguration();
                for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                    if (!backend.getBackendID().equalsIgnoreCase(NewIndexPanel.this.backendName.getText())) continue;
                    NewIndexPanel.this.newIndex = new IndexDescriptor(this.attributeName, NewIndexPanel.this.schema.getAttributeType(this.attributeName.toLowerCase()), backend, this.indexTypes, this.entryLimitValue);
                    this.getInfo().registerModifiedIndex(NewIndexPanel.this.newIndex);
                    NewIndexPanel.this.notifyConfigurationElementCreated(NewIndexPanel.this.newIndex);
                    break;
                }
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public void postOperation() {
            if (this.lastException == null && this.state == Task.State.FINISHED_SUCCESSFULLY && NewIndexPanel.this.newIndex != null) {
                NewIndexPanel.this.rebuildIndexIfNecessary(NewIndexPanel.this.newIndex, this.getProgressDialog());
            }
        }

        private ArrayList<String> getDSConfigCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("create-local-db-index");
            args.add("--backend-name");
            args.add(NewIndexPanel.this.backendName.getText());
            args.add("--type");
            args.add("generic");
            args.add("--index-name");
            args.add(this.attributeName);
            for (LocalDBIndexCfgDefn.IndexType type : this.indexTypes) {
                args.add("--set");
                args.add("index-type:" + type.toString());
            }
            args.add("--set");
            args.add("index-entry-limit:" + this.entryLimitValue);
            args.addAll(this.getConnectionCommandLineArguments());
            args.add(this.getNoPropertiesFileArgument());
            args.add("--no-prompt");
            return args;
        }
    }
}

