/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.upgrader.VersionIssueNotifier;
import org.opends.server.util.VersionCompatibilityIssue;

public class UpgradeIssueNotifier
extends VersionIssueNotifier {
    private static final Logger LOG = Logger.getLogger(UpgradeIssueNotifier.class.getName());

    public UpgradeIssueNotifier(UserInteraction ui, BuildInformation current, BuildInformation neu) {
        super(ui, current, neu);
    }

    public void notifyUser() throws ApplicationException {
        Message cont = QuickSetupMessages.INFO_ORACLE_ACTION_PROMPT_CONTINUE.get();
        Message cancel = QuickSetupMessages.INFO_ORACLE_ACTION_PROMPT_CANCEL.get();
        if (this.hasIssues()) {
            List<VersionIssueNotifier.Directive> issues = this.getIssues();
            if (!this.isSupported()) {
                MessageBuilder reason = new MessageBuilder();
                if (issues != null) {
                    for (VersionIssueNotifier.Directive directive : issues) {
                        LOG.log(Level.INFO, "Unsupported upgrade details: " + directive.getMessage());
                        reason.append(directive.getMessage());
                        reason.append(EOL);
                    }
                }
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_UPGRADE_ORACLE_UNSUPPORTED.get(this.currentBuildInfo.toString(), this.newBuildInfo.toString(), reason.toMessage()), null);
            }
            if (this.ui != null) {
                String lineBreak = this.ui.isCLI() ? Constants.LINE_SEPARATOR : "<br>";
                for (VersionIssueNotifier.Directive directive : issues) {
                    Message defaultAction;
                    UserInteraction.MessageType msgType;
                    Message details;
                    Message summary;
                    Message title;
                    switch (directive.getType()) {
                        case ACTION: {
                            title = QuickSetupMessages.INFO_GENERAL_ACTION_REQUIRED.get();
                            summary = QuickSetupMessages.INFO_UPGRADE_ORACLE_ACTION.get();
                            details = new MessageBuilder(directive.getMessage()).append(lineBreak).append(lineBreak).append(QuickSetupMessages.INFO_ORACLE_ACTION_PROMPT.get()).toMessage();
                            msgType = UserInteraction.MessageType.WARNING;
                            defaultAction = cancel;
                            break;
                        }
                        case INFO: {
                            title = QuickSetupMessages.INFO_GENERAL_INFO.get();
                            summary = QuickSetupMessages.INFO_UPGRADE_ORACLE_INFO.get();
                            details = new MessageBuilder(directive.getMessage()).append(lineBreak).append(lineBreak).append(QuickSetupMessages.INFO_ORACLE_INFO_PROMPT.get()).toMessage();
                            msgType = UserInteraction.MessageType.INFORMATION;
                            defaultAction = cont;
                            break;
                        }
                        case WARNING: {
                            title = QuickSetupMessages.INFO_GENERAL_WARNING.get();
                            summary = QuickSetupMessages.INFO_UPGRADE_ORACLE_WARNING.get();
                            details = new MessageBuilder(directive.getMessage()).append(lineBreak).append(lineBreak).append(QuickSetupMessages.INFO_ORACLE_INFO_PROMPT.get()).toMessage();
                            msgType = UserInteraction.MessageType.WARNING;
                            defaultAction = cont;
                            break;
                        }
                        default: {
                            LOG.log(Level.INFO, "Unexpected issue type " + (Object)((Object)directive.getType()));
                            title = Message.EMPTY;
                            summary = Message.EMPTY;
                            details = directive.getMessage();
                            msgType = UserInteraction.MessageType.WARNING;
                            defaultAction = cont;
                        }
                    }
                    if (!cancel.equals(this.ui.confirm(summary, details, title, msgType, new Message[]{cont, cancel}, defaultAction))) continue;
                    throw new ApplicationException(ReturnCode.CANCELLED, QuickSetupMessages.INFO_UPGRADE_CANCELED.get(), null);
                }
            } else {
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_ORACLE_NO_SILENT.get(), null);
            }
        }
    }

    protected Message getLocalizedDetailMessage(VersionCompatibilityIssue.Cause cause) {
        Message msg = cause.getLocalizedUpgradeMessage();
        Set<VersionCompatibilityIssue.Effect> effects = cause.getEffects();
        if (effects.contains((Object)VersionCompatibilityIssue.Effect.UPGRADE_DATA_EXPORT_AND_REIMPORT_REQUIRED)) {
            if (this.ui != null) {
                String lineBreak = this.ui.isCLI() ? Constants.LINE_SEPARATOR : "<br>";
                msg = new MessageBuilder(msg).append(lineBreak).append(this.ui.createUnorderedList(this.getExportImportInstructions())).toMessage();
            } else {
                String lineBreak = Constants.LINE_SEPARATOR;
                msg = new MessageBuilder(msg).append(lineBreak).append(this.createUnorderedList(this.getExportImportInstructions())).toMessage();
            }
        }
        return msg;
    }

    protected boolean isActionRequired(VersionCompatibilityIssue.Cause cause) {
        boolean isAction = false;
        if (cause != null) {
            Set<VersionCompatibilityIssue.Effect> effects = cause.getEffects();
            isAction = effects.contains((Object)VersionCompatibilityIssue.Effect.UPGRADE_DATA_EXPORT_AND_REIMPORT_REQUIRED) || effects.contains((Object)VersionCompatibilityIssue.Effect.UPGRADE_MANUAL_ACTION_REQUIRED) && cause.getLocalizedUpgradeMessage() != null;
        }
        return isAction;
    }

    protected boolean isWarning(VersionCompatibilityIssue.Cause cause) {
        boolean isWarning = false;
        if (cause != null && !this.isActionRequired(cause)) {
            Set<VersionCompatibilityIssue.Effect> effects = cause.getEffects();
            isWarning = effects.contains((Object)VersionCompatibilityIssue.Effect.UPGRADE_SHOW_WARNING_MESSAGE) && cause.getLocalizedUpgradeMessage() != null;
        }
        return isWarning;
    }

    protected boolean isUnsupported(VersionCompatibilityIssue.Cause cause) {
        boolean isUnsupported = false;
        if (cause != null) {
            Set<VersionCompatibilityIssue.Effect> effects = cause.getEffects();
            for (VersionCompatibilityIssue.Effect effect : effects) {
                switch (effect) {
                    case UPGRADE_NOT_POSSIBLE: {
                        isUnsupported = true;
                        break;
                    }
                }
            }
        }
        return isUnsupported;
    }
}

