/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.net.InetAddress;
import java.util.Collection;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.ConnectionCriteria;
import org.opends.server.types.AddressMask;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IPConnectionCriteria
implements ConnectionCriteria {
    private final AddressMask[] allowedClients;
    private final AddressMask[] deniedClients;

    public IPConnectionCriteria(Collection<AddressMask> allowedClients, Collection<AddressMask> deniedClients) {
        this.allowedClients = allowedClients.toArray(new AddressMask[0]);
        this.deniedClients = deniedClients.toArray(new AddressMask[0]);
    }

    @Override
    public boolean matches(ClientConnection connection) {
        InetAddress ipAddr = connection.getRemoteAddress();
        byte[] address = ipAddr.getAddress();
        String hostName = ipAddr.getHostName();
        if (this.deniedClients.length > 0 && AddressMask.maskListContains(address, hostName, this.deniedClients)) {
            return false;
        }
        return this.allowedClients.length <= 0 || AddressMask.maskListContains(address, hostName, this.allowedClients);
    }

    @Override
    public boolean willMatchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        return this.matches(connection);
    }
}

