/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.CancelExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelExtendedOperation
extends ExtendedOperationHandler<CancelExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeExtendedOperationHandler(CancelExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        DirectoryServer.registerSupportedExtension("1.3.6.1.1.8", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.1.8");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        int idToCancel;
        ByteString requestValue = operation.getRequestValue();
        if (requestValue == null) {
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_CANCEL_NO_REQUEST_VALUE.get());
            return;
        }
        try {
            ASN1Reader reader = ASN1.getReader(requestValue);
            reader.readStartSequence();
            idToCancel = (int)reader.readInteger();
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            Message message = ExtensionMessages.ERR_EXTOP_CANCEL_CANNOT_DECODE_REQUEST_VALUE.get(StaticUtils.getExceptionMessage(e));
            operation.appendErrorMessage(message);
            return;
        }
        Message cancelReason = ExtensionMessages.INFO_EXTOP_CANCEL_REASON.get(operation.getMessageID());
        CancelRequest cancelRequest = new CancelRequest(true, cancelReason);
        ClientConnection clientConnection = operation.getClientConnection();
        CancelResult cancelResult = clientConnection.cancelOperation(idToCancel, cancelRequest);
        operation.setResultCode(cancelResult.getResultCode());
        operation.appendErrorMessage(cancelResult.getResponseMessage());
    }

    @Override
    public String getExtendedOperationName() {
        return "Cancel";
    }
}

