/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

public class CounterMonitor {
    private int count = 0;
    private int max = 0;

    private CounterMonitor() {
    }

    private CounterMonitor(CounterMonitor countMonitor) {
        this.count = countMonitor.getCount();
        this.max = countMonitor.getMax();
    }

    public static CounterMonitor getCounter() {
        return new CounterMonitor();
    }

    public CounterMonitor duplicate() {
        return new CounterMonitor(this);
    }

    public void add(CounterMonitor countMonitor) {
        this.count += countMonitor.count;
        if (this.count > this.max && this.count >= countMonitor.max) {
            this.max = this.count;
        } else if (this.max < countMonitor.getMax()) {
            this.max = countMonitor.getMax();
        }
    }

    public void increment() {
        ++this.count;
        if (this.count > this.max) {
            this.max = this.count;
        }
    }

    public void decrement() {
        --this.count;
    }

    public int getCount() {
        return this.count;
    }

    public int getMax() {
        return this.max;
    }

    public void reset() {
        this.count = 0;
        this.max = 0;
    }
}

