/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ReplicationMsg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyMsg
extends ReplicationMsg {
    private List<DSInfo> dsList = new ArrayList<DSInfo>();
    private List<RSInfo> rsList = new ArrayList<RSInfo>();

    public TopologyMsg(byte[] in) throws DataFormatException {
        try {
            long generationId;
            if (in.length < 1 || in[0] != 26) {
                throw new DataFormatException("Input is not a valid " + this.getClass().getCanonicalName());
            }
            int pos = 1;
            for (byte nDsInfo = in[pos++]; nDsInfo > 0 && pos < in.length; nDsInfo = (byte)(nDsInfo - 1)) {
                int length = this.getNextLength(in, pos);
                String serverIdString = new String(in, pos, length, "UTF-8");
                short dsId = Short.valueOf(serverIdString);
                pos += length + 1;
                length = this.getNextLength(in, pos);
                serverIdString = new String(in, pos, length, "UTF-8");
                short rsId = Short.valueOf(serverIdString);
                pos += length + 1;
                length = this.getNextLength(in, pos);
                generationId = Long.valueOf(new String(in, pos, length, "UTF-8"));
                pos += length + 1;
                ServerStatus status = ServerStatus.valueOf(in[pos++]);
                boolean assuredFlag = in[pos++] == 1;
                AssuredMode assuredMode = AssuredMode.valueOf(in[pos++]);
                byte safeDataLevel = in[pos++];
                byte groupId = in[pos++];
                ArrayList<String> refUrls = new ArrayList<String>();
                byte nUrls = in[pos++];
                for (byte nRead = 0; nRead != nUrls && pos < in.length; pos += length + 1, nRead = (byte)(nRead + 1)) {
                    length = this.getNextLength(in, pos);
                    String url = new String(in, pos, length, "UTF-8");
                    refUrls.add(url);
                }
                DSInfo dsInfo = new DSInfo(dsId, rsId, generationId, status, assuredFlag, assuredMode, safeDataLevel, groupId, refUrls);
                this.dsList.add(dsInfo);
            }
            for (byte nRsInfo = in[pos++]; nRsInfo > 0 && pos < in.length; nRsInfo = (byte)(nRsInfo - 1)) {
                int length = this.getNextLength(in, pos);
                String serverIdString = new String(in, pos, length, "UTF-8");
                short id = Short.valueOf(serverIdString);
                pos += length + 1;
                length = this.getNextLength(in, pos);
                generationId = Long.valueOf(new String(in, pos, length, "UTF-8"));
                pos += length + 1;
                byte groupId = in[pos++];
                RSInfo rsInfo = new RSInfo(id, generationId, groupId);
                this.rsList.add(rsInfo);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public TopologyMsg(List<DSInfo> dsList, List<RSInfo> rsList) {
        if (dsList != null) {
            this.dsList = dsList;
        }
        if (rsList != null) {
            this.rsList = rsList;
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            byte[] byteServerId;
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            oStream.write(26);
            oStream.write((byte)this.dsList.size());
            for (DSInfo dsInfo : this.dsList) {
                byteServerId = String.valueOf(dsInfo.getDsId()).getBytes("UTF-8");
                oStream.write(byteServerId);
                oStream.write(0);
                byteServerId = String.valueOf(dsInfo.getRsId()).getBytes("UTF-8");
                oStream.write(byteServerId);
                oStream.write(0);
                oStream.write(String.valueOf(dsInfo.getGenerationId()).getBytes("UTF-8"));
                oStream.write(0);
                oStream.write(dsInfo.getStatus().getValue());
                oStream.write(dsInfo.isAssured() ? 1 : 0);
                oStream.write(dsInfo.getAssuredMode().getValue());
                oStream.write(dsInfo.getSafeDataLevel());
                oStream.write(dsInfo.getGroupId());
                List<String> refUrls = dsInfo.getRefUrls();
                oStream.write(refUrls.size());
                for (String url : refUrls) {
                    oStream.write(url.getBytes("UTF-8"));
                    oStream.write(0);
                }
            }
            oStream.write((byte)this.rsList.size());
            for (RSInfo rsInfo : this.rsList) {
                byteServerId = String.valueOf(rsInfo.getId()).getBytes("UTF-8");
                oStream.write(byteServerId);
                oStream.write(0);
                oStream.write(String.valueOf(rsInfo.getGenerationId()).getBytes("UTF-8"));
                oStream.write(0);
                oStream.write(rsInfo.getGroupId());
            }
            return oStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        String dsStr = "";
        for (DSInfo dsInfo : this.dsList) {
            dsStr = dsStr + dsInfo.toString() + "\n----------------------------\n";
        }
        String rsStr = "";
        for (RSInfo rsInfo : this.rsList) {
            rsStr = rsStr + rsInfo.toString() + "\n----------------------------\n";
        }
        return "TopologyMsg content: \n----------------------------\nCONNECTED DS SERVERS:\n--------------------\n" + dsStr + "CONNECTED RS SERVERS:" + "\n--------------------\n" + rsStr + (rsStr.equals("") ? "----------------------------\n" : "");
    }

    public List<DSInfo> getDsList() {
        return this.dsList;
    }

    public List<RSInfo> getRsList() {
        return this.rsList;
    }
}

