/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.net.SocketException;
import java.util.NoSuchElementException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.util.StaticUtils;

public class ServerWriter
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private ServerHandler handler;
    private ReplicationServerDomain replicationServerDomain;
    private short serverId;
    private short protocolVersion = (short)-1;

    public ServerWriter(ProtocolSession session, short serverId, ServerHandler handler, ReplicationServerDomain replicationServerDomain) {
        super("Replication Writer for " + handler.toString() + " in RS " + replicationServerDomain.getReplicationServer().getServerId());
        this.serverId = serverId;
        this.session = session;
        this.handler = handler;
        this.replicationServerDomain = replicationServerDomain;
        this.protocolVersion = handler.getProtocolVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (DebugLogger.debugEnabled()) {
            if (this.handler.isReplicationServer()) {
                TRACER.debugInfo("Replication server writer starting " + this.serverId);
            } else {
                TRACER.debugInfo("LDAP server writer starting " + this.serverId);
            }
        }
        try {
            while (true) {
                UpdateMsg update;
                if ((update = this.replicationServerDomain.take(this.handler)) == null) {
                    return;
                }
                if (this.handler.isLDAPserver()) {
                    ServerStatus dsStatus = this.handler.getStatus();
                    if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS || dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                        long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                        if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS) {
                            ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_TO_DS_BADGENID.get(Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), update.getChangeNumber().toString(), Short.toString(this.handler.getServerId()), Long.toString(this.handler.getGenerationId()), Long.toString(referenceGenerationId)));
                        }
                        if (dsStatus != ServerStatus.FULL_UPDATE_STATUS) continue;
                        ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_TO_DS_FULLUP.get(Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), update.getChangeNumber().toString(), Short.toString(this.handler.getServerId())));
                        continue;
                    }
                } else {
                    long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                    if (referenceGenerationId != this.handler.getGenerationId() || referenceGenerationId == -1L || this.handler.getGenerationId() == -1L) {
                        ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_TO_RS.get(Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), update.getChangeNumber().toString(), Short.toString(this.handler.getServerId()), Long.toString(this.handler.getGenerationId()), Long.toString(referenceGenerationId)));
                        continue;
                    }
                }
                this.session.publish(update, this.protocolVersion);
                continue;
                break;
            }
        }
        catch (NoSuchElementException e) {
            Message message = ReplicationMessages.NOTE_SERVER_DISCONNECT.get(this.handler.toString(), Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()));
            ErrorLogger.logError(message);
            return;
        }
        catch (SocketException e) {
            Message message = ReplicationMessages.NOTE_SERVER_DISCONNECT.get(this.handler.toString(), Short.toString(this.replicationServerDomain.getReplicationServer().getServerId()));
            ErrorLogger.logError(message);
            return;
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_WRITER_UNEXPECTED_EXCEPTION.get(this.handler.toString() + " " + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            return;
        }
        finally {
            try {
                this.session.close();
            }
            catch (IOException e) {}
            this.replicationServerDomain.stopServer(this.handler);
            if (DebugLogger.debugEnabled()) {
                if (this.handler.isReplicationServer()) {
                    TRACER.debugInfo("Replication server writer stopping " + this.serverId);
                } else {
                    TRACER.debugInfo("LDAP server writer stopping " + this.serverId);
                }
            }
        }
    }
}

