/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.LDAPCompareOptions;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.Base64;
import org.opends.server.util.EmbeddedUtils;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPCompare {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPCompare";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPCompare(AtomicInteger nextMessageID, PrintStream out, PrintStream err) {
        this.nextMessageID = nextMessageID;
        this.out = out;
        this.err = err;
    }

    public void readAndExecute(LDAPConnection connection, String attributeType, byte[] attributeVal, ArrayList<String> lines, LDAPCompareOptions compareOptions) throws IOException, LDAPException {
        for (String line : lines) {
            this.executeCompare(connection, attributeType, attributeVal, line, compareOptions);
        }
    }

    public void readAndExecute(LDAPConnection connection, String attributeType, byte[] attributeVal, Reader reader, LDAPCompareOptions compareOptions) throws IOException, LDAPException {
        BufferedReader in = new BufferedReader(reader);
        String line = null;
        while ((line = in.readLine()) != null) {
            this.executeCompare(connection, attributeType, attributeVal, line, compareOptions);
        }
        in.close();
    }

    private void executeCompare(LDAPConnection connection, String attributeType, byte[] attributeVal, String line, LDAPCompareOptions compareOptions) throws IOException, LDAPException {
        ArrayList<Control> controls = compareOptions.getControls();
        ByteString dnOctetStr = ByteString.valueOf(line);
        ByteString attrValOctetStr = ByteString.wrap(attributeVal);
        CompareRequestProtocolOp protocolOp = new CompareRequestProtocolOp(dnOctetStr, attributeType, attrValOctetStr);
        this.out.println(ToolMessages.INFO_PROCESSING_COMPARE_OPERATION.get(attributeType, String.valueOf(attrValOctetStr), String.valueOf(dnOctetStr)));
        if (!compareOptions.showOperations()) {
            LDAPMessage responseMessage = null;
            try {
                LDAPMessage message = new LDAPMessage(this.nextMessageID.getAndIncrement(), protocolOp, controls);
                connection.getLDAPWriter().writeMessage(message);
                responseMessage = connection.getLDAPReader().readMessage();
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                if (!compareOptions.continueOnError()) {
                    throw new IOException(ae.getMessage());
                }
                Message msg = ToolMessages.INFO_OPERATION_FAILED.get("COMPARE");
                this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                this.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return;
            }
            CompareResponseProtocolOp op = responseMessage.getCompareResponseProtocolOp();
            int resultCode = op.getResultCode();
            Message errorMessage = op.getErrorMessage();
            if (resultCode != 6 && resultCode != 5 && !compareOptions.continueOnError()) {
                Message msg = ToolMessages.INFO_OPERATION_FAILED.get("COMPARE");
                throw new LDAPException(resultCode, errorMessage, msg, op.getMatchedDN(), null);
            }
            if (resultCode == 5) {
                this.out.println(ToolMessages.INFO_COMPARE_OPERATION_RESULT_FALSE.get(line));
            } else if (resultCode == 6) {
                this.out.println(ToolMessages.INFO_COMPARE_OPERATION_RESULT_TRUE.get(line));
            } else {
                Message msg = ToolMessages.INFO_OPERATION_FAILED.get("COMPARE");
                LDAPToolUtils.printErrorMessage(this.err, msg, resultCode, errorMessage, op.getMatchedDN());
            }
        }
    }

    public static void main(String[] args) {
        int retCode = LDAPCompare.mainCompare(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainCompare(String[] args) {
        return LDAPCompare.mainCompare(args, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainCompare(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        int n;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        LDAPCompareOptions compareOptions = new LDAPCompareOptions();
        LDAPConnection connection = null;
        BooleanArgument continueOnError = null;
        BooleanArgument noop = null;
        BooleanArgument saslExternal = null;
        BooleanArgument showUsage = null;
        BooleanArgument startTLS = null;
        BooleanArgument trustAll = null;
        BooleanArgument useSSL = null;
        BooleanArgument verbose = null;
        FileBasedArgument bindPasswordFile = null;
        FileBasedArgument keyStorePasswordFile = null;
        FileBasedArgument trustStorePasswordFile = null;
        IntegerArgument port = null;
        IntegerArgument version = null;
        StringArgument assertionFilter = null;
        StringArgument bindDN = null;
        StringArgument bindPassword = null;
        StringArgument certNickname = null;
        StringArgument controlStr = null;
        StringArgument encodingStr = null;
        StringArgument filename = null;
        StringArgument hostName = null;
        StringArgument keyStorePath = null;
        StringArgument keyStorePassword = null;
        StringArgument saslOptions = null;
        StringArgument trustStorePath = null;
        StringArgument trustStorePassword = null;
        StringArgument propertiesFileArgument = null;
        BooleanArgument noPropertiesFileArgument = null;
        ArrayList<String> dnStrings = new ArrayList<String>();
        String attributeType = null;
        byte[] attributeVal = null;
        InputStreamReader rdr = null;
        Message toolDescription = ToolMessages.INFO_LDAPCOMPARE_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false, true, 1, 0, " 'attribute:value' \"DN\" ...");
        try {
            propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            argParser.addArgument(propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            argParser.addArgument(noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            hostName = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), "localhost", null, ToolMessages.INFO_DESCRIPTION_HOST.get());
            hostName.setPropertyName("hostname");
            argParser.addArgument(hostName);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, ToolMessages.INFO_DESCRIPTION_PORT.get());
            port.setPropertyName("port");
            argParser.addArgument(port);
            useSSL = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", ToolMessages.INFO_DESCRIPTION_USE_SSL.get());
            useSSL.setPropertyName("useSSL");
            argParser.addArgument(useSSL);
            startTLS = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", ToolMessages.INFO_DESCRIPTION_START_TLS.get());
            startTLS.setPropertyName("useStartTLS");
            argParser.addArgument(startTLS);
            bindDN = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDDN.get());
            bindDN.setPropertyName("bindDN");
            argParser.addArgument(bindDN);
            bindPassword = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORD.get());
            bindPassword.setPropertyName("bindPassword");
            argParser.addArgument(bindPassword);
            bindPasswordFile = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get());
            bindPasswordFile.setPropertyName("bindPasswordFile");
            argParser.addArgument(bindPasswordFile);
            filename = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_COMPARE_DESCRIPTION_FILENAME.get());
            filename.setPropertyName("filename");
            argParser.addArgument(filename);
            saslExternal = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", ToolMessages.INFO_DESCRIPTION_USE_SASL_EXTERNAL.get());
            saslExternal.setPropertyName("useSASLExternal");
            argParser.addArgument(saslExternal);
            saslOptions = new StringArgument("saslOption", Character.valueOf('o'), "saslOption", false, true, true, ToolMessages.INFO_SASL_OPTION_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_SASL_PROPERTIES.get());
            saslOptions.setPropertyName("saslOption");
            argParser.addArgument(saslOptions);
            trustAll = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", ToolMessages.INFO_DESCRIPTION_TRUSTALL.get());
            trustAll.setPropertyName("trustAll");
            argParser.addArgument(trustAll);
            keyStorePath = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPATH.get());
            keyStorePath.setPropertyName("keyStorePath");
            argParser.addArgument(keyStorePath);
            keyStorePassword = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, ToolMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD.get());
            keyStorePassword.setPropertyName("keyStorePassword");
            argParser.addArgument(keyStorePassword);
            keyStorePasswordFile = new FileBasedArgument("keyStorePasswordFile", Character.valueOf('u'), "keyStorePasswordFile", false, false, ToolMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD_FILE.get());
            keyStorePasswordFile.setPropertyName("keyStorePasswordFile");
            argParser.addArgument(keyStorePasswordFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, ToolMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
            certNickname.setPropertyName("certNickname");
            argParser.addArgument(certNickname);
            trustStorePath = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, ToolMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPATH.get());
            trustStorePath.setPropertyName("trustStorePath");
            argParser.addArgument(trustStorePath);
            trustStorePassword = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, ToolMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD.get());
            trustStorePassword.setPropertyName("trustStorePassword");
            argParser.addArgument(trustStorePassword);
            trustStorePasswordFile = new FileBasedArgument("trustStorePasswordFile", Character.valueOf('U'), "trustStorePasswordFile", false, false, ToolMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD_FILE.get());
            trustStorePasswordFile.setPropertyName("trustStorePasswordFile");
            argParser.addArgument(trustStorePasswordFile);
            assertionFilter = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, ToolMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get());
            assertionFilter.setPropertyName("assertionFilter");
            argParser.addArgument(assertionFilter);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, ToolMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONTROLS.get());
            controlStr.setPropertyName("control");
            argParser.addArgument(controlStr);
            version = new IntegerArgument("version", Character.valueOf('V'), "ldapVersion", false, false, true, ToolMessages.INFO_PROTOCOL_VERSION_PLACEHOLDER.get(), 3, null, ToolMessages.INFO_DESCRIPTION_VERSION.get());
            version.setPropertyName("ldapVersion");
            argParser.addArgument(version);
            encodingStr = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, ToolMessages.INFO_ENCODING_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_ENCODING.get());
            encodingStr.setPropertyName("encoding");
            argParser.addArgument(encodingStr);
            continueOnError = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", ToolMessages.INFO_DESCRIPTION_CONTINUE_ON_ERROR.get());
            continueOnError.setPropertyName("continueOnError");
            argParser.addArgument(continueOnError);
            noop = new BooleanArgument("no-op", Character.valueOf('n'), "dry-run", ToolMessages.INFO_DESCRIPTION_NOOP.get());
            argParser.addArgument(noop);
            noop.setPropertyName("dry-run");
            verbose = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
            verbose.setPropertyName("verbose");
            argParser.addArgument(verbose);
            showUsage = new BooleanArgument("showUsage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (bindPassword.isPresent() && bindPasswordFile.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(bindPassword.getLongIdentifier(), bindPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        ArrayList<String> attrAndDNStrings = argParser.getTrailingArguments();
        if (attrAndDNStrings.isEmpty()) {
            Message message = ToolMessages.ERR_LDAPCOMPARE_NO_ATTR.get();
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        String attributeString = attrAndDNStrings.remove(0);
        for (String s : attrAndDNStrings) {
            dnStrings.add(s);
        }
        if (dnStrings.isEmpty() && !filename.isPresent()) {
            err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPCOMPARE_NO_DNS.get(), ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (!dnStrings.isEmpty() && filename.isPresent()) {
            err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPCOMPARE_FILENAME_AND_DNS.get(), ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        int idx = attributeString.indexOf(":");
        if (idx == -1) {
            Message message = ToolMessages.ERR_LDAPCOMPARE_INVALID_ATTR_STRING.get(attributeString);
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        attributeType = attributeString.substring(0, idx);
        String remainder = attributeString.substring(idx + 1, attributeString.length());
        if (remainder.length() > 0) {
            char nextChar = remainder.charAt(0);
            if (nextChar == ':') {
                String base64 = remainder.substring(1, remainder.length());
                try {
                    attributeVal = Base64.decode(base64);
                }
                catch (ParseException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    err.println(StaticUtils.wrapText(ToolMessages.INFO_COMPARE_CANNOT_BASE64_DECODE_ASSERTION_VALUE.get(), ServerConstants.MAX_LINE_WIDTH));
                    return 89;
                }
            } else if (nextChar == '<') {
                try {
                    String filePath = remainder.substring(1, remainder.length());
                    attributeVal = LDAPToolUtils.readBytesFromFile(filePath, err);
                }
                catch (Exception e) {
                    err.println(StaticUtils.wrapText(ToolMessages.INFO_COMPARE_CANNOT_READ_ASSERTION_VALUE_FROM_FILE.get(String.valueOf(e)), ServerConstants.MAX_LINE_WIDTH));
                    return 89;
                }
            } else {
                attributeVal = remainder.getBytes();
            }
        } else {
            attributeVal = remainder.getBytes();
        }
        String hostNameValue = hostName.getValue();
        int portNumber = 389;
        try {
            portNumber = port.getIntValue();
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        try {
            int versionNumber = version.getIntValue();
            if (versionNumber != 2 && versionNumber != 3) {
                err.println(StaticUtils.wrapText(ToolMessages.ERR_DESCRIPTION_INVALID_VERSION.get(String.valueOf(versionNumber)), ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            connectionOptions.setVersionNumber(versionNumber);
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        String bindDNValue = bindDN.getValue();
        String fileNameValue = filename.getValue();
        String bindPasswordValue = bindPassword.getValue();
        if (bindPasswordValue != null && bindPasswordValue.equals("-") || !bindPasswordFile.isPresent() && bindDNValue != null && bindPasswordValue == null) {
            try {
                out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(bindDNValue));
                char[] pwChars = PasswordReader.readPassword();
                bindPasswordValue = new String(pwChars);
                while (pwChars.length == 0) {
                    err.println(StaticUtils.wrapText(ToolMessages.INFO_LDAPAUTH_NON_EMPTY_PASSWORD.get(), ServerConstants.MAX_LINE_WIDTH));
                    out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(bindDNValue));
                    pwChars = PasswordReader.readPassword();
                }
                bindPasswordValue = new String(pwChars);
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                err.println(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
        } else if (bindPasswordValue == null) {
            bindPasswordValue = bindPasswordFile.getValue();
        }
        String keyStorePathValue = keyStorePath.getValue();
        String trustStorePathValue = trustStorePath.getValue();
        String keyStorePasswordValue = null;
        if (keyStorePassword.isPresent()) {
            keyStorePasswordValue = keyStorePassword.getValue();
        } else if (keyStorePasswordFile.isPresent()) {
            keyStorePasswordValue = keyStorePasswordFile.getValue();
        }
        String trustStorePasswordValue = null;
        if (trustStorePassword.isPresent()) {
            trustStorePasswordValue = trustStorePassword.getValue();
        } else if (trustStorePasswordFile.isPresent()) {
            trustStorePasswordValue = trustStorePasswordFile.getValue();
        }
        compareOptions.setShowOperations(noop.isPresent());
        compareOptions.setVerbose(verbose.isPresent());
        compareOptions.setContinueOnError(continueOnError.isPresent());
        compareOptions.setEncoding(encodingStr.getValue());
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                LDAPControl ctrl = LDAPToolUtils.getControl(ctrlString, err);
                if (ctrl == null) {
                    Message message = ToolMessages.ERR_TOOL_INVALID_CONTROL_STRING.get(ctrlString);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    err.println(argParser.getUsage());
                    return 89;
                }
                compareOptions.getControls().add(ctrl);
            }
        }
        if (assertionFilter.isPresent()) {
            String filterString = assertionFilter.getValue();
            try {
                LDAPFilter filter = LDAPFilter.decode(filterString);
                LDAPAssertionRequestControl assertionControl = new LDAPAssertionRequestControl(true, filter);
                compareOptions.getControls().add(assertionControl);
            }
            catch (LDAPException le) {
                Message message = ToolMessages.ERR_LDAP_ASSERTION_INVALID_FILTER.get(le.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
        }
        connectionOptions.setSASLExternal(saslExternal.isPresent());
        if (saslOptions.isPresent()) {
            LinkedList<String> values = saslOptions.getValues();
            for (String saslOption : values) {
                boolean val;
                if (!(saslOption.startsWith("mech=") ? !(val = connectionOptions.setSASLMechanism(saslOption)) : !(val = connectionOptions.addSASLProperty(saslOption)))) continue;
                return 89;
            }
        }
        connectionOptions.setUseSSL(useSSL.isPresent());
        connectionOptions.setStartTLS(startTLS.isPresent());
        if (connectionOptions.useSASLExternal()) {
            Message message;
            if (!connectionOptions.useSSL() && !connectionOptions.useStartTLS()) {
                message = ToolMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_SSL_OR_TLS.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            if (keyStorePathValue == null) {
                message = ToolMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_KEYSTORE.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
        }
        LDAPCompare ldapCompare = null;
        try {
            if (initializeServer) {
                EmbeddedUtils.initializeForClientUse();
            }
            SSLConnectionFactory sslConnectionFactory = null;
            if (connectionOptions.useSSL() || connectionOptions.useStartTLS()) {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStorePathValue, keyStorePasswordValue, clientAlias, trustStorePathValue, trustStorePasswordValue);
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            AtomicInteger nextMessageID = new AtomicInteger(1);
            connection = new LDAPConnection(hostNameValue, portNumber, connectionOptions, out, err);
            connection.connectToHost(bindDNValue, bindPasswordValue, nextMessageID);
            ldapCompare = new LDAPCompare(nextMessageID, out, err);
            if (fileNameValue == null && dnStrings.isEmpty()) {
                rdr = new InputStreamReader(System.in);
            } else if (fileNameValue != null) {
                try {
                    rdr = new FileReader(fileNameValue);
                }
                catch (Throwable t) {
                    String details;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, t);
                    }
                    if ((details = t.getMessage()) == null) {
                        details = t.toString();
                    }
                    err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPCOMPARE_ERROR_READING_FILE.get(fileNameValue, details), ServerConstants.MAX_LINE_WIDTH));
                    int n2 = 89;
                    if (connection != null) {
                        if (ldapCompare == null) {
                            connection.close(null);
                        } else {
                            connection.close(ldapCompare.nextMessageID);
                        }
                    }
                    return n2;
                }
            }
            if (rdr != null) {
                ldapCompare.readAndExecute(connection, attributeType, attributeVal, rdr, compareOptions);
            } else {
                ldapCompare.readAndExecute(connection, attributeType, attributeVal, dnStrings, compareOptions);
            }
        }
        catch (LDAPException le) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            LDAPToolUtils.printErrorMessage(err, le.getMessageObject(), le.getResultCode(), le.getMessageObject(), le.getMatchedDN());
            n = code = le.getResultCode();
            return n;
        }
        catch (LDAPConnectionException lce) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, lce);
            }
            LDAPToolUtils.printErrorMessage(err, lce.getMessageObject(), lce.getResultCode(), lce.getMessageObject(), lce.getMatchedDN());
            n = code = lce.getResultCode();
            return n;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            int n3 = 1;
            return n3;
        }
        finally {
            if (connection != null) {
                if (ldapCompare == null) {
                    connection.close(null);
                } else {
                    connection.close(ldapCompare.nextMessageID);
                }
            }
        }
        return 0;
    }
}

