/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.types.Attribute;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public abstract class RawAttribute {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static RawAttribute create(String attributeType) {
        Validator.ensureNotNull(attributeType);
        return new LDAPAttribute(attributeType);
    }

    public static RawAttribute create(String attributeType, String value) {
        Validator.ensureNotNull(attributeType, value);
        return new LDAPAttribute(attributeType, value);
    }

    public static RawAttribute create(String attributeType, ByteString value) {
        Validator.ensureNotNull(attributeType);
        return new LDAPAttribute(attributeType, value);
    }

    public static RawAttribute create(String attributeType, ArrayList<ByteString> values) {
        Validator.ensureNotNull(attributeType);
        return new LDAPAttribute(attributeType, values);
    }

    public static RawAttribute create(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        return new LDAPAttribute(attribute);
    }

    public abstract String getAttributeType();

    public abstract void setAttributeType(String var1);

    public abstract ArrayList<ByteString> getValues();

    public abstract Attribute toAttribute() throws LDAPException;

    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence();
        stream.writeOctetString(this.getAttributeType());
        stream.writeStartSet();
        ArrayList<ByteString> values = this.getValues();
        if (values != null) {
            for (ByteString value : values) {
                stream.writeOctetString(value);
            }
        }
        stream.writeEndSequence();
        stream.writeEndSequence();
    }

    public static LDAPAttribute decode(ASN1Reader reader) throws LDAPException {
        ArrayList<ByteString> values;
        String attributeType;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            attributeType = reader.readOctetStringAsString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DECODE_TYPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readStartSequence();
            values = new ArrayList<ByteString>();
            while (reader.hasNextElement()) {
                values.add(reader.readOctetString());
            }
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DECODE_VALUES.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPAttribute(attributeType, values);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public abstract void toString(StringBuilder var1, int var2);
}

