/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.LicenseFile;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;

public class InstallLicensePanel
extends QuickSetupStepPanel {
    private static final long serialVersionUID = 6209217138897900860L;
    private TextArea detailsTextArea;
    private JCheckBox acceptCheck;

    public InstallLicensePanel(GuiApplication app) {
        super(app);
    }

    protected Message getTitle() {
        return QuickSetupMessages.INFO_LICENSE_PANEL_TITLE.get();
    }

    protected Message getInstructions() {
        Message message;
        if (Utils.isWebStart()) {
            String cmd = Utils.isWindows() ? "setup.bat" : "setup";
            message = QuickSetupMessages.INFO_LICENSE_PANEL_WEBSTART_INSTRUCTIONS.get();
        } else {
            message = QuickSetupMessages.INFO_LICENSE_PANEL_OFFLINE_INSTRUCTIONS.get();
        }
        return message;
    }

    protected Component createInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_LICENSE_DETAILS_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        gbc.insets = UIFactory.getEmptyInsets();
        panel.add((Component)l, gbc);
        this.detailsTextArea = new TextArea();
        this.detailsTextArea.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        this.detailsTextArea.setText(LicenseFile.getText());
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        panel.add((Component)this.detailsTextArea, gbc);
        this.acceptCheck = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_LICENSE_CLICK_LABEL.get(), null, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.acceptCheck.setOpaque(false);
        this.acceptCheck.setSelected(false);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.weighty = 0.0;
        panel.add((Component)this.acceptCheck, gbc);
        this.addActionListeners();
        return panel;
    }

    private void addActionListeners() {
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallLicensePanel.this.getQuickSetup().getDialog().setButtonEnabled(ButtonName.NEXT, InstallLicensePanel.this.acceptCheck.isSelected());
                LicenseFile.setApproval(InstallLicensePanel.this.acceptCheck.isSelected());
            }
        };
        this.acceptCheck.addActionListener(l);
    }
}

