/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.Collections;
import java.util.SortedSet;
import org.opends.admin.ads.ADSContext;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendDescriptor {
    private String backendID;
    private SortedSet<BaseDNDescriptor> baseDns;
    private SortedSet<IndexDescriptor> indexes;
    private SortedSet<VLVIndexDescriptor> vlvIndexes;
    private int entries;
    private boolean isConfigBackend;
    private boolean isEnabled;
    private CustomSearchResult monitoringEntry;
    private Type type;
    private int hashCode;

    public BackendDescriptor(String backendID, SortedSet<BaseDNDescriptor> baseDns, SortedSet<IndexDescriptor> indexes, SortedSet<VLVIndexDescriptor> vlvIndexes, int entries, boolean isEnabled, Type type) {
        this.backendID = backendID;
        this.baseDns = Collections.unmodifiableSortedSet(baseDns);
        this.indexes = Collections.unmodifiableSortedSet(indexes);
        this.vlvIndexes = Collections.unmodifiableSortedSet(vlvIndexes);
        this.entries = entries;
        this.isConfigBackend = this.isConfigBackend(backendID);
        this.type = type;
        this.isEnabled = isEnabled;
        this.updateBaseDnsAndIndexes();
        this.recalculateHashCode();
    }

    public String getBackendID() {
        return this.backendID;
    }

    public SortedSet<BaseDNDescriptor> getBaseDns() {
        return this.baseDns;
    }

    public SortedSet<VLVIndexDescriptor> getVLVIndexes() {
        return this.vlvIndexes;
    }

    public SortedSet<IndexDescriptor> getIndexes() {
        return this.indexes;
    }

    public int getEntries() {
        return this.entries;
    }

    public boolean equals(Object v) {
        boolean equals = false;
        if (this != v) {
            if (v instanceof BackendDescriptor) {
                BackendDescriptor desc = (BackendDescriptor)v;
                boolean bl = equals = this.getBackendID().equals(desc.getBackendID()) && this.getEntries() == desc.getEntries();
                if (equals) {
                    equals = desc.getBaseDns().equals(this.getBaseDns());
                }
                if (equals) {
                    equals = desc.getIndexes().equals(this.getIndexes());
                }
                if (equals) {
                    equals = desc.getVLVIndexes().equals(this.getVLVIndexes());
                }
                if (equals) {
                    equals = this.getMonitoringEntry() == null ? desc.getMonitoringEntry() == null : this.getMonitoringEntry().equals(desc.getMonitoringEntry());
                }
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public CustomSearchResult getMonitoringEntry() {
        return this.monitoringEntry;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void recalculateHashCode() {
        this.hashCode = 0;
        for (BaseDNDescriptor baseDNDescriptor : this.getBaseDns()) {
            this.hashCode += baseDNDescriptor.hashCode();
        }
        this.hashCode += this.entries;
        for (IndexDescriptor indexDescriptor : this.indexes) {
            this.hashCode += indexDescriptor.hashCode();
        }
        for (VLVIndexDescriptor vLVIndexDescriptor : this.vlvIndexes) {
            this.hashCode += vLVIndexDescriptor.hashCode();
        }
    }

    private void updateBaseDnsAndIndexes() {
        for (BaseDNDescriptor baseDNDescriptor : this.baseDns) {
            baseDNDescriptor.setBackend(this);
        }
        for (IndexDescriptor indexDescriptor : this.indexes) {
            indexDescriptor.setBackend(this);
        }
        for (VLVIndexDescriptor vLVIndexDescriptor : this.vlvIndexes) {
            vLVIndexDescriptor.setBackend(this);
        }
    }

    private boolean isConfigBackend(String id) {
        return "tasks".equalsIgnoreCase(id) || "schema".equalsIgnoreCase(id) || "config".equalsIgnoreCase(id) || "monitor".equalsIgnoreCase(id) || "backup".equalsIgnoreCase(id) || ADSContext.getDefaultBackendName().equalsIgnoreCase(id) || "ads-truststore".equalsIgnoreCase(id) || "replicationchanges".equalsIgnoreCase(id);
    }

    public boolean isConfigBackend() {
        return this.isConfigBackend;
    }

    public void setEntries(int entries) {
        this.entries = entries;
        this.recalculateHashCode();
    }

    public void setMonitoringEntry(CustomSearchResult monitoringEntry) {
        this.monitoringEntry = monitoringEntry;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        LOCAL_DB,
        LDIF,
        MEMORY,
        BACKUP,
        MONITOR,
        TASK,
        OTHER;

    }
}

