/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexTableModel;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;

public class IndexTableModel
extends AbstractIndexTableModel {
    private static final long serialVersionUID = 6979651281772979301L;

    protected String[] getColumnNames() {
        return new String[]{this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_INDEXES_HEADER_ATTRIBUTE.get(), 30), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_INDEXES_HEADER_ENTRY_LIMIT.get(), 30), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_INDEXES_HEADER_INDEX_TYPES.get(), 30), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_INDEXES_HEADER_REQUIRES_REBUILD.get(), 30)};
    }

    public int compare(AbstractIndexDescriptor index1, AbstractIndexDescriptor index2) {
        IndexDescriptor i1 = (IndexDescriptor)index1;
        IndexDescriptor i2 = (IndexDescriptor)index2;
        int[] possibleResults = new int[]{this.compareNames(i1, i2), this.compareEntryLimits(i1, i2), this.compareTypes(i1, i2), this.compareRebuildRequired(i1, i2)};
        int result = possibleResults[this.sortColumn];
        if (result == 0) {
            for (int i : possibleResults) {
                if (i == 0) continue;
                result = i;
                break;
            }
        }
        if (!this.sortAscending) {
            result = -result;
        }
        return result;
    }

    protected String[] getLine(AbstractIndexDescriptor index) {
        IndexDescriptor i = (IndexDescriptor)index;
        return new String[]{i.getName(), this.getEntryLimitValue(i), this.getIndexTypeString(i), this.getRebuildRequiredString(i).toString()};
    }

    private String getEntryLimitValue(IndexDescriptor i) {
        if (i.getEntryLimit() >= 0) {
            return String.valueOf(i.getEntryLimit());
        }
        return AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get().toString();
    }

    private int compareNames(IndexDescriptor i1, IndexDescriptor i2) {
        return i1.getName().compareTo(i2.getName());
    }

    private int compareEntryLimits(IndexDescriptor i1, IndexDescriptor i2) {
        return this.getEntryLimitValue(i1).compareTo(this.getEntryLimitValue(i2));
    }

    private int compareTypes(IndexDescriptor i1, IndexDescriptor i2) {
        return this.getIndexTypeString(i1).compareTo(this.getIndexTypeString(i2));
    }

    private String getIndexTypeString(IndexDescriptor index) {
        StringBuilder sb = new StringBuilder();
        for (LocalDBIndexCfgDefn.IndexType type : index.getTypes()) {
            Message v;
            switch (type) {
                case SUBSTRING: {
                    v = AdminToolMessages.INFO_CTRL_PANEL_INDEX_SUBSTRING.get();
                    break;
                }
                case ORDERING: {
                    v = AdminToolMessages.INFO_CTRL_PANEL_INDEX_ORDERING.get();
                    break;
                }
                case PRESENCE: {
                    v = AdminToolMessages.INFO_CTRL_PANEL_INDEX_PRESENCE.get();
                    break;
                }
                case EQUALITY: {
                    v = AdminToolMessages.INFO_CTRL_PANEL_INDEX_EQUALITY.get();
                    break;
                }
                case APPROXIMATE: {
                    v = AdminToolMessages.INFO_CTRL_PANEL_INDEX_APPROXIMATE.get();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown index type: " + (Object)((Object)type));
                }
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(v);
        }
        if (sb.length() == 0) {
            sb.append(AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get().toString());
        }
        return sb.toString();
    }
}

