/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.datamodel.BinaryValue;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ObjectClassValue;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.LDAPEntryChangedEvent;
import org.opends.guitools.controlpanel.event.LDAPEntryChangedListener;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.RDN;
import org.opends.server.types.Schema;
import org.opends.server.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewEntryPanel
extends StatusGenericPanel {
    protected SortedSet<String> schemaReadOnlyAttributes = new TreeSet<String>();
    protected SortedSet<String> schemaReadOnlyAttributesLowerCase = new TreeSet<String>();
    private JLabel title = Utilities.createDefaultLabel();
    private Set<LDAPEntryChangedListener> listeners = new LinkedHashSet<LDAPEntryChangedListener>();
    protected boolean ignoreEntryChangeEvents;
    protected static boolean displayOnlyWithAttrs = true;
    static String[] editableOperationalAttrNames = new String[]{"objectClasses", "attributeTypes", "matchingRules", "nameForms", "ldapSyntaxes", "dITStructureRules", "aci"};

    @Override
    public void okClicked() {
    }

    public abstract Entry getEntry() throws OpenDsException;

    public abstract void update(CustomSearchResult var1, boolean var2, TreePath var3);

    protected void addTitlePanel(Container c, GridBagConstraints gbc) {
        c.add((Component)this.title, gbc);
    }

    protected boolean checkSchema() {
        return this.getInfo().getServerDescriptor().isSchemaEnabled();
    }

    public void addLDAPEntryChangedListener(LDAPEntryChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeLDAPEntryChangedListener(LDAPEntryChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean requiresBorder() {
        return true;
    }

    protected abstract String getDisplayedDN();

    protected void notifyListeners() {
        if (this.ignoreEntryChangeEvents) {
            return;
        }
        Entry entry = null;
        String dn = this.getDisplayedDN();
        if (dn != null && !dn.equals(this.title.getText())) {
            this.title.setText(dn);
        }
        LDAPEntryChangedEvent ev = new LDAPEntryChangedEvent(this, entry);
        for (LDAPEntryChangedListener listener : this.listeners) {
            listener.entryChanged(ev);
        }
    }

    protected void updateTitle(CustomSearchResult sr, TreePath path) {
        BasicNode node;
        String dn = sr.getDN();
        if (dn != null && dn.length() > 0) {
            this.title.setText(sr.getDN());
        } else if (path != null) {
            node = (BasicNode)path.getLastPathComponent();
            this.title.setText(node.getDisplayName());
        }
        if (path != null) {
            node = (BasicNode)path.getLastPathComponent();
            this.title.setIcon(node.getIcon());
        } else {
            this.title.setIcon(null);
        }
        Set<Object> ocs = sr.getAttributeValues("objectclass");
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (!ocs.isEmpty() && schema != null) {
            ObjectClassValue ocDesc = this.getObjectClassDescriptor(ocs, schema);
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            if (ocDesc.getStructural() != null) {
                sb.append(AdminToolMessages.INFO_CTRL_OBJECTCLASS_DESCRIPTOR.get(ocDesc.getStructural()));
            }
            if (ocDesc.getAuxiliary().size() > 0) {
                if (sb.length() > 0) {
                    sb.append("<br>");
                }
                sb.append(AdminToolMessages.INFO_CTRL_AUXILIARY_OBJECTCLASS_DESCRIPTOR.get(Utilities.getStringFromCollection(ocDesc.getAuxiliary(), ", ")));
            }
            this.title.setToolTipText(sb.toString());
        } else {
            this.title.setToolTipText(null);
        }
    }

    protected ObjectClassValue getObjectClassDescriptor(Set<Object> ocValues, Schema schema) {
        CommonSchemaElements structuralObjectClass = null;
        TreeSet<String> auxiliaryClasses = new TreeSet<String>();
        for (Object o : ocValues) {
            ObjectClass objectClass = schema.getObjectClass(((String)o).toLowerCase());
            if (objectClass == null) continue;
            if (objectClass.getObjectClassType() == ObjectClassType.STRUCTURAL) {
                if (structuralObjectClass == null) {
                    structuralObjectClass = objectClass;
                    continue;
                }
                if (!objectClass.isDescendantOf((ObjectClass)structuralObjectClass)) continue;
                structuralObjectClass = objectClass;
                continue;
            }
            String name = objectClass.getNameOrOID();
            if (name.equals("top")) continue;
            auxiliaryClasses.add(objectClass.getNameOrOID());
        }
        String structural = structuralObjectClass != null ? structuralObjectClass.getNameOrOID() : null;
        return new ObjectClassValue(structural, auxiliaryClasses);
    }

    protected void addValuesInRDN(Entry entry) {
        RDN rdn = entry.getDN().getRDN();
        for (int i = 0; i < rdn.getNumValues(); ++i) {
            String attrName = rdn.getAttributeName(i);
            AttributeValue value = rdn.getAttributeValue(i);
            List<Attribute> attrs = entry.getAttribute(attrName.toLowerCase());
            boolean done = false;
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    if (!attr.getNameWithOptions().equals(attrName)) continue;
                    ArrayList<AttributeValue> newValues = new ArrayList<AttributeValue>();
                    Iterator<AttributeValue> it = attr.iterator();
                    while (it.hasNext()) {
                        newValues.add(it.next());
                    }
                    newValues.add(value);
                    entry.addAttribute(attr, newValues);
                    done = true;
                    break;
                }
            }
            if (done) continue;
            Attribute attr = Attributes.create(rdn.getAttributeType(i), value);
            ArrayList<AttributeValue> newValues = new ArrayList<AttributeValue>();
            newValues.add(value);
            entry.addAttribute(attr, newValues);
        }
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_EDIT_LDAP_ENTRY_TITLE.get();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        Schema schema = ev.getNewDescriptor().getSchema();
        if (schema != null) {
            this.schemaReadOnlyAttributes.clear();
            this.schemaReadOnlyAttributesLowerCase.clear();
            for (AttributeType attr : schema.getAttributeTypes().values()) {
                String attrName;
                if (!attr.isOperational() || ViewEntryPanel.isEditable(attrName = attr.getNameOrOID(), schema)) continue;
                this.schemaReadOnlyAttributes.add(attrName);
                this.schemaReadOnlyAttributesLowerCase.add(attrName.toLowerCase());
            }
        }
    }

    protected void appendLDIFLines(StringBuilder sb, String attrName, Set<Object> values) {
        for (Object value : values) {
            this.appendLDIFLine(sb, attrName, value);
        }
    }

    protected void appendLDIFLine(StringBuilder sb, String attrName, Object value) {
        if (value instanceof ObjectClassValue) {
            ObjectClassValue ocValue = (ObjectClassValue)value;
            if (ocValue.getStructural() != null) {
                ObjectClass oc;
                sb.append("\n");
                sb.append(attrName + ": " + ocValue.getStructural());
                Schema schema = this.getInfo().getServerDescriptor().getSchema();
                if (schema != null && (oc = schema.getObjectClass(ocValue.getStructural().toLowerCase())) != null) {
                    for (ObjectClass parent = oc.getSuperiorClass(); parent != null; parent = parent.getSuperiorClass()) {
                        sb.append("\n");
                        sb.append(attrName + ": " + parent.getNameOrOID());
                    }
                }
            }
            for (String v : ocValue.getAuxiliary()) {
                sb.append("\n");
                sb.append(attrName + ": " + v);
            }
        } else if (value instanceof byte[]) {
            if (((byte[])value).length > 0) {
                sb.append("\n");
                sb.append(attrName + ":: " + Base64.encode((byte[])value));
            }
        } else if (value instanceof BinaryValue) {
            sb.append("\n");
            sb.append(attrName + ":: " + ((BinaryValue)value).getBase64());
        } else if (String.valueOf(value).trim().length() > 0) {
            sb.append("\n");
            sb.append(attrName + ": " + value);
        }
    }

    protected boolean isBinary(String attrName) {
        boolean isBinary = false;
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        isBinary = Utilities.hasBinarySyntax(attrName, schema);
        return isBinary;
    }

    protected boolean isPassword(String attrName) {
        boolean isBinary = false;
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        isBinary = Utilities.hasPasswordSyntax(attrName, schema);
        return isBinary;
    }

    protected boolean hasCertificateSyntax(String attrName, Schema schema) {
        AttributeSyntax syntax;
        AttributeType attr;
        boolean isCertificate = false;
        if (schema != null && (attr = schema.getAttributeType(Utilities.getAttributeNameWithoutOptions(attrName).toLowerCase())) != null && (syntax = attr.getSyntax()) != null) {
            isCertificate = syntax.getOID().equals("1.3.6.1.4.1.1466.115.121.1.8");
        }
        return isCertificate;
    }

    private static boolean isEditableOperationalAttribute(String attrName) {
        boolean isEditableOperationalAttribute = false;
        for (String attr : editableOperationalAttrNames) {
            if (!attr.equalsIgnoreCase(attrName)) continue;
            isEditableOperationalAttribute = true;
            break;
        }
        return isEditableOperationalAttribute;
    }

    protected abstract Set<Object> getValues(String var1);

    protected void setValues(CustomSearchResult sr, String attrName) {
        Set<Object> values = this.getValues(attrName);
        LinkedHashSet<Object> valuesToSet = new LinkedHashSet<Object>();
        for (Object value : values) {
            if (value instanceof ObjectClassValue) {
                ObjectClassValue ocValue = (ObjectClassValue)value;
                if (ocValue.getStructural() != null) {
                    valuesToSet.add(ocValue.getStructural());
                }
                valuesToSet.addAll(ocValue.getAuxiliary());
                continue;
            }
            if (value instanceof byte[]) {
                valuesToSet.add(value);
                continue;
            }
            if (value instanceof BinaryValue) {
                try {
                    valuesToSet.add(((BinaryValue)value).getBytes());
                    continue;
                }
                catch (ParseException pe) {
                    throw new IllegalStateException("Unexpected error: " + pe, pe);
                }
            }
            if (String.valueOf(value).trim().length() <= 0) continue;
            valuesToSet.add(String.valueOf(value));
        }
        if (valuesToSet.size() > 0) {
            sr.set(attrName, valuesToSet);
        }
    }

    public static boolean isEditable(String attrName, Schema schema) {
        boolean isOperational = false;
        AttributeType attrType = schema.getAttributeType((attrName = Utilities.getAttributeNameWithoutOptions(attrName)).toLowerCase());
        if (attrType != null) {
            isOperational = attrType.isOperational();
        }
        return !isOperational || ViewEntryPanel.isEditableOperationalAttribute(attrName);
    }
}

