/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.StartMsg;

public class ServerStartMsg
extends StartMsg {
    private short serverId;
    private String serverURL;
    private String baseDn;
    private int maxReceiveQueue;
    private int maxSendQueue;
    private int maxReceiveDelay;
    private int maxSendDelay;
    private int windowSize;
    private ServerState serverState = null;
    private long heartbeatInterval = 0L;
    private boolean sslEncryption;

    public ServerStartMsg(short serverId, String baseDn, int maxReceiveDelay, int maxReceiveQueue, int maxSendDelay, int maxSendQueue, int windowSize, long heartbeatInterval, ServerState serverState, short protocolVersion, long generationId, boolean sslEncryption, byte groupId) {
        super(protocolVersion, generationId);
        this.serverId = serverId;
        this.baseDn = baseDn;
        this.maxReceiveDelay = maxReceiveDelay;
        this.maxReceiveQueue = maxReceiveQueue;
        this.maxSendDelay = maxSendDelay;
        this.maxSendQueue = maxSendQueue;
        this.windowSize = windowSize;
        this.heartbeatInterval = heartbeatInterval;
        this.sslEncryption = sslEncryption;
        this.serverState = serverState;
        this.groupId = groupId;
        try {
            this.serverURL = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.serverURL = "Unknown host";
        }
    }

    public ServerStartMsg(byte[] in) throws DataFormatException {
        byte[] allowedPduTypes = new byte[]{20};
        this.headerLength = this.decodeHeader(allowedPduTypes, in);
        try {
            int pos = this.headerLength;
            int length = this.getNextLength(in, pos);
            this.baseDn = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.serverId = Short.valueOf(serverIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.serverURL = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.maxReceiveDelay = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.maxReceiveQueue = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.maxSendDelay = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.maxSendQueue = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.windowSize = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.heartbeatInterval = Integer.valueOf(new String(in, pos, length, "UTF-8")).intValue();
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.sslEncryption = Boolean.valueOf(new String(in, pos, length, "UTF-8"));
            this.serverState = new ServerState(in, pos += length + 1, in.length - 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public int getMaxReceiveDelay() {
        return this.maxReceiveDelay;
    }

    public int getMaxReceiveQueue() {
        return this.maxReceiveQueue;
    }

    public int getMaxSendDelay() {
        return this.maxSendDelay;
    }

    public int getMaxSendQueue() {
        return this.maxSendQueue;
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    public byte[] getBytes() {
        try {
            byte[] byteDn = this.baseDn.getBytes("UTF-8");
            byte[] byteServerId = String.valueOf(this.serverId).getBytes("UTF-8");
            byte[] byteServerUrl = this.serverURL.getBytes("UTF-8");
            byte[] byteMaxRecvDelay = String.valueOf(this.maxReceiveDelay).getBytes("UTF-8");
            byte[] byteMaxRecvQueue = String.valueOf(this.maxReceiveQueue).getBytes("UTF-8");
            byte[] byteMaxSendDelay = String.valueOf(this.maxSendDelay).getBytes("UTF-8");
            byte[] byteMaxSendQueue = String.valueOf(this.maxSendQueue).getBytes("UTF-8");
            byte[] byteWindowSize = String.valueOf(this.windowSize).getBytes("UTF-8");
            byte[] byteHeartbeatInterval = String.valueOf(this.heartbeatInterval).getBytes("UTF-8");
            byte[] byteSSLEncryption = String.valueOf(this.sslEncryption).getBytes("UTF-8");
            byte[] byteServerState = this.serverState.getBytes();
            int length = byteDn.length + 1 + byteServerId.length + 1 + byteServerUrl.length + 1 + byteMaxRecvDelay.length + 1 + byteMaxRecvQueue.length + 1 + byteMaxSendDelay.length + 1 + byteMaxSendQueue.length + 1 + byteWindowSize.length + 1 + byteHeartbeatInterval.length + 1 + byteSSLEncryption.length + 1 + byteServerState.length + 1;
            byte[] resultByteArray = this.encodeHeader((byte)20, length);
            int pos = this.headerLength;
            pos = ServerStartMsg.addByteArray(byteDn, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteServerId, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteServerUrl, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteMaxRecvDelay, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteMaxRecvQueue, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteMaxSendDelay, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteMaxSendQueue, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteWindowSize, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteHeartbeatInterval, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteSSLEncryption, resultByteArray, pos);
            pos = ServerStartMsg.addByteArray(byteServerState, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public boolean getSSLEncryption() {
        return this.sslEncryption;
    }

    public String toString() {
        return "ServerStartMsg content: \nprotocolVersion: " + this.protocolVersion + "\ngenerationId: " + this.generationId + "\ngroupId: " + this.groupId + "\nbaseDn: " + this.baseDn.toString() + "\nheartbeatInterval: " + this.heartbeatInterval + "\nmaxReceiveDelay: " + this.maxReceiveDelay + "\nmaxReceiveQueue: " + this.maxReceiveQueue + "\nmaxSendDelay: " + this.maxSendDelay + "\nmaxSendQueue: " + this.maxSendQueue + "\nserverId: " + this.serverId + "\nserverState: " + this.serverState + "\nserverURL: " + this.serverURL + "\nsslEncryption: " + this.sslEncryption + "\nwindowSize: " + this.windowSize;
    }
}

