/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.BackupTaskListener;
import org.opends.server.api.ExportTaskListener;
import org.opends.server.api.ImportTaskListener;
import org.opends.server.api.RestoreTaskListener;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.ReplicationBackend;
import org.opends.server.replication.server.ReplicationDBException;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationServerConnectThread;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ReplicationServerListenThread;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationServer
implements ConfigurationChangeListener<ReplicationServerCfg>,
BackupTaskListener,
RestoreTaskListener,
ImportTaskListener,
ExportTaskListener {
    private short serverId;
    private String serverURL;
    private ServerSocket listenSocket;
    private Thread listenThread;
    private Thread connectThread;
    private Collection<String> replicationServers;
    private ConcurrentHashMap<String, ReplicationServerDomain> baseDNs = new ConcurrentHashMap();
    private String localURL = "null";
    private boolean shutdown = false;
    private ReplicationDbEnv dbEnv;
    private int rcvWindow;
    private int queueSize;
    private String dbDirname = null;
    private long purgeDelay;
    private int replicationPort;
    private boolean stopListen = false;
    private ReplSessionSecurity replSessionSecurity;
    private DN backendConfigEntryDN;
    private static final String backendId = "replicationChanges";
    private boolean connectedInTopology = false;
    private final Object connectedInTopologyLock = new Object();
    private long assuredTimeout = 1000L;
    private byte groupId = 1;
    private int degradedStatusThreshold = 5000;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static HashSet<Integer> localPorts = new HashSet();
    private long monitorDataLifeTime = 500L;
    private long monitorDataLastBuildDate = 0L;
    Semaphore remoteMonitorResponsesSemaphore = new Semaphore(0);

    public ReplicationServer(ReplicationServerCfg configuration) throws ConfigException {
        this.replicationPort = configuration.getReplicationPort();
        this.serverId = (short)configuration.getReplicationServerId();
        this.replicationServers = configuration.getReplicationServer();
        if (this.replicationServers == null) {
            this.replicationServers = new ArrayList<String>();
        }
        this.queueSize = configuration.getQueueSize();
        this.purgeDelay = configuration.getReplicationPurgeDelay();
        this.dbDirname = configuration.getReplicationDBDirectory();
        this.rcvWindow = configuration.getWindowSize();
        if (this.dbDirname == null) {
            this.dbDirname = "changelogDb";
        }
        File f = StaticUtils.getFileForPath(this.dbDirname);
        try {
            if (!f.exists()) {
                f.mkdir();
            }
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getLocalizedMessage());
            mb.append(" ");
            mb.append(String.valueOf(StaticUtils.getFileForPath(this.dbDirname)));
            Message msg = ReplicationMessages.ERR_FILE_CHECK_CREATE_FAILED.get(mb.toString());
            throw new ConfigException(msg, (Throwable)e);
        }
        this.groupId = (byte)configuration.getGroupId();
        this.assuredTimeout = configuration.getAssuredTimeout();
        this.degradedStatusThreshold = configuration.getDegradedStatusThreshold();
        this.replSessionSecurity = new ReplSessionSecurity();
        this.initialize(this.replicationPort);
        configuration.addChangeListener(this);
        try {
            this.backendConfigEntryDN = DN.decode("ds-cfg-backend-id=replicationChanges,cn=Backends,cn=config");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createBackend();
        DirectoryServer.registerBackupTaskListener(this);
        DirectoryServer.registerRestoreTaskListener(this);
        DirectoryServer.registerExportTaskListener(this);
        DirectoryServer.registerImportTaskListener(this);
        localPorts.add(this.replicationPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runListen() {
        Object object = this.connectedInTopologyLock;
        synchronized (object) {
            if (!this.connectedInTopology) {
                try {
                    this.connectedInTopologyLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        while (!this.shutdown && !this.stopListen) {
            try {
                ProtocolSession session;
                block12: {
                    Socket newSocket = null;
                    try {
                        newSocket = this.listenSocket.accept();
                        newSocket.setTcpNoDelay(true);
                        newSocket.setKeepAlive(true);
                        session = this.replSessionSecurity.createServerSession(newSocket, 4000);
                        if (session == null) {
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        if (newSocket == null) continue;
                        newSocket.close();
                    }
                    continue;
                }
                ServerHandler handler = new ServerHandler(session, this.queueSize);
                handler.start(null, this.serverId, this.serverURL, this.rcvWindow, false, this);
            }
            catch (Exception e) {
                if (this.shutdown) continue;
                Message message = ReplicationMessages.ERR_EXCEPTION_LISTENING.get(e.getLocalizedMessage());
                ErrorLogger.logError(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runConnect() {
        while (!this.shutdown) {
            for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
                Set<String> connectedReplServers = replicationServerDomain.getChangelogs();
                for (String serverURL : this.replicationServers) {
                    int separator = serverURL.lastIndexOf(58);
                    String port = serverURL.substring(separator + 1);
                    String hostname = serverURL.substring(0, separator);
                    try {
                        InetAddress inetAddress = InetAddress.getByName(hostname);
                        String serverAddress = inetAddress.getHostAddress() + ":" + port;
                        String alternServerAddress = null;
                        if (hostname.equalsIgnoreCase("localhost")) {
                            alternServerAddress = InetAddress.getLocalHost().getHostAddress() + ":" + port;
                        }
                        if (inetAddress.equals(InetAddress.getLocalHost())) {
                            alternServerAddress = "127.0.0.1:" + port;
                        }
                        if (serverAddress.compareTo("127.0.0.1:" + this.replicationPort) == 0 || serverAddress.compareTo(this.localURL) == 0 || connectedReplServers.contains(serverAddress) || alternServerAddress != null && connectedReplServers.contains(alternServerAddress)) continue;
                        this.connect(serverURL, replicationServerDomain.getBaseDn());
                    }
                    catch (IOException e) {
                        Message message = ReplicationMessages.ERR_COULD_NOT_SOLVE_HOSTNAME.get(hostname);
                        ErrorLogger.logError(message);
                    }
                }
            }
            Object i$ = this.connectedInTopologyLock;
            synchronized (i$) {
                if (!this.connectedInTopology) {
                    this.connectedInTopologyLock.notify();
                    this.connectedInTopology = true;
                }
            }
            try {
                i$ = this;
                synchronized (i$) {
                    int randomizer = (int)(Math.random() * 100.0);
                    this.wait(1000 + randomizer);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void connect(String serverURL, String baseDn) {
        int separator = serverURL.lastIndexOf(58);
        String port = serverURL.substring(separator + 1);
        String hostname = serverURL.substring(0, separator);
        boolean sslEncryption = this.replSessionSecurity.isSslEncryption(serverURL);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " connects to " + serverURL);
        }
        try {
            InetSocketAddress ServerAddr = new InetSocketAddress(InetAddress.getByName(hostname), Integer.parseInt(port));
            Socket socket = new Socket();
            socket.setTcpNoDelay(true);
            socket.connect(ServerAddr, 500);
            ServerHandler handler = new ServerHandler(this.replSessionSecurity.createClientSession(serverURL, socket, 4000), this.queueSize);
            handler.start(baseDn, this.serverId, this.serverURL, this.rcvWindow, sslEncryption, this);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void initialize(int changelogPort) {
        this.shutdown = false;
        try {
            this.dbEnv = new ReplicationDbEnv(StaticUtils.getFileForPath(this.dbDirname).getAbsolutePath(), this);
            String localhostname = InetAddress.getLocalHost().getHostName();
            String localAdddress = InetAddress.getLocalHost().getHostAddress();
            this.serverURL = localhostname + ":" + String.valueOf(changelogPort);
            this.localURL = localAdddress + ":" + String.valueOf(changelogPort);
            this.listenSocket = new ServerSocket();
            this.listenSocket.bind(new InetSocketAddress(changelogPort));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " creates connect thread");
            }
            this.connectThread = new ReplicationServerConnectThread("Replication Server Connect " + this.serverId, this);
            this.connectThread.start();
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " creates listen thread");
            }
            this.listenThread = new ReplicationServerListenThread("Replication Server Listener " + this.serverId, this);
            this.listenThread.start();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " successfully initialized");
            }
        }
        catch (DatabaseException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_INITIALIZE_DB.get(StaticUtils.getFileForPath(this.dbDirname).getAbsolutePath());
            ErrorLogger.logError(message);
        }
        catch (ReplicationDBException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_READ_DB.get(this.dbDirname, e.getLocalizedMessage());
            ErrorLogger.logError(message);
        }
        catch (UnknownHostException e) {
            Message message = ReplicationMessages.ERR_UNKNOWN_HOSTNAME.get();
            ErrorLogger.logError(message);
        }
        catch (IOException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_BIND_CHANGELOG.get(changelogPort, e.getMessage());
            ErrorLogger.logError(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationServerDomain getReplicationServerDomain(String baseDn, boolean create) {
        ReplicationServerDomain replicationServerDomain;
        ConcurrentHashMap<String, ReplicationServerDomain> concurrentHashMap = this.baseDNs;
        synchronized (concurrentHashMap) {
            replicationServerDomain = this.baseDNs.get(baseDn);
            if (replicationServerDomain == null && create) {
                replicationServerDomain = new ReplicationServerDomain(baseDn, this);
                this.baseDNs.put(baseDn, replicationServerDomain);
            }
        }
        return replicationServerDomain;
    }

    public void shutdown() {
        localPorts.remove(this.replicationPort);
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.connectThread != null) {
            this.connectThread.interrupt();
        }
        try {
            if (this.listenSocket != null) {
                this.listenSocket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.listenThread != null) {
            this.listenThread.interrupt();
        }
        for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
            replicationServerDomain.shutdown();
        }
        if (this.dbEnv != null) {
            this.dbEnv.shutdown();
        }
    }

    public DbHandler newDbHandler(short id, String baseDn) throws DatabaseException {
        return new DbHandler(id, baseDn, this, this.dbEnv, this.queueSize);
    }

    public void clearGenerationId(String baseDn) throws DatabaseException {
        try {
            this.dbEnv.clearGenerationId(baseDn);
        }
        catch (Exception e) {
            TRACER.debugCaught(LogLevel.ALL, e);
        }
    }

    long getTrimage() {
        return this.purgeDelay * 1000L;
    }

    public static boolean isConfigurationAcceptable(ReplicationServerCfg configuration, List<Message> unacceptableReasons) {
        int port = configuration.getReplicationPort();
        try {
            ServerSocket tmpSocket = new ServerSocket();
            tmpSocket.bind(new InetSocketAddress(port));
            tmpSocket.close();
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_BIND_CHANGELOG.get(port, e.getMessage());
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReplicationServerCfg configuration) {
        byte newGroupId;
        this.disconnectRemovedReplicationServers(configuration.getReplicationServer());
        this.replicationServers = configuration.getReplicationServer();
        if (this.replicationServers == null) {
            this.replicationServers = new ArrayList<String>();
        }
        this.queueSize = configuration.getQueueSize();
        long newPurgeDelay = configuration.getReplicationPurgeDelay();
        if (newPurgeDelay != this.purgeDelay) {
            this.purgeDelay = newPurgeDelay;
            for (ReplicationServerDomain domain : this.baseDNs.values()) {
                domain.setPurgeDelay(this.purgeDelay * 1000L);
            }
        }
        this.rcvWindow = configuration.getWindowSize();
        this.assuredTimeout = configuration.getAssuredTimeout();
        int newPort = configuration.getReplicationPort();
        if (newPort != this.replicationPort) {
            Message message;
            this.stopListen = true;
            try {
                this.listenSocket.close();
                this.listenThread.join();
                this.stopListen = false;
                this.replicationPort = newPort;
                String localhostname = InetAddress.getLocalHost().getHostName();
                String localAdddress = InetAddress.getLocalHost().getHostAddress();
                this.serverURL = localhostname + ":" + String.valueOf(this.replicationPort);
                this.localURL = localAdddress + ":" + String.valueOf(this.replicationPort);
                this.listenSocket = new ServerSocket();
                this.listenSocket.bind(new InetSocketAddress(this.replicationPort));
                this.listenThread = new ReplicationServerListenThread("Replication Server Listener", this);
                this.listenThread.start();
            }
            catch (IOException e) {
                message = ReplicationMessages.ERR_COULD_NOT_CLOSE_THE_SOCKET.get(e.toString());
                ErrorLogger.logError(message);
                new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false);
            }
            catch (InterruptedException e) {
                message = ReplicationMessages.ERR_COULD_NOT_STOP_LISTEN_THREAD.get(e.toString());
                ErrorLogger.logError(message);
                new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false);
            }
        }
        if (this.degradedStatusThreshold != configuration.getDegradedStatusThreshold()) {
            int oldThresholdValue = this.degradedStatusThreshold;
            this.degradedStatusThreshold = configuration.getDegradedStatusThreshold();
            for (ReplicationServerDomain rsd : this.baseDNs.values()) {
                if (this.degradedStatusThreshold == 0) {
                    rsd.stopStatusAnalyzer();
                    continue;
                }
                if (rsd.isRunningStatusAnalyzer()) {
                    rsd.updateStatusAnalyzer(this.degradedStatusThreshold);
                    continue;
                }
                if (oldThresholdValue != 0 || rsd.getConnectedDSs().size() <= 0) continue;
                rsd.startStatusAnalyzer();
            }
        }
        if ((newGroupId = (byte)configuration.getGroupId()) != this.groupId) {
            this.groupId = newGroupId;
            for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
                replicationServerDomain.stopAllServers();
            }
        }
        if (configuration.getReplicationDBDirectory() != null && !this.dbDirname.equals(configuration.getReplicationDBDirectory())) {
            return new ConfigChangeResult(ResultCode.SUCCESS, true);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReplicationServerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public long getGenerationId(String baseDN) {
        ReplicationServerDomain rsd = this.getReplicationServerDomain(baseDN, false);
        if (rsd != null) {
            return rsd.getGenerationId();
        }
        return -1L;
    }

    public short getServerId() {
        return this.serverId;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    private void createBackend() throws ConfigException {
        try {
            String ldif = ReplicationServer.makeLdif("dn: ds-cfg-backend-id=replicationChanges,cn=Backends,cn=config", "objectClass: top", "objectClass: ds-cfg-backend", "ds-cfg-base-dn: dc=replicationChanges", "ds-cfg-enabled: true", "ds-cfg-writability-mode: enabled", "ds-cfg-java-class: org.opends.server.replication.server.ReplicationBackend", "ds-cfg-backend-id: replicationChanges");
            LDIFImportConfig ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
            LDIFReader reader = new LDIFReader(ldifImportConfig);
            Entry backendConfigEntry = reader.readEntry();
            if (!DirectoryServer.getConfigHandler().entryExists(this.backendConfigEntryDN)) {
                DirectoryServer.getConfigHandler().addEntry(backendConfigEntry, null);
            }
            ldifImportConfig.close();
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getLocalizedMessage());
            Message msg = ReplicationMessages.ERR_CHECK_CREATE_REPL_BACKEND_FAILED.get(mb.toString());
            throw new ConfigException(msg, (Throwable)e);
        }
    }

    private static String makeLdif(String ... lines) {
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append(ServerConstants.EOL);
        }
        buffer.append(ServerConstants.EOL);
        return buffer.toString();
    }

    public void remove() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " starts removing");
        }
        this.shutdown();
        this.removeBackend();
        DirectoryServer.deregisterBackupTaskListener(this);
        DirectoryServer.deregisterRestoreTaskListener(this);
        DirectoryServer.deregisterExportTaskListener(this);
        DirectoryServer.deregisterImportTaskListener(this);
    }

    protected void removeBackend() {
        try {
            if (DirectoryServer.getConfigHandler().entryExists(this.backendConfigEntryDN)) {
                DirectoryServer.getConfigHandler().deleteEntry(this.backendConfigEntryDN, null);
            }
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getLocalizedMessage());
            Message msg = ReplicationMessages.ERR_DELETE_REPL_BACKEND_FAILED.get(mb.toString());
            ErrorLogger.logError(msg);
        }
    }

    @Override
    public void processBackupBegin(Backend backend, BackupConfig config) {
    }

    @Override
    public void processBackupEnd(Backend backend, BackupConfig config, boolean successful) {
    }

    @Override
    public void processRestoreBegin(Backend backend, RestoreConfig config) {
        if (backend.getBackendID().equals(backendId)) {
            this.shutdown();
        }
    }

    @Override
    public void processRestoreEnd(Backend backend, RestoreConfig config, boolean successful) {
        if (backend.getBackendID().equals(backendId)) {
            this.initialize(this.replicationPort);
        }
    }

    @Override
    public void processImportBegin(Backend backend, LDIFImportConfig config) {
    }

    @Override
    public void processImportEnd(Backend backend, LDIFImportConfig config, boolean successful) {
    }

    @Override
    public void processExportBegin(Backend backend, LDIFExportConfig config) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " Export starts");
        }
        if (backend.getBackendID().equals(backendId)) {
            ReplicationBackend b = (ReplicationBackend)DirectoryServer.getBackend(backendId);
            b.setServer(this);
        }
    }

    @Override
    public void processExportEnd(Backend backend, LDIFExportConfig config, boolean successful) {
    }

    public Iterator<ReplicationServerDomain> getCacheIterator() {
        if (!this.baseDNs.isEmpty()) {
            return this.baseDNs.values().iterator();
        }
        return null;
    }

    public void clearDb() {
        Iterator<ReplicationServerDomain> rcachei = this.getCacheIterator();
        if (rcachei != null) {
            while (rcachei.hasNext()) {
                ReplicationServerDomain rsd = rcachei.next();
                rsd.clearDbs();
            }
        }
    }

    public long getAssuredTimeout() {
        return this.assuredTimeout;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public int getDegradedStatusThreshold() {
        return this.degradedStatusThreshold;
    }

    private void disconnectRemovedReplicationServers(Collection<String> newReplServers) {
        ArrayList<String> serversToDisconnect = new ArrayList<String>();
        for (String server : this.replicationServers) {
            if (newReplServers.contains(server)) continue;
            try {
                String[] host = server.split(":");
                serversToDisconnect.add(InetAddress.getByName(host[0]).getHostAddress() + ":" + host[1]);
            }
            catch (IOException e) {
                Message message = ReplicationMessages.ERR_COULD_NOT_SOLVE_HOSTNAME.get(server);
                ErrorLogger.logError(message);
            }
        }
        if (serversToDisconnect.isEmpty()) {
            return;
        }
        for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
            replicationServerDomain.stopReplicationServers(serversToDisconnect);
        }
    }

    public String getMonitorInstanceName() {
        return "Replication Server " + this.replicationPort + " " + this.serverId;
    }

    public int getReplicationPort() {
        return this.replicationPort;
    }

    public void computeMonitorData() throws DirectoryException {
        if (this.monitorDataLastBuildDate + this.monitorDataLifeTime > TimeThread.getTime()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.getMonitorInstanceName() + " getRemoteMonitorData in cache");
            }
            return;
        }
        this.remoteMonitorResponsesSemaphore.drainPermits();
        int count = 0;
        for (ReplicationServerDomain domain : this.baseDNs.values()) {
            count += domain.initializeMonitorData();
        }
        this.waitMonitorDataResponses(count);
        for (ReplicationServerDomain domain : this.baseDNs.values()) {
            domain.completeMonitorData();
        }
    }

    private void waitMonitorDataResponses(int expectedResponses) throws DirectoryException {
        try {
            boolean allPermitsAcquired;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.getMonitorInstanceName() + " baseDn=" + " waiting for " + expectedResponses + " expected monitor messages");
            }
            if (!(allPermitsAcquired = this.remoteMonitorResponsesSemaphore.tryAcquire(expectedResponses, 5000L, TimeUnit.MILLISECONDS))) {
                this.monitorDataLastBuildDate = TimeThread.getTime();
                ErrorLogger.logError(ReplicationMessages.ERR_MISSING_REMOTE_MONITOR_DATA.get());
            } else {
                this.monitorDataLastBuildDate = TimeThread.getTime();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In " + this.getMonitorInstanceName() + " baseDn=" + " Successfully received all " + expectedResponses + " expected monitor messages");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.logError(ReplicationMessages.ERR_PROCESSING_REMOTE_MONITOR_DATA.get(e.getMessage()));
        }
    }

    public void responseReceived() {
        this.remoteMonitorResponsesSemaphore.release();
    }

    public void responseReceivedAll() {
        this.remoteMonitorResponsesSemaphore.notifyAll();
    }

    public static boolean isLocalReplicationServer(String server) {
        int separator = server.lastIndexOf(58);
        if (separator == -1) {
            return false;
        }
        int port = Integer.parseInt(server.substring(separator + 1));
        String hostname = server.substring(0, separator);
        try {
            InetAddress localAddr = InetAddress.getLocalHost();
            return localPorts.contains(port) && (InetAddress.getByName(hostname).isLoopbackAddress() || InetAddress.getByName(hostname).equals(localAddr));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

