/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.MonitorRequestMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.ExpectedAcksInfo;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.NotAssuredUpdateMsg;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.SafeDataExpectedAcksInfo;
import org.opends.server.replication.server.SafeReadExpectedAcksInfo;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.replication.server.StatusAnalyzer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.Attributes;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationServerDomain
extends MonitorProvider<MonitorProviderCfg> {
    private final Object flowControlLock = new Object();
    private final String baseDn;
    private StatusAnalyzer statusAnalyzer = null;
    private final Map<Short, ServerHandler> directoryServers = new ConcurrentHashMap<Short, ServerHandler>();
    private final Map<Short, ServerHandler> replicationServers = new ConcurrentHashMap<Short, ServerHandler>();
    private final Map<Short, DbHandler> sourceDbHandlers = new ConcurrentHashMap<Short, DbHandler>();
    private ReplicationServer replicationServer;
    private long generationId = -1L;
    private boolean generationIdSavedStatus = false;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private MonitorData monitorData = new MonitorData();
    private MonitorData wrkMonitorData;
    private Object monitorDataLock = new Object();
    private final ConcurrentHashMap<ChangeNumber, ExpectedAcksInfo> waitingAcks = new ConcurrentHashMap();
    private Timer assuredTimeoutTimer = null;
    private int assuredTimeoutTimerPurgeCounter = 0;
    private ReentrantLock lock = new ReentrantLock();

    public ReplicationServerDomain(String baseDn, ReplicationServer replicationServer) {
        super("Replication Server " + replicationServer.getReplicationPort() + " " + baseDn + " " + replicationServer.getServerId());
        this.baseDn = baseDn;
        this.replicationServer = replicationServer;
        this.assuredTimeoutTimer = new Timer("Replication Assured Timer for " + baseDn + " in RS " + replicationServer.getServerId(), true);
        DirectoryServer.registerMonitorProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(UpdateMsg update, ServerHandler sourceHandler) throws IOException {
        Object errorMsg;
        ChangeNumber cn = update.getChangeNumber();
        short id = cn.getServerId();
        sourceHandler.updateServerState(update);
        sourceHandler.incrementInCount();
        if (this.generationId < 0L) {
            this.generationId = sourceHandler.getGenerationId();
        }
        boolean assuredMessage = update.isAssured();
        PreparedAssuredInfo preparedAssuredInfo = null;
        if (assuredMessage) {
            if (sourceHandler.getProtocolVersion() >= 2) {
                AssuredMode assuredMode = update.getAssuredMode();
                if (assuredMode == AssuredMode.SAFE_DATA_MODE) {
                    sourceHandler.incrementAssuredSdReceivedUpdates();
                    preparedAssuredInfo = this.processSafeDataUpdateMsg(update, sourceHandler);
                } else if (assuredMode == AssuredMode.SAFE_READ_MODE) {
                    sourceHandler.incrementAssuredSrReceivedUpdates();
                    preparedAssuredInfo = this.processSafeReadUpdateMsg(update, sourceHandler);
                } else {
                    errorMsg = ReplicationMessages.ERR_RS_UNKNOWN_ASSURED_MODE.get(Short.toString(this.replicationServer.getServerId()), assuredMode.toString(), this.baseDn, update.toString());
                    ErrorLogger.logError((Message)errorMsg);
                    assuredMessage = false;
                }
            } else {
                assuredMessage = false;
            }
        }
        DbHandler dbHandler = null;
        errorMsg = this.sourceDbHandlers;
        synchronized (errorMsg) {
            dbHandler = this.sourceDbHandlers.get(id);
            if (dbHandler == null) {
                try {
                    dbHandler = this.replicationServer.newDbHandler(id, this.baseDn);
                    this.generationIdSavedStatus = true;
                }
                catch (DatabaseException e) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    this.replicationServer.shutdown();
                    return;
                }
                this.sourceDbHandlers.put(id, dbHandler);
            }
        }
        dbHandler.add(update);
        List<Short> expectedServers = null;
        if (assuredMessage && (expectedServers = preparedAssuredInfo.expectedServers) != null) {
            this.waitingAcks.put(cn, preparedAssuredInfo.expectedAcksInfo);
            AssuredTimeoutTask assuredTimeoutTask = new AssuredTimeoutTask(cn);
            this.assuredTimeoutTimer.schedule((TimerTask)assuredTimeoutTask, this.replicationServer.getAssuredTimeout());
            ++this.assuredTimeoutTimerPurgeCounter;
            if (this.assuredTimeoutTimerPurgeCounter % 100 == 0) {
                this.assuredTimeoutTimer.purge();
            }
        }
        NotAssuredUpdateMsg notAssuredUpdate = null;
        if (sourceHandler.isLDAPserver()) {
            for (ServerHandler handler : this.replicationServers.values()) {
                if (this.generationId > 0L && this.generationId != handler.getGenerationId()) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("In RS " + this.replicationServer.getServerId() + " for dn " + this.baseDn + ", update " + update.getChangeNumber().toString() + " will not be sent to replication server " + Short.toString(handler.getServerId()) + " with generation id " + Long.toString(handler.getGenerationId()) + " different from local " + "generation id " + Long.toString(this.generationId));
                    continue;
                }
                if (assuredMessage) {
                    if (expectedServers != null && expectedServers.contains(handler.getServerId())) {
                        handler.add(update, sourceHandler);
                        continue;
                    }
                    if (notAssuredUpdate == null) {
                        notAssuredUpdate = new NotAssuredUpdateMsg(update);
                    }
                    handler.add(notAssuredUpdate, sourceHandler);
                    continue;
                }
                handler.add(update, sourceHandler);
            }
        }
        for (ServerHandler handler : this.directoryServers.values()) {
            if (handler == sourceHandler) continue;
            ServerStatus dsStatus = handler.getStatus();
            if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS || dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                if (!DebugLogger.debugEnabled()) continue;
                if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS) {
                    TRACER.debugInfo("In RS " + this.replicationServer.getServerId() + " for dn " + this.baseDn + ", update " + update.getChangeNumber().toString() + " will not be sent to directory server " + Short.toString(handler.getServerId()) + " with generation id " + Long.toString(handler.getGenerationId()) + " different from local " + "generation id " + Long.toString(this.generationId));
                }
                if (dsStatus != ServerStatus.FULL_UPDATE_STATUS) continue;
                TRACER.debugInfo("In RS " + this.replicationServer.getServerId() + " for dn " + this.baseDn + ", update " + update.getChangeNumber().toString() + " will not be sent to directory server " + Short.toString(handler.getServerId()) + " as it is in full update");
                continue;
            }
            if (assuredMessage) {
                if (expectedServers != null && expectedServers.contains(handler.getServerId())) {
                    handler.add(update, sourceHandler);
                    continue;
                }
                if (notAssuredUpdate == null) {
                    notAssuredUpdate = new NotAssuredUpdateMsg(update);
                }
                handler.add(notAssuredUpdate, sourceHandler);
                continue;
            }
            handler.add(update, sourceHandler);
        }
    }

    private PreparedAssuredInfo processSafeReadUpdateMsg(UpdateMsg update, ServerHandler sourceHandler) throws IOException {
        ChangeNumber cn = update.getChangeNumber();
        byte groupId = this.replicationServer.getGroupId();
        byte sourceGroupId = sourceHandler.getGroupId();
        ArrayList<Short> expectedServers = new ArrayList<Short>();
        ArrayList<Short> wrongStatusServers = new ArrayList<Short>();
        if (sourceGroupId == groupId) {
            if (sourceHandler.isLDAPserver()) {
                for (ServerHandler handler : this.replicationServers.values()) {
                    if (handler.getGroupId() != groupId || this.generationId <= 0L || this.generationId != handler.getGenerationId()) continue;
                    expectedServers.add(handler.getServerId());
                }
            }
            for (ServerHandler handler : this.directoryServers.values()) {
                if (handler == sourceHandler || handler.getGroupId() != groupId) continue;
                ServerStatus serverStatus = handler.getStatus();
                if (serverStatus == ServerStatus.NORMAL_STATUS) {
                    expectedServers.add(handler.getServerId());
                    continue;
                }
                if (serverStatus != ServerStatus.DEGRADED_STATUS) continue;
                wrongStatusServers.add(handler.getServerId());
            }
        }
        PreparedAssuredInfo preparedAssuredInfo = new PreparedAssuredInfo();
        if (expectedServers.size() > 0) {
            preparedAssuredInfo.expectedAcksInfo = new SafeReadExpectedAcksInfo(cn, sourceHandler, expectedServers, wrongStatusServers);
            preparedAssuredInfo.expectedServers = expectedServers;
        }
        if (preparedAssuredInfo.expectedServers == null) {
            AckMsg ack = new AckMsg(cn);
            sourceHandler.sendAck(ack);
        }
        return preparedAssuredInfo;
    }

    private PreparedAssuredInfo processSafeDataUpdateMsg(UpdateMsg update, ServerHandler sourceHandler) throws IOException {
        ChangeNumber cn = update.getChangeNumber();
        boolean interestedInAcks = false;
        byte safeDataLevel = update.getSafeDataLevel();
        byte groupId = this.replicationServer.getGroupId();
        byte sourceGroupId = sourceHandler.getGroupId();
        if (safeDataLevel < 1) {
            Message errorMsg = ReplicationMessages.ERR_UNKNOWN_ASSURED_SAFE_DATA_LEVEL.get(Short.toString(this.replicationServer.getServerId()), Byte.toString(safeDataLevel), this.baseDn, update.toString());
            ErrorLogger.logError(errorMsg);
        } else if (sourceGroupId == groupId && this.generationId > 0L && this.generationId == sourceHandler.getGenerationId()) {
            AckMsg ack;
            if (sourceHandler.isLDAPserver()) {
                if (safeDataLevel == 1) {
                    ack = new AckMsg(cn);
                    sourceHandler.sendAck(ack);
                } else if (safeDataLevel != 0) {
                    interestedInAcks = true;
                }
            } else if (safeDataLevel != 1) {
                ack = new AckMsg(cn);
                sourceHandler.sendAck(ack);
            }
        }
        ArrayList<Short> expectedServers = new ArrayList<Short>();
        if (interestedInAcks && sourceHandler.isLDAPserver()) {
            for (ServerHandler handler : this.replicationServers.values()) {
                if (handler.getGroupId() != groupId || this.generationId <= 0L || this.generationId != handler.getGenerationId()) continue;
                expectedServers.add(handler.getServerId());
            }
        }
        PreparedAssuredInfo preparedAssuredInfo = new PreparedAssuredInfo();
        int nExpectedServers = expectedServers.size();
        if (interestedInAcks) {
            if (nExpectedServers > 0) {
                byte sdl = update.getSafeDataLevel();
                int neededAdditionalServers = sdl - 1;
                byte finalSdl = nExpectedServers >= neededAdditionalServers ? (byte)sdl : (byte)(nExpectedServers + 1);
                preparedAssuredInfo.expectedAcksInfo = new SafeDataExpectedAcksInfo(cn, sourceHandler, finalSdl, expectedServers);
                preparedAssuredInfo.expectedServers = expectedServers;
            } else {
                AckMsg ack = new AckMsg(cn);
                sourceHandler.sendAck(ack);
            }
        }
        return preparedAssuredInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAck(AckMsg ack, ServerHandler ackingServer) {
        ChangeNumber cn = ack.getChangeNumber();
        ExpectedAcksInfo expectedAcksInfo = this.waitingAcks.get(cn);
        if (expectedAcksInfo != null) {
            ExpectedAcksInfo expectedAcksInfo2 = expectedAcksInfo;
            synchronized (expectedAcksInfo2) {
                if (expectedAcksInfo.isCompleted()) {
                    return;
                }
                if (expectedAcksInfo.processReceivedAck(ackingServer, ack)) {
                    this.waitingAcks.remove(cn);
                    AckMsg finalAck = expectedAcksInfo.createAck(false);
                    ServerHandler origServer = expectedAcksInfo.getRequesterServer();
                    try {
                        origServer.sendAck(finalAck);
                    }
                    catch (IOException e) {
                        MessageBuilder mb = new MessageBuilder();
                        mb.append(ReplicationMessages.ERR_RS_ERROR_SENDING_ACK.get(Short.toString(this.replicationServer.getServerId()), Short.toString(origServer.getServerId()), cn.toString(), this.baseDn));
                        mb.append(StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(mb.toMessage());
                        this.stopServer(origServer);
                    }
                    expectedAcksInfo.completed();
                }
            }
        }
    }

    public void waitDisconnection(short serverId) {
        if (this.directoryServers.containsKey(serverId)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stopReplicationServers(Collection<String> replServers) {
        for (ServerHandler handler : this.replicationServers.values()) {
            if (!replServers.contains(handler.getServerAddressURL())) continue;
            this.stopServer(handler);
        }
    }

    public void stopAllServers() {
        for (ServerHandler serverHandler : this.replicationServers.values()) {
            this.stopServer(serverHandler);
        }
        for (ServerHandler serverHandler : this.directoryServers.values()) {
            this.stopServer(serverHandler);
        }
    }

    public boolean checkForDuplicateDS(ServerHandler handler) {
        ServerHandler oldHandler = this.directoryServers.get(handler.getServerId());
        if (this.directoryServers.containsKey(handler.getServerId())) {
            Message message = ReplicationMessages.ERR_DUPLICATE_SERVER_ID.get(this.replicationServer.getMonitorInstanceName(), oldHandler.toString(), handler.toString(), handler.getServerId());
            ErrorLogger.logError(message);
            return false;
        }
        return true;
    }

    public void stopServer(ServerHandler handler) {
        if (!handler.engageShutdown()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " stopServer " + handler.getMonitorInstanceName());
            }
            try {
                this.lock();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (handler.isReplicationServer()) {
                if (this.replicationServers.containsValue(handler)) {
                    this.replicationServers.remove(handler.getServerId());
                    handler.shutdown();
                    this.mayResetGenerationId();
                    this.sendTopoInfoToDSs(null);
                }
            } else if (this.directoryServers.containsValue(handler)) {
                if (this.directoryServers.size() == 1) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " remote server " + handler.getMonitorInstanceName() + " is the last DS to be stopped: stopping status analyzer");
                    }
                    this.stopStatusAnalyzer();
                }
                this.directoryServers.remove(handler.getServerId());
                handler.shutdown();
                this.mayResetGenerationId();
                this.sendTopoInfoToRSs();
                this.sendTopoInfoToDSs(null);
            }
            this.release();
        }
    }

    protected void mayResetGenerationId() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId generationIdSavedStatus=" + this.generationIdSavedStatus);
        }
        boolean lDAPServersConnectedInTheTopology = false;
        if (this.directoryServers.isEmpty()) {
            for (ServerHandler rsh : this.replicationServers.values()) {
                if (this.generationId != rsh.getGenerationId()) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId skip RS" + rsh.getMonitorInstanceName() + " that has different genId");
                    continue;
                }
                if (!rsh.hasRemoteLDAPServers()) continue;
                lDAPServersConnectedInTheTopology = true;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId RS" + rsh.getMonitorInstanceName() + " has servers connected to it - will not reset generationId");
                }
                break;
            }
        } else {
            lDAPServersConnectedInTheTopology = true;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " has servers connected to it - will not reset generationId");
            }
        }
        if (!lDAPServersConnectedInTheTopology && !this.generationIdSavedStatus && this.generationId != -1L) {
            this.setGenerationId(-1L, false);
        }
    }

    public boolean checkForDuplicateRS(ServerHandler handler) {
        ServerHandler oldHandler = this.replicationServers.get(handler.getServerId());
        if (oldHandler != null) {
            if (!oldHandler.getServerAddressURL().equals(handler.getServerAddressURL())) {
                Message message = ReplicationMessages.ERR_DUPLICATE_REPLICATION_SERVER_ID.get(this.replicationServer.getMonitorInstanceName(), oldHandler.getServerAddressURL(), handler.getServerAddressURL(), handler.getServerId());
                ErrorLogger.logError(message);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMsg take(ServerHandler handler) {
        UpdateMsg msg = handler.take();
        Object object = this.flowControlLock;
        synchronized (object) {
            if (handler.restartAfterSaturation(null)) {
                this.flowControlLock.notifyAll();
            }
        }
        return msg;
    }

    public Set<String> getChangelogs() {
        LinkedHashSet<String> mySet = new LinkedHashSet<String>();
        for (ServerHandler handler : this.replicationServers.values()) {
            mySet.add(handler.getServerAddressURL());
        }
        return mySet;
    }

    public Set<Short> getServers() {
        return this.sourceDbHandlers.keySet();
    }

    public List<String> getConnectedLDAPservers() {
        ArrayList<String> mySet = new ArrayList<String>(0);
        for (ServerHandler handler : this.directoryServers.values()) {
            mySet.add(String.valueOf(handler.getServerId()));
        }
        return mySet;
    }

    public ReplicationIterator getChangelogIterator(short serverId, ChangeNumber changeNumber) {
        DbHandler handler = this.sourceDbHandlers.get(serverId);
        if (handler == null) {
            return null;
        }
        try {
            return handler.generateIterator(changeNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getChangesCount() {
        long entryCount = 0L;
        for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
            entryCount += dbHandler.getChangesCount();
        }
        return entryCount;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDbHandler(short serverId, DbHandler dbHandler) throws DatabaseException {
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            this.sourceDbHandlers.put(serverId, dbHandler);
        }
    }

    protected List<ServerHandler> getDestinationServers(RoutableMsg msg, ServerHandler senderHandler) {
        ArrayList<ServerHandler> servers;
        block4: {
            block6: {
                block5: {
                    servers = new ArrayList<ServerHandler>();
                    if (msg.getDestination() == -3) break block4;
                    if (msg.getDestination() != -2) break block5;
                    if (!senderHandler.isReplicationServer()) {
                        for (ServerHandler rsh : this.replicationServers.values()) {
                            if (!rsh.hasRemoteLDAPServers()) continue;
                            servers.add(rsh);
                        }
                    }
                    for (ServerHandler destinationHandler : this.directoryServers.values()) {
                        if (destinationHandler == senderHandler) continue;
                        servers.add(destinationHandler);
                    }
                    break block4;
                }
                ServerHandler destinationHandler = this.directoryServers.get(msg.getDestination());
                if (destinationHandler == null) break block6;
                servers.add(destinationHandler);
                break block4;
            }
            if (!senderHandler.isLDAPserver()) break block4;
            for (ServerHandler h : this.replicationServers.values()) {
                if (!h.isRemoteLDAPServer(msg.getDestination())) continue;
                servers.add(h);
            }
        }
        return servers;
    }

    public void process(RoutableMsg msg, ServerHandler senderHandler) {
        if (msg.getDestination() == this.replicationServer.getServerId()) {
            if (msg instanceof ErrorMsg) {
                ErrorMsg errorMsg = (ErrorMsg)msg;
                ErrorLogger.logError(ReplicationMessages.ERR_ERROR_MSG_RECEIVED.get(errorMsg.getDetails()));
            } else if (msg instanceof MonitorRequestMsg) {
                if (senderHandler.isLDAPserver()) {
                    MonitorMsg returnMsg = new MonitorMsg(msg.getDestination(), msg.getsenderID());
                    try {
                        short replicaId;
                        returnMsg.setReplServerDbState(this.getDbServerState());
                        MonitorData md = this.computeMonitorData();
                        Iterator<Short> it = md.ldapIterator();
                        while (it.hasNext()) {
                            replicaId = it.next();
                            returnMsg.setServerState(replicaId, md.getLDAPServerState(replicaId), md.getApproxFirstMissingDate(replicaId), true);
                        }
                        it = md.rsIterator();
                        while (it.hasNext()) {
                            replicaId = it.next();
                            returnMsg.setServerState(replicaId, md.getRSStates(replicaId), md.getRSApproxFirstMissingDate(replicaId), false);
                        }
                    }
                    catch (DirectoryException e) {
                        // empty catch block
                    }
                    try {
                        senderHandler.send(returnMsg);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                MonitorRequestMsg replServerMonitorRequestMsg = (MonitorRequestMsg)msg;
                MonitorMsg monitorMsg = new MonitorMsg(replServerMonitorRequestMsg.getDestination(), replServerMonitorRequestMsg.getsenderID());
                for (ServerHandler lsh : this.directoryServers.values()) {
                    monitorMsg.setServerState(lsh.getServerId(), lsh.getServerState(), lsh.getApproxFirstMissingDate(), true);
                }
                for (ServerHandler rsh : this.replicationServers.values()) {
                    monitorMsg.setServerState(rsh.getServerId(), rsh.getServerState(), rsh.getApproxFirstMissingDate(), false);
                }
                monitorMsg.setReplServerDbState(this.getDbServerState());
                try {
                    senderHandler.send(monitorMsg);
                }
                catch (Exception e) {
                    ErrorLogger.logError(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_MSG.get(Short.toString(msg.getDestination())));
                }
            } else if (msg instanceof MonitorMsg) {
                MonitorMsg monitorMsg = (MonitorMsg)msg;
                this.receivesMonitorDataResponse(monitorMsg);
            } else {
                ErrorLogger.logError(ReplicationMessages.NOTE_ERR_ROUTING_TO_SERVER.get(msg.getClass().getCanonicalName()));
            }
            return;
        }
        List<ServerHandler> servers = this.getDestinationServers(msg, senderHandler);
        if (servers.isEmpty()) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.get());
            mb.append(" In Replication Server=" + this.replicationServer.getMonitorInstanceName());
            mb.append(" domain =" + this.baseDn);
            mb.append(" unroutable message =" + msg.toString());
            mb.append(" routing table is empty");
            ErrorMsg errMsg = new ErrorMsg(this.replicationServer.getServerId(), msg.getsenderID(), mb.toMessage());
            ErrorLogger.logError(mb.toMessage());
            try {
                senderHandler.send(errMsg);
            }
            catch (IOException ioe) {
                MessageBuilder mb2 = new MessageBuilder();
                mb2.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_ERROR.get(this.toString()));
                mb2.append(StaticUtils.stackTraceToSingleLineString(ioe));
                ErrorLogger.logError(mb2.toMessage());
                this.stopServer(senderHandler);
            }
        } else {
            for (ServerHandler targetHandler : servers) {
                try {
                    targetHandler.send(msg);
                }
                catch (IOException ioe) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_MSG.get(this.toString()));
                    mb.append(StaticUtils.stackTraceToSingleLineString(ioe));
                    mb.append(" ");
                    mb.append(msg.getClass().getCanonicalName());
                    ErrorLogger.logError(mb.toMessage());
                    MessageBuilder mb1 = new MessageBuilder();
                    mb1.append(ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.get());
                    mb1.append("serverID:" + msg.getDestination());
                    ErrorMsg errMsg = new ErrorMsg(msg.getsenderID(), mb1.toMessage());
                    try {
                        senderHandler.send(errMsg);
                    }
                    catch (IOException ioe1) {
                        this.stopServer(senderHandler);
                        this.stopServer(targetHandler);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
        this.assuredTimeoutTimer.cancel();
        this.stopAllServers();
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
                dbHandler.shutdown();
            }
            this.sourceDbHandlers.clear();
        }
    }

    public ServerState getDbServerState() {
        ServerState serverState = new ServerState();
        for (DbHandler db : this.sourceDbHandlers.values()) {
            serverState.update(db.getLastChange());
        }
        return serverState;
    }

    @Override
    public String toString() {
        return "ReplicationServerDomain " + this.baseDn;
    }

    public void checkAllSaturation() throws IOException {
        for (ServerHandler handler : this.replicationServers.values()) {
            handler.checkWindow();
        }
        for (ServerHandler handler : this.directoryServers.values()) {
            handler.checkWindow();
        }
    }

    public boolean restartAfterSaturation(ServerHandler sourceHandler) {
        for (ServerHandler handler : this.replicationServers.values()) {
            if (handler.restartAfterSaturation(sourceHandler)) continue;
            return false;
        }
        for (ServerHandler handler : this.directoryServers.values()) {
            if (handler.restartAfterSaturation(sourceHandler)) continue;
            return false;
        }
        return true;
    }

    public void sendTopoInfoToDSs(ServerHandler notThisOne) {
        for (ServerHandler handler : this.directoryServers.values()) {
            if (notThisOne != null && (notThisOne == null || handler == notThisOne)) continue;
            TopologyMsg topoMsg = this.createTopologyMsgForDS(handler.getServerId());
            try {
                handler.sendTopoInfo(topoMsg);
            }
            catch (IOException e) {
                Message message = ReplicationMessages.ERR_EXCEPTION_SENDING_TOPO_INFO.get(this.baseDn.toString(), "directory", Short.toString(handler.getServerId()), e.getMessage());
                ErrorLogger.logError(message);
            }
        }
    }

    public void sendTopoInfoToRSs() {
        TopologyMsg topoMsg = this.createTopologyMsgForRS();
        for (ServerHandler handler : this.replicationServers.values()) {
            try {
                handler.sendTopoInfo(topoMsg);
            }
            catch (IOException e) {
                Message message = ReplicationMessages.ERR_EXCEPTION_SENDING_TOPO_INFO.get(this.baseDn.toString(), "replication", Short.toString(handler.getServerId()), e.getMessage());
                ErrorLogger.logError(message);
            }
        }
    }

    public TopologyMsg createTopologyMsgForRS() {
        ArrayList<DSInfo> dsInfos = new ArrayList<DSInfo>();
        for (ServerHandler serverHandler : this.directoryServers.values()) {
            dsInfos.add(serverHandler.toDSInfo());
        }
        ArrayList<RSInfo> rsInfos = new ArrayList<RSInfo>();
        RSInfo localRSInfo = new RSInfo(this.replicationServer.getServerId(), this.generationId, this.replicationServer.getGroupId());
        rsInfos.add(localRSInfo);
        return new TopologyMsg(dsInfos, rsInfos);
    }

    public TopologyMsg createTopologyMsgForDS(short destDsId) {
        ArrayList<DSInfo> dsInfos = new ArrayList<DSInfo>();
        ArrayList<RSInfo> rsInfos = new ArrayList<RSInfo>();
        for (ServerHandler serverHandler : this.directoryServers.values()) {
            if (serverHandler.getServerId() == destDsId) continue;
            dsInfos.add(serverHandler.toDSInfo());
        }
        RSInfo localRSInfo = new RSInfo(this.replicationServer.getServerId(), this.generationId, this.replicationServer.getGroupId());
        rsInfos.add(localRSInfo);
        for (ServerHandler serverHandler : this.replicationServers.values()) {
            rsInfos.add(serverHandler.toRSInfo());
            serverHandler.addDSInfos(dsInfos);
        }
        return new TopologyMsg(dsInfos, rsInfos);
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public boolean getGenerationIdSavedStatus() {
        return this.generationIdSavedStatus;
    }

    public synchronized long setGenerationId(long generationId, boolean savedStatus) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " RCache.set GenerationId=" + generationId);
        }
        long oldGenerationId = this.generationId;
        if (this.generationId != generationId) {
            this.clearDbs();
            this.generationId = generationId;
            this.generationIdSavedStatus = savedStatus;
        }
        return oldGenerationId;
    }

    public void resetGenerationId(ServerHandler senderHandler, ResetGenerationIdMsg genIdMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.getReplicationServer().getServerId() + " Receiving ResetGenerationIdMsg from " + senderHandler.getServerId() + " for baseDn " + this.baseDn + ":\n" + genIdMsg);
        }
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        long newGenId = genIdMsg.getGenerationId();
        if (newGenId != this.generationId) {
            this.setGenerationId(newGenId, false);
        } else if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.getReplicationServer().getServerId() + " Reset generation id requested for baseDn " + this.baseDn + " but generation id was already " + this.generationId + ":\n" + genIdMsg);
        }
        for (ServerHandler rsHandler : this.replicationServers.values()) {
            try {
                rsHandler.setGenerationId(newGenId);
                if (!senderHandler.isLDAPserver()) continue;
                rsHandler.forwardGenerationIdToRS(genIdMsg);
            }
            catch (IOException e) {
                ErrorLogger.logError(ReplicationMessages.ERR_EXCEPTION_FORWARDING_RESET_GEN_ID.get(this.baseDn.toString(), e.getMessage()));
            }
        }
        for (ServerHandler dsHandler : this.directoryServers.values()) {
            try {
                dsHandler.changeStatusForResetGenId(newGenId);
            }
            catch (IOException e) {
                ErrorLogger.logError(ReplicationMessages.ERR_EXCEPTION_CHANGING_STATUS_AFTER_RESET_GEN_ID.get(this.baseDn.toString(), Short.toString(dsHandler.getServerId()), e.getMessage()));
            }
        }
        this.sendTopoInfoToDSs(null);
        this.sendTopoInfoToRSs();
        Message message = ReplicationMessages.NOTE_RESET_GENERATION_ID.get(this.baseDn.toString(), Long.toString(newGenId));
        ErrorLogger.logError(message);
        this.release();
    }

    public void processNewStatus(ServerHandler senderHandler, ChangeStatusMsg csMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.getReplicationServer().getServerId() + " Receiving ChangeStatusMsg from " + senderHandler.getServerId() + " for baseDn " + this.baseDn + ":\n" + csMsg);
        }
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        ServerStatus newStatus = senderHandler.processNewStatus(csMsg);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            this.release();
            return;
        }
        this.sendTopoInfoToDSs(senderHandler);
        this.sendTopoInfoToRSs();
        Message message = ReplicationMessages.NOTE_DIRECTORY_SERVER_CHANGED_STATUS.get(Short.toString(senderHandler.getServerId()), this.baseDn.toString(), newStatus.toString());
        ErrorLogger.logError(message);
        this.release();
    }

    public boolean changeStatusFromStatusAnalyzer(ServerHandler serverHandler, StatusMachineEvent event) {
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Status analyzer for domain " + this.baseDn + " has been interrupted when" + " trying to acquire domain lock for changing the status of DS " + serverHandler.getServerId());
            }
            return true;
        }
        ServerStatus newStatus = ServerStatus.INVALID_STATUS;
        ServerStatus oldStatus = serverHandler.getStatus();
        try {
            newStatus = serverHandler.changeStatusFromStatusAnalyzer(event);
        }
        catch (IOException e) {
            ErrorLogger.logError(ReplicationMessages.ERR_EXCEPTION_CHANGING_STATUS_FROM_STATUS_ANALYZER.get(this.baseDn.toString(), Short.toString(serverHandler.getServerId()), e.getMessage()));
        }
        if (newStatus == ServerStatus.INVALID_STATUS || newStatus == oldStatus) {
            this.release();
            return false;
        }
        this.sendTopoInfoToDSs(serverHandler);
        this.sendTopoInfoToRSs();
        this.release();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDbs() {
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
                try {
                    dbHandler.clear();
                }
                catch (Exception e) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(dbHandler.toString(), e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString(e)));
                    ErrorLogger.logError(mb.toMessage());
                }
            }
            this.sourceDbHandlers.clear();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " The source db handler has been cleared");
            }
        }
        try {
            this.replicationServer.clearGenerationId(this.baseDn);
        }
        catch (Exception e) {
            ErrorLogger.logError(Message.raw("Exception caught while clearing generationId:" + e.getLocalizedMessage(), new Object[0]));
        }
    }

    public boolean isDegradedDueToGenerationId(short serverId) {
        ServerHandler handler;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " isDegraded serverId=" + serverId + " given local generation Id=" + this.generationId);
        }
        if ((handler = this.replicationServers.get(serverId)) == null && (handler = this.directoryServers.get(serverId)) == null) {
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " Compute degradation of serverId=" + serverId + " LS server generation Id=" + handler.getGenerationId());
        }
        return handler.getGenerationId() != this.generationId;
    }

    public ReplicationServer getReplicationServer() {
        return this.replicationServer;
    }

    public void receiveTopoInfoFromRS(TopologyMsg topoMsg, ServerHandler handler, boolean allowResetGenId) throws IOException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.getReplicationServer().getServerId() + " Receiving TopologyMsg from " + handler.getServerId() + " for baseDn " + this.baseDn + ":\n" + topoMsg);
        }
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        handler.receiveTopoInfoFromRS(topoMsg);
        if (allowResetGenId) {
            this.mayResetGenerationId();
            if (this.generationId < 0L) {
                this.generationId = handler.getGenerationId();
            }
        }
        if (this.generationId > 0L && this.generationId != handler.getGenerationId()) {
            Message message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.baseDn, Short.toString(handler.getServerId()), Long.toString(handler.getGenerationId()), Long.toString(this.generationId));
            ErrorLogger.logError(message);
            ErrorMsg errorMsg = new ErrorMsg(this.getReplicationServer().getServerId(), handler.getServerId(), message);
            handler.sendError(errorMsg);
        }
        this.sendTopoInfoToDSs(null);
        this.release();
    }

    protected synchronized MonitorData computeMonitorData() throws DirectoryException {
        this.replicationServer.computeMonitorData();
        return this.monitorData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int initializeMonitorData() throws DirectoryException {
        Object object = this.monitorDataLock;
        synchronized (object) {
            this.wrkMonitorData = new MonitorData();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " Computing monitor data ");
            }
            for (ServerHandler directlsh : this.directoryServers.values()) {
                short serverID = directlsh.getServerId();
                ServerState directlshState = directlsh.getServerState().duplicate();
                ChangeNumber maxcn = directlshState.getMaxChangeNumber(serverID);
                if (maxcn == null) {
                    maxcn = new ChangeNumber(0L, 0, serverID);
                }
                this.wrkMonitorData.setMaxCN(serverID, maxcn);
                this.wrkMonitorData.setLDAPServerState(serverID, directlshState);
                this.wrkMonitorData.setFirstMissingDate(serverID, directlsh.getApproxFirstMissingDate());
            }
            ServerState dbServerState = this.getDbServerState();
            this.wrkMonitorData.setRSState(this.replicationServer.getServerId(), dbServerState);
            for (short sid : dbServerState) {
                ChangeNumber storedCN = dbServerState.getMaxChangeNumber(sid);
                this.wrkMonitorData.setMaxCN(sid, storedCN);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " Local monitor data: " + this.wrkMonitorData.toString());
            }
        }
        return this.sendMonitorDataRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeMonitorData() {
        this.wrkMonitorData.completeComputing();
        Object object = this.monitorDataLock;
        synchronized (object) {
            this.monitorData = this.wrkMonitorData;
            this.wrkMonitorData = null;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " *** Computed MonitorData: " + this.monitorData.toString());
            }
        }
    }

    protected int sendMonitorDataRequest() throws DirectoryException {
        int sent = 0;
        try {
            for (ServerHandler rs : this.replicationServers.values()) {
                MonitorRequestMsg msg = new MonitorRequestMsg(this.replicationServer.getServerId(), rs.getServerId());
                rs.send(msg);
                ++sent;
            }
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_SENDING_REMOTE_MONITOR_DATA_REQUEST.get();
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, e);
        }
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivesMonitorDataResponse(MonitorMsg msg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + "Receiving " + msg + " from " + msg.getsenderID());
        }
        try {
            Object object = this.monitorDataLock;
            synchronized (object) {
                if (this.wrkMonitorData == null) {
                    ErrorLogger.logError(ReplicationMessages.NOTE_IGNORING_REMOTE_MONITOR_DATA.get(Short.toString(msg.getsenderID())));
                    return;
                }
                ServerState replServerState = msg.getReplServerDbState();
                this.wrkMonitorData.setMaxCNs(replServerState);
                this.wrkMonitorData.setRSState(msg.getsenderID(), replServerState);
                Iterator<Short> lsidIterator = msg.ldapIterator();
                while (lsidIterator.hasNext()) {
                    short sid = lsidIterator.next();
                    ServerState dsServerState = msg.getLDAPServerState(sid);
                    this.wrkMonitorData.setMaxCNs(dsServerState);
                    this.wrkMonitorData.setLDAPServerState(sid, dsServerState);
                    this.wrkMonitorData.setFirstMissingDate(sid, msg.getLDAPApproxFirstMissingDate(sid));
                }
                Iterator<Short> rsidIterator = msg.rsIterator();
                while (rsidIterator.hasNext()) {
                    Long newfmd;
                    short rsid = rsidIterator.next();
                    if (rsid == this.replicationServer.getServerId()) {
                        for (ServerHandler connectedlsh : this.directoryServers.values()) {
                            short connectedlsid = connectedlsh.getServerId();
                            newfmd = msg.getRSApproxFirstMissingDate(rsid);
                            this.wrkMonitorData.setFirstMissingDate(connectedlsid, newfmd);
                        }
                        continue;
                    }
                    ServerHandler rsjHdr = this.replicationServers.get(rsid);
                    if (rsjHdr == null) continue;
                    for (short remotelsid : rsjHdr.getConnectedDirectoryServerIds()) {
                        newfmd = msg.getRSApproxFirstMissingDate(rsid);
                        this.wrkMonitorData.setFirstMissingDate(remotelsid, newfmd);
                    }
                }
                if (DebugLogger.debugEnabled() && DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " Processed msg from " + msg.getsenderID() + " New monitor data: " + this.wrkMonitorData.toString());
                }
            }
            this.replicationServer.responseReceived();
        }
        catch (Exception e) {
            ErrorLogger.logError(ReplicationMessages.ERR_PROCESSING_REMOTE_MONITOR_DATA.get(e.getMessage() + StaticUtils.stackTraceToSingleLineString(e)));
            this.replicationServer.responseReceivedAll();
        }
    }

    void setPurgeDelay(long delay) {
        for (DbHandler handler : this.sourceDbHandlers.values()) {
            handler.setPurgeDelay(delay);
        }
    }

    public Map<Short, ServerHandler> getConnectedDSs() {
        return this.directoryServers;
    }

    public Map<Short, ServerHandler> getConnectedRSs() {
        return this.replicationServers;
    }

    public boolean hasLock() {
        return this.lock.getHoldCount() > 0;
    }

    public void lock() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public void release() {
        this.lock.unlock();
    }

    public boolean tryLock(long timeout) throws InterruptedException {
        return this.lock.tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    public void startStatusAnalyzer() {
        int degradedStatusThreshold;
        if (this.statusAnalyzer == null && (degradedStatusThreshold = this.replicationServer.getDegradedStatusThreshold()) > 0) {
            this.statusAnalyzer = new StatusAnalyzer(this, degradedStatusThreshold);
            this.statusAnalyzer.start();
        }
    }

    public void stopStatusAnalyzer() {
        if (this.statusAnalyzer != null) {
            this.statusAnalyzer.shutdown();
            this.statusAnalyzer.waitForShutdown();
            this.statusAnalyzer = null;
        }
    }

    public boolean isRunningStatusAnalyzer() {
        return this.statusAnalyzer != null;
    }

    public void updateStatusAnalyzer(int degradedStatusThreshold) {
        if (this.statusAnalyzer != null) {
            this.statusAnalyzer.setDeradedStatusThreshold(degradedStatusThreshold);
        }
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuraiton) {
    }

    @Override
    public String getMonitorInstanceName() {
        return "Replication Server " + this.replicationServer.getReplicationPort() + " " + " " + this.replicationServer.getServerId() + ",cn=" + this.baseDn.replace(',', '_').replace('=', '_') + ",cn=replication";
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(Attributes.create("replication server id", String.valueOf(this.replicationServer.getServerId())));
        attributes.add(Attributes.create("replication server port", String.valueOf(this.replicationServer.getReplicationPort())));
        AttributeBuilder builder = new AttributeBuilder("domain-name");
        builder.add(this.baseDn);
        attributes.add(builder.toAttribute());
        builder = new AttributeBuilder("generation-id");
        builder.add(this.baseDn.toString() + " " + this.generationId);
        attributes.add(builder.toAttribute());
        try {
            MonitorData md = this.computeMonitorData();
            long missingChanges = md.getMissingChangesRS(this.replicationServer.getServerId());
            attributes.add(Attributes.create("missing-changes", String.valueOf(missingChanges)));
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_ERROR_RETRIEVING_MONITOR_DATA.get(StaticUtils.stackTraceToSingleLineString(e));
            attributes.add(Attributes.create("error", message.toString()));
        }
        return attributes;
    }

    private class AssuredTimeoutTask
    extends TimerTask {
        private ChangeNumber cn = null;

        public AssuredTimeoutTask(ChangeNumber cn) {
            this.cn = cn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ExpectedAcksInfo expectedAcksInfo = (ExpectedAcksInfo)ReplicationServerDomain.this.waitingAcks.get(this.cn);
            if (expectedAcksInfo != null) {
                ExpectedAcksInfo expectedAcksInfo2 = expectedAcksInfo;
                synchronized (expectedAcksInfo2) {
                    boolean safeRead;
                    if (expectedAcksInfo.isCompleted()) {
                        return;
                    }
                    ReplicationServerDomain.this.waitingAcks.remove(this.cn);
                    AckMsg finalAck = expectedAcksInfo.createAck(true);
                    ServerHandler origServer = expectedAcksInfo.getRequesterServer();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS " + Short.toString(ReplicationServerDomain.this.replicationServer.getServerId()) + " for " + ReplicationServerDomain.this.baseDn + ", sending timeout for assured update with change " + " number " + this.cn.toString() + " to server id " + Short.toString(origServer.getServerId()));
                    }
                    try {
                        origServer.sendAck(finalAck);
                    }
                    catch (IOException e) {
                        MessageBuilder mb = new MessageBuilder();
                        mb.append(ReplicationMessages.ERR_RS_ERROR_SENDING_ACK.get(Short.toString(ReplicationServerDomain.this.replicationServer.getServerId()), Short.toString(origServer.getServerId()), this.cn.toString(), ReplicationServerDomain.this.baseDn));
                        mb.append(StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(mb.toMessage());
                        ReplicationServerDomain.this.stopServer(origServer);
                    }
                    boolean bl = safeRead = expectedAcksInfo instanceof SafeReadExpectedAcksInfo;
                    if (safeRead) {
                        origServer.incrementAssuredSrReceivedUpdatesTimeout();
                    } else if (origServer.isLDAPserver()) {
                        origServer.incrementAssuredSdReceivedUpdatesTimeout();
                    }
                    List<Short> serversInTimeout = expectedAcksInfo.getTimeoutServers();
                    for (Short serverId : serversInTimeout) {
                        ServerHandler expectedServerInTimeout = (ServerHandler)ReplicationServerDomain.this.directoryServers.get(serverId);
                        if (expectedServerInTimeout != null) {
                            if (!safeRead) continue;
                            expectedServerInTimeout.incrementAssuredSrSentUpdatesTimeout();
                            continue;
                        }
                        expectedServerInTimeout = (ServerHandler)ReplicationServerDomain.this.replicationServers.get(serverId);
                        if (expectedServerInTimeout == null) continue;
                        if (safeRead) {
                            expectedServerInTimeout.incrementAssuredSrSentUpdatesTimeout();
                            continue;
                        }
                        expectedServerInTimeout.incrementAssuredSdSentUpdatesTimeout();
                    }
                    expectedAcksInfo.completed();
                }
            }
        }
    }

    private class PreparedAssuredInfo {
        public List<Short> expectedServers = null;
        public ExpectedAcksInfo expectedAcksInfo = null;

        private PreparedAssuredInfo() {
        }
    }
}

