/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPResultCode;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

public class LDAPToolUtils {
    public static LDAPControl getControl(String argString, PrintStream err) {
        LDAPControl control = null;
        String controlOID = null;
        boolean controlCriticality = false;
        ByteString controlValue = null;
        int idx = argString.indexOf(":");
        controlOID = idx < 0 ? argString : argString.substring(0, idx);
        String lowerOID = StaticUtils.toLowerCase(controlOID);
        if (lowerOID.equals("accountusable") || lowerOID.equals("accountusability")) {
            controlOID = "1.3.6.1.4.1.42.2.27.9.5.8";
        } else if (lowerOID.equals("authzid") || lowerOID.equals("authorizationidentity")) {
            controlOID = "2.16.840.1.113730.3.4.16";
        } else if (lowerOID.equals("noop") || lowerOID.equals("no-op")) {
            controlOID = "1.3.6.1.4.1.4203.1.10.2";
        } else if (lowerOID.equals("subentries")) {
            controlOID = "1.3.6.1.4.1.7628.5.101.1";
        } else if (lowerOID.equals("managedsait")) {
            controlOID = "2.16.840.1.113730.3.4.2";
        } else if (lowerOID.equals("pwpolicy") || lowerOID.equals("passwordpolicy")) {
            controlOID = "1.3.6.1.4.1.42.2.27.8.5.1";
        } else if (lowerOID.equals("subtreedelete") || lowerOID.equals("treedelete")) {
            controlOID = "1.2.840.113556.1.4.805";
        } else if (lowerOID.equals("realattrsonly") || lowerOID.equals("realattributesonly")) {
            controlOID = "2.16.840.1.113730.3.4.17";
        } else if (lowerOID.equals("virtualattrsonly") || lowerOID.equals("virtualattributesonly")) {
            controlOID = "2.16.840.1.113730.3.4.19";
        } else if (lowerOID.equals("effectiverights") || lowerOID.equals("geteffectiverights")) {
            controlOID = "1.3.6.1.4.1.42.2.27.9.5.2";
        }
        if (idx < 0) {
            return new LDAPControl(controlOID);
        }
        String remainder = argString.substring(idx + 1, argString.length());
        if ((idx = remainder.indexOf(":")) == -1) {
            if (remainder.equalsIgnoreCase("true")) {
                controlCriticality = true;
            } else if (remainder.equalsIgnoreCase("false")) {
                controlCriticality = false;
            } else {
                err.println("Invalid format for criticality value:" + remainder);
                return null;
            }
            control = new LDAPControl(controlOID, controlCriticality);
            return control;
        }
        String critical = remainder.substring(0, idx);
        if (critical.equalsIgnoreCase("true")) {
            controlCriticality = true;
        } else if (critical.equalsIgnoreCase("false")) {
            controlCriticality = false;
        } else {
            err.println("Invalid format for criticality value:" + critical);
            return null;
        }
        String valString = remainder.substring(idx + 1, remainder.length());
        if (valString.charAt(0) == ':') {
            controlValue = ByteString.valueOf(valString.substring(1, valString.length()));
        } else if (valString.charAt(0) == '<') {
            String filePath = valString.substring(1, valString.length());
            try {
                byte[] val = LDAPToolUtils.readBytesFromFile(filePath, err);
                controlValue = ByteString.wrap(val);
            }
            catch (Exception e) {
                return null;
            }
        } else {
            controlValue = ByteString.valueOf(valString);
        }
        control = new LDAPControl(controlOID, controlCriticality, controlValue);
        return control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromFile(String filePath, PrintStream err) throws IOException {
        byte[] val = null;
        FileInputStream fis = null;
        try {
            int offset;
            File file = new File(filePath);
            fis = new FileInputStream(file);
            long length = file.length();
            val = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < val.length && (numRead = fis.read(val, offset, val.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < val.length) {
                err.println("Could not completely read file " + filePath);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = val;
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static void printErrorMessage(PrintStream err, Message explanation, int resultCode, Message errorMessage, DN matchedDN) {
        if (explanation != null && explanation.length() > 0) {
            err.println(explanation);
        }
        if (resultCode >= 0) {
            err.println(ToolMessages.ERR_TOOL_RESULT_CODE.get(resultCode, LDAPResultCode.toString(resultCode)));
        }
        if (errorMessage != null && errorMessage.length() > 0) {
            err.println(ToolMessages.ERR_TOOL_ERROR_MESSAGE.get(errorMessage));
        }
        if (matchedDN != null) {
            err.println(ToolMessages.ERR_TOOL_MATCHED_DN.get(matchedDN.toString()));
        }
    }
}

