/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchScope;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public class DN
implements Comparable<DN>,
Serializable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static DN NULL_DN = new DN();
    private static final long serialVersionUID = 1184263456768819888L;
    private final int numComponents;
    private final RDN[] rdnComponents;
    private String dnString;
    private String normalizedDN;

    public DN() {
        this(new RDN[0]);
    }

    public DN(RDN[] rdnComponents) {
        this.rdnComponents = rdnComponents == null ? new RDN[0] : rdnComponents;
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = null;
    }

    public DN(List<RDN> rdnComponents) {
        if (rdnComponents == null || rdnComponents.isEmpty()) {
            this.rdnComponents = new RDN[0];
        } else {
            this.rdnComponents = new RDN[rdnComponents.size()];
            rdnComponents.toArray(this.rdnComponents);
        }
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = null;
    }

    public DN(RDN rdn, DN parentDN) {
        Validator.ensureNotNull(rdn, parentDN);
        if (parentDN.isNullDN()) {
            this.rdnComponents = new RDN[]{rdn};
        } else {
            this.rdnComponents = new RDN[parentDN.numComponents + 1];
            this.rdnComponents[0] = rdn;
            System.arraycopy(parentDN.rdnComponents, 0, this.rdnComponents, 1, parentDN.numComponents);
        }
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = null;
    }

    public static DN nullDN() {
        return NULL_DN;
    }

    public boolean isNullDN() {
        return this.numComponents == 0;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public RDN getRDN() {
        if (this.numComponents == 0) {
            return null;
        }
        return this.rdnComponents[0];
    }

    public RDN getRDN(int pos) {
        return this.rdnComponents[pos];
    }

    public DN getParent() {
        if (this.numComponents <= 1) {
            return null;
        }
        RDN[] parentComponents = new RDN[this.numComponents - 1];
        System.arraycopy(this.rdnComponents, 1, parentComponents, 0, this.numComponents - 1);
        return new DN(parentComponents);
    }

    public DN getParentDNInSuffix() {
        if (this.numComponents <= 1 || DirectoryServer.isNamingContext(this)) {
            return null;
        }
        RDN[] parentComponents = new RDN[this.numComponents - 1];
        System.arraycopy(this.rdnComponents, 1, parentComponents, 0, this.numComponents - 1);
        return new DN(parentComponents);
    }

    public DN concat(RDN rdn) {
        RDN[] newComponents = new RDN[this.rdnComponents.length + 1];
        newComponents[0] = rdn;
        System.arraycopy(this.rdnComponents, 0, newComponents, 1, this.rdnComponents.length);
        return new DN(newComponents);
    }

    public DN concat(RDN[] rdnComponents) {
        RDN[] newComponents = new RDN[rdnComponents.length + this.rdnComponents.length];
        System.arraycopy(rdnComponents, 0, newComponents, 0, rdnComponents.length);
        System.arraycopy(this.rdnComponents, 0, newComponents, rdnComponents.length, this.rdnComponents.length);
        return new DN(newComponents);
    }

    public DN concat(DN relativeBaseDN) {
        RDN[] newComponents = new RDN[this.rdnComponents.length + relativeBaseDN.rdnComponents.length];
        System.arraycopy(relativeBaseDN.rdnComponents, 0, newComponents, 0, relativeBaseDN.rdnComponents.length);
        System.arraycopy(this.rdnComponents, 0, newComponents, relativeBaseDN.rdnComponents.length, this.rdnComponents.length);
        return new DN(newComponents);
    }

    public boolean isDescendantOf(DN dn) {
        int offset = this.numComponents - dn.numComponents;
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < dn.numComponents; ++i) {
            if (this.rdnComponents[i + offset].equals(dn.rdnComponents[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOf(DN dn) {
        int offset = dn.numComponents - this.numComponents;
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < this.numComponents; ++i) {
            if (this.rdnComponents[i].equals(dn.rdnComponents[i + offset])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesBaseAndScope(DN baseDN, SearchScope scope) {
        switch (scope) {
            case BASE_OBJECT: {
                return this.equals(baseDN);
            }
            case SINGLE_LEVEL: {
                return baseDN.equals(this.getParent());
            }
            case WHOLE_SUBTREE: {
                return this.isDescendantOf(baseDN);
            }
            case SUBORDINATE_SUBTREE: {
                return !this.equals(baseDN) && this.isDescendantOf(baseDN);
            }
        }
        return false;
    }

    public static DN decode(ByteString dnString) throws DirectoryException {
        if (dnString == null) {
            return NULL_DN;
        }
        int length = dnString.length();
        if (length == 0) {
            return NULL_DN;
        }
        int b = 0;
        for (int i = 0; i < length; ++i) {
            b = dnString.byteAt(i);
            if ((b & 0x7F) == b && b != 92) continue;
            return DN.decode(dnString.toString());
        }
        ByteSequenceReader dnReader = dnString.asReader();
        b = 32;
        while (dnReader.remaining() > 0) {
            byte by = dnReader.get();
            b = by;
            if (by == 32) continue;
        }
        if (b == 32) {
            return NULL_DN;
        }
        dnReader.skip(-1);
        boolean allowExceptions = DirectoryServer.allowAttributeNameExceptions();
        LinkedList<RDN> rdnComponents = new LinkedList<RDN>();
        block2: while (true) {
            Message message;
            ByteString attributeName = DN.parseAttributeName(dnReader, allowExceptions);
            if (dnReader.remaining() <= 0) {
                message = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(dnString.toString(), attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            b = 32;
            while (dnReader.remaining() > 0) {
                byte by = dnReader.get();
                b = by;
                if (by == 32) continue;
            }
            if (b == 32) {
                message = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(dnString.toString(), attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            if (b != 61) {
                message = SchemaMessages.ERR_ATTR_SYNTAX_DN_NO_EQUAL.get(dnString.toString(), attributeName.toString(), Character.valueOf((char)b));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            b = 32;
            while (dnReader.remaining() > 0) {
                byte by = dnReader.get();
                b = by;
                if (by == 32) continue;
            }
            if (b == 32) {
                StringBuilder lowerName = new StringBuilder();
                StaticUtils.toLowerCase(attributeName, lowerName, true);
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName.toString());
                String attributeNameString = attributeName.toString();
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attributeNameString);
                }
                AttributeValue value = AttributeValues.create(ByteString.empty(), ByteString.empty());
                rdnComponents.add(new RDN(attrType, attributeNameString, value));
                return new DN(rdnComponents);
            }
            dnReader.skip(-1);
            ByteString parsedValue = DN.parseAttributeValue(dnReader);
            StringBuilder lowerName = new StringBuilder();
            StaticUtils.toLowerCase(attributeName, lowerName, true);
            AttributeType attrType = DirectoryServer.getAttributeType(lowerName.toString());
            String attributeNameString = attributeName.toString();
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(attributeNameString);
            }
            AttributeValue value = AttributeValues.create(attrType, parsedValue);
            RDN rdn = new RDN(attrType, attributeNameString, value);
            b = 32;
            while (dnReader.remaining() > 0) {
                byte by = dnReader.get();
                b = by;
                if (by == 32) continue;
            }
            if (b == 32) {
                rdnComponents.add(rdn);
                return new DN(rdnComponents);
            }
            if (b == 44 || b == 59) {
                rdnComponents.add(rdn);
                continue;
            }
            if (b != 43) {
                Message message2 = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_CHAR.get(dnReader.toString(), Character.valueOf((char)b), dnReader.position() - 1);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message2);
            }
            do {
                b = 32;
                while (dnReader.remaining() > 0) {
                    byte by = dnReader.get();
                    b = by;
                    if (by == 32) continue;
                }
                dnReader.skip(-1);
                attributeName = DN.parseAttributeName(dnReader, allowExceptions);
                if (b == 32) {
                    Message message3 = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(dnString.toString(), attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message3);
                }
                b = 32;
                while (dnReader.remaining() > 0) {
                    byte by = dnReader.get();
                    b = by;
                    if (by == 32) continue;
                }
                if (b == 32) {
                    Message message4 = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(dnString.toString(), attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message4);
                }
                if (b != 61) {
                    Message message5 = SchemaMessages.ERR_ATTR_SYNTAX_DN_NO_EQUAL.get(dnString.toString(), attributeName.toString(), Character.valueOf((char)b));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message5);
                }
                b = 32;
                while (dnReader.remaining() > 0) {
                    byte by = dnReader.get();
                    b = by;
                    if (by == 32) continue;
                }
                if (b == 32) {
                    lowerName = new StringBuilder();
                    StaticUtils.toLowerCase(attributeName, lowerName, true);
                    attrType = DirectoryServer.getAttributeType(lowerName.toString());
                    attributeNameString = attributeName.toString();
                    if (attrType == null) {
                        attrType = DirectoryServer.getDefaultAttributeType(attributeNameString);
                    }
                    value = AttributeValues.create(ByteString.empty(), ByteString.empty());
                    rdn.addValue(attrType, attributeNameString, value);
                    rdnComponents.add(rdn);
                    return new DN(rdnComponents);
                }
                dnReader.skip(-1);
                parsedValue = DN.parseAttributeValue(dnReader);
                lowerName = new StringBuilder();
                StaticUtils.toLowerCase(attributeName, lowerName, true);
                attrType = DirectoryServer.getAttributeType(lowerName.toString());
                attributeNameString = attributeName.toString();
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attributeNameString);
                }
                value = AttributeValues.create(attrType, parsedValue);
                rdn.addValue(attrType, attributeNameString, value);
                b = 32;
                while (dnReader.remaining() > 0) {
                    byte by = dnReader.get();
                    b = by;
                    if (by == 32) continue;
                }
                if (b == 32) {
                    rdnComponents.add(rdn);
                    return new DN(rdnComponents);
                }
                if (b != 44 && b != 59) continue;
                rdnComponents.add(rdn);
                continue block2;
            } while (b == 43);
            break;
        }
        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_CHAR.get(dnString.toString(), Character.valueOf((char)b), dnReader.position() - 1);
        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
    }

    public static DN decode(String dnString) throws DirectoryException {
        if (dnString == null) {
            return NULL_DN;
        }
        int length = dnString.length();
        if (length == 0) {
            return NULL_DN;
        }
        int pos = 0;
        char c = dnString.charAt(pos);
        while (c == ' ') {
            if (++pos == length) {
                return NULL_DN;
            }
            c = dnString.charAt(pos);
        }
        boolean allowExceptions = DirectoryServer.allowAttributeNameExceptions();
        LinkedList<RDN> rdnComponents = new LinkedList<RDN>();
        block1: while (true) {
            Message message;
            StringBuilder attributeName;
            if ((pos = DN.parseAttributeName(dnString, pos, attributeName = new StringBuilder(), allowExceptions)) >= length) {
                message = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(dnString, attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            c = dnString.charAt(pos);
            while (c == ' ') {
                if (++pos >= length) {
                    message = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(dnString, attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                c = dnString.charAt(pos);
            }
            if (c == '=') {
                ++pos;
            } else {
                message = SchemaMessages.ERR_ATTR_SYNTAX_DN_NO_EQUAL.get(dnString, attributeName.toString(), Character.valueOf(c));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                String name = attributeName.toString();
                String lowerName = StaticUtils.toLowerCase(name);
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(name);
                }
                AttributeValue value = AttributeValues.create(ByteString.empty(), ByteString.empty());
                rdnComponents.add(new RDN(attrType, name, value));
                return new DN(rdnComponents);
            }
            ByteStringBuilder parsedValue = new ByteStringBuilder(0);
            pos = DN.parseAttributeValue(dnString, pos, parsedValue);
            String name = attributeName.toString();
            String lowerName = StaticUtils.toLowerCase(name);
            AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(name);
            }
            AttributeValue value = AttributeValues.create(attrType, parsedValue.toByteString());
            RDN rdn = new RDN(attrType, name, value);
            while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                rdnComponents.add(rdn);
                return new DN(rdnComponents);
            }
            if (c == ',' || c == ';') {
                rdnComponents.add(rdn);
                ++pos;
                continue;
            }
            if (c != '+') {
                Message message2 = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_CHAR.get(dnString, Character.valueOf(c), pos);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message2);
            }
            do {
                ++pos;
                while (pos < length && dnString.charAt(pos) == ' ') {
                    ++pos;
                }
                attributeName = new StringBuilder();
                if ((pos = DN.parseAttributeName(dnString, pos, attributeName, allowExceptions)) >= length) {
                    Message message3 = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(dnString, attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message3);
                }
                c = dnString.charAt(pos);
                while (c == ' ') {
                    if (++pos >= length) {
                        Message message4 = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(dnString, attributeName.toString());
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message4);
                    }
                    c = dnString.charAt(pos);
                }
                if (c == '=') {
                    ++pos;
                } else {
                    Message message5 = SchemaMessages.ERR_ATTR_SYNTAX_DN_NO_EQUAL.get(dnString, attributeName.toString(), Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message5);
                }
                while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                    ++pos;
                }
                if (pos >= length) {
                    name = attributeName.toString();
                    lowerName = StaticUtils.toLowerCase(name);
                    attrType = DirectoryServer.getAttributeType(lowerName);
                    if (attrType == null) {
                        attrType = DirectoryServer.getDefaultAttributeType(name);
                    }
                    value = AttributeValues.create(ByteString.empty(), ByteString.empty());
                    rdn.addValue(attrType, name, value);
                    rdnComponents.add(rdn);
                    return new DN(rdnComponents);
                }
                parsedValue.clear();
                pos = DN.parseAttributeValue(dnString, pos, parsedValue);
                name = attributeName.toString();
                lowerName = StaticUtils.toLowerCase(name);
                attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(name);
                }
                value = AttributeValues.create(attrType, parsedValue.toByteString());
                rdn.addValue(attrType, name, value);
                while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                    ++pos;
                }
                if (pos >= length) {
                    rdnComponents.add(rdn);
                    return new DN(rdnComponents);
                }
                if (c != ',' && c != ';') continue;
                rdnComponents.add(rdn);
                ++pos;
                continue block1;
            } while (c == '+');
            break;
        }
        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_CHAR.get(dnString, Character.valueOf(c), pos);
        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
    }

    static ByteString parseAttributeName(ByteSequenceReader dnBytes, boolean allowExceptions) throws DirectoryException {
        while (dnBytes.remaining() > 0 && dnBytes.get() == 32) {
        }
        if (dnBytes.remaining() <= 0) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_COMMA.get(dnBytes.toString());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        dnBytes.skip(-1);
        int nameStartPos = dnBytes.position();
        ByteString nameBytes = null;
        boolean checkForOID = false;
        boolean endOfName = false;
        while (dnBytes.remaining() > 0) {
            byte b = dnBytes.get();
            switch (b) {
                case 32: {
                    endOfName = true;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnBytes.toString(), Character.valueOf((char)b), dnBytes.position() - 1);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
                case 45: {
                    if (dnBytes.position() != nameStartPos + 1) break;
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_DASH.get(dnBytes.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
                case 46: {
                    checkForOID = true;
                    break;
                }
                case 47: {
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnBytes.toString(), Character.valueOf((char)b), dnBytes.position() - 1);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                case 58: 
                case 59: 
                case 60: {
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnBytes.toString(), Character.valueOf((char)b), dnBytes.position() - 1);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
                case 61: {
                    endOfName = true;
                    break;
                }
                case 62: 
                case 63: 
                case 64: {
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnBytes.toString(), Character.valueOf((char)b), dnBytes.position() - 1);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    break;
                }
                case 91: 
                case 92: 
                case 93: 
                case 94: {
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnBytes.toString(), Character.valueOf((char)b), dnBytes.position() - 1);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
                case 95: {
                    if (dnBytes.position() == nameStartPos + 1) {
                        Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_UNDERSCORE.get(dnBytes.toString(), "ds-cfg-allow-attribute-name-exceptions");
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                    }
                    if (allowExceptions) break;
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_UNDERSCORE_CHAR.get(dnBytes.toString(), "ds-cfg-allow-attribute-name-exceptions");
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
                case 96: {
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnBytes.toString(), Character.valueOf((char)b), dnBytes.position() - 1);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    break;
                }
                default: {
                    Message msg = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnBytes.toString(), Character.valueOf((char)b), dnBytes.position() - 1);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, msg);
                }
            }
            if (!endOfName) continue;
            int nameEndPos = dnBytes.position() - 1;
            dnBytes.position(nameStartPos);
            nameBytes = dnBytes.getByteString(nameEndPos - nameStartPos);
            break;
        }
        if (nameBytes == null || nameBytes.length() == 0) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME.get(dnBytes.toString());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        if (checkForOID) {
            boolean validOID = true;
            int namePos = 0;
            int nameLength = nameBytes.length();
            byte ch = nameBytes.byteAt(0);
            if (ch == 111 || ch == 79) {
                if (nameLength <= 4) {
                    validOID = false;
                } else {
                    ch = nameBytes.byteAt(1);
                    if (!(ch != 105 && ch != 73 || (ch = nameBytes.byteAt(2)) != 100 && ch != 68 || nameBytes.byteAt(3) != 46)) {
                        nameBytes = nameBytes.subSequence(4, nameBytes.length());
                        nameLength -= 4;
                    } else {
                        validOID = false;
                    }
                }
            }
            while (validOID && namePos < nameLength) {
                if (StaticUtils.isDigit((char)(ch = nameBytes.byteAt(namePos++)))) {
                    while (validOID && namePos < nameLength && StaticUtils.isDigit((char)nameBytes.byteAt(namePos))) {
                        ++namePos;
                    }
                    if (namePos >= nameLength || nameBytes.byteAt(namePos) == 46) continue;
                    validOID = false;
                    continue;
                }
                if (ch == 46) {
                    if (namePos != 1 && nameBytes.byteAt(namePos - 2) != 46) continue;
                    validOID = false;
                    continue;
                }
                validOID = false;
            }
            if (validOID && nameBytes.byteAt(nameLength - 1) == 46) {
                validOID = false;
            }
            if (!validOID) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_PERIOD.get(dnBytes.toString(), nameBytes.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
        } else if (StaticUtils.isDigit((char)nameBytes.byteAt(0)) && !allowExceptions) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_DIGIT.get(dnBytes.toString(), Character.valueOf((char)nameBytes.byteAt(0)), "ds-cfg-allow-attribute-name-exceptions");
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        return nameBytes;
    }

    static int parseAttributeName(String dnString, int pos, StringBuilder attributeName, boolean allowExceptions) throws DirectoryException {
        int length = dnString.length();
        if (pos < length) {
            while (dnString.charAt(pos) == ' ') {
                if (++pos != length) continue;
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_END_WITH_COMMA.get(dnString);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
        }
        boolean checkForOID = false;
        boolean endOfName = false;
        while (pos < length) {
            char c = dnString.charAt(pos);
            switch (c) {
                case ' ': {
                    endOfName = true;
                    break;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                case '-': {
                    if (attributeName.length() > 0) {
                        attributeName.append(c);
                        break;
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_DASH.get(dnString);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                case '.': {
                    attributeName.append(c);
                    checkForOID = true;
                    break;
                }
                case '/': {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    attributeName.append(c);
                    break;
                }
                case ':': 
                case ';': 
                case '<': {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                case '=': {
                    endOfName = true;
                    break;
                }
                case '>': 
                case '?': 
                case '@': {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    attributeName.append(c);
                    break;
                }
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                case '_': {
                    if (attributeName.length() == 0) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_UNDERSCORE.get(dnString, "ds-cfg-allow-attribute-name-exceptions");
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                    }
                    if (allowExceptions) {
                        attributeName.append(c);
                        break;
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_UNDERSCORE_CHAR.get(dnString, "ds-cfg-allow-attribute-name-exceptions");
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                case '`': {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    attributeName.append(c);
                    break;
                }
                default: {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
            }
            if (endOfName) break;
            ++pos;
        }
        if (attributeName.length() == 0) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME.get(dnString);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        if (checkForOID) {
            boolean validOID = true;
            int namePos = 0;
            int nameLength = attributeName.length();
            char ch = attributeName.charAt(0);
            if (ch == 'o' || ch == 'O') {
                if (nameLength <= 4) {
                    validOID = false;
                } else {
                    ch = attributeName.charAt(1);
                    if (!(ch != 'i' && ch != 'I' || (ch = attributeName.charAt(2)) != 'd' && ch != 'D' || attributeName.charAt(3) != '.')) {
                        attributeName.delete(0, 4);
                        nameLength -= 4;
                    } else {
                        validOID = false;
                    }
                }
            }
            while (validOID && namePos < nameLength) {
                if (StaticUtils.isDigit(ch = attributeName.charAt(namePos++))) {
                    while (validOID && namePos < nameLength && StaticUtils.isDigit(attributeName.charAt(namePos))) {
                        ++namePos;
                    }
                    if (namePos >= nameLength || attributeName.charAt(namePos) == '.') continue;
                    validOID = false;
                    continue;
                }
                if (ch == '.') {
                    if (namePos != 1 && attributeName.charAt(namePos - 2) != '.') continue;
                    validOID = false;
                    continue;
                }
                validOID = false;
            }
            if (validOID && attributeName.charAt(nameLength - 1) == '.') {
                validOID = false;
            }
            if (!validOID) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_PERIOD.get(dnString, attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
        } else if (StaticUtils.isDigit(attributeName.charAt(0)) && !allowExceptions) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_DIGIT.get(dnString, Character.valueOf(attributeName.charAt(0)), "ds-cfg-allow-attribute-name-exceptions");
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        return pos;
    }

    static ByteString parseAttributeValue(ByteSequenceReader dnBytes) throws DirectoryException {
        if (dnBytes.remaining() <= 0) {
            return ByteString.empty();
        }
        byte b = dnBytes.get();
        if (b == 35) {
            StringBuilder hexString = new StringBuilder();
            if (dnBytes.remaining() < 2) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT.get(dnBytes.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            for (int i = 0; i < 2; ++i) {
                b = dnBytes.get();
                if (!StaticUtils.isHexDigit(b)) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(dnBytes.toString(), Character.valueOf((char)b));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                hexString.append((char)b);
            }
            while (dnBytes.remaining() > 0) {
                b = dnBytes.get();
                if (StaticUtils.isHexDigit(b)) {
                    hexString.append((char)b);
                    if (dnBytes.remaining() > 0) {
                        b = dnBytes.get();
                        if (StaticUtils.isHexDigit(b)) {
                            hexString.append((char)b);
                            continue;
                        }
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(dnBytes.toString(), Character.valueOf((char)b));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT.get(dnBytes.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                if (b == 32 || b == 44 || b == 59 || b == 43) {
                    dnBytes.skip(-1);
                    break;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(dnBytes.toString(), Character.valueOf((char)b));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            try {
                return ByteString.wrap(StaticUtils.hexStringToByteArray(hexString.toString()));
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE.get(dnBytes.toString(), String.valueOf(e));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
        }
        if (b == 34) {
            int valueStartPos = dnBytes.position();
            do {
                if (dnBytes.remaining() > 0) continue;
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_UNMATCHED_QUOTE.get(dnBytes.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            } while (dnBytes.get() != 34);
            int valueEndPos = dnBytes.position();
            dnBytes.position(valueStartPos);
            ByteString bs = dnBytes.getByteString(valueEndPos - valueStartPos - 1);
            dnBytes.skip(1);
            return bs;
        }
        if (b == 43 || b == 44) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_REQUIRES_ESCAPE_CHAR.get(dnBytes.toString(), dnBytes.position());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        int valueEndPos = dnBytes.position();
        int valueStartPos = valueEndPos - 1;
        while (dnBytes.remaining() > 0) {
            b = dnBytes.get();
            if (b == 44 || b == 59 || b == 43) {
                dnBytes.skip(-1);
                break;
            }
            if (b == 32) continue;
            valueEndPos = dnBytes.position();
        }
        dnBytes.position(valueStartPos);
        return dnBytes.getByteString(valueEndPos - valueStartPos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int parseAttributeValue(String dnString, int pos, ByteStringBuilder attributeValue) throws DirectoryException {
        boolean escaped;
        StringBuilder hexChars;
        StringBuilder valueString;
        char c;
        int length = dnString.length();
        if (pos >= length) {
            attributeValue.append("");
            return pos;
        }
        if ((c = dnString.charAt(pos++)) == '#') {
            StringBuilder hexString = new StringBuilder();
            if (pos + 2 > length) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT.get(dnString);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            for (int i = 0; i < 2; ++i) {
                if (!StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(dnString, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                hexString.append(c);
            }
            while (pos < length) {
                if (StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                    hexString.append(c);
                    if (pos >= length) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT.get(dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                    }
                    if (!StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(dnString, Character.valueOf(c));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                    }
                    hexString.append(c);
                    continue;
                }
                if (c != ' ' && c != ',' && c != ';') {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(dnString, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                --pos;
                break;
            }
            try {
                attributeValue.append(StaticUtils.hexStringToByteArray(hexString.toString()));
                return pos;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE.get(dnString, String.valueOf(e));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
        }
        if (c != '\"') {
            if (c == '+' || c == ',') {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID_REQUIRES_ESCAPE_CHAR.get(dnString, pos);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            valueString = new StringBuilder();
            hexChars = new StringBuilder();
            if (c == '\\') {
                escaped = true;
            } else {
                escaped = false;
                valueString.append(c);
            }
        } else {
            boolean escaped2 = false;
            StringBuilder valueString2 = new StringBuilder();
            while (true) {
                if (pos >= length) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_UNMATCHED_QUOTE.get(dnString);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                c = dnString.charAt(pos++);
                if (escaped2) {
                    valueString2.append(c);
                    escaped2 = false;
                    continue;
                }
                if (c == '\\') {
                    escaped2 = true;
                    continue;
                }
                if (c == '\"') {
                    attributeValue.append(valueString2.toString());
                    return pos;
                }
                valueString2.append(c);
            }
        }
        while (true) {
            if (pos >= length) {
                DN.appendHexChars(dnString, valueString, hexChars);
                break;
            }
            c = dnString.charAt(pos++);
            if (escaped) {
                if (StaticUtils.isHexDigit(c)) {
                    char c2;
                    if (pos >= length) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ESCAPED_HEX_VALUE_INVALID.get(dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                    }
                    if (!StaticUtils.isHexDigit(c2 = dnString.charAt(pos++))) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ESCAPED_HEX_VALUE_INVALID.get(dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                    }
                    hexChars.append(c);
                    hexChars.append(c2);
                } else {
                    DN.appendHexChars(dnString, valueString, hexChars);
                    valueString.append(c);
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ',' || c == ';') {
                DN.appendHexChars(dnString, valueString, hexChars);
                --pos;
                break;
            }
            if (c == '+') {
                DN.appendHexChars(dnString, valueString, hexChars);
                --pos;
                break;
            }
            DN.appendHexChars(dnString, valueString, hexChars);
            valueString.append(c);
        }
        if (pos > 2 && dnString.charAt(pos - 1) == ' ' && dnString.charAt(pos - 2) != '\\') {
            for (int lastPos = valueString.length() - 1; lastPos > 0 && valueString.charAt(lastPos) == ' '; --lastPos) {
                valueString.delete(lastPos, lastPos + 1);
            }
        }
        attributeValue.append(valueString.toString());
        return pos;
    }

    private static void appendHexChars(String dnString, StringBuilder valueString, StringBuilder hexChars) throws DirectoryException {
        if (hexChars.length() == 0) {
            return;
        }
        try {
            byte[] hexBytes = StaticUtils.hexStringToByteArray(hexChars.toString());
            valueString.append(new String(hexBytes, "UTF-8"));
            hexChars.delete(0, hexChars.length());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE.get(dnString, String.valueOf(e));
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        try {
            return this.toNormalizedString().equals(((DN)o).toNormalizedString());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    public String toString() {
        if (this.dnString == null) {
            if (this.numComponents == 0) {
                this.dnString = "";
            } else {
                StringBuilder buffer = new StringBuilder();
                this.rdnComponents[0].toString(buffer);
                for (int i = 1; i < this.numComponents; ++i) {
                    buffer.append(",");
                    this.rdnComponents[i].toString(buffer);
                }
                this.dnString = buffer.toString();
            }
        }
        return this.dnString;
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.toString());
    }

    private static final String normalize(RDN[] rdnComponents) {
        if (rdnComponents.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        rdnComponents[0].toNormalizedString(buffer);
        for (int i = 1; i < rdnComponents.length; ++i) {
            buffer.append(',');
            rdnComponents[i].toNormalizedString(buffer);
        }
        return buffer.toString();
    }

    public String toNormalizedString() {
        if (this.normalizedDN == null) {
            this.normalizedDN = DN.normalize(this.rdnComponents);
        }
        return this.normalizedDN;
    }

    public void toNormalizedString(StringBuilder buffer) {
        buffer.append(this.toNormalizedString());
    }

    @Override
    public int compareTo(DN dn) {
        if (this.equals(dn)) {
            return 0;
        }
        if (this.isNullDN()) {
            return -1;
        }
        if (dn.isNullDN()) {
            return 1;
        }
        if (this.isAncestorOf(dn)) {
            return -1;
        }
        if (this.isDescendantOf(dn)) {
            return 1;
        }
        int minComps = Math.min(this.numComponents, dn.numComponents);
        for (int i = 0; i < minComps; ++i) {
            RDN r1 = this.rdnComponents[this.rdnComponents.length - 1 - i];
            RDN r2 = dn.rdnComponents[dn.rdnComponents.length - 1 - i];
            int result = r1.compareTo(r2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

