/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.FileHandleSource;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileSource;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogBufferPool;
import com.sleepycat.je.log.LogContext;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogSource;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogManager {
    private static final String DEBUG_NAME = LogManager.class.getName();
    protected LogBufferPool logBufferPool;
    protected Latch logWriteLatch;
    private boolean doChecksumOnRead;
    private FileManager fileManager;
    protected EnvironmentImpl envImpl;
    private boolean readOnly;
    private int readBufferSize;
    private long lastLsnAtRecovery = -1L;
    private int nRepeatFaultReads;
    private long nTempBufferWrites;
    private TestHook readHook;

    public LogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        this.envImpl = envImpl;
        this.fileManager = envImpl.getFileManager();
        DbConfigManager configManager = envImpl.getConfigManager();
        this.readOnly = readOnly;
        this.logBufferPool = new LogBufferPool(this.fileManager, envImpl);
        this.doChecksumOnRead = configManager.getBoolean(EnvironmentParams.LOG_CHECKSUM_READ);
        this.logWriteLatch = new Latch(DEBUG_NAME);
        this.readBufferSize = configManager.getInt(EnvironmentParams.LOG_FAULT_READ_SIZE);
    }

    public boolean getChecksumOnRead() {
        return this.doChecksumOnRead;
    }

    public long getLastLsnAtRecovery() {
        return this.lastLsnAtRecovery;
    }

    public void setLastLsnAtRecovery(long lastLsnAtRecovery) {
        this.lastLsnAtRecovery = lastLsnAtRecovery;
    }

    public void resetPool(DbConfigManager configManager) throws DatabaseException {
        this.logBufferPool.reset(configManager);
    }

    public long logForceFlush(LogEntry entry, boolean fsyncRequired, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, Provisional.NO, true, fsyncRequired, false, false, -1L, null, repContext);
    }

    public long logForceFlip(LogEntry entry) throws DatabaseException {
        return this.log(entry, Provisional.NO, true, false, true, false, -1L, null, ReplicationContext.NO_REPLICATE);
    }

    public long log(LogEntry entry, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, Provisional.NO, false, false, false, false, -1L, null, repContext);
    }

    public long log(LogEntry entry, boolean isProvisional, boolean backgroundIO, long oldNodeLsn, DatabaseImpl nodeDb, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, isProvisional ? Provisional.YES : Provisional.NO, false, false, false, backgroundIO, oldNodeLsn, nodeDb, repContext);
    }

    public long log(LogEntry entry, Provisional provisional, boolean backgroundIO, long oldNodeLsn, DatabaseImpl nodeDb, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, provisional, false, false, false, backgroundIO, oldNodeLsn, nodeDb, repContext);
    }

    private long log(LogEntry entry, Provisional provisional, boolean flushRequired, boolean fsyncRequired, boolean forceNewLogFile, boolean backgroundIO, long oldNodeLsn, DatabaseImpl nodeDb, ReplicationContext repContext) throws DatabaseException {
        LogItem item = new LogItem();
        item.entry = entry;
        item.provisional = provisional;
        item.oldLsn = oldNodeLsn;
        item.repContext = repContext;
        LogContext context = new LogContext();
        context.flushRequired = flushRequired;
        context.fsyncRequired = fsyncRequired;
        context.forceNewLogFile = forceNewLogFile;
        context.backgroundIO = backgroundIO;
        context.nodeDb = nodeDb;
        this.log(item, context);
        return item.newLsn;
    }

    public void log(LogItem item, LogContext context) throws DatabaseException {
        this.multiLog(new LogItem[]{item}, context);
    }

    public void multiLog(LogItem[] itemArray, LogContext context) throws DatabaseException {
        if (this.readOnly || itemArray.length == 0) {
            return;
        }
        try {
            for (LogItem item : itemArray) {
                LogEntry logEntry = item.entry;
                item.oldSize = logEntry.getLastLoggedSize();
                if (!logEntry.getLogType().marshallOutsideLatch()) continue;
                item.header = new LogEntryHeader(logEntry, item.provisional, item.repContext);
                item.buffer = this.marshallIntoBuffer(item.header, logEntry);
            }
            this.serialLog(itemArray, context);
        }
        catch (BufferOverflowException e) {
            throw new RunRecoveryException(this.envImpl, (Throwable)e);
        }
        catch (IOException e) {
            throw new DatabaseException(Tracer.getStackTrace(e), e);
        }
        if (context.fsyncRequired) {
            this.fileManager.groupSync();
        }
        for (LogItem item : itemArray) {
            if (!item.repContext.inReplicationStream()) continue;
            assert (item.header.getVLSN() != null) : "Unexpected null vlsn: " + item.header + " " + item.repContext;
            this.envImpl.getReplicator().registerVLSN(item.newLsn, item.header);
        }
        this.envImpl.getCheckpointer().wakeupAfterWrite();
        if (context.wakeupCleaner) {
            this.envImpl.getUtilizationTracker().activateCleaner();
        }
        if (context.backgroundIO) {
            this.envImpl.updateBackgroundWrites(context.totalNewSize, this.logBufferPool.getLogBufferSize());
        }
    }

    abstract void serialLog(LogItem[] var1, LogContext var2) throws IOException, DatabaseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serialLogInternal(LogItem[] itemArray, LogContext context) throws IOException, DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        LogItem firstItem = itemArray[0];
        LogItem lastItem = itemArray[itemArray.length - 1];
        for (LogItem item : itemArray) {
            Object var25_22;
            int entrySize;
            boolean marshallOutsideLatch = item.buffer != null;
            boolean isFirstItem = item == firstItem;
            boolean isLastItem = item == lastItem;
            LogEntryType entryType = item.entry.getLogType();
            if (item.oldLsn != -1L) {
                tracker.countObsoleteNode(item.oldLsn, entryType, item.oldSize, context.nodeDb);
            }
            if (marshallOutsideLatch) {
                entrySize = item.buffer.limit();
                assert (item.header != null);
            } else {
                assert (item.header == null);
                item.header = new LogEntryHeader(item.entry, item.provisional, item.repContext);
                entrySize = item.header.getSize() + item.header.getItemSize();
            }
            if (isFirstItem && context.forceNewLogFile) {
                this.fileManager.forceNewLogFile();
            }
            boolean flippedFile = this.fileManager.bumpLsn(entrySize);
            long currentLsn = -1L;
            boolean usedTemporaryBuffer = false;
            boolean success = false;
            try {
                Object var23_21;
                currentLsn = this.fileManager.getLastUsedLsn();
                if (tracker.countNewLogEntry(currentLsn, entryType, entrySize, context.nodeDb)) {
                    context.wakeupCleaner = true;
                }
                if (item.entry.countAsObsoleteWhenLogged()) {
                    tracker.countObsoleteNodeInexact(currentLsn, entryType, entrySize, context.nodeDb);
                }
                if (!marshallOutsideLatch) {
                    assert (item.buffer == null);
                    item.buffer = this.marshallIntoBuffer(item.header, item.entry);
                }
                if (entrySize != item.buffer.limit()) {
                    throw new DatabaseException("Logged entry entrySize= " + entrySize + " but marshalledSize=" + item.buffer.limit() + " type=" + entryType + " currentLsn=" + DbLsn.getNoFormatString(currentLsn));
                }
                LogBuffer useLogBuffer = this.logBufferPool.getWriteBuffer(entrySize, flippedFile);
                item.buffer = item.header.addPostMarshallingInfo(this.envImpl, item.buffer, this.fileManager.getPrevEntryOffset(), item.repContext);
                useLogBuffer.latchForWrite();
                try {
                    ByteBuffer useBuffer = useLogBuffer.getDataBuffer();
                    if (useBuffer.capacity() - useBuffer.position() < entrySize) {
                        this.fileManager.writeLogBuffer(new LogBuffer(item.buffer, currentLsn));
                        usedTemporaryBuffer = true;
                        assert (useBuffer.position() == 0);
                        ++this.nTempBufferWrites;
                    } else {
                        useBuffer.put(item.buffer);
                    }
                    var23_21 = null;
                }
                catch (Throwable throwable) {
                    var23_21 = null;
                    useLogBuffer.release();
                    throw throwable;
                }
                useLogBuffer.release();
                success = true;
                var25_22 = null;
                if (!success) {
                    this.fileManager.restoreLastPosition();
                    if (item.header.getVLSN() != null) {
                        this.envImpl.getReplicator().decrementVLSN();
                    }
                }
            }
            catch (Throwable throwable) {
                var25_22 = null;
                if (!success) {
                    this.fileManager.restoreLastPosition();
                    if (item.header.getVLSN() != null) {
                        this.envImpl.getReplicator().decrementVLSN();
                    }
                }
                throw throwable;
            }
            if (!usedTemporaryBuffer) {
                this.logBufferPool.writeCompleted(currentLsn, isLastItem && context.flushRequired);
            }
            item.entry.postLogWork(currentLsn);
            item.newLsn = currentLsn;
            context.totalNewSize += entrySize;
        }
    }

    private ByteBuffer marshallIntoBuffer(LogEntryHeader header, LogEntry entry) throws DatabaseException {
        int entrySize = header.getSize() + header.getItemSize();
        ByteBuffer destBuffer = ByteBuffer.allocate(entrySize);
        header.writeToLog(destBuffer);
        entry.writeEntry(header, destBuffer);
        destBuffer.flip();
        return destBuffer;
    }

    ByteBuffer putIntoBuffer(LogEntry entry, long prevLogEntryOffset) throws DatabaseException {
        LogEntryHeader header = new LogEntryHeader(entry, Provisional.NO, ReplicationContext.NO_REPLICATE);
        assert (entry.getLogType() != LogEntryType.LOG_LN_TRANSACTIONAL);
        ByteBuffer destBuffer = this.marshallIntoBuffer(header, entry);
        return header.addPostMarshallingInfo(this.envImpl, destBuffer, prevLogEntryOffset, ReplicationContext.NO_REPLICATE);
    }

    public LogEntry getLogEntry(long lsn) throws DatabaseException {
        this.envImpl.checkIfInvalid();
        LogSource logSource = this.getLogSource(lsn);
        return this.getLogEntryFromLogSource(lsn, logSource);
    }

    LogEntry getLogEntry(long lsn, RandomAccessFile file) throws DatabaseException {
        return this.getLogEntryFromLogSource(lsn, new FileSource(file, this.readBufferSize, this.fileManager, DbLsn.getFileNumber(lsn)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LogEntry getLogEntryFromLogSource(long lsn, LogSource logSource) throws DatabaseException {
        LogEntry logEntry;
        try {
            try {
                long fileOffset = DbLsn.getFileOffset(lsn);
                ByteBuffer entryBuffer = logSource.getBytes(fileOffset);
                assert (entryBuffer.limit() - entryBuffer.position() >= 22);
                LogEntryHeader header = new LogEntryHeader(this.envImpl, entryBuffer, false);
                header.readVariablePortion(entryBuffer);
                ChecksumValidator validator = null;
                if (this.doChecksumOnRead) {
                    validator = new ChecksumValidator();
                    int headerSizeMinusChecksum = header.getSizeMinusChecksum();
                    int itemStart = entryBuffer.position();
                    entryBuffer.position(itemStart - headerSizeMinusChecksum);
                    validator.update(this.envImpl, entryBuffer, headerSizeMinusChecksum, false);
                    entryBuffer.position(itemStart);
                }
                int itemSize = header.getItemSize();
                if (entryBuffer.remaining() < itemSize) {
                    entryBuffer = logSource.getBytes(fileOffset + (long)header.getSize(), itemSize);
                    ++this.nRepeatFaultReads;
                }
                if (this.doChecksumOnRead) {
                    validator.update(this.envImpl, entryBuffer, itemSize, false);
                    validator.validate(this.envImpl, header.getChecksum(), lsn);
                }
                assert (LogEntryType.isValidType(header.getType())) : "Read non-valid log entry type: " + header.getType();
                LogEntry logEntry2 = LogEntryType.findType(header.getType()).getNewLogEntry();
                logEntry2.readEntry(header, entryBuffer, true);
                if (this.readHook != null) {
                    this.readHook.doIOHook();
                }
                logEntry = logEntry2;
                Object var13_15 = null;
                if (logSource == null) return logEntry;
            }
            catch (DbChecksumException e) {
                e.addErrorMessage(" lsn= " + DbLsn.getNoFormatString(lsn) + " logSource=" + logSource);
                throw e;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                throw new RunRecoveryException(this.envImpl, "Channel closed, may be due to thread interrupt", e);
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (logSource == null) throw throwable;
            logSource.release();
            throw throwable;
        }
        logSource.release();
        return logEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getByteBufferFromLog(long lsn) throws DatabaseException {
        ByteBuffer byteBuffer;
        this.envImpl.checkIfInvalid();
        LogSource logSource = this.getLogSource(lsn);
        ByteBuffer entryBuffer = null;
        try {
            try {
                long fileOffset = DbLsn.getFileOffset(lsn);
                entryBuffer = logSource.getBytes(fileOffset);
                int startingPosition = entryBuffer.position();
                int amountRemaining = entryBuffer.remaining();
                assert (amountRemaining >= 22);
                LogEntryHeader header = new LogEntryHeader(this.envImpl, entryBuffer, false);
                int totalSize = header.getSize() + header.getItemSize();
                if (amountRemaining < totalSize) {
                    entryBuffer = logSource.getBytes(fileOffset, totalSize);
                    ++this.nRepeatFaultReads;
                }
                entryBuffer.position(startingPosition);
                ByteBuffer singleEntryBuffer = ByteBuffer.allocate(totalSize);
                entryBuffer.limit(startingPosition + totalSize);
                singleEntryBuffer.put(entryBuffer);
                singleEntryBuffer.position(0);
                byteBuffer = singleEntryBuffer;
                Object var14_14 = null;
                if (logSource == null) return byteBuffer;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                throw new RunRecoveryException(this.envImpl, "Channel closed, may be due to thread interrupt", e);
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (logSource == null) throw throwable;
            logSource.release();
            throw throwable;
        }
        logSource.release();
        return byteBuffer;
    }

    public Object get(long lsn) throws DatabaseException {
        LogEntry entry = this.getLogEntry(lsn);
        return entry.getMainItem();
    }

    public LogSource getLogSource(long lsn) throws DatabaseException {
        LogBuffer logBuffer = this.logBufferPool.getReadBuffer(lsn);
        if (logBuffer == null) {
            try {
                long fileNum = DbLsn.getFileNumber(lsn);
                return new FileHandleSource(this.fileManager.getFileHandle(fileNum), this.readBufferSize, this.fileManager);
            }
            catch (LogFileNotFoundException e) {
                throw new LogFileNotFoundException(DbLsn.getNoFormatString(lsn) + ' ' + e.getMessage());
            }
        }
        return logBuffer;
    }

    public void flush() throws DatabaseException {
        if (!this.readOnly) {
            this.flushInternal();
            this.fileManager.syncLogEnd();
        }
    }

    public void flushNoSync() throws DatabaseException {
        if (!this.readOnly) {
            this.flushInternal();
        }
    }

    abstract void flushInternal() throws LogException, DatabaseException;

    public void loadStats(StatsConfig config, EnvironmentStats stats) throws DatabaseException {
        stats.setNRepeatFaultReads(this.nRepeatFaultReads);
        stats.setNTempBufferWrites(this.nTempBufferWrites);
        if (config.getClear()) {
            this.nRepeatFaultReads = 0;
            this.nTempBufferWrites = 0L;
        }
        this.logBufferPool.loadStats(config, stats);
        this.fileManager.loadStats(config, stats);
        if (!config.getFast()) {
            this.loadEndOfLogStat(stats);
        }
    }

    public abstract TrackedFileSummary getUnflushableTrackedSummary(long var1) throws DatabaseException;

    TrackedFileSummary getUnflushableTrackedSummaryInternal(long file) throws DatabaseException {
        return this.envImpl.getUtilizationTracker().getUnflushableTrackedSummary(file);
    }

    public abstract void removeTrackedFile(TrackedFileSummary var1) throws DatabaseException;

    protected void removeTrackedFileInternal(TrackedFileSummary tfs) {
        tfs.reset();
    }

    public abstract void countObsoleteNode(long var1, LogEntryType var3, int var4, DatabaseImpl var5) throws DatabaseException;

    void countObsoleteNodeInternal(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        tracker.countObsoleteNode(lsn, type, size, nodeDb);
    }

    public abstract void transferToUtilizationTracker(LocalUtilizationTracker var1) throws DatabaseException;

    void transferToUtilizationTrackerInternal(LocalUtilizationTracker localTracker) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        localTracker.transferToUtilizationTracker(tracker);
    }

    public abstract void countObsoleteINs(List<Long> var1, DatabaseImpl var2) throws DatabaseException;

    void countObsoleteINsInternal(List<Long> lsnList, DatabaseImpl nodeDb) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        for (int i = 0; i < lsnList.size(); ++i) {
            Long lsn = lsnList.get(i);
            tracker.countObsoleteNode(lsn, LogEntryType.LOG_IN, 0, nodeDb);
        }
    }

    public abstract void countObsoleteDb(DatabaseImpl var1) throws DatabaseException;

    void countObsoleteDbInternal(DatabaseImpl db) {
        db.countObsoleteDb(this.envImpl.getUtilizationTracker(), -1L);
    }

    public abstract boolean removeDbFileSummary(DatabaseImpl var1, Long var2) throws DatabaseException;

    boolean removeDbFileSummaryInternal(DatabaseImpl db, Long fileNum) {
        return db.removeDbFileSummary(fileNum);
    }

    public abstract void loadEndOfLogStat(EnvironmentStats var1) throws DatabaseException;

    void loadEndOfLogStatInternal(EnvironmentStats stats) {
        stats.setEndOfLog(this.fileManager.getLastUsedLsn());
    }

    public void setReadHook(TestHook hook) {
        this.readHook = hook;
    }
}

