/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Evictor
extends DaemonThread {
    private static final boolean DEBUG = false;
    private final MemoryBudget.Totals memBudgetTotals;
    private static final int MAX_BATCHES_PER_RUN = 100;
    private volatile boolean active;
    private final int nodesPerScan;
    private final long evictBytesSetting;
    private final boolean evictByLruOnly;
    private final boolean forcedYield;
    private final int deadlockRetries;
    private NumberFormat formatter;
    private long nNodesScannedThisRun;
    private final StatGroup stats;
    private long currentRequiredEvictBytes = 0L;
    private final LongStat requiredEvictBytes;
    private final LongStat nEvictPasses;
    private final LongStat nNodesSelected;
    private final LongStat nNodesScanned;
    private boolean everFull;
    private final LongStat nNodesEvicted;
    private final LongStat nRootNodesEvicted;
    private final LongStat nBINsStripped;
    protected IntStat sharedCacheEnvs;
    private final AtomicLongStat nLNFetch;
    private final AtomicLongStat nBINFetch;
    private final AtomicLongStat nUpperINFetch;
    private final AtomicLongStat nLNFetchMiss;
    private final AtomicLongStat nBINFetchMiss;
    private final AtomicLongStat nUpperINFetchMiss;
    private final AtomicLongStat[] binEvictSources;
    private final AtomicLongStat[] inEvictSources;
    EvictProfile evictProfile;
    private TestHook<Boolean> runnableHook;
    private TestHook<Object> preEvictINHook;

    Evictor(EnvironmentImpl envImpl, long wakeupInterval, String name) throws DatabaseException {
        super(wakeupInterval, name, envImpl);
        this.memBudgetTotals = envImpl.getMemoryBudget().getTotals();
        DbConfigManager configManager = envImpl.getConfigManager();
        this.nodesPerScan = configManager.getInt(EnvironmentParams.EVICTOR_NODES_PER_SCAN);
        this.evictBytesSetting = configManager.getLong(EnvironmentParams.EVICTOR_EVICT_BYTES);
        this.evictByLruOnly = configManager.getBoolean(EnvironmentParams.EVICTOR_LRU_ONLY);
        this.forcedYield = configManager.getBoolean(EnvironmentParams.EVICTOR_FORCED_YIELD);
        this.deadlockRetries = configManager.getInt(EnvironmentParams.EVICTOR_RETRY);
        this.evictProfile = new EvictProfile();
        this.active = false;
        this.stats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        this.requiredEvictBytes = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_REQUIRED_EVICT_BYTES);
        this.nEvictPasses = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_EVICT_PASSES);
        this.nNodesSelected = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_SELECTED);
        this.nNodesScanned = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_SCANNED);
        this.nNodesEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_EVICTED);
        this.nRootNodesEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED);
        this.nBINsStripped = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_BINS_STRIPPED);
        this.sharedCacheEnvs = new IntStat(this.stats, EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS);
        this.nLNFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.LN_FETCH);
        this.nBINFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_FETCH);
        this.nUpperINFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.UPPER_IN_FETCH);
        this.nLNFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.LN_FETCH_MISS);
        this.nBINFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_FETCH_MISS);
        this.nUpperINFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.UPPER_IN_FETCH_MISS);
        EnumSet<EvictionSource> allSources = EnumSet.allOf(EvictionSource.class);
        this.binEvictSources = new AtomicLongStat[allSources.size()];
        this.inEvictSources = new AtomicLongStat[allSources.size()];
        for (EvictionSource source : allSources) {
            this.binEvictSources[source.ordinal()] = new AtomicLongStat(this.stats, source.getBINStatDef());
            this.inEvictSources[source.ordinal()] = new AtomicLongStat(this.stats, source.getUpperINStatDef());
        }
    }

    abstract StatGroup getINListStats(StatsConfig var1);

    public StatGroup loadStats(StatsConfig config) {
        this.requiredEvictBytes.set(this.currentRequiredEvictBytes);
        StatGroup copy = this.stats.cloneGroup(config.getClear());
        copy.addAll(this.getINListStats(config));
        return copy;
    }

    @Override
    protected long nDeadlockRetries() {
        return this.deadlockRetries;
    }

    public void alert() {
        if (!this.active) {
            this.wakeup();
        }
    }

    @Override
    public void onWakeup() throws DatabaseException {
        this.doEvict(EvictionSource.EVICTORTHREAD, false, true);
    }

    public void doEvict(EvictionSource source) throws DatabaseException {
        this.doEvict(source, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doEvict(EvictionSource source, boolean criticalEviction, boolean backgroundIO) throws DatabaseException {
        if (this.active) {
            return;
        }
        this.active = true;
        try {
            boolean progress = true;
            for (int nBatches = 0; progress && nBatches < 100 && (criticalEviction || !this.isShutdownRequested()) && this.isRunnable(source); ++nBatches) {
                if (this.evictBatch(source, backgroundIO, this.currentRequiredEvictBytes) != 0L) continue;
                progress = false;
            }
            Object var7_6 = null;
            this.active = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.active = false;
            throw throwable;
        }
    }

    public void doCriticalEviction(boolean backgroundIO) {
        long maxMem;
        long currentUsage = this.memBudgetTotals.getCacheUsage();
        long over = currentUsage - (maxMem = this.memBudgetTotals.getMaxMemory());
        if (over > this.memBudgetTotals.getCriticalThreshold()) {
            this.doEvict(EvictionSource.CRITICAL, true, backgroundIO);
        }
        if (this.forcedYield) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long evictBatch(EvictionSource source, boolean backgroundIO, long reqEvictBytes) throws DatabaseException {
        this.nNodesScannedThisRun = 0L;
        this.nEvictPasses.increment();
        assert (this.evictProfile.clear());
        int nBatchSets = 0;
        long evictBytes = this.startBatch();
        int maxINsPerBatch = this.getMaxINsPerBatch();
        if (maxINsPerBatch == 0) {
            return evictBytes;
        }
        try {
            IN target;
            while (evictBytes < reqEvictBytes && this.nNodesScannedThisRun <= (long)maxINsPerBatch && (target = this.selectIN(maxINsPerBatch)) != null) {
                Object var16_7;
                assert (this.evictProfile.count(target));
                DatabaseImpl targetDb = target.getDatabase();
                DbTree dbTree = targetDb.getDbEnvironment().getDbTree();
                DatabaseImpl refreshedDb = null;
                try {
                    refreshedDb = dbTree.getDb(targetDb.getId());
                    if (refreshedDb != null && !refreshedDb.isDeleted()) {
                        evictBytes = target.isDbRoot() ? (evictBytes += this.evictRoot(target, backgroundIO)) : (evictBytes += this.evictIN(target, backgroundIO, source));
                    } else if (targetDb.isDeleteFinished() && target.getInListResident()) {
                        String inInfo = " IN type=" + target.getLogType() + " id=" + target.getNodeId() + " not expected on INList";
                        String errMsg = refreshedDb == null ? inInfo : "Database " + refreshedDb.getDebugName() + " id=" + refreshedDb.getId() + " rootLsn=" + DbLsn.getNoFormatString(refreshedDb.getTree().getRootLsn()) + ' ' + inInfo;
                        throw EnvironmentFailureException.unexpectedState(errMsg);
                    }
                    var16_7 = null;
                    dbTree.releaseDb(refreshedDb);
                }
                catch (Throwable throwable) {
                    var16_7 = null;
                    dbTree.releaseDb(refreshedDb);
                    throw throwable;
                }
                ++nBatchSets;
            }
            Object var18_15 = null;
            this.nNodesScanned.add(this.nNodesScannedThisRun);
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            this.nNodesScanned.add(this.nNodesScannedThisRun);
            throw throwable;
        }
        assert (LatchSupport.countLatchesHeld() == 0) : "latches held = " + LatchSupport.countLatchesHeld();
        return evictBytes;
    }

    public boolean isCacheFull() {
        boolean ret;
        boolean bl = ret = this.memBudgetTotals.getCacheUsage() + 2L * this.evictBytesSetting >= this.memBudgetTotals.getMaxMemory();
        if (ret) {
            this.everFull = true;
        }
        return ret;
    }

    public boolean wasCacheEverFull() {
        return this.currentRequiredEvictBytes > 0L;
    }

    private boolean isRunnable(EvictionSource source) {
        boolean doRun;
        long maxMem;
        long currentUsage = this.memBudgetTotals.getCacheUsage();
        long overBudget = currentUsage - (maxMem = this.memBudgetTotals.getMaxMemory());
        boolean bl = doRun = overBudget > 0L;
        if (doRun) {
            this.currentRequiredEvictBytes = overBudget + this.evictBytesSetting;
            if (currentUsage - this.currentRequiredEvictBytes < maxMem / 2L) {
                this.currentRequiredEvictBytes = overBudget + maxMem / 2L;
            }
        }
        if (this.runnableHook != null) {
            doRun = this.runnableHook.getHookValue();
            this.currentRequiredEvictBytes = maxMem;
        }
        if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
            this.maybeInitFormatter();
            Runtime r = Runtime.getRuntime();
            long totalBytes = r.totalMemory();
            long freeBytes = r.freeMemory();
            long usedBytes = r.totalMemory() - r.freeMemory();
            StringBuffer sb = new StringBuffer();
            sb.append(" source=").append((Object)source);
            sb.append(" doRun=").append(doRun);
            sb.append(" JEusedBytes=").append(this.formatter.format(currentUsage));
            sb.append(" requiredEvict=").append(this.formatter.format(this.currentRequiredEvictBytes));
            sb.append(" JVMtotalBytes= ").append(this.formatter.format(totalBytes));
            sb.append(" JVMfreeBytes= ").append(this.formatter.format(freeBytes));
            sb.append(" JVMusedBytes= ").append(this.formatter.format(usedBytes));
            LoggerUtils.logMsg(this.logger, this.envImpl, Level.FINE, sb.toString());
        }
        return doRun;
    }

    private IN selectIN(int maxNodesToIterate) {
        IN in;
        IN target = null;
        long targetGeneration = Long.MAX_VALUE;
        int targetLevel = Integer.MAX_VALUE;
        boolean targetDirty = true;
        int nCandidates = 0;
        int nIterated = 0;
        while (nIterated < maxNodesToIterate && nCandidates < this.nodesPerScan && (in = this.getNextIN()) != null) {
            int evictType;
            ++nIterated;
            ++this.nNodesScannedThisRun;
            DatabaseImpl db = in.getDatabase();
            if (db == null || db.isDeleted() || db.getDbEnvironment().isReadOnly() && in.getDirty() || (evictType = in.getEvictionType()) == 0) continue;
            if (this.evictByLruOnly) {
                if (targetGeneration > in.getGeneration()) {
                    targetGeneration = in.getGeneration();
                    target = in;
                }
            } else {
                int level = this.normalizeLevel(in, evictType);
                if (targetLevel != level) {
                    if (targetLevel > level) {
                        targetLevel = level;
                        targetDirty = in.getDirty();
                        targetGeneration = in.getGeneration();
                        target = in;
                    }
                } else if (targetDirty != in.getDirty()) {
                    if (targetDirty) {
                        targetDirty = false;
                        targetGeneration = in.getGeneration();
                        target = in;
                    }
                } else if (targetGeneration > in.getGeneration()) {
                    targetGeneration = in.getGeneration();
                    target = in;
                }
            }
            ++nCandidates;
        }
        if (target != null) {
            this.nNodesSelected.increment();
        }
        return target;
    }

    public int normalizeLevel(IN in, int evictType) {
        int level = in.getLevel() & 0xFFFF;
        if (level == 1 && evictType == 1) {
            level = 0;
        }
        return level;
    }

    private long evictRoot(final IN target, final boolean backgroundIO) throws DatabaseException {
        final DatabaseImpl db = target.getDatabase();
        final EnvironmentImpl envImpl = db.getDbEnvironment();
        final INList inList = envImpl.getInMemoryINs();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RootEvictor
        implements WithRootLatched {
            boolean flushed = false;
            long evictBytes = 0L;

            RootEvictor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IN doWork(ChildReference root) throws DatabaseException {
                IN rootIN = (IN)root.fetchTarget(db, null);
                rootIN.latch(CacheMode.UNCHANGED);
                try {
                    boolean isDirty = rootIN.getDirty();
                    if (rootIN == target && rootIN.isDbRoot() && rootIN.isEvictable() && (!envImpl.isReadOnly() || !isDirty)) {
                        if (isDirty) {
                            long newLsn = rootIN.log(envImpl.getLogManager(), false, Evictor.this.isProvisionalRequired(rootIN), backgroundIO, null);
                            root.setLsn(newLsn);
                            this.flushed = true;
                        }
                        inList.remove(rootIN);
                        this.evictBytes = rootIN.getBudgetedMemorySize();
                        root.clearTarget();
                        Evictor.this.nRootNodesEvicted.increment();
                    }
                    Object var7_5 = null;
                    rootIN.releaseLatch();
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    rootIN.releaseLatch();
                    throw throwable;
                }
                return null;
            }
        }
        RootEvictor evictor = new RootEvictor();
        db.getTree().withRootLatchedExclusive(evictor);
        if (evictor.flushed) {
            envImpl.getDbTree().modifyDbRoot(db);
        }
        return evictor.evictBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long evictIN(IN target, boolean backgroundIO, EvictionSource source) throws DatabaseException {
        boolean targetIsLatched;
        LocalUtilizationTracker localTracker;
        long evictedBytes;
        EnvironmentImpl envImpl;
        DatabaseImpl db;
        block17: {
            block16: {
                boolean inline;
                db = target.getDatabase();
                envImpl = db.getDbEnvironment();
                evictedBytes = 0L;
                localTracker = null;
                boolean bl = inline = source == EvictionSource.CACHEMODE;
                if (inline) {
                    target.latch(CacheMode.UNCHANGED);
                } else if (!target.latchNoWait(CacheMode.UNCHANGED)) {
                    return evictedBytes;
                }
                targetIsLatched = true;
                try {
                    if (target instanceof BIN) {
                        localTracker = new LocalUtilizationTracker(envImpl);
                        envImpl.lazyCompress(target, localTracker);
                        evictedBytes = ((BIN)target).evictLNs();
                        if (evictedBytes > 0L) {
                            this.nBINsStripped.increment();
                        }
                    }
                    if (inline || evictedBytes == 0L) break block16;
                    long l = evictedBytes;
                    Object var14_13 = null;
                    if (targetIsLatched) {
                        target.releaseLatch();
                    }
                    return l;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    if (targetIsLatched) {
                        target.releaseLatch();
                    }
                    throw throwable;
                }
            }
            if (target.isEvictable()) break block17;
            long l = evictedBytes;
            Object var14_14 = null;
            if (targetIsLatched) {
                target.releaseLatch();
            }
            return l;
        }
        Tree tree = db.getTree();
        assert (TestHookExecute.doHookIfSet(this.preEvictINHook));
        targetIsLatched = false;
        SearchResult result = tree.getParentINForChildIN(target, true, CacheMode.UNCHANGED);
        if (result.exactParentFound) {
            evictedBytes = this.evictIN(target, result.parent, result.index, backgroundIO, source);
        }
        Object var14_15 = null;
        if (targetIsLatched) {
            target.releaseLatch();
        }
        if (localTracker != null) {
            envImpl.getUtilizationProfile().flushLocalTracker(localTracker);
        }
        return evictedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long evictIN(IN child, IN parent, int index, boolean backgroundIO, EvictionSource source) throws DatabaseException {
        long evictBytes;
        block22: {
            long l;
            block21: {
                long l2;
                block20: {
                    long l3;
                    block19: {
                        evictBytes = 0L;
                        try {
                            boolean inline;
                            assert (parent.isLatchOwnerForWrite());
                            long oldGenerationCount = child.getGeneration();
                            IN renewedChild = (IN)parent.getTarget(index);
                            if (renewedChild == null) {
                                long l4 = evictBytes;
                                Object var21_11 = null;
                                parent.releaseLatch();
                                return l4;
                            }
                            boolean bl = inline = source == EvictionSource.CACHEMODE;
                            if (!inline && renewedChild.getGeneration() > oldGenerationCount) {
                                l3 = evictBytes;
                                break block19;
                            }
                            if (inline) {
                                renewedChild.latch(CacheMode.UNCHANGED);
                            } else if (!renewedChild.latchNoWait(CacheMode.UNCHANGED)) {
                                l2 = evictBytes;
                                break block20;
                            }
                            try {
                                if (!renewedChild.isEvictable()) {
                                    l = evictBytes;
                                    Object var19_21 = null;
                                    renewedChild.releaseLatch();
                                    break block21;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var19_23 = null;
                                renewedChild.releaseLatch();
                                throw throwable;
                            }
                            {
                                DatabaseImpl db = renewedChild.getDatabase();
                                EnvironmentImpl envImpl = db.getDbEnvironment();
                                long renewedChildLsn = -1L;
                                boolean newChildLsn = false;
                                if (renewedChild.getDirty()) {
                                    if (!envImpl.isReadOnly()) {
                                        boolean logProvisional = this.isProvisionalRequired(renewedChild);
                                        renewedChildLsn = renewedChild.log(envImpl.getLogManager(), false, logProvisional, backgroundIO, parent);
                                        newChildLsn = true;
                                    }
                                } else {
                                    renewedChildLsn = parent.getLsn(index);
                                }
                                if (renewedChildLsn != -1L) {
                                    envImpl.getInMemoryINs().remove(renewedChild);
                                    evictBytes = renewedChild.getBudgetedMemorySize();
                                    if (newChildLsn) {
                                        parent.updateNode(index, null, renewedChildLsn, null);
                                    } else {
                                        parent.updateNode(index, null, null);
                                    }
                                    this.nNodesEvicted.increment();
                                    renewedChild.incEvictStats(source);
                                }
                                Object var19_22 = null;
                                renewedChild.releaseLatch();
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var21_16 = null;
                            parent.releaseLatch();
                            throw throwable;
                        }
                    }
                    Object var21_12 = null;
                    parent.releaseLatch();
                    return l3;
                }
                Object var21_13 = null;
                parent.releaseLatch();
                return l2;
            }
            Object var21_14 = null;
            parent.releaseLatch();
            return l;
        }
        Object var21_15 = null;
        parent.releaseLatch();
        return evictBytes;
    }

    public void incBINEvictStats(EvictionSource source) {
        this.binEvictSources[source.ordinal()].increment();
    }

    public void incINEvictStats(EvictionSource source) {
        this.inEvictSources[source.ordinal()].increment();
    }

    public void incLNFetchStats(boolean isMiss) {
        this.nLNFetch.increment();
        if (isMiss) {
            this.nLNFetchMiss.increment();
        }
    }

    public void incBINFetchStats(boolean isMiss) {
        this.nBINFetch.increment();
        if (isMiss) {
            this.nBINFetchMiss.increment();
        }
    }

    public void incINFetchStats(boolean isMiss) {
        this.nUpperINFetch.increment();
        if (isMiss) {
            this.nUpperINFetchMiss.increment();
        }
    }

    private boolean isProvisionalRequired(IN target) {
        DatabaseImpl db = target.getDatabase();
        EnvironmentImpl envImpl = db.getDbEnvironment();
        if (db.isDeferredWriteMode()) {
            return true;
        }
        Checkpointer ckpter = envImpl.getCheckpointer();
        return ckpter != null && target.getLevel() < ckpter.getHighestFlushLevel(db);
    }

    private void maybeInitFormatter() {
        if (this.formatter == null) {
            this.formatter = NumberFormat.getNumberInstance();
        }
    }

    public void setRunnableHook(TestHook<Boolean> hook) {
        this.runnableHook = hook;
    }

    public void setPreEvictINHook(TestHook<Object> hook) {
        this.preEvictINHook = hook;
    }

    public abstract void clearEnv();

    public abstract void noteINListChange(int var1);

    public abstract void addEnvironment(EnvironmentImpl var1);

    public abstract void removeEnvironment(EnvironmentImpl var1);

    public abstract boolean checkEnv(EnvironmentImpl var1);

    abstract long startBatch() throws DatabaseException;

    abstract int getMaxINsPerBatch();

    abstract IN getNextIN();

    abstract Iterator<IN> getScanIterator();

    abstract void setScanIterator(Iterator<IN> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EvictProfile {
        private final List<Long> candidates = new ArrayList<Long>();

        EvictProfile() {
        }

        public boolean count(IN target) {
            this.candidates.add(target.getNodeId());
            return true;
        }

        public List<Long> getCandidates() {
            return this.candidates;
        }

        public boolean clear() {
            this.candidates.clear();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EvictionSource {
        EVICTORTHREAD,
        MANUAL,
        CRITICAL,
        CACHEMODE;


        public StatDefinition getBINStatDef() {
            return new StatDefinition("nBINsEvicted" + this.toString(), "Number of BINs evicted from the cache, using the specified eviction source. As a subset of nNodesEvicted, it is an indicator of what eviction is targeting and the activity that is instigating eviction");
        }

        public StatDefinition getUpperINStatDef() {
            return new StatDefinition("nUpperINsEvicted" + this.toString(), "Number of upper INs evicted from the cache, using the specified eviction source. As a subset of nNodesEvicted, it is an indicator of what eviction is targeting and the activity that is instigating eviction");
        }
    }
}

