/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDescriptor {
    private Map<ADSContext.ServerProperty, Object> adsProperties = new HashMap<ADSContext.ServerProperty, Object>();
    private Set<ReplicaDescriptor> replicas = new HashSet<ReplicaDescriptor>();
    private Map<ServerProperty, Object> serverProperties = new HashMap<ServerProperty, Object>();
    private TopologyCacheException lastException;
    private static final String TRUSTSTORE_DN = "cn=ads-truststore";
    private static final Logger LOG = Logger.getLogger(ServerDescriptor.class.getName());

    protected ServerDescriptor() {
    }

    public Set<ReplicaDescriptor> getReplicas() {
        HashSet<ReplicaDescriptor> hashSet = new HashSet<ReplicaDescriptor>();
        hashSet.addAll(this.replicas);
        return hashSet;
    }

    public void setReplicas(Set<ReplicaDescriptor> set) {
        this.replicas.clear();
        this.replicas.addAll(set);
    }

    public Map<ADSContext.ServerProperty, Object> getAdsProperties() {
        return this.adsProperties;
    }

    public Map<ServerProperty, Object> getServerProperties() {
        return this.serverProperties;
    }

    public boolean isRegistered() {
        return !this.adsProperties.isEmpty();
    }

    public boolean isReplicationServer() {
        return Boolean.TRUE.equals(this.serverProperties.get((Object)ServerProperty.IS_REPLICATION_SERVER));
    }

    public String getReplicationServerHostPort() {
        String string = null;
        if (this.isReplicationServer()) {
            string = this.getHostName().toLowerCase() + ":" + this.getReplicationServerPort();
        }
        return string;
    }

    public int getReplicationServerId() {
        int n = -1;
        if (this.isReplicationServer()) {
            n = (Integer)this.serverProperties.get((Object)ServerProperty.REPLICATION_SERVER_ID);
        }
        return n;
    }

    public int getReplicationServerPort() {
        int n = -1;
        if (this.isReplicationServer()) {
            n = (Integer)this.serverProperties.get((Object)ServerProperty.REPLICATION_SERVER_PORT);
        }
        return n;
    }

    public boolean isReplicationSecure() {
        boolean bl = this.isReplicationServer() ? Boolean.TRUE.equals(this.serverProperties.get((Object)ServerProperty.IS_REPLICATION_SECURE)) : false;
        return bl;
    }

    public void setAdsProperties(Map<ADSContext.ServerProperty, Object> map) {
        this.adsProperties.clear();
        this.adsProperties.putAll(map);
    }

    public String getHostName() {
        String string = (String)this.serverProperties.get((Object)ServerProperty.HOST_NAME);
        if (string == null) {
            string = (String)this.adsProperties.get((Object)ADSContext.ServerProperty.HOST_NAME);
        }
        return string;
    }

    public String getLDAPURL() {
        String string = null;
        String string2 = this.getHostName();
        int n = -1;
        if (!this.serverProperties.isEmpty()) {
            ArrayList arrayList = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_ENABLED);
            ArrayList arrayList2 = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_PORT);
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!Boolean.TRUE.equals(arrayList.get(i))) continue;
                    n = (Integer)arrayList2.get(i);
                    break;
                }
            }
        }
        if (n != -1) {
            string = ConnectionUtils.getLDAPUrl(string2, n, false);
        }
        return string;
    }

    public String getLDAPsURL() {
        String string = null;
        String string2 = this.getHostName();
        int n = -1;
        if (!this.serverProperties.isEmpty()) {
            ArrayList arrayList = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAPS_ENABLED);
            ArrayList arrayList2 = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAPS_PORT);
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!Boolean.TRUE.equals(arrayList.get(i))) continue;
                    n = (Integer)arrayList2.get(i);
                    break;
                }
            }
        }
        if (n != -1) {
            string = ConnectionUtils.getLDAPUrl(string2, n, true);
        }
        return string;
    }

    public String getAdminConnectorURL() {
        String string = null;
        String string2 = this.getHostName();
        int n = -1;
        if (!this.serverProperties.isEmpty()) {
            ArrayList arrayList = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_ENABLED);
            ArrayList arrayList2 = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_PORT);
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!Boolean.TRUE.equals(arrayList.get(i))) continue;
                    n = (Integer)arrayList2.get(i);
                    break;
                }
            }
        }
        if (n != -1) {
            string = ConnectionUtils.getLDAPUrl(string2, n, true);
        }
        return string;
    }

    public List<Integer> getEnabledAdministrationPorts() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        ArrayList arrayList2 = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_ENABLED);
        ArrayList arrayList3 = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_PORT);
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (!Boolean.TRUE.equals(arrayList2.get(i))) continue;
                arrayList.add((Integer)arrayList3.get(i));
            }
        }
        return arrayList;
    }

    public String getHostPort(boolean bl) {
        int n;
        String string;
        block15: {
            block16: {
                int n2;
                string = this.getHostName();
                n = -1;
                if (this.serverProperties.isEmpty()) break block16;
                ArrayList arrayList = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_ENABLED);
                ArrayList arrayList2 = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_PORT);
                if (arrayList != null) {
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        if (!Boolean.TRUE.equals(arrayList.get(n2))) continue;
                        n = (Integer)arrayList2.get(n2);
                        break;
                    }
                }
                if (!bl) break block15;
                arrayList = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_ENABLED);
                arrayList2 = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_PORT);
                if (arrayList == null) break block15;
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    if (!Boolean.TRUE.equals(arrayList.get(n2))) continue;
                    n = (Integer)arrayList2.get(n2);
                    break block15;
                }
                break block15;
            }
            ArrayList<ADSContext.ServerProperty> arrayList = new ArrayList<ADSContext.ServerProperty>();
            if (bl) {
                arrayList.add(ADSContext.ServerProperty.ADMIN_ENABLED);
                arrayList.add(ADSContext.ServerProperty.LDAPS_ENABLED);
                arrayList.add(ADSContext.ServerProperty.LDAP_ENABLED);
            } else {
                arrayList.add(ADSContext.ServerProperty.LDAP_ENABLED);
                arrayList.add(ADSContext.ServerProperty.ADMIN_ENABLED);
                arrayList.add(ADSContext.ServerProperty.LDAPS_ENABLED);
            }
            for (ADSContext.ServerProperty serverProperty : arrayList) {
                ADSContext.ServerProperty serverProperty2;
                Object object = this.adsProperties.get((Object)serverProperty);
                if (object == null || !"true".equalsIgnoreCase(String.valueOf(object))) continue;
                if (serverProperty == ADSContext.ServerProperty.ADMIN_ENABLED) {
                    serverProperty2 = ADSContext.ServerProperty.ADMIN_PORT;
                } else if (serverProperty == ADSContext.ServerProperty.LDAPS_ENABLED) {
                    serverProperty2 = ADSContext.ServerProperty.LDAPS_PORT;
                } else if (serverProperty == ADSContext.ServerProperty.LDAP_ENABLED) {
                    serverProperty2 = ADSContext.ServerProperty.LDAP_PORT;
                } else {
                    throw new IllegalStateException("Unexpected prop: " + (Object)((Object)serverProperty));
                }
                Object object2 = this.adsProperties.get((Object)serverProperty2);
                if (object2 != null) {
                    try {
                        n = Integer.parseInt(String.valueOf(object2));
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, "Error calculating host port: " + throwable + " in " + this.adsProperties, throwable);
                    }
                    break;
                }
                LOG.log(Level.WARNING, "Value for " + (Object)((Object)serverProperty2) + " is null in " + this.adsProperties);
            }
        }
        return string + ":" + n;
    }

    public String getId() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.serverProperties.size() > 0) {
            ServerProperty[] serverPropertyArray;
            stringBuilder.append(this.serverProperties.get((Object)ServerProperty.HOST_NAME));
            for (ServerProperty serverProperty : serverPropertyArray = new ServerProperty[]{ServerProperty.LDAP_PORT, ServerProperty.LDAPS_PORT, ServerProperty.ADMIN_PORT, ServerProperty.LDAP_ENABLED, ServerProperty.LDAPS_ENABLED, ServerProperty.ADMIN_ENABLED}) {
                ArrayList arrayList = (ArrayList)this.serverProperties.get((Object)serverProperty);
                for (Object e : arrayList) {
                    stringBuilder.append(":").append(e);
                }
            }
        } else {
            ADSContext.ServerProperty[] serverPropertyArray = new ADSContext.ServerProperty[]{ADSContext.ServerProperty.HOST_NAME, ADSContext.ServerProperty.LDAP_PORT, ADSContext.ServerProperty.LDAPS_PORT, ADSContext.ServerProperty.ADMIN_PORT, ADSContext.ServerProperty.LDAP_ENABLED, ADSContext.ServerProperty.LDAPS_ENABLED, ADSContext.ServerProperty.ADMIN_ENABLED};
            for (int i = 0; i < serverPropertyArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(":");
                }
                stringBuilder.append(this.adsProperties.get((Object)serverPropertyArray[i]));
            }
        }
        return stringBuilder.toString();
    }

    public byte[] getInstancePublicKeyCertificate() {
        return (byte[])this.serverProperties.get((Object)ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE);
    }

    public String getSchemaReplicationID() {
        return (String)this.serverProperties.get((Object)ServerProperty.SCHEMA_GENERATION_ID);
    }

    public TopologyCacheException getLastException() {
        return this.lastException;
    }

    public void setLastException(TopologyCacheException topologyCacheException) {
        this.lastException = topologyCacheException;
    }

    public void updateAdsPropertiesWithServerProperties() {
        this.adsProperties.put(ADSContext.ServerProperty.HOST_NAME, this.getHostName());
        ServerProperty[][] serverPropertyArrayArray = new ServerProperty[][]{{ServerProperty.LDAP_ENABLED, ServerProperty.LDAP_PORT}, {ServerProperty.LDAPS_ENABLED, ServerProperty.LDAPS_PORT}, {ServerProperty.ADMIN_ENABLED, ServerProperty.ADMIN_PORT}, {ServerProperty.JMX_ENABLED, ServerProperty.JMX_PORT}, {ServerProperty.JMXS_ENABLED, ServerProperty.JMXS_PORT}};
        ADSContext.ServerProperty[][] serverPropertyArrayArray2 = new ADSContext.ServerProperty[][]{{ADSContext.ServerProperty.LDAP_ENABLED, ADSContext.ServerProperty.LDAP_PORT}, {ADSContext.ServerProperty.LDAPS_ENABLED, ADSContext.ServerProperty.LDAPS_PORT}, {ADSContext.ServerProperty.ADMIN_ENABLED, ADSContext.ServerProperty.ADMIN_PORT}, {ADSContext.ServerProperty.JMX_ENABLED, ADSContext.ServerProperty.JMX_PORT}, {ADSContext.ServerProperty.JMXS_ENABLED, ADSContext.ServerProperty.JMXS_PORT}};
        for (int i = 0; i < serverPropertyArrayArray.length; ++i) {
            ArrayList arrayList = (ArrayList)this.serverProperties.get((Object)serverPropertyArrayArray[i][0]);
            ArrayList arrayList2 = (ArrayList)this.serverProperties.get((Object)serverPropertyArrayArray[i][1]);
            if (arrayList == null) continue;
            int n = -1;
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!Boolean.TRUE.equals(arrayList.get(j))) continue;
                n = (Integer)arrayList2.get(j);
                break;
            }
            if (n == -1) {
                this.adsProperties.put(serverPropertyArrayArray2[i][0], "false");
                if (arrayList2.size() > 0) {
                    n = (Integer)arrayList2.iterator().next();
                }
            } else {
                this.adsProperties.put(serverPropertyArrayArray2[i][0], "true");
            }
            this.adsProperties.put(serverPropertyArrayArray2[i][1], String.valueOf(n));
        }
        ArrayList arrayList = (ArrayList)this.serverProperties.get((Object)ServerProperty.STARTTLS_ENABLED);
        boolean bl = false;
        if (arrayList != null && !arrayList.isEmpty()) {
            bl = Boolean.TRUE.equals(arrayList.get(arrayList.size() - 1));
        }
        this.adsProperties.put(ADSContext.ServerProperty.STARTTLS_ENABLED, bl ? "true" : "false");
        this.adsProperties.put(ADSContext.ServerProperty.ID, this.getHostPort(true));
        this.adsProperties.put(ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE, this.getInstancePublicKeyCertificate());
    }

    public static ServerDescriptor createStandalone(Map<ADSContext.ServerProperty, Object> map) {
        ServerDescriptor serverDescriptor = new ServerDescriptor();
        serverDescriptor.setAdsProperties(map);
        return serverDescriptor;
    }

    public static ServerDescriptor createStandalone(InitialLdapContext initialLdapContext, TopologyCacheFilter topologyCacheFilter) throws NamingException {
        ServerDescriptor serverDescriptor = new ServerDescriptor();
        ServerDescriptor.updateLdapConfiguration(serverDescriptor, initialLdapContext, topologyCacheFilter);
        ServerDescriptor.updateAdminConnectorConfiguration(serverDescriptor, initialLdapContext, topologyCacheFilter);
        ServerDescriptor.updateJmxConfiguration(serverDescriptor, initialLdapContext, topologyCacheFilter);
        ServerDescriptor.updateReplicas(serverDescriptor, initialLdapContext, topologyCacheFilter);
        ServerDescriptor.updateReplication(serverDescriptor, initialLdapContext, topologyCacheFilter);
        ServerDescriptor.updatePublicKeyCertificate(serverDescriptor, initialLdapContext, topologyCacheFilter);
        ServerDescriptor.updateMiscellaneous(serverDescriptor, initialLdapContext, topologyCacheFilter);
        serverDescriptor.serverProperties.put(ServerProperty.HOST_NAME, ConnectionUtils.getHostName(initialLdapContext));
        return serverDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLdapConfiguration(ServerDescriptor serverDescriptor, InitialLdapContext initialLdapContext, TopologyCacheFilter topologyCacheFilter) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"ds-cfg-enabled", "ds-cfg-listen-address", "ds-cfg-listen-port", "ds-cfg-use-ssl", "ds-cfg-allow-start-tls", "objectclass"});
        String string = "(objectclass=ds-cfg-ldap-connection-handler)";
        LdapName ldapName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search((Name)ldapName, string, searchControls);
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
            ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
            ArrayList<Boolean> arrayList5 = new ArrayList<Boolean>();
            serverDescriptor.serverProperties.put(ServerProperty.LDAP_PORT, arrayList);
            serverDescriptor.serverProperties.put(ServerProperty.LDAPS_PORT, arrayList2);
            serverDescriptor.serverProperties.put(ServerProperty.LDAP_ENABLED, arrayList3);
            serverDescriptor.serverProperties.put(ServerProperty.LDAPS_ENABLED, arrayList4);
            serverDescriptor.serverProperties.put(ServerProperty.STARTTLS_ENABLED, arrayList5);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string2 = ServerDescriptor.getFirstValue(searchResult, "ds-cfg-listen-port");
                boolean bl = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(searchResult, "ds-cfg-use-ssl"));
                boolean bl2 = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(searchResult, "ds-cfg-enabled"));
                if (bl) {
                    arrayList2.add(new Integer(string2));
                    arrayList4.add(bl2);
                    continue;
                }
                arrayList.add(new Integer(string2));
                arrayList3.add(bl2);
                bl2 = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(searchResult, "ds-cfg-allow-start-tls"));
                arrayList5.add(bl2);
            }
        }
        finally {
            namingEnumeration.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAdminConnectorConfiguration(ServerDescriptor serverDescriptor, InitialLdapContext initialLdapContext, TopologyCacheFilter topologyCacheFilter) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"ds-cfg-listen-port", "objectclass"});
        String string = "(objectclass=ds-cfg-administration-connector)";
        LdapName ldapName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search((Name)ldapName, string, searchControls);
        try {
            Object object;
            Serializable serializable;
            Integer n = null;
            if (namingEnumeration.hasMore()) {
                serializable = namingEnumeration.next();
                object = ServerDescriptor.getFirstValue((SearchResult)serializable, "ds-cfg-listen-port");
                n = new Integer((String)object);
            }
            serializable = new ArrayList();
            object = new ArrayList();
            if (n != null) {
                ((ArrayList)serializable).add(n);
                ((ArrayList)object).add(Boolean.TRUE);
            }
            serverDescriptor.serverProperties.put(ServerProperty.ADMIN_PORT, serializable);
            serverDescriptor.serverProperties.put(ServerProperty.ADMIN_ENABLED, object);
        }
        finally {
            namingEnumeration.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateJmxConfiguration(ServerDescriptor serverDescriptor, InitialLdapContext initialLdapContext, TopologyCacheFilter topologyCacheFilter) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"ds-cfg-enabled", "ds-cfg-listen-address", "ds-cfg-listen-port", "ds-cfg-use-ssl", "objectclass"});
        String string = "(objectclass=ds-cfg-jmx-connection-handler)";
        LdapName ldapName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search((Name)ldapName, string, searchControls);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
        serverDescriptor.serverProperties.put(ServerProperty.JMX_PORT, arrayList);
        serverDescriptor.serverProperties.put(ServerProperty.JMXS_PORT, arrayList2);
        serverDescriptor.serverProperties.put(ServerProperty.JMX_ENABLED, arrayList3);
        serverDescriptor.serverProperties.put(ServerProperty.JMXS_ENABLED, arrayList4);
        try {
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string2 = ServerDescriptor.getFirstValue(searchResult, "ds-cfg-listen-port");
                boolean bl = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(searchResult, "ds-cfg-use-ssl"));
                boolean bl2 = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(searchResult, "ds-cfg-enabled"));
                if (bl) {
                    arrayList2.add(new Integer(string2));
                    arrayList4.add(bl2);
                    continue;
                }
                arrayList.add(new Integer(string2));
                arrayList3.add(bl2);
            }
        }
        finally {
            namingEnumeration.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateReplicas(ServerDescriptor serverDescriptor, InitialLdapContext initialLdapContext, TopologyCacheFilter topologyCacheFilter) throws NamingException {
        if (!topologyCacheFilter.searchBaseDNInformation()) {
            return;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"ds-cfg-base-dn", "ds-cfg-backend-id"});
        String string = "(objectclass=ds-cfg-backend)";
        LdapName ldapName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search((Name)ldapName, string, searchControls);
        try {
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string2 = ServerDescriptor.getFirstValue(searchResult, "ds-cfg-backend-id");
                if (ServerDescriptor.isConfigBackend(string2) && !ServerDescriptor.isSchemaBackend(string2)) continue;
                Set<String> set = ServerDescriptor.getValues(searchResult, "ds-cfg-base-dn");
                Set<String> set2 = topologyCacheFilter.searchMonitoringInformation() ? ServerDescriptor.getBaseDNEntryCount(initialLdapContext, string2) : new HashSet<String>();
                Set<ReplicaDescriptor> set3 = serverDescriptor.getReplicas();
                for (String string3 : set) {
                    Object object;
                    Object object2;
                    boolean bl = topologyCacheFilter.searchAllBaseDNs();
                    if (!bl) {
                        object2 = topologyCacheFilter.getBaseDNsToSearch().iterator();
                        while (object2.hasNext() && !(bl = Utils.areDnsEqual((String)(object = (String)object2.next()), string3))) {
                        }
                    }
                    if (!bl) continue;
                    object2 = new SuffixDescriptor();
                    ((SuffixDescriptor)object2).setDN(string3);
                    object = new ReplicaDescriptor();
                    ((ReplicaDescriptor)object).setServer(serverDescriptor);
                    ((ReplicaDescriptor)object).setBackendName(string2);
                    set3.add((ReplicaDescriptor)object);
                    HashSet<ReplicaDescriptor> hashSet = new HashSet<ReplicaDescriptor>();
                    hashSet.add((ReplicaDescriptor)object);
                    ((SuffixDescriptor)object2).setReplicas(hashSet);
                    ((ReplicaDescriptor)object).setSuffix((SuffixDescriptor)object2);
                    int n = -1;
                    for (String string4 : set2) {
                        String string5;
                        int n2 = string4.indexOf(" ");
                        if (n2 == -1 || !Utils.areDnsEqual(string3, string5 = string4.substring(n2 + 1))) continue;
                        try {
                            n = Integer.parseInt(string4.substring(0, n2));
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    ((ReplicaDescriptor)object).setEntries(n);
                }
                serverDescriptor.setReplicas(set3);
            }
        }
        finally {
            namingEnumeration.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateReplication(ServerDescriptor serverDescriptor, InitialLdapContext initialLdapContext, TopologyCacheFilter topologyCacheFilter) throws NamingException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        NamingEnumeration<SearchResult> namingEnumeration;
        Serializable serializable;
        boolean bl = false;
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        searchControls.setReturningAttributes(new String[]{"ds-cfg-enabled"});
        String string = "(objectclass=ds-cfg-synchronization-provider)";
        LdapName ldapName = new LdapName("cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        NamingEnumeration<SearchResult> namingEnumeration2 = null;
        try {
            namingEnumeration2 = initialLdapContext.search((Name)ldapName, string, searchControls);
            while (namingEnumeration2.hasMore()) {
                serializable = namingEnumeration2.next();
                if (!"true".equalsIgnoreCase(ServerDescriptor.getFirstValue((SearchResult)serializable, "ds-cfg-enabled"))) continue;
                bl = true;
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
        }
        finally {
            if (namingEnumeration2 != null) {
                namingEnumeration2.close();
            }
        }
        serverDescriptor.serverProperties.put(ServerProperty.IS_REPLICATION_ENABLED, bl ? Boolean.TRUE : Boolean.FALSE);
        serializable = new LinkedHashSet();
        if (topologyCacheFilter.searchBaseDNInformation()) {
            searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{"ds-cfg-base-dn", "ds-cfg-replication-server", "ds-cfg-server-id"});
            string = "(objectclass=ds-cfg-replication-domain)";
            ldapName = new LdapName("cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
            namingEnumeration2 = null;
            try {
                namingEnumeration2 = initialLdapContext.search((Name)ldapName, string, searchControls);
                while (namingEnumeration2.hasMore()) {
                    namingEnumeration = namingEnumeration2.next();
                    int n = Integer.parseInt(ServerDescriptor.getFirstValue((SearchResult)((Object)namingEnumeration), "ds-cfg-server-id"));
                    object4 = ServerDescriptor.getValues((SearchResult)((Object)namingEnumeration), "ds-cfg-replication-server");
                    object3 = ServerDescriptor.getValues((SearchResult)((Object)namingEnumeration), "ds-cfg-base-dn");
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        for (ReplicaDescriptor replicaDescriptor : serverDescriptor.getReplicas()) {
                            if (!ServerDescriptor.areDnsEqual(replicaDescriptor.getSuffix().getDN(), (String)object)) continue;
                            replicaDescriptor.setReplicationId(n);
                            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                            Iterator iterator = object4.iterator();
                            while (iterator.hasNext()) {
                                String string2 = (String)iterator.next();
                                linkedHashSet.add(string2.toLowerCase());
                            }
                            replicaDescriptor.setReplicationServers(linkedHashSet);
                            serializable.addAll(linkedHashSet);
                        }
                    }
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            finally {
                if (namingEnumeration2 != null) {
                    namingEnumeration2.close();
                }
            }
        }
        searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        searchControls.setReturningAttributes(new String[]{"ds-cfg-replication-port", "ds-cfg-replication-server", "ds-cfg-replication-server-id"});
        string = "(objectclass=ds-cfg-replication-server)";
        ldapName = new LdapName("cn=Replication Server,cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        serverDescriptor.serverProperties.put(ServerProperty.IS_REPLICATION_SERVER, Boolean.FALSE);
        namingEnumeration = null;
        try {
            namingEnumeration = initialLdapContext.search((Name)ldapName, string, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)namingEnumeration.next();
                serverDescriptor.serverProperties.put(ServerProperty.IS_REPLICATION_SERVER, Boolean.TRUE);
                object4 = ServerDescriptor.getFirstValue(searchResult, "ds-cfg-replication-port");
                serverDescriptor.serverProperties.put(ServerProperty.REPLICATION_SERVER_PORT, Integer.parseInt((String)object4));
                object4 = ServerDescriptor.getFirstValue(searchResult, "ds-cfg-replication-server-id");
                serverDescriptor.serverProperties.put(ServerProperty.REPLICATION_SERVER_ID, Integer.parseInt((String)object4));
                object3 = ServerDescriptor.getValues(searchResult, "ds-cfg-replication-server");
                object2 = new LinkedHashSet();
                object = object3.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    ((HashSet)object2).add(string3.toLowerCase());
                }
                serializable.addAll(object2);
                serverDescriptor.serverProperties.put(ServerProperty.EXTERNAL_REPLICATION_SERVERS, serializable);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
        }
        finally {
            if (namingEnumeration != null) {
                namingEnumeration.close();
            }
        }
        boolean bl2 = false;
        if (bl) {
            searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(new String[]{"ds-cfg-ssl-encryption"});
            string = "(objectclass=ds-cfg-crypto-manager)";
            ldapName = new LdapName("cn=Crypto Manager,cn=config");
            namingEnumeration = initialLdapContext.search((Name)ldapName, string, searchControls);
            try {
                while (namingEnumeration.hasMore()) {
                    object4 = namingEnumeration.next();
                    object3 = ServerDescriptor.getFirstValue((SearchResult)object4, "ds-cfg-ssl-encryption");
                    bl2 = "true".equalsIgnoreCase((String)object3);
                }
            }
            finally {
                namingEnumeration.close();
            }
        }
        serverDescriptor.serverProperties.put(ServerProperty.IS_REPLICATION_SECURE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    private static void updatePublicKeyCertificate(ServerDescriptor serverDescriptor, InitialLdapContext initialLdapContext, TopologyCacheFilter topologyCacheFilter) throws NamingException {
        LdapName ldapName = new LdapName("ds-cfg-key-id=ads-certificate,cn=ads-truststore");
        for (int i = 0; i < 2; ++i) {
            Serializable serializable;
            String[] stringArray;
            try {
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(0);
                stringArray = new String[]{"ds-cfg-public-key-certificate;binary"};
                searchControls.setReturningAttributes(stringArray);
                serializable = initialLdapContext.search((Name)ldapName, "(objectclass=ds-cfg-instance-key)", searchControls).next();
                Attribute attribute = ((SearchResult)serializable).getAttributes().get(stringArray[0]);
                if (null == attribute) break;
                serverDescriptor.serverProperties.put(ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE, attribute.get());
                break;
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (0 != i) {
                    throw nameNotFoundException;
                }
                stringArray = new BasicAttributes();
                serializable = new BasicAttribute("objectclass");
                serializable.add("top");
                serializable.add("ds-cfg-self-signed-cert-request");
                stringArray.put((Attribute)serializable);
                initialLdapContext.createSubcontext(ldapName, (Attributes)stringArray).close();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMiscellaneous(ServerDescriptor serverDescriptor, InitialLdapContext initialLdapContext, TopologyCacheFilter topologyCacheFilter) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        searchControls.setReturningAttributes(new String[]{"ds-sync-generation-id"});
        String string = "|(objectclass=*)(objectclass=ldapsubentry)";
        LdapName ldapName = new LdapName("cn=schema");
        NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search((Name)ldapName, string, searchControls);
        try {
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                serverDescriptor.serverProperties.put(ServerProperty.SCHEMA_GENERATION_ID, ServerDescriptor.getFirstValue(searchResult, "ds-sync-generation-id"));
            }
        }
        finally {
            namingEnumeration.close();
        }
    }

    public static void seedAdsTrustStore(InitialLdapContext initialLdapContext, Map<String, byte[]> map) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("top");
        basicAttribute.add("ds-cfg-instance-key");
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            BasicAttributes basicAttributes = new BasicAttributes();
            basicAttributes.put(basicAttribute);
            BasicAttribute basicAttribute2 = new BasicAttribute(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName(), entry.getKey());
            basicAttributes.put(basicAttribute2);
            basicAttributes.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE.getAttributeName() + ";binary", entry.getValue()));
            LdapName ldapName = new LdapName(basicAttribute2.getID() + "=" + Rdn.escapeValue(basicAttribute2.get()) + "," + TRUSTSTORE_DN);
            try {
                initialLdapContext.createSubcontext(ldapName, (Attributes)basicAttributes).close();
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                initialLdapContext.destroySubcontext(ldapName);
                initialLdapContext.createSubcontext(ldapName, (Attributes)basicAttributes).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanAdsTrustStore(InitialLdapContext initialLdapContext) throws NamingException {
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(1);
            String[] stringArray = new String[]{"1.1"};
            searchControls.setReturningAttributes(stringArray);
            NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search(TRUSTSTORE_DN, "(objectclass=ds-cfg-instance-key)", searchControls);
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                while (namingEnumeration.hasMore()) {
                    SearchResult searchResult = namingEnumeration.next();
                    arrayList.add(searchResult.getName() + "," + TRUSTSTORE_DN);
                }
            }
            finally {
                namingEnumeration.close();
            }
            for (String string : arrayList) {
                initialLdapContext.destroySubcontext(string);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            LOG.log(Level.WARNING, "Error cleaning truststore: " + nameNotFoundException, nameNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getBaseDNEntryCount(InitialLdapContext initialLdapContext, String string) throws NamingException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(new String[]{"ds-base-dn-entry-count"});
        String string2 = "(ds-backend-id=" + string + ")";
        LdapName ldapName = new LdapName("cn=monitor");
        NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search((Name)ldapName, string2, searchControls);
        try {
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                linkedHashSet.addAll(ServerDescriptor.getValues(searchResult, "ds-base-dn-entry-count"));
            }
        }
        finally {
            namingEnumeration.close();
        }
        return linkedHashSet;
    }

    private static String getFirstValue(SearchResult searchResult, String string) throws NamingException {
        return ConnectionUtils.getFirstValue(searchResult, string);
    }

    private static Set<String> getValues(SearchResult searchResult, String string) throws NamingException {
        return ConnectionUtils.getValues(searchResult, string);
    }

    private static boolean isConfigBackend(String string) {
        return "tasks".equalsIgnoreCase(string) || "schema".equalsIgnoreCase(string) || "config".equalsIgnoreCase(string) || "monitor".equalsIgnoreCase(string) || "backup".equalsIgnoreCase(string) || "ads-truststore".equalsIgnoreCase(string);
    }

    private static boolean isSchemaBackend(String string) {
        return "schema".equalsIgnoreCase(string);
    }

    private static boolean areDnsEqual(String string, String string2) {
        boolean bl = false;
        try {
            LdapName ldapName = new LdapName(string);
            LdapName ldapName2 = new LdapName(string2);
            bl = ldapName.equals(ldapName2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static String getReplicationServer(String string, int n) {
        return string.toLowerCase() + ":" + n;
    }

    public static String getServerRepresentation(String string, int n) {
        return string.toLowerCase() + ":" + n;
    }

    public static String getSuffixDisplay(String string, Set<ServerDescriptor> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (ServerDescriptor serverDescriptor : set) {
            stringBuilder.append(Constants.LINE_SEPARATOR + "    ");
            stringBuilder.append(serverDescriptor.getHostPort(true));
        }
        return stringBuilder.toString();
    }

    public boolean isSameServer(ServerDescriptor serverDescriptor) {
        return this.getId().equals(serverDescriptor.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerProperty {
        HOST_NAME,
        LDAP_PORT,
        LDAPS_PORT,
        ADMIN_PORT,
        LDAP_ENABLED,
        LDAPS_ENABLED,
        ADMIN_ENABLED,
        STARTTLS_ENABLED,
        JMX_PORT,
        JMXS_PORT,
        JMX_ENABLED,
        JMXS_ENABLED,
        REPLICATION_SERVER_PORT,
        IS_REPLICATION_SERVER,
        IS_REPLICATION_ENABLED,
        IS_REPLICATION_SECURE,
        EXTERNAL_REPLICATION_SERVERS,
        REPLICATION_SERVER_ID,
        INSTANCE_PUBLIC_KEY_CERTIFICATE,
        SCHEMA_GENERATION_ID;

    }
}

