/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.opends.server.util.Platform;

public class ApplicationKeyManager
implements X509KeyManager {
    private static final Logger LOG = Logger.getLogger(ApplicationKeyManager.class.getName());
    private X509KeyManager keyManager = null;

    public ApplicationKeyManager(KeyStore keyStore, char[] cArray) {
        KeyManagerFactory keyManagerFactory = null;
        String string = System.getProperty("org.opends.admin.keymanageralgo");
        String string2 = System.getProperty("org.opends.admin.keymanagerprovider");
        if (string == null && Platform.isVendor("IBM")) {
            string = "IbmX509";
        }
        if (string2 == null && Platform.isVendor("IBM")) {
            string2 = "IBMJSSE2";
        }
        String[] stringArray = new String[]{string2, "SunJSSE", null, null};
        String[] stringArray2 = new String[]{string, "SunX509", "SunX509", TrustManagerFactory.getDefaultAlgorithm()};
        block5: for (int i = 0; i < stringArray.length && this.keyManager == null; ++i) {
            String string3 = stringArray[i];
            String string4 = stringArray2[i];
            if (string4 == null) continue;
            try {
                keyManagerFactory = string3 != null ? KeyManagerFactory.getInstance(string4, string3) : KeyManagerFactory.getInstance(string4);
                keyManagerFactory.init(keyStore, cArray);
                KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                for (int j = 0; j < keyManagerArray.length; ++j) {
                    if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                    this.keyManager = (X509KeyManager)keyManagerArray[j];
                    continue block5;
                }
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOG.log(Level.WARNING, "Error with the algorithm", noSuchAlgorithmException);
                continue;
            }
            catch (KeyStoreException keyStoreException) {
                LOG.log(Level.WARNING, "Error with the keystore", keyStoreException);
                continue;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                LOG.log(Level.WARNING, "Error with the key", unrecoverableKeyException);
                continue;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                LOG.log(Level.WARNING, "Error with the provider", noSuchProviderException);
            }
        }
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (this.keyManager != null) {
            return this.keyManager.chooseClientAlias(stringArray, principalArray, socket);
        }
        return null;
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (this.keyManager != null) {
            return this.keyManager.chooseServerAlias(string, principalArray, socket);
        }
        return null;
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (this.keyManager != null) {
            return this.keyManager.getCertificateChain(string);
        }
        return null;
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        if (this.keyManager != null) {
            return this.keyManager.getClientAliases(string, principalArray);
        }
        return null;
    }

    public PrivateKey getPrivateKey(String string) {
        if (this.keyManager != null) {
            return this.keyManager.getPrivateKey(string);
        }
        return null;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        if (this.keyManager != null) {
            return this.keyManager.getServerAliases(string, principalArray);
        }
        return null;
    }
}

