/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.opends.admin.ads.util.BlindHostnameVerifier;
import org.opends.admin.ads.util.BlindTrustManager;
import org.opends.admin.ads.util.TrustedSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionUtils {
    private static final int DEFAULT_LDAP_CONNECT_TIMEOUT = 30000;
    private static final String STARTTLS_PROPERTY = "org.opends.connectionutils.isstarttls";
    private static final Logger LOG = Logger.getLogger(ConnectionUtils.class.getName());

    private ConnectionUtils() {
    }

    public static InitialLdapContext createLdapContext(String string, String string2, String string3, int n, Hashtable<String, String> hashtable) throws NamingException {
        hashtable = hashtable != null ? new Hashtable<String, String>(hashtable) : new Hashtable();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        if (n >= 1) {
            hashtable.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(n));
        }
        if (string2 != null) {
            hashtable.put("java.naming.security.principal", string2);
        }
        if (string3 != null) {
            hashtable.put("java.naming.security.credentials", string3);
        }
        final Object[] objectArray = new Object[]{null, null};
        final Hashtable<String, String> hashtable2 = hashtable;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    objectArray[0] = new InitialLdapContext(hashtable2, null);
                }
                catch (NamingException namingException) {
                    objectArray[1] = namingException;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    objectArray[1] = throwable;
                }
            }
        });
        thread.setDaemon(true);
        return ConnectionUtils.getInitialLdapContext(thread, objectArray, n);
    }

    public static InitialLdapContext createLdapsContext(String string, String string2, String string3, int n, Hashtable<String, String> hashtable, TrustManager trustManager, KeyManager keyManager) throws NamingException {
        hashtable = hashtable != null ? new Hashtable<String, String>(hashtable) : new Hashtable();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.ldap.factory.socket", TrustedSocketFactory.class.getName());
        if (string2 != null) {
            hashtable.put("java.naming.security.principal", string2);
        }
        if (string3 != null) {
            hashtable.put("java.naming.security.credentials", string3);
        }
        if (trustManager == null) {
            trustManager = new BlindTrustManager();
        }
        final Object[] objectArray = new Object[]{null, null};
        final Hashtable<String, String> hashtable2 = hashtable;
        final TrustManager trustManager2 = trustManager;
        final KeyManager keyManager2 = keyManager;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    TrustedSocketFactory.setCurrentThreadTrustManager(trustManager2, keyManager2);
                    objectArray[0] = new InitialLdapContext(hashtable2, null);
                }
                catch (NamingException namingException) {
                    objectArray[1] = namingException;
                }
                catch (RuntimeException runtimeException) {
                    objectArray[1] = runtimeException;
                }
            }
        });
        thread.setDaemon(true);
        return ConnectionUtils.getInitialLdapContext(thread, objectArray, n);
    }

    public static InitialLdapContext cloneInitialLdapContext(final InitialLdapContext initialLdapContext, int n, TrustManager trustManager, KeyManager keyManager) throws NamingException {
        Hashtable<?, ?> hashtable = initialLdapContext.getEnvironment();
        Control[] controlArray = initialLdapContext.getConnectControls();
        Control[] controlArray2 = null;
        if (controlArray != null) {
            controlArray2 = new Control[controlArray.length];
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray2[i] = controlArray[i];
            }
        }
        final Object[] objectArray = new Object[]{null, null};
        final Hashtable<?, ?> hashtable2 = hashtable;
        final TrustManager trustManager2 = trustManager;
        final KeyManager keyManager2 = keyManager;
        final Control[] controlArray3 = controlArray2;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (ConnectionUtils.isSSL(initialLdapContext) || ConnectionUtils.isStartTLS(initialLdapContext)) {
                        TrustedSocketFactory.setCurrentThreadTrustManager(trustManager2, keyManager2);
                    }
                    objectArray[0] = new InitialLdapContext(hashtable2, controlArray3);
                }
                catch (NamingException namingException) {
                    objectArray[1] = namingException;
                }
                catch (RuntimeException runtimeException) {
                    objectArray[1] = runtimeException;
                }
            }
        });
        return ConnectionUtils.getInitialLdapContext(thread, objectArray, n);
    }

    public static InitialLdapContext createStartTLSContext(String string, String string2, String string3, int n, Hashtable<String, String> hashtable, TrustManager trustManager, KeyManager keyManager, HostnameVerifier hostnameVerifier) throws NamingException {
        if (trustManager == null) {
            trustManager = new BlindTrustManager();
        }
        if (hostnameVerifier == null) {
            hostnameVerifier = new BlindHostnameVerifier();
        }
        hashtable = hashtable != null ? new Hashtable<String, String>(hashtable) : new Hashtable();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.security.authentication", "none");
        final Object[] objectArray = new Object[]{null, null};
        final Hashtable<String, String> hashtable2 = hashtable;
        final String string4 = string2;
        final String string5 = string3;
        final TrustManager trustManager2 = trustManager;
        final KeyManager keyManager2 = keyManager;
        final HostnameVerifier hostnameVerifier2 = hostnameVerifier;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    InitialLdapContext initialLdapContext = new InitialLdapContext(hashtable2, null);
                    StartTlsResponse startTlsResponse = (StartTlsResponse)initialLdapContext.extendedOperation(new StartTlsRequest());
                    startTlsResponse.setHostnameVerifier(hostnameVerifier2);
                    try {
                        startTlsResponse.negotiate(new TrustedSocketFactory(trustManager2, keyManager2));
                    }
                    catch (IOException iOException) {
                        CommunicationException communicationException = new CommunicationException("Failed to negotiate Start TLS operation");
                        communicationException.initCause(iOException);
                        initialLdapContext.close();
                        throw communicationException;
                    }
                    initialLdapContext.addToEnvironment(ConnectionUtils.STARTTLS_PROPERTY, "true");
                    if (string4 != null) {
                        initialLdapContext.addToEnvironment("java.naming.security.authentication", "simple");
                        initialLdapContext.addToEnvironment("java.naming.security.principal", string4);
                        if (string5 != null) {
                            initialLdapContext.addToEnvironment("java.naming.security.credentials", string5);
                        }
                        initialLdapContext.reconnect(null);
                    }
                    objectArray[0] = initialLdapContext;
                }
                catch (NamingException namingException) {
                    objectArray[1] = namingException;
                }
                catch (RuntimeException runtimeException) {
                    objectArray[1] = runtimeException;
                }
            }
        });
        thread.setDaemon(true);
        return ConnectionUtils.getInitialLdapContext(thread, objectArray, n);
    }

    public static String getLdapUrl(InitialLdapContext initialLdapContext) {
        String string = null;
        try {
            string = (String)initialLdapContext.getEnvironment().get("java.naming.provider.url");
        }
        catch (NamingException namingException) {
            LOG.log(Level.WARNING, "Naming exception getting environment of " + initialLdapContext, namingException);
        }
        return string;
    }

    public static String getHostName(InitialLdapContext initialLdapContext) {
        String string = null;
        try {
            URI uRI = new URI(ConnectionUtils.getLdapUrl(initialLdapContext));
            string = uRI.getHost();
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Error getting host: " + throwable, throwable);
        }
        return string;
    }

    public static int getPort(InitialLdapContext initialLdapContext) {
        int n = -1;
        try {
            URI uRI = new URI(ConnectionUtils.getLdapUrl(initialLdapContext));
            n = uRI.getPort();
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Error getting port: " + throwable, throwable);
        }
        return n;
    }

    public static String getHostPort(InitialLdapContext initialLdapContext) {
        return ConnectionUtils.getHostName(initialLdapContext) + ":" + ConnectionUtils.getPort(initialLdapContext);
    }

    public static String getBindDN(InitialLdapContext initialLdapContext) {
        String string = null;
        try {
            string = (String)initialLdapContext.getEnvironment().get("java.naming.security.principal");
        }
        catch (NamingException namingException) {
            LOG.log(Level.WARNING, "Naming exception getting environment of " + initialLdapContext, namingException);
        }
        return string;
    }

    public static String getBindPassword(InitialLdapContext initialLdapContext) {
        String string = null;
        try {
            string = (String)initialLdapContext.getEnvironment().get("java.naming.security.credentials");
        }
        catch (NamingException namingException) {
            LOG.log(Level.WARNING, "Naming exception getting environment of " + initialLdapContext, namingException);
        }
        return string;
    }

    public static boolean isSSL(InitialLdapContext initialLdapContext) {
        boolean bl = false;
        String string = null;
        try {
            string = ConnectionUtils.getLdapUrl(initialLdapContext);
            bl = string.toLowerCase().startsWith("ldaps");
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Error getting if is SSL " + throwable, throwable);
        }
        return bl;
    }

    public static boolean isStartTLS(InitialLdapContext initialLdapContext) {
        boolean bl = false;
        try {
            bl = "true".equalsIgnoreCase((String)initialLdapContext.getEnvironment().get(STARTTLS_PROPERTY));
        }
        catch (NamingException namingException) {
            LOG.log(Level.WARNING, "Naming exception getting environment of " + initialLdapContext, namingException);
        }
        return bl;
    }

    public static boolean canConnectAsAdministrativeUser(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            InitialLdapContext initialLdapContext = string.toLowerCase().startsWith("ldap:") ? ConnectionUtils.createLdapContext(string, string2, string3, n, null) : ConnectionUtils.createLdapsContext(string, string2, string3, n, null, null, null);
            bl = ConnectionUtils.connectedAsAdministrativeUser(initialLdapContext);
        }
        catch (NamingException namingException) {
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unexpected throwable.", throwable);
        }
        return bl;
    }

    public static boolean connectedAsAdministrativeUser(InitialLdapContext initialLdapContext) {
        boolean bl = false;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setCountLimit(1L);
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(new String[]{"1.1"});
            initialLdapContext.search("cn=config", "objectclass=*", searchControls);
            bl = true;
        }
        catch (NamingException namingException) {
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unexpected throwable.", throwable);
        }
        return bl;
    }

    private static InitialLdapContext getInitialLdapContext(Thread thread, Object[] objectArray, int n) throws NamingException {
        try {
            if (n > 0) {
                thread.start();
                thread.join(n);
            } else {
                thread.run();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean bl = false;
        if (n > 0 && thread.isAlive()) {
            thread.interrupt();
            try {
                thread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl = true;
        }
        if (objectArray[0] == null && objectArray[1] == null) {
            bl = true;
        }
        if (bl) {
            ConnectException connectException = new ConnectException("Connection timed out");
            CommunicationException communicationException = new CommunicationException("Connection timed out");
            communicationException.initCause(connectException);
            throw communicationException;
        }
        if (objectArray[1] != null) {
            if (objectArray[1] instanceof NamingException) {
                throw (NamingException)objectArray[1];
            }
            if (objectArray[1] instanceof RuntimeException) {
                throw (RuntimeException)objectArray[1];
            }
            if (objectArray[1] instanceof Throwable) {
                throw new IllegalStateException("Unexpected throwable occurred", (Throwable)objectArray[1]);
            }
        }
        return (InitialLdapContext)objectArray[0];
    }

    public static int getDefaultLDAPTimeout() {
        return 30000;
    }

    public static String getHostNameForLdapUrl(String string) {
        if (string != null && string.indexOf(":") != -1) {
            if (!(string = string.trim()).startsWith("[")) {
                string = "[" + string;
            }
            if (!string.endsWith("]")) {
                string = string + "]";
            }
        }
        return string;
    }

    public static String getLDAPUrl(String string, int n, boolean bl) {
        string = ConnectionUtils.getHostNameForLdapUrl(string);
        String string2 = bl ? "ldaps://" + string + ":" + n : "ldap://" + string + ":" + n;
        return string2;
    }

    public static boolean isCertificateException(Throwable throwable) {
        boolean bl = false;
        while (!bl && throwable != null) {
            bl = throwable instanceof SSLHandshakeException || throwable instanceof GeneralSecurityException;
            throwable = throwable.getCause();
        }
        return bl;
    }

    public static String getFirstValue(SearchResult searchResult, String string) throws NamingException {
        Attribute attribute;
        String string2 = null;
        Attributes attributes = searchResult.getAttributes();
        if (attributes != null && (attribute = attributes.get(string)) != null && attribute.size() > 0) {
            Object object = attribute.get();
            string2 = object instanceof String ? (String)object : String.valueOf(object);
        }
        return string2;
    }

    public static Set<String> getValues(SearchResult searchResult, String string) throws NamingException {
        Attribute attribute;
        HashSet<String> hashSet = new HashSet<String>();
        Attributes attributes = searchResult.getAttributes();
        if (attributes != null && (attribute = attributes.get(string)) != null) {
            for (int i = 0; i < attribute.size(); ++i) {
                hashSet.add((String)attribute.get(i));
            }
        }
        return hashSet;
    }
}

