/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.opends.quicksetup.util.Utils;

public class LicenseFile {
    private static File licFile = null;
    private static boolean approved = false;

    private static String getLegalDirectory() {
        if (Utils.isWebStart()) {
            return File.separatorChar + "Legal";
        }
        String installRootFromSystem = System.getProperty("INSTALL_ROOT");
        if (installRootFromSystem == null) {
            installRootFromSystem = System.getenv("INSTALL_ROOT");
        }
        if (installRootFromSystem == null) {
            installRootFromSystem = "";
        }
        return installRootFromSystem + File.separatorChar + "Legal";
    }

    private static String getInstanceLegalDirectory() {
        String instanceLegalDirName;
        if (Utils.isWebStart()) {
            instanceLegalDirName = File.separatorChar + "Legal";
        } else {
            String instanceDirname;
            File instanceLegalDir;
            String installDirName = System.getProperty("INSTALL_ROOT");
            if (installDirName == null) {
                installDirName = System.getenv("INSTALL_ROOT");
            }
            if (installDirName == null) {
                installDirName = ".";
            }
            if (!(instanceLegalDir = new File(instanceLegalDirName = (instanceDirname = Utils.getInstancePathFromInstallPath(installDirName)) + File.separator + "Legal")).exists()) {
                instanceLegalDir.mkdir();
            }
        }
        return instanceLegalDirName;
    }

    private static String getName() {
        return LicenseFile.getLegalDirectory() + File.separatorChar + "license_to_accept.txt";
    }

    private static File getFile() {
        if (licFile == null) {
            licFile = new File(LicenseFile.getName());
        }
        return licFile;
    }

    public static boolean exists() {
        if (Utils.isWebStart()) {
            return false;
        }
        return LicenseFile.getFile().exists();
    }

    public static String getText() {
        FileReader reader;
        try {
            reader = new FileReader(LicenseFile.getFile());
        }
        catch (Exception e) {
            return "";
        }
        int fileLen = (int)LicenseFile.getFile().length();
        char[] charArray = new char[fileLen];
        try {
            reader.read(charArray);
        }
        catch (IOException ioe) {
            System.out.println("Could not read license file");
        }
        return new String(charArray);
    }

    public static boolean getApproval() {
        return approved;
    }

    public static void setApproval(boolean p_approved) {
        approved = p_approved;
    }

    public static void createFileLicenseApproved() {
        if (LicenseFile.getApproval()) {
            try {
                new File(LicenseFile.getInstanceLegalDirectory() + File.separatorChar + "licenseAccepted").createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isAlreadyApproved() {
        File f = new File(LicenseFile.getInstanceLegalDirectory() + File.separatorChar + "licenseAccepted");
        return f.exists();
    }
}

