/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.JavaArguments;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.ReviewPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.HtmlProgressMessageFormatter;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;

public class InstallReviewPanel
extends ReviewPanel {
    private static final long serialVersionUID = -7356174829193265699L;
    private boolean displayServerLocation;
    private HashMap<FieldName, JLabel> hmLabels = new HashMap();
    private HashMap<FieldName, JTextComponent> hmFields = new HashMap();
    private JPanel bottomComponent;
    private JCheckBox startCheckBox;
    private JCheckBox enableWindowsServiceCheckBox;
    private JLabel warningLabel;
    private JComboBox viewCombo;
    private final Message DISPLAY_TEXT = QuickSetupMessages.INFO_REVIEW_DISPLAY_TEXT.get();
    private final Message DISPLAY_EQUIVALENT_COMMAND = QuickSetupMessages.INFO_REVIEW_DISPLAY_EQUIVALENT_COMMAND.get();
    private JComponent cardLayoutPanel;
    private JEditorPane equivalentCommandPane;
    private UserData lastUserData;

    public InstallReviewPanel(GuiApplication application) {
        super(application);
        this.displayServerLocation = this.isWebStart();
        this.populateLabelAndFieldsMap();
    }

    public void beginDisplay(UserData userData) {
        if (this.displayServerLocation) {
            this.setFieldValue(FieldName.SERVER_LOCATION, userData.getServerLocation());
        }
        this.setFieldValue(FieldName.HOST_NAME, String.valueOf(userData.getHostName()));
        this.setFieldValue(FieldName.SERVER_PORT, String.valueOf(userData.getServerPort()));
        this.setFieldValue(FieldName.ADMIN_CONNECTOR_PORT, String.valueOf(userData.getAdminConnectorPort()));
        this.setFieldValue(FieldName.SECURITY_OPTIONS, Utils.getSecurityOptionsString(userData.getSecurityOptions(), false));
        this.setFieldValue(FieldName.DIRECTORY_MANAGER_DN, userData.getDirectoryManagerDn());
        this.setFieldValue(FieldName.DATA_OPTIONS, Utils.getDataDisplayString(userData));
        if (userData.mustCreateAdministrator()) {
            this.setFieldValue(FieldName.GLOBAL_ADMINISTRATOR_UID, String.valueOf(userData.getGlobalAdministratorUID()));
            this.getField(FieldName.GLOBAL_ADMINISTRATOR_UID).setVisible(true);
            this.getLabel(FieldName.GLOBAL_ADMINISTRATOR_UID).setVisible(true);
        } else {
            this.getField(FieldName.GLOBAL_ADMINISTRATOR_UID).setVisible(false);
            this.getLabel(FieldName.GLOBAL_ADMINISTRATOR_UID).setVisible(false);
        }
        if (userData.getReplicationOptions().getType() == DataReplicationOptions.Type.STANDALONE) {
            this.getField(FieldName.REPLICATION_PORT).setVisible(false);
            this.getLabel(FieldName.REPLICATION_PORT).setVisible(false);
        } else {
            this.setFieldValue(FieldName.REPLICATION_PORT, this.getReplicationPortString(userData));
            this.getField(FieldName.REPLICATION_PORT).setVisible(true);
            this.getLabel(FieldName.REPLICATION_PORT).setVisible(true);
        }
        this.setFieldValue(FieldName.SERVER_JAVA_ARGUMENTS, this.getRuntimeString(userData));
        this.checkStartWarningLabel();
        this.updateEquivalentCommand(userData);
        this.lastUserData = userData;
    }

    protected Component createInstructionsPanel() {
        JPanel instructionsPanel = new JPanel(new GridBagLayout());
        instructionsPanel.setOpaque(false);
        Message instructions = this.getInstructions();
        JLabel l = new JLabel(instructions.toString());
        l.setFont(UIFactory.INSTRUCTIONS_FONT);
        Message[] values = new Message[]{this.DISPLAY_TEXT, this.DISPLAY_EQUIVALENT_COMMAND};
        DefaultComboBoxModel<Message> model = new DefaultComboBoxModel<Message>(values);
        this.viewCombo = new JComboBox();
        this.viewCombo.setModel(model);
        this.viewCombo.setSelectedIndex(0);
        this.viewCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                InstallReviewPanel.this.updateInputPanel();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        instructionsPanel.add((Component)l, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        instructionsPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets.left = 10;
        instructionsPanel.add(this.viewCombo);
        return instructionsPanel;
    }

    protected boolean requiresScroll() {
        return false;
    }

    protected Component createInputPanel() {
        JPanel panel = UIFactory.makeJPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)this.createFieldsPanel(), gbc);
        JComponent chk = this.getBottomComponent();
        if (chk != null) {
            gbc.insets.top = 10;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            panel.add((Component)chk, gbc);
        }
        return panel;
    }

    public Object getFieldValue(FieldName fieldName) {
        Boolean value = null;
        if (fieldName == FieldName.SERVER_START_INSTALLER) {
            value = this.getStartCheckBox().isSelected();
        } else if (fieldName == FieldName.ENABLE_WINDOWS_SERVICE) {
            value = this.getEnableWindowsServiceCheckBox().isSelected();
        }
        return value;
    }

    protected Message getInstructions() {
        return QuickSetupMessages.INFO_REVIEW_PANEL_INSTRUCTIONS.get();
    }

    protected Message getTitle() {
        return QuickSetupMessages.INFO_REVIEW_PANEL_TITLE.get();
    }

    private void updateInputPanel() {
        CardLayout cl = (CardLayout)this.cardLayoutPanel.getLayout();
        cl.show(this.cardLayoutPanel, this.viewCombo.getSelectedItem().toString());
    }

    private void populateLabelAndFieldsMap() {
        HashMap<FieldName, LabelFieldDescriptor> hm = new HashMap<FieldName, LabelFieldDescriptor>();
        if (this.displayServerLocation) {
            hm.put(FieldName.SERVER_LOCATION, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_LOCATION_LABEL.get(), QuickSetupMessages.INFO_SERVER_LOCATION_RELATIVE_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        }
        hm.put(FieldName.HOST_NAME, new LabelFieldDescriptor(QuickSetupMessages.INFO_HOST_NAME_LABEL.get(), QuickSetupMessages.INFO_HOST_NAME_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.SERVER_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_PORT_LABEL.get(), QuickSetupMessages.INFO_SERVER_PORT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.ADMIN_CONNECTOR_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_ADMIN_CONNECTOR_PORT_LABEL.get(), QuickSetupMessages.INFO_ADMIN_CONNECTOR_PORT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.SECURITY_OPTIONS, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_SECURITY_LABEL.get(), QuickSetupMessages.INFO_SERVER_SECURITY_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.DIRECTORY_MANAGER_DN, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_DN_LABEL.get(), QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_DN_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.GLOBAL_ADMINISTRATOR_UID, new LabelFieldDescriptor(QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_UID_LABEL.get(), null, LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.DATA_OPTIONS, new LabelFieldDescriptor(QuickSetupMessages.INFO_DIRECTORY_DATA_LABEL.get(), null, LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.REPLICATION_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_REPLICATION_PORT_LABEL.get(), null, LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.SERVER_JAVA_ARGUMENTS, new LabelFieldDescriptor(QuickSetupMessages.INFO_RUNTIME_OPTIONS_LABEL.get(), null, LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        for (FieldName fieldName : hm.keySet()) {
            LabelFieldDescriptor desc = (LabelFieldDescriptor)hm.get((Object)fieldName);
            JTextComponent field = UIFactory.makeJTextComponent(desc, null);
            field.setOpaque(false);
            JLabel label = UIFactory.makeJLabel(desc);
            this.hmFields.put(fieldName, field);
            label.setLabelFor(field);
            this.hmLabels.put(fieldName, label);
        }
    }

    private JLabel getLabel(FieldName fieldName) {
        return this.hmLabels.get((Object)fieldName);
    }

    private JTextComponent getField(FieldName fieldName) {
        return this.hmFields.get((Object)fieldName);
    }

    private void setFieldValue(FieldName fieldName, String value) {
        this.getField(fieldName).setText(value);
    }

    private String getReplicationPortString(UserData userInstallData) {
        MessageBuilder buf = new MessageBuilder();
        DataReplicationOptions repl = userInstallData.getReplicationOptions();
        SuffixesToReplicateOptions suf = userInstallData.getSuffixesToReplicateOptions();
        Map<ServerDescriptor, AuthenticationData> remotePorts = userInstallData.getRemoteWithNoReplicationPort();
        if (repl.getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY && suf.getType() == SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES && remotePorts.size() > 0) {
            AuthenticationData authData = userInstallData.getReplicationOptions().getAuthenticationData();
            String serverToConnectDisplay = authData != null ? authData.getHostName() + ":" + authData.getPort() : "";
            String s = userInstallData.getReplicationOptions().useSecureReplication() ? QuickSetupMessages.INFO_SECURE_REPLICATION_PORT_LABEL.get(String.valueOf(userInstallData.getReplicationOptions().getReplicationPort())).toString() : String.valueOf(userInstallData.getReplicationOptions().getReplicationPort());
            buf.append(s);
            TreeSet<Message> remoteServerLines = new TreeSet<Message>();
            for (ServerDescriptor server : remotePorts.keySet()) {
                String serverDisplay = server.getHostPort(false).equalsIgnoreCase(serverToConnectDisplay) ? serverToConnectDisplay : server.getHostPort(true);
                AuthenticationData repPort = remotePorts.get(server);
                s = repPort.useSecureConnection() ? QuickSetupMessages.INFO_SECURE_REPLICATION_PORT_LABEL.get(String.valueOf(repPort.getPort())).toString() : String.valueOf(repPort.getPort());
                remoteServerLines.add(QuickSetupMessages.INFO_REMOTE_SERVER_REPLICATION_PORT.get(s, serverDisplay));
            }
            for (Message line : remoteServerLines) {
                buf.append("\n").append(line);
            }
        } else {
            buf.append(userInstallData.getReplicationOptions().getReplicationPort());
        }
        return buf.toString();
    }

    private String getRuntimeString(UserData userData) {
        JavaArguments serverArguments = userData.getJavaArguments(UserData.SERVER_SCRIPT_NAME);
        JavaArguments importArguments = userData.getJavaArguments(UserData.IMPORT_SCRIPT_NAME);
        boolean defaultServer = userData.getDefaultJavaArguments(UserData.SERVER_SCRIPT_NAME).equals(serverArguments);
        boolean defaultImport = userData.getDefaultJavaArguments(UserData.IMPORT_SCRIPT_NAME).equals(importArguments);
        String s = defaultServer && defaultImport ? QuickSetupMessages.INFO_DEFAULT_JAVA_ARGUMENTS.get().toString() : (defaultServer ? QuickSetupMessages.INFO_USE_CUSTOM_IMPORT_RUNTIME.get(importArguments.getStringArguments()).toString() : (defaultImport ? QuickSetupMessages.INFO_USE_CUSTOM_SERVER_RUNTIME.get(serverArguments.getStringArguments()).toString() : QuickSetupMessages.INFO_USE_CUSTOM_SERVER_RUNTIME.get(serverArguments.getStringArguments()) + "\n" + QuickSetupMessages.INFO_USE_CUSTOM_IMPORT_RUNTIME.get(importArguments.getStringArguments())));
        return s;
    }

    protected JPanel createFieldsPanel() {
        JPanel fieldsPanel = new JPanel(new GridBagLayout());
        fieldsPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        this.cardLayoutPanel = new JPanel(new CardLayout());
        this.cardLayoutPanel.setOpaque(false);
        JComponent p = this.createReadOnlyPanel();
        p.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane scroll = new JScrollPane(p);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        scroll.getViewport().setBackground(UIFactory.DEFAULT_BACKGROUND);
        scroll.setBackground(UIFactory.DEFAULT_BACKGROUND);
        this.cardLayoutPanel.add((Component)scroll, this.DISPLAY_TEXT.toString());
        scroll = new JScrollPane();
        this.createEquivalentCommandPanel(scroll);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        scroll.getViewport().setBackground(UIFactory.DEFAULT_BACKGROUND);
        scroll.setBackground(UIFactory.DEFAULT_BACKGROUND);
        this.cardLayoutPanel.add((Component)scroll, this.DISPLAY_EQUIVALENT_COMMAND.toString());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        fieldsPanel.add((Component)this.cardLayoutPanel, gbc);
        return fieldsPanel;
    }

    private JComponent createReadOnlyPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        FieldName[] fieldNames = this.displayServerLocation ? new FieldName[]{FieldName.SERVER_LOCATION, FieldName.HOST_NAME, FieldName.SERVER_PORT, FieldName.ADMIN_CONNECTOR_PORT, FieldName.SECURITY_OPTIONS, FieldName.DIRECTORY_MANAGER_DN, FieldName.GLOBAL_ADMINISTRATOR_UID, FieldName.DATA_OPTIONS, FieldName.REPLICATION_PORT, FieldName.SERVER_JAVA_ARGUMENTS} : new FieldName[]{FieldName.HOST_NAME, FieldName.SERVER_PORT, FieldName.ADMIN_CONNECTOR_PORT, FieldName.SECURITY_OPTIONS, FieldName.DIRECTORY_MANAGER_DN, FieldName.GLOBAL_ADMINISTRATOR_UID, FieldName.DATA_OPTIONS, FieldName.REPLICATION_PORT, FieldName.SERVER_JAVA_ARGUMENTS};
        for (int i = 0; i < fieldNames.length; ++i) {
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.insets.top = i > 0 ? 10 : 0;
            gbc.insets.left = 0;
            gbc.anchor = 18;
            panel.add((Component)this.getLabel(fieldNames[i]), gbc);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets.top = i > 0 ? 10 : 0;
            gbc.insets.left = 10;
            gbc.gridwidth = 0;
            panel.add((Component)this.getField(fieldNames[i]), gbc);
        }
        gbc.weighty = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 3;
        panel.add(Box.createVerticalGlue(), gbc);
        return panel;
    }

    private Component createEquivalentCommandPanel(JScrollPane scroll) {
        this.equivalentCommandPane = UIFactory.makeProgressPane(scroll);
        this.equivalentCommandPane.setAutoscrolls(true);
        scroll.setViewportView(this.equivalentCommandPane);
        this.equivalentCommandPane.setOpaque(false);
        return this.equivalentCommandPane;
    }

    protected JComponent getBottomComponent() {
        if (this.bottomComponent == null) {
            this.bottomComponent = new JPanel(new GridBagLayout());
            this.bottomComponent.setOpaque(false);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            JPanel auxPanel = new JPanel(new GridBagLayout());
            auxPanel.setOpaque(false);
            gbc.gridwidth = 3;
            auxPanel.add((Component)this.getStartCheckBox(), gbc);
            gbc.insets.left = 5;
            gbc.gridwidth = -1;
            auxPanel.add((Component)this.getWarningLabel(), gbc);
            gbc.gridwidth = 0;
            gbc.insets.left = 0;
            gbc.weightx = 1.0;
            auxPanel.add(Box.createHorizontalGlue(), gbc);
            this.bottomComponent.add((Component)auxPanel, gbc);
            if (Utils.isWindows()) {
                gbc.insets.top = 10;
                this.bottomComponent.add((Component)this.getEnableWindowsServiceCheckBox(), gbc);
            }
        }
        return this.bottomComponent;
    }

    private JLabel getWarningLabel() {
        if (this.warningLabel == null) {
            this.warningLabel = UIFactory.makeJLabel(UIFactory.IconType.WARNING, QuickSetupMessages.INFO_INSTALL_SERVER_MUST_BE_TEMPORARILY_STARTED.get(), UIFactory.TextStyle.READ_ONLY);
        }
        return this.warningLabel;
    }

    private JCheckBox getStartCheckBox() {
        if (this.startCheckBox == null) {
            this.startCheckBox = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_START_SERVER_LABEL.get(), QuickSetupMessages.INFO_START_SERVER_TOOLTIP.get(), UIFactory.TextStyle.CHECKBOX);
            this.startCheckBox.setSelected(this.getApplication().getUserData().getStartServer());
            this.startCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    InstallReviewPanel.this.checkStartWarningLabel();
                    InstallReviewPanel.this.lastUserData.setStartServer(InstallReviewPanel.this.startCheckBox.isSelected());
                    InstallReviewPanel.this.updateEquivalentCommand(InstallReviewPanel.this.lastUserData);
                }
            });
        }
        return this.startCheckBox;
    }

    private JCheckBox getEnableWindowsServiceCheckBox() {
        if (this.enableWindowsServiceCheckBox == null) {
            this.enableWindowsServiceCheckBox = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_ENABLE_WINDOWS_SERVICE_LABEL.get(), QuickSetupMessages.INFO_ENABLE_WINDOWS_SERVICE_TOOLTIP.get(), UIFactory.TextStyle.CHECKBOX);
            this.enableWindowsServiceCheckBox.setSelected(this.getApplication().getUserData().getEnableWindowsService());
            this.enableWindowsServiceCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if (Utils.isWindows()) {
                        InstallReviewPanel.this.lastUserData.setEnableWindowsService(InstallReviewPanel.this.enableWindowsServiceCheckBox.isSelected());
                        InstallReviewPanel.this.updateEquivalentCommand(InstallReviewPanel.this.lastUserData);
                    }
                }
            });
        }
        return this.enableWindowsServiceCheckBox;
    }

    private void checkStartWarningLabel() {
        boolean visible;
        boolean bl = visible = !this.getStartCheckBox().isSelected();
        if (visible) {
            UserData userData = this.getApplication().getUserData();
            DataReplicationOptions rep = userData.getReplicationOptions();
            visible = rep.getType() != DataReplicationOptions.Type.STANDALONE;
        }
        this.getWarningLabel().setVisible(visible);
    }

    private void updateEquivalentCommand(UserData userData) {
        ArrayList<ArrayList<String>> cmdLines;
        HtmlProgressMessageFormatter formatter = new HtmlProgressMessageFormatter();
        StringBuilder sb = new StringBuilder();
        String s = this.getEquivalentJavaPropertiesProcedure(userData, formatter);
        if (s != null && s.length() > 0) {
            sb.append(s);
            sb.append(formatter.getTaskSeparator());
        }
        sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_INSTALL_SETUP_EQUIVALENT_COMMAND_LINE.get()));
        sb.append(formatter.getLineBreak());
        sb.append("<b>" + Utils.getFormattedEquivalentCommandLine(Utils.getSetupEquivalentCommandLine(userData), formatter) + "</b>");
        if (userData.getReplicationOptions().getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY) {
            sb.append(formatter.getTaskSeparator());
            cmdLines = Utils.getDsReplicationEnableEquivalentCommandLines(userData);
            if (cmdLines.size() == 1) {
                sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_INSTALL_ENABLE_REPLICATION_EQUIVALENT_COMMAND_LINE.get()));
            } else if (cmdLines.size() > 1) {
                sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_INSTALL_ENABLE_REPLICATION_EQUIVALENT_COMMAND_LINES.get()));
            }
            for (ArrayList<String> cmdLine : cmdLines) {
                sb.append(formatter.getLineBreak());
                sb.append("<b>" + Utils.getFormattedEquivalentCommandLine(cmdLine, formatter) + "</b>");
            }
            sb.append(formatter.getLineBreak());
            sb.append(formatter.getLineBreak());
            cmdLines = Utils.getDsReplicationInitializeEquivalentCommandLines(userData);
            if (cmdLines.size() == 1) {
                sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_INSTALL_INITIALIZE_REPLICATION_EQUIVALENT_COMMAND_LINE.get()));
            } else if (cmdLines.size() > 1) {
                sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_INSTALL_INITIALIZE_REPLICATION_EQUIVALENT_COMMAND_LINES.get()));
            }
            for (ArrayList<String> cmdLine : cmdLines) {
                sb.append(formatter.getLineBreak());
                sb.append("<b>" + Utils.getFormattedEquivalentCommandLine(cmdLine, formatter) + "</b>");
            }
        } else if (userData.getReplicationOptions().getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY) {
            sb.append(formatter.getTaskSeparator());
            sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_INSTALL_ENABLE_REPLICATION_EQUIVALENT_COMMAND_LINES.get()));
            cmdLines = Utils.getDsConfigReplicationEnableEquivalentCommandLines(userData);
            for (ArrayList<String> cmdLine : cmdLines) {
                sb.append(formatter.getLineBreak());
                sb.append("<b>" + Utils.getFormattedEquivalentCommandLine(cmdLine, formatter) + "</b>");
            }
        }
        if (userData.getReplicationOptions().getType() != DataReplicationOptions.Type.STANDALONE && !userData.getStartServer()) {
            sb.append(formatter.getTaskSeparator());
            String cmd = Utils.getPath(Installation.getLocal().getServerStopCommandFile());
            sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_INSTALL_STOP_SERVER_EQUIVALENT_COMMAND_LINE.get()));
            sb.append(formatter.getLineBreak());
            sb.append("<b>" + formatter.getFormattedProgress(Message.raw(cmd, new Object[0])) + "</b>");
        }
        this.equivalentCommandPane.setText(sb.toString());
    }

    private String getEquivalentJavaPropertiesProcedure(UserData userData, ProgressMessageFormatter formatter) {
        StringBuilder sb = new StringBuilder();
        JavaArguments serverArguments = userData.getJavaArguments(UserData.SERVER_SCRIPT_NAME);
        JavaArguments importArguments = userData.getJavaArguments(UserData.IMPORT_SCRIPT_NAME);
        ArrayList<String> linesToAdd = new ArrayList<String>();
        boolean defaultServer = userData.getDefaultJavaArguments(UserData.SERVER_SCRIPT_NAME).equals(serverArguments);
        boolean defaultImport = userData.getDefaultJavaArguments(UserData.IMPORT_SCRIPT_NAME).equals(importArguments);
        if (!defaultServer) {
            linesToAdd.add(InstallReviewPanel.getJavaArgPropertyForScript(UserData.SERVER_SCRIPT_NAME) + ": " + serverArguments.getStringArguments());
        }
        if (!defaultImport) {
            linesToAdd.add(InstallReviewPanel.getJavaArgPropertyForScript(UserData.IMPORT_SCRIPT_NAME) + ": " + importArguments.getStringArguments());
        }
        if (linesToAdd.size() == 1) {
            String arg0 = this.getJavaPropertiesFilePath(userData);
            String arg1 = (String)linesToAdd.get(0);
            sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_EDIT_JAVA_PROPERTIES_LINE.get(arg0, arg1)));
        } else if (linesToAdd.size() > 1) {
            String arg0 = this.getJavaPropertiesFilePath(userData);
            String arg1 = Utils.getStringFromCollection(linesToAdd, "\n");
            sb.append(formatter.getFormattedProgress(QuickSetupMessages.INFO_EDIT_JAVA_PROPERTIES_LINES.get(arg0, arg1)));
        }
        return sb.toString();
    }

    private static String getJavaArgPropertyForScript(String scriptName) {
        return scriptName + ".java-args";
    }

    private String getJavaPropertiesFilePath(UserData userData) {
        String path;
        if (this.isWebStart()) {
            path = userData.getServerLocation();
        } else {
            path = Utils.getInstallPathFromClasspath();
            path = Utils.getInstancePathFromInstallPath(path);
        }
        String configDir = Utils.getPath(path, "config");
        String propertiesFile = Utils.getPath(configDir, "java.properties");
        return propertiesFile;
    }
}

