/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.LicenseFile;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.event.ButtonActionListener;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetupPanel;
import org.opends.quicksetup.ui.UIFactory;

public class ButtonsPanel
extends QuickSetupPanel {
    private static final long serialVersionUID = -8460400337486357976L;
    private HashSet<ButtonActionListener> buttonListeners = new HashSet();
    private JButton nextButton;
    private JButton previousButton;
    private JButton quitButton;
    private JButton closeButton;
    private JButton finishButton;

    public ButtonsPanel(GuiApplication application) {
        super(application);
        this.createButtons();
        this.layoutButtons();
    }

    public void addButtonActionListener(ButtonActionListener l) {
        this.buttonListeners.add(l);
    }

    public void removeButtonActionListener(ButtonActionListener l) {
        this.buttonListeners.remove(l);
    }

    public void updateButtons(WizardStep step) {
        GuiApplication application = this.getApplication();
        this.previousButton.setVisible(application.canGoBack(step));
        if (application.canFinish(step)) {
            this.finishButton.setVisible(true);
            this.nextButton.setVisible(false);
        } else {
            this.finishButton.setVisible(false);
            this.nextButton.setVisible(application.canGoForward(step));
        }
        this.quitButton.setVisible(!step.isProgressStep() && !step.isFinishedStep());
        this.closeButton.setVisible(step.isProgressStep() || step.isFinishedStep());
        this.closeButton.setEnabled(application.getCurrentProgressStep().isLast());
        this.nextButton.setEnabled(!step.isLicenseStep() || LicenseFile.getApproval());
    }

    public JButton getButton(ButtonName buttonName) {
        JButton b = null;
        if (buttonName != null) {
            switch (buttonName) {
                case NEXT: {
                    b = this.nextButton;
                    break;
                }
                case PREVIOUS: {
                    b = this.previousButton;
                    break;
                }
                case QUIT: {
                    b = this.quitButton;
                    break;
                }
                case CLOSE: {
                    b = this.closeButton;
                    break;
                }
                case FINISH: {
                    b = this.finishButton;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown button name: " + (Object)((Object)buttonName));
                }
            }
        }
        return b;
    }

    private void createButtons() {
        GuiApplication application = this.getApplication();
        this.nextButton = this.createButton(QuickSetupMessages.INFO_NEXT_BUTTON_LABEL.get(), QuickSetupMessages.INFO_NEXT_BUTTON_TOOLTIP.get(), ButtonName.NEXT);
        this.previousButton = this.createButton(QuickSetupMessages.INFO_PREVIOUS_BUTTON_LABEL.get(), QuickSetupMessages.INFO_PREVIOUS_BUTTON_TOOLTIP.get(), ButtonName.PREVIOUS);
        this.quitButton = this.createButton(QuickSetupMessages.INFO_QUIT_BUTTON_LABEL.get(), application.getQuitButtonToolTip(), ButtonName.QUIT);
        this.closeButton = this.createButton(QuickSetupMessages.INFO_CLOSE_BUTTON_LABEL.get(), application.getCloseButtonToolTip(), ButtonName.CLOSE);
        this.finishButton = this.createButton(application.getFinishButtonLabel(), application.getFinishButtonToolTip(), ButtonName.FINISH);
    }

    private void layoutButtons() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagConstraints gbcAux = new GridBagConstraints();
        gbcAux.gridwidth = 0;
        gbcAux.fill = 2;
        JPanel previousPanel = new JPanel(new GridBagLayout());
        previousPanel.setOpaque(false);
        previousPanel.add((Component)this.previousButton, gbcAux);
        int width = (int)this.previousButton.getPreferredSize().getWidth();
        previousPanel.add(Box.createHorizontalStrut(width), gbcAux);
        gbc.gridwidth = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.bottom = 0;
        gbc.insets.right = 5;
        gbc.anchor = 17;
        gbc.fill = 0;
        this.add((Component)previousPanel, gbc);
        --gbc.gridwidth;
        JPanel nextFinishPanel = new JPanel(new GridBagLayout());
        nextFinishPanel.setOpaque(false);
        nextFinishPanel.add((Component)this.nextButton, gbcAux);
        if (this.getApplication().finishOnLeft()) {
            nextFinishPanel.add((Component)this.finishButton, gbcAux);
        }
        width = (int)Math.max(this.nextButton.getPreferredSize().getWidth(), this.finishButton.getPreferredSize().getWidth());
        nextFinishPanel.add(Box.createHorizontalStrut(width), gbcAux);
        this.add((Component)nextFinishPanel, gbc);
        --gbc.gridwidth;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.right = 0;
        this.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.left = 5;
        if (!this.getApplication().finishOnLeft()) {
            gbc.insets.right = 5;
            this.add((Component)this.finishButton, gbc);
            gbc.insets.right = 0;
        }
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.left = 0;
        JPanel quitClosePanel = new JPanel(new GridBagLayout());
        quitClosePanel.setOpaque(false);
        quitClosePanel.add(Box.createHorizontalStrut(5), gbcAux);
        quitClosePanel.add((Component)this.quitButton, gbcAux);
        quitClosePanel.add((Component)this.closeButton, gbcAux);
        width = (int)Math.max(this.quitButton.getPreferredSize().getWidth(), this.closeButton.getPreferredSize().getWidth());
        quitClosePanel.add(Box.createHorizontalStrut(width), gbcAux);
        this.add((Component)quitClosePanel, gbc);
    }

    private JButton createButton(Message label, Message tooltip, ButtonName buttonName) {
        JButton b = UIFactory.makeJButton(label, tooltip);
        final ButtonName fButtonName = buttonName;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ButtonEvent be = new ButtonEvent(ev.getSource(), fButtonName);
                for (ButtonActionListener li : ButtonsPanel.this.buttonListeners) {
                    li.buttonActionPerformed(be);
                }
            }
        };
        b.addActionListener(actionListener);
        return b;
    }
}

