/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ProgressDescriptor;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.event.ButtonActionListener;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetupPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.HtmlProgressMessageFormatter;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.URLWorker;
import org.opends.quicksetup.util.Utils;

public abstract class QuickSetupStepPanel
extends QuickSetupPanel
implements HyperlinkListener {
    private static final long serialVersionUID = -1983448318085588324L;
    private JPanel inputContainer;
    private Component inputPanel;
    private HashSet<ButtonActionListener> buttonListeners = new HashSet();
    private ProgressMessageFormatter formatter;
    private static final String INPUT_PANEL = "input";
    private static final String CHECKING_PANEL = "checking";
    private boolean isCheckingVisible;
    private HashMap<String, URLWorker> hmURLWorkers = new HashMap();

    public QuickSetupStepPanel(GuiApplication application) {
        super(application);
    }

    public void initialize() {
        this.createLayout();
    }

    public void beginDisplay(UserData data) {
    }

    public void endDisplay() {
    }

    public boolean blockingBeginDisplay() {
        return false;
    }

    public void displayProgress(ProgressDescriptor descriptor) {
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        String url;
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !this.isURLWorkerRunning(url = e.getURL().toString())) {
            URLWorker worker = new URLWorker(this, url);
            this.startWorker(worker);
        }
    }

    public Object getFieldValue(FieldName fieldName) {
        return null;
    }

    public void setFieldValue(FieldName fieldName, Object value) {
    }

    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
    }

    public int getMinimumWidth() {
        int width = 0;
        if (this.inputPanel != null) {
            width = (int)this.inputPanel.getPreferredSize().getWidth();
        }
        return width;
    }

    public int getMinimumHeight() {
        return (int)this.getPreferredSize().getHeight();
    }

    public void addButtonActionListener(ButtonActionListener l) {
        this.buttonListeners.add(l);
    }

    public void removeButtonActionListener(ButtonActionListener l) {
        this.buttonListeners.remove(l);
    }

    public void setCheckingVisible(boolean visible) {
        if (visible != this.isCheckingVisible && this.inputContainer != null) {
            CardLayout cl = (CardLayout)this.inputContainer.getLayout();
            if (visible) {
                cl.show(this.inputContainer, CHECKING_PANEL);
            } else {
                cl.show(this.inputContainer, INPUT_PANEL);
            }
            this.isCheckingVisible = visible;
        }
    }

    public boolean isCheckingVisible() {
        return this.isCheckingVisible;
    }

    protected Message getTextForIcon(UIFactory.IconType iconType) {
        Message text = iconType == UIFactory.IconType.WAIT ? QuickSetupMessages.INFO_GENERAL_CHECKING_DATA.get() : Message.EMPTY;
        return text;
    }

    protected void notifyButtonListeners(ButtonEvent ev) {
        for (ButtonActionListener l : this.buttonListeners) {
            l.buttonActionPerformed(ev);
        }
    }

    protected void createLayout() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        Component titlePanel = this.createTitlePanel();
        Component instructionsPanel = this.createInstructionsPanel();
        this.inputPanel = this.createInputPanel();
        boolean somethingAdded = false;
        if (titlePanel != null) {
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.insets.left = 0;
            this.add(titlePanel, gbc);
            somethingAdded = true;
        }
        if (instructionsPanel != null) {
            gbc.insets.top = somethingAdded ? 10 : 0;
            gbc.insets.left = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 0;
            gbc.fill = 1;
            gbc.anchor = 18;
            this.add(instructionsPanel, gbc);
            somethingAdded = true;
        }
        if (this.inputPanel != null) {
            this.inputContainer = new JPanel(new CardLayout());
            this.inputContainer.setOpaque(false);
            if (this.requiresScroll()) {
                this.inputContainer.add((Component)UIFactory.createBorderLessScrollBar(this.inputPanel), INPUT_PANEL);
            } else {
                this.inputContainer.add(this.inputPanel, INPUT_PANEL);
            }
            JPanel checkingPanel = UIFactory.makeJPanel();
            checkingPanel.setLayout(new GridBagLayout());
            checkingPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.WAIT, QuickSetupMessages.INFO_GENERAL_CHECKING_DATA.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), new GridBagConstraints());
            this.inputContainer.add((Component)checkingPanel, CHECKING_PANEL);
            gbc.insets.top = somethingAdded ? 10 : 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 0;
            gbc.fill = 1;
            gbc.anchor = 18;
            gbc.insets.left = 0;
            this.add((Component)this.inputContainer, gbc);
            somethingAdded = true;
        } else {
            this.addVerticalGlue(this);
        }
    }

    protected abstract Component createInputPanel();

    protected abstract Message getTitle();

    protected abstract Message getInstructions();

    protected void addVerticalGlue(JPanel panel) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel.add(Box.createVerticalGlue(), gbc);
    }

    public void urlWorkerFinished(URLWorker worker) {
        this.hmURLWorkers.remove(worker.getURL());
    }

    protected boolean requiresScroll() {
        return true;
    }

    protected boolean isWebStart() {
        return Utils.isWebStart();
    }

    ProgressMessageFormatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new HtmlProgressMessageFormatter();
        }
        return this.formatter;
    }

    private Component createTitlePanel() {
        JPanel titlePanel = null;
        Message title = this.getTitle();
        if (title != null) {
            JPanel p = new JPanel(new GridBagLayout());
            p.setOpaque(false);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.gridwidth = -1;
            JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, title, UIFactory.TextStyle.TITLE);
            p.add((Component)l, gbc);
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            p.add(Box.createHorizontalGlue(), gbc);
            titlePanel = p;
        }
        return titlePanel;
    }

    protected Component createInstructionsPanel() {
        JEditorPane instructionsPanel = null;
        Message instructions = this.getInstructions();
        if (instructions != null) {
            JEditorPane p = UIFactory.makeHtmlPane(instructions, UIFactory.INSTRUCTIONS_FONT);
            p.setOpaque(false);
            p.setEditable(false);
            p.addHyperlinkListener(this);
            instructionsPanel = p;
        }
        return instructionsPanel;
    }

    private boolean isURLWorkerRunning(String url) {
        return this.hmURLWorkers.get(url) != null;
    }

    private void startWorker(URLWorker worker) {
        this.hmURLWorkers.put(worker.getURL(), worker);
        worker.startBackgroundTask();
    }
}

