/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Configuration;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.installer.InstallerHelper;
import org.opends.quicksetup.util.OperationOutput;
import org.opends.quicksetup.util.StandardOutputSuppressor;
import org.opends.quicksetup.util.Utils;

public class ServerController {
    private static final Logger LOG = Logger.getLogger(ServerController.class.getName());
    private Application application;
    private Installation installation;

    public ServerController(Application application) {
        this(application, application.getInstallation());
    }

    public ServerController(Installation installation) {
        this(null, installation);
    }

    public ServerController(Application application, Installation installation) {
        if (installation == null) {
            throw new NullPointerException("installation cannot be null");
        }
        this.application = application;
        this.installation = installation;
    }

    public void stopServer() throws ApplicationException {
        this.stopServer(false);
    }

    public void stopServer(boolean suppressOutput) throws ApplicationException {
        this.stopServer(suppressOutput, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopServer(boolean suppressOutput, boolean noPropertiesFile) throws ApplicationException {
        if (suppressOutput && !StandardOutputSuppressor.isSuppressed()) {
            StandardOutputSuppressor.suppress();
        }
        if (suppressOutput && this.application != null) {
            this.application.setNotifyListeners(false);
        }
        try {
            if (this.application != null) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(this.application.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_STOPPING.get()));
                mb.append(this.application.getLineBreak());
                this.application.notifyListeners(mb.toMessage());
            }
            LOG.log(Level.INFO, "stopping server");
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(Utils.getScriptPath(Utils.getPath(this.installation.getServerStopCommandFile())));
            int size = argList.size();
            if (noPropertiesFile) {
                ++size;
            }
            String[] args = new String[size];
            argList.toArray(args);
            if (noPropertiesFile) {
                args[argList.size()] = "--noPropertiesFile";
            }
            ProcessBuilder pb = new ProcessBuilder(args);
            Map<String, String> env = pb.environment();
            env.put("OPENDS_JAVA_HOME", System.getProperty("java.home"));
            env.remove("OPENDS_JAVA_ARGS");
            env.remove("CLASSPATH");
            LOG.log(Level.INFO, "Before calling stop-ds.  Is server running? " + this.installation.getStatus().isServerRunning());
            int stopTries = 3;
            while (stopTries > 0) {
                LOG.log(Level.INFO, "Launching stop command, stopTries left: " + --stopTries);
                try {
                    LOG.log(Level.INFO, "Launching stop command, argList: " + argList);
                    Process process = pb.start();
                    BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    new StopReader(err, true);
                    new StopReader(out, false);
                    int returnValue = process.waitFor();
                    int clientSideError = 91;
                    if ((returnValue == clientSideError || returnValue == 0) && Utils.isWindows()) {
                        int nTries = 10;
                        boolean stopped = false;
                        for (int i = 0; i < nTries && !stopped; ++i) {
                            LOG.log(Level.FINE, "waiting for server to stop");
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            stopped = !this.installation.getStatus().isServerRunning();
                            LOG.log(Level.INFO, "After calling stop-ds.  Is server running? " + !stopped);
                            if (stopped) break;
                            if (this.application == null) continue;
                            MessageBuilder mb = new MessageBuilder();
                            mb.append(this.application.getFormattedLog(QuickSetupMessages.INFO_PROGRESS_SERVER_WAITING_TO_STOP.get()));
                            mb.append(this.application.getLineBreak());
                            this.application.notifyListeners(mb.toMessage());
                        }
                        if (!stopped) {
                            returnValue = -1;
                        }
                    }
                    if (returnValue == clientSideError) {
                        if (this.application != null) {
                            MessageBuilder mb = new MessageBuilder();
                            mb.append(this.application.getLineBreak());
                            mb.append(this.application.getFormattedLog(QuickSetupMessages.INFO_PROGRESS_SERVER_ALREADY_STOPPED.get()));
                            mb.append(this.application.getLineBreak());
                            this.application.notifyListeners(mb.toMessage());
                        }
                        LOG.log(Level.INFO, "server already stopped");
                        return;
                    } else {
                        if (returnValue != 0) {
                            if (stopTries > 0) continue;
                            throw new ApplicationException(ReturnCode.STOP_ERROR, QuickSetupMessages.INFO_ERROR_STOPPING_SERVER_CODE.get(String.valueOf(returnValue)), null);
                        }
                        if (this.application != null) {
                            this.application.notifyListeners(this.application.getFormattedLog(QuickSetupMessages.INFO_PROGRESS_SERVER_STOPPED.get()));
                        }
                        LOG.log(Level.INFO, "server stopped");
                    }
                    return;
                }
                catch (Exception e) {
                    throw new ApplicationException(ReturnCode.STOP_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_STOPPING_SERVER.get(), e), e);
                    return;
                }
            }
        }
        finally {
            if (suppressOutput && StandardOutputSuppressor.isSuppressed()) {
                StandardOutputSuppressor.unsuppress();
            }
            if (suppressOutput && this.application != null) {
                this.application.setNotifyListeners(true);
            }
        }
    }

    public OperationOutput startServer() throws ApplicationException {
        return this.startServer(true, false);
    }

    public OperationOutput startServer(boolean suppressOutput) throws ApplicationException {
        return this.startServer(true, suppressOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationOutput startServer(boolean verify, boolean suppressOutput) throws ApplicationException {
        OperationOutput output;
        block45: {
            output = new OperationOutput();
            if (suppressOutput && !StandardOutputSuppressor.isSuppressed()) {
                StandardOutputSuppressor.suppress();
            }
            if (suppressOutput && this.application != null) {
                this.application.setNotifyListeners(false);
            }
            try {
                if (this.application != null) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(this.application.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_STARTING.get()));
                    mb.append(this.application.getLineBreak());
                    this.application.notifyListeners(mb.toMessage());
                }
                LOG.log(Level.INFO, "starting server");
                ArrayList<String> argList = new ArrayList<String>();
                argList.add(Utils.getScriptPath(Utils.getPath(this.installation.getServerStartCommandFile())));
                argList.add("--timeout");
                argList.add("0");
                String[] args = new String[argList.size()];
                argList.toArray(args);
                ProcessBuilder pb = new ProcessBuilder(args);
                pb.directory(this.installation.getBinariesDirectory());
                Map<String, String> env = pb.environment();
                env.put("OPENDS_JAVA_HOME", System.getProperty("java.home"));
                env.remove("OPENDS_JAVA_ARGS");
                env.remove("CLASSPATH");
                try {
                    ApplicationException ex;
                    List<Message> messages;
                    List<Message> errors;
                    String startedId = this.getStartedId();
                    Process process = pb.start();
                    BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    StartReader errReader = new StartReader(err, startedId, true);
                    StartReader outputReader = new StartReader(out, startedId, false);
                    int returnValue = process.waitFor();
                    LOG.log(Level.INFO, "start-ds return value: " + returnValue);
                    if (returnValue != 0) {
                        throw new ApplicationException(ReturnCode.START_ERROR, QuickSetupMessages.INFO_ERROR_STARTING_SERVER_CODE.get(String.valueOf(returnValue)), null);
                    }
                    if (outputReader.isFinished()) {
                        LOG.log(Level.INFO, "Output reader finished.");
                    }
                    if (errReader.isFinished()) {
                        LOG.log(Level.INFO, "Error reader finished.");
                    }
                    if (!outputReader.startedIdFound() && !errReader.startedIdFound()) {
                        LOG.log(Level.WARNING, "Started ID could not be found");
                    }
                    if ((errors = errReader.getMessages()) != null) {
                        for (Message error : errors) {
                            output.addErrorMessage(error);
                        }
                    }
                    if ((messages = outputReader.getMessages()) != null) {
                        for (Message msg : messages) {
                            output.addErrorMessage(msg);
                        }
                    }
                    if ((ex = errReader.getException()) == null) {
                        ex = outputReader.getException();
                    }
                    if (ex != null) {
                        output.setException(ex);
                        throw ex;
                    }
                    if (!verify) break block45;
                    boolean connected = false;
                    Configuration config = this.installation.getCurrentConfiguration();
                    int port = config.getAdminConnectorPort();
                    String userDn = null;
                    String userPw = null;
                    if (this.application != null) {
                        userDn = this.application.getUserData().getDirectoryManagerDn();
                        userPw = this.application.getUserData().getDirectoryManagerPwd();
                    }
                    if (userDn == null || userPw == null) {
                        userDn = null;
                        userPw = null;
                    }
                    InitialContext ctx = null;
                    for (int i = 0; i < 50 && !connected; ++i) {
                        int dig;
                        String hostName = null;
                        if (this.application != null) {
                            hostName = this.application.getUserData().getHostName();
                        }
                        if (hostName == null) {
                            hostName = "localhost";
                        }
                        if (!((dig = i % 10) < 3 && dig > 4 || "localhost".equals(hostName))) {
                            hostName = "localhost";
                        }
                        if (dig >= 5 || dig <= 6) {
                            hostName = "0.0.0.0";
                        }
                        hostName = ConnectionUtils.getHostNameForLdapUrl(hostName);
                        String ldapUrl = "ldaps://" + hostName + ":" + port;
                        try {
                            int timeout = ConnectionUtils.getDefaultLDAPTimeout();
                            if (this.application != null && this.application.getUserData() != null) {
                                timeout = this.application.getUserData().getConnectTimeout();
                            }
                            ctx = Utils.createLdapsContext(ldapUrl, userDn, userPw, timeout, null, null);
                            connected = true;
                        }
                        catch (NamingException ne) {
                            LOG.log(Level.WARNING, "Could not connect to server: " + ne, ne);
                        }
                        finally {
                            if (ctx != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable t) {}
                            }
                        }
                        if (connected) continue;
                        try {
                            Thread.sleep(3000L);
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (!connected) {
                        if (Utils.isWindows()) {
                            throw new ApplicationException(ReturnCode.START_ERROR, QuickSetupMessages.INFO_ERROR_STARTING_SERVER_IN_WINDOWS.get(String.valueOf(port)), null);
                        }
                        throw new ApplicationException(ReturnCode.START_ERROR, QuickSetupMessages.INFO_ERROR_STARTING_SERVER_IN_UNIX.get(String.valueOf(port)), null);
                    }
                }
                catch (IOException ioe) {
                    throw new ApplicationException(ReturnCode.START_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_STARTING_SERVER.get(), ioe), ioe);
                }
                catch (InterruptedException ie) {
                    throw new ApplicationException(ReturnCode.START_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_STARTING_SERVER.get(), ie), ie);
                }
            }
            finally {
                if (suppressOutput && StandardOutputSuppressor.isSuppressed()) {
                    StandardOutputSuppressor.unsuppress();
                }
                if (suppressOutput && this.application != null) {
                    this.application.setNotifyListeners(true);
                }
            }
        }
        return output;
    }

    private String getStartedId() {
        InstallerHelper helper = new InstallerHelper();
        return helper.getStartedId();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartReader {
        private ApplicationException ex;
        private List<Message> messages = new ArrayList<Message>();
        private boolean isFinished;
        private boolean startedIdFound;
        private boolean isFirstLine;

        public StartReader(final BufferedReader reader, final String startedId, final boolean isError) {
            final Message errorTag = isError ? QuickSetupMessages.INFO_ERROR_READING_ERROROUTPUT.get() : QuickSetupMessages.INFO_ERROR_READING_OUTPUT.get();
            this.isFirstLine = true;
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            if (ServerController.this.application != null) {
                                MessageBuilder buf = new MessageBuilder();
                                if (!StartReader.this.isFirstLine) {
                                    buf.append(ServerController.this.application.getProgressMessageFormatter().getLineBreak());
                                }
                                if (isError) {
                                    buf.append(ServerController.this.application.getFormattedLogError(Message.raw(line, new Object[0])));
                                } else {
                                    buf.append(ServerController.this.application.getFormattedLog(Message.raw(line, new Object[0])));
                                }
                                ServerController.this.application.notifyListeners(buf.toMessage());
                                StartReader.this.isFirstLine = false;
                            }
                            LOG.log(Level.INFO, "server: " + line);
                            if (line.toLowerCase().indexOf("=" + startedId) != -1) {
                                StartReader.this.isFinished = true;
                                StartReader.this.startedIdFound = true;
                            }
                            StartReader.this.messages.add(Message.raw(line, new Object[0]));
                            line = reader.readLine();
                        }
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Error reading output: " + t, t);
                        StartReader.this.ex = new ApplicationException(ReturnCode.START_ERROR, Utils.getThrowableMsg(errorTag, t), t);
                    }
                    StartReader.this.isFinished = true;
                }
            });
            t.start();
        }

        public ApplicationException getException() {
            return this.ex;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public boolean isFinished() {
            return this.isFinished;
        }

        public boolean startedIdFound() {
            return this.startedIdFound;
        }
    }

    private class StopReader {
        private boolean isFirstLine;

        public StopReader(final BufferedReader reader, final boolean isError) {
            final Message errorTag = isError ? QuickSetupMessages.INFO_ERROR_READING_ERROROUTPUT.get() : QuickSetupMessages.INFO_ERROR_READING_OUTPUT.get();
            this.isFirstLine = true;
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            if (ServerController.this.application != null) {
                                MessageBuilder buf = new MessageBuilder();
                                if (!StopReader.this.isFirstLine) {
                                    buf.append(ServerController.this.application.getProgressMessageFormatter().getLineBreak());
                                }
                                if (isError) {
                                    buf.append(ServerController.this.application.getFormattedLogError(Message.raw(line, new Object[0])));
                                } else {
                                    buf.append(ServerController.this.application.getFormattedLog(Message.raw(line, new Object[0])));
                                }
                                ServerController.this.application.notifyListeners(buf.toMessage());
                                StopReader.this.isFirstLine = false;
                            }
                            LOG.log(Level.INFO, "server: " + line);
                            line = reader.readLine();
                        }
                    }
                    catch (Throwable t) {
                        if (ServerController.this.application != null) {
                            Message errorMsg = Utils.getThrowableMsg(errorTag, t);
                            ServerController.this.application.notifyListeners(errorMsg);
                        }
                        LOG.log(Level.INFO, "error reading server messages", t);
                    }
                }
            });
            t.start();
        }
    }
}

