/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.browser;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.ImageIcon;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.quicksetup.ui.UIFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconPool {
    public static final int MODIFIER_LEAF = 1;
    public static final int MODIFIER_REFERRAL = 2;
    public static final int MODIFIER_ERROR = 4;
    private HashMap<String, ImageIcon> iconTable = new HashMap();
    private HashMap<String, String> pathTable = new HashMap();
    private HashMap<String, String> descriptionTable = new HashMap();
    private ImageIcon defaultLeafIcon;
    private ImageIcon suffixIcon;
    private ImageIcon defaultContainerIcon;
    private ImageIcon rootNodeIcon;
    private ImageIcon errorIcon;
    private ImageIcon errorMaskIcon;
    private ImageIcon referralMaskIcon;
    public static final String IMAGE_PATH = "org/opends/guitools/controlpanel/images";
    private static final String[] ICON_PATH = new String[]{"person", "ds-user.png", "organization", "ds-folder.png", "organizationalunit", "ds-ou.png", "groupofuniquenames", "ds-group.png", "groupofurls", "ds-group.png", "ds-virtual-static-group", "ds-group.png", "passwordpolicy", "ds-ppol.png"};
    private static final String[] DESCRIPTION = new String[]{"person", AdminToolMessages.INFO_PERSON_ICON_DESCRIPTION.get().toString(), "organization", AdminToolMessages.INFO_ORGANIZATION_ICON_DESCRIPTION.get().toString(), "organizationalunit", AdminToolMessages.INFO_ORGANIZATIONAL_UNIT_ICON_DESCRIPTION.get().toString(), "groupofuniquenames", AdminToolMessages.INFO_STATIC_GROUP_ICON_DESCRIPTION.get().toString(), "groupofurls", AdminToolMessages.INFO_DYNAMIC_GROUP_ICON_DESCRIPTION.get().toString(), "ds-virtual-static-group", AdminToolMessages.INFO_VIRTUAL_STATIC_GROUP_ICON_DESCRIPTION.get().toString(), "passwordpolicy", AdminToolMessages.INFO_PASSWORD_POLICY_ICON_DESCRIPTION.get().toString()};
    private String GENERIC_OBJECT_DESCRIPTION = "Generic entry";

    public IconPool() {
        int i;
        for (i = 0; i < ICON_PATH.length; i += 2) {
            this.pathTable.put(ICON_PATH[i], ICON_PATH[i + 1]);
        }
        for (i = 0; i < DESCRIPTION.length; i += 2) {
            this.descriptionTable.put(DESCRIPTION[i], DESCRIPTION[i + 1]);
        }
    }

    public ImageIcon getIcon(SortedSet<String> objectClasses, int modifiers) {
        String key = this.makeKey(objectClasses, modifiers);
        ImageIcon result = this.iconTable.get(key);
        if (result == null) {
            result = this.makeIcon(objectClasses, modifiers);
            this.iconTable.put(key, result);
        }
        return result;
    }

    private ImageIcon createIcon(String path, String description) {
        ImageIcon icon = Utilities.createImageIcon(path);
        if (description != null) {
            icon.setDescription(description);
            icon.getAccessibleContext().setAccessibleDescription(description);
        }
        return icon;
    }

    public ImageIcon getDefaultLeafIcon() {
        if (this.defaultLeafIcon == null) {
            this.defaultLeafIcon = this.createIcon("org/opends/guitools/controlpanel/images/ds-generic.png", this.GENERIC_OBJECT_DESCRIPTION);
        }
        return this.defaultLeafIcon;
    }

    public ImageIcon getDefaultContainerIcon() {
        if (this.defaultContainerIcon == null) {
            this.defaultContainerIcon = this.createIcon("org/opends/guitools/controlpanel/images/ds-folder.png", "Folder entry");
        }
        return this.defaultContainerIcon;
    }

    public ImageIcon getSuffixIcon() {
        if (this.suffixIcon == null) {
            this.suffixIcon = this.createIcon("org/opends/guitools/controlpanel/images/ds-suffix.png", "Suffix entry");
        }
        return this.suffixIcon;
    }

    public ImageIcon getIconForRootNode() {
        if (this.rootNodeIcon == null) {
            this.rootNodeIcon = this.createIcon("org/opends/guitools/controlpanel/images/ds-directory.png", "Root entry");
        }
        return this.rootNodeIcon;
    }

    public ImageIcon getErrorIcon() {
        if (this.errorIcon == null) {
            this.errorIcon = UIFactory.getImageIcon(UIFactory.IconType.ERROR);
        }
        return this.errorIcon;
    }

    public ImageIcon getErrorMaskIcon() {
        if (this.errorMaskIcon == null) {
            this.errorMaskIcon = UIFactory.getImageIcon(UIFactory.IconType.ERROR);
        }
        return this.errorMaskIcon;
    }

    public ImageIcon getReferralMaskIcon() {
        if (this.referralMaskIcon == null) {
            this.referralMaskIcon = this.createIcon("org/opends/guitools/controlpanel/images/ds-referral.png", "Referral mask");
        }
        return this.referralMaskIcon;
    }

    private ImageIcon makeIcon(Set<String> objectClasses, int modifiers) {
        ImageIcon result;
        if (objectClasses == null || objectClasses.size() == 0) {
            result = this.getDefaultContainerIcon();
        } else {
            String value;
            String iconFile = null;
            Iterator<String> i$ = objectClasses.iterator();
            while (i$.hasNext() && (iconFile = this.pathTable.get((value = i$.next()).toLowerCase())) == null) {
            }
            if (iconFile == null) {
                result = (modifiers & 1) != 0 ? this.getDefaultLeafIcon() : this.getDefaultContainerIcon();
            } else {
                String value2;
                String description = null;
                Iterator<String> i$2 = objectClasses.iterator();
                while (i$2.hasNext() && (description = this.descriptionTable.get((value2 = i$2.next()).toLowerCase())) == null) {
                }
                if (description == null) {
                    description = this.GENERIC_OBJECT_DESCRIPTION;
                }
                result = this.createIcon("org/opends/guitools/controlpanel/images/" + iconFile, description);
            }
        }
        if ((modifiers & 2) != 0) {
            result = this.getReferralMaskIcon();
        }
        if ((modifiers & 4) != 0) {
            result = this.getErrorMaskIcon();
        }
        return result;
    }

    private String makeKey(SortedSet<String> ocValues, int modifiers) {
        StringBuilder result = new StringBuilder();
        if (ocValues != null) {
            result.append(Utilities.getStringFromCollection(ocValues, ""));
        }
        result.append(String.valueOf(modifiers));
        return result.toString();
    }

    public static ImageIcon maskedIcon(ImageIcon icon, ImageIcon mask) {
        int TRANSPARENT = 0xFEFDFD;
        int h = icon.getIconHeight();
        int w = icon.getIconWidth();
        if (mask.getImageLoadStatus() != 8) {
            return null;
        }
        Image maskImage = mask.getImage();
        Image scaledMaskImage = maskImage.getScaledInstance(w, h, 4);
        ImageIcon scaledMask = new ImageIcon(scaledMaskImage);
        if (scaledMask.getImageLoadStatus() != 8) {
            return null;
        }
        int[] iconPixels = new int[w * h];
        try {
            PixelGrabber pg = new PixelGrabber(icon.getImage(), 0, 0, w, h, iconPixels, 0, w);
            pg.grabPixels();
            if ((pg.status() & 0x80) != 0) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int[] filterPixels = new int[w * h];
        try {
            PixelGrabber pgf = new PixelGrabber(scaledMask.getImage(), 0, 0, w, h, filterPixels, 0, w);
            pgf.grabPixels();
            if ((pgf.status() & 0x80) != 0) {
                ImageIcon fReturn = null;
                return fReturn;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ImageIcon fReturn = null;
            return fReturn;
        }
        int[] newPixels = new int[w * h];
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                newPixels[j + i * w] = filterPixels[j + i * w] != TRANSPARENT ? filterPixels[j + i * w] : iconPixels[j + i * w];
            }
        }
        Canvas component = new Canvas();
        Image newImage = component.getToolkit().createImage(new MemoryImageSource(w, h, ColorModel.getRGBdefault(), newPixels, 0, w));
        ImageIcon fReturn = new ImageIcon(newImage, icon.getDescription());
        return fReturn;
    }
}

