/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedListener;
import org.opends.guitools.controlpanel.event.SchemaElementSelectionEvent;
import org.opends.guitools.controlpanel.event.SchemaElementSelectionListener;
import org.opends.guitools.controlpanel.task.DeleteSchemaElementsTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.GenericFrame;
import org.opends.guitools.controlpanel.ui.MatchingRulePanel;
import org.opends.guitools.controlpanel.ui.NewAttributePanel;
import org.opends.guitools.controlpanel.ui.NewObjectClassPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.SchemaBrowserRightPanel;
import org.opends.guitools.controlpanel.ui.StandardAttributePanel;
import org.opends.guitools.controlpanel.ui.StandardObjectClassPanel;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.CustomTree;
import org.opends.guitools.controlpanel.ui.components.FilterTextField;
import org.opends.guitools.controlpanel.ui.components.TreePanel;
import org.opends.guitools.controlpanel.ui.nodes.AttributeSyntaxTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.CategoryTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.ConfigurationAttributeTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.ConfigurationObjectClassTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.CustomAttributeTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.CustomObjectClassTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.MatchingRuleTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.SchemaElementTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.StandardAttributeTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.StandardObjectClassTreeNode;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.guitools.controlpanel.ui.renderer.TreeCellRenderer;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.guitools.controlpanel.util.ViewPositions;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MatchingRule;
import org.opends.server.types.AttributeType;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseSchemaPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -6462914563743569830L;
    private JComboBox filterAttribute;
    private FilterTextField filter;
    private JButton applyButton;
    private JButton newAttribute;
    private JButton newObjectClass;
    private JLabel lNumberOfElements;
    private JLabel lFilter;
    private SchemaBrowserRightPanel entryPane;
    private TreePanel treePane;
    private JScrollPane treeScroll;
    private TreePath lastEntryTreePath;
    private Schema lastSchema;
    private GenericDialog newAttributeDialog;
    private GenericDialog newObjectClassDialog;
    private JMenuItem deleteMenuItem;
    private JPopupMenu popup;
    private CommonSchemaElements lastCreatedElement;
    private final Message NAME = AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_ELEMENT_NAME.get();
    private final Message TYPE = AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_ELEMENT_TYPE.get();
    private final Message PARENT_CLASS = AdminToolMessages.INFO_CTRL_PANEL_PARENT_CLASS.get();
    private final Message CHILD_CLASS = AdminToolMessages.INFO_CTRL_PANEL_CHILD_CLASS.get();
    private final Message REQUIRED_ATTRIBUTES = AdminToolMessages.INFO_CTRL_PANEL_REQUIRED_ATTRIBUTES.get();
    private final Message OPTIONAL_ATTRIBUTES = AdminToolMessages.INFO_CTRL_PANEL_OPTIONAL_ATTRIBUTES.get();
    private CategoryTreeNode attributes = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTES_CATEGORY_NODE.get());
    private CategoryTreeNode objectClasses = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASSES_CATEGORY_NODE.get());
    private CategoryTreeNode standardObjectClasses = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_STANDARD_OBJECTCLASSES_CATEGORY_NODE.get());
    private CategoryTreeNode standardAttributes = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_STANDARD_ATTRIBUTES_CATEGORY_NODE.get());
    private CategoryTreeNode configurationObjectClasses = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_CONFIGURATION_OBJECTCLASSES_CATEGORY_NODE.get());
    private CategoryTreeNode configurationAttributes = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_CONFIGURATION_ATTRIBUTES_CATEGORY_NODE.get());
    private CategoryTreeNode customObjectClasses = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_CUSTOM_OBJECTCLASSES_CATEGORY_NODE.get());
    private CategoryTreeNode customAttributes = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_CUSTOM_ATTRIBUTES_CATEGORY_NODE.get());
    private CategoryTreeNode matchingRules = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULES_CATEGORY_NODE.get());
    private CategoryTreeNode syntaxes = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SYNTAXES_CATEGORY_NODE.get());
    private CategoryTreeNode[] underRootNodes = new CategoryTreeNode[]{this.objectClasses, this.attributes, this.matchingRules, this.syntaxes};
    private CategoryTreeNode[] categoryNodes = new CategoryTreeNode[]{this.standardObjectClasses, this.standardAttributes, this.customObjectClasses, this.customAttributes, this.configurationObjectClasses, this.configurationAttributes, this.matchingRules, this.syntaxes};
    private JLabel lNoMatchFound;
    private boolean ignoreSelectionEvents;
    private Message NO_SCHEMA_ITEM_SELECTED = AdminToolMessages.INFO_CTRL_PANEL_NO_SCHEMA_ITEM_SELECTED.get();
    private Message CATEGORY_ITEM_SELECTED = AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_ITEM_SELECTED.get();
    private Message MULTIPLE_ITEMS_SELECTED = AdminToolMessages.INFO_CTRL_PANEL_MULTIPLE_SCHEMA_ITEMS_SELECTED.get();
    private HashMap<Object, ImageIcon> hmCategoryImages = new HashMap();
    private HashMap<Class<?>, ImageIcon> hmImages = new HashMap();

    public BrowseSchemaPanel() {
        Object[] nodes = new Object[]{this.attributes, this.objectClasses, this.standardObjectClasses, this.standardAttributes, this.configurationObjectClasses, this.configurationAttributes, this.customObjectClasses, this.customAttributes, this.matchingRules, this.syntaxes};
        String[] paths = new String[]{"ds-attr-folder.png", "ds-class-folder.png", "ds-folder.png", "ds-folder.png", "ds-folder.png", "ds-folder.png", "ds-folder.png", "ds-folder.png", "ds-rule-folder.png", "ds-syntax-folder.png"};
        for (int i = 0; i < nodes.length; ++i) {
            this.hmCategoryImages.put(nodes[i], Utilities.createImageIcon("org/opends/guitools/controlpanel/images/" + paths[i]));
        }
        Class[] classes = new Class[]{ConfigurationAttributeTreeNode.class, StandardAttributeTreeNode.class, CustomAttributeTreeNode.class, ConfigurationObjectClassTreeNode.class, StandardObjectClassTreeNode.class, CustomObjectClassTreeNode.class, MatchingRuleTreeNode.class, AttributeSyntaxTreeNode.class};
        String[] ocPaths = new String[]{"ds-attr.png", "ds-attr.png", "ds-attr.png", "ds-class.png", "ds-class.png", "ds-class.png", "ds-rule.png", "ds-syntax.png"};
        for (int i = 0; i < classes.length; ++i) {
            this.hmImages.put(classes[i], Utilities.createImageIcon("org/opends/guitools/controlpanel/images/" + ocPaths[i]));
        }
        this.createLayout();
    }

    @Override
    public boolean requiresBorder() {
        return false;
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    @Override
    public boolean callConfigurationChangedInBackground() {
        return true;
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        Window w = Utilities.getParentDialog(this);
        if (w instanceof GenericDialog) {
            ((GenericDialog)w).getRootPane().setDefaultButton(null);
        } else if (w instanceof GenericFrame) {
            ((GenericFrame)w).getRootPane().setDefaultButton(null);
        }
    }

    private void createLayout() {
        this.setBackground(ColorAndFontConstants.greyBackground);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 7;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 0, 0);
        this.newObjectClass = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASS_BUTTON.get());
        this.newObjectClass.setOpaque(false);
        gbc.weightx = 0.0;
        this.add((Component)this.newObjectClass, gbc);
        this.newObjectClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseSchemaPanel.this.newObjectClassClicked();
            }
        });
        this.newAttribute = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_NEW_ATTRIBUTE_BUTTON.get());
        this.newAttribute.setOpaque(false);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets.left = 10;
        this.add((Component)this.newAttribute, gbc);
        this.newAttribute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseSchemaPanel.this.newAttributeClicked();
            }
        });
        ++gbc.gridx;
        JSeparator sep = new JSeparator(1);
        gbc.fill = 3;
        this.add((Component)sep, gbc);
        this.lFilter = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_FILTER_LABEL.get());
        gbc.fill = 2;
        ++gbc.gridx;
        this.add((Component)this.lFilter, gbc);
        this.filterAttribute = Utilities.createComboBox();
        this.filterAttribute.setModel(new DefaultComboBoxModel<Message>(new Message[]{this.NAME, this.TYPE, this.PARENT_CLASS, this.CHILD_CLASS, this.REQUIRED_ATTRIBUTES, this.OPTIONAL_ATTRIBUTES}));
        this.filterAttribute.setRenderer(new CustomListCellRenderer(this.filterAttribute));
        gbc.insets.left = 5;
        ++gbc.gridx;
        this.add((Component)this.filterAttribute, gbc);
        this.filter = new FilterTextField();
        this.filter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && BrowseSchemaPanel.this.applyButton.isEnabled()) {
                    BrowseSchemaPanel.this.filter.displayRefreshIcon(FilterTextField.DEFAULT_REFRESH_ICON_TIME);
                    BrowseSchemaPanel.this.repopulateTree(BrowseSchemaPanel.this.treePane.getTree(), false);
                }
            }
        });
        this.filter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseSchemaPanel.this.filter.displayRefreshIcon(FilterTextField.DEFAULT_REFRESH_ICON_TIME);
                BrowseSchemaPanel.this.repopulateTree(BrowseSchemaPanel.this.treePane.getTree(), false);
            }
        });
        ++gbc.gridx;
        gbc.weightx = 1.0;
        this.add((Component)this.filter, gbc);
        this.applyButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_APPLY_BUTTON_LABEL.get());
        this.applyButton.setOpaque(false);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets.right = 10;
        this.add((Component)this.applyButton, gbc);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseSchemaPanel.this.filter.displayRefreshIcon(FilterTextField.DEFAULT_REFRESH_ICON_TIME);
                BrowseSchemaPanel.this.repopulateTree(BrowseSchemaPanel.this.treePane.getTree(), false);
            }
        });
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 7;
        this.add(this.createSplitPane(), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createButtonsPanel(), gbc);
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        this.lNumberOfElements = Utilities.createDefaultLabel();
        gbc.insets = new Insets(10, 10, 10, 10);
        buttonsPanel.add((Component)this.lNumberOfElements, gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        buttonsPanel.add(Box.createHorizontalGlue(), gbc);
        buttonsPanel.setOpaque(true);
        buttonsPanel.setBackground(ColorAndFontConstants.greyBackground);
        gbc.insets.left = 5;
        gbc.insets.right = 10;
        ++gbc.gridx;
        gbc.weightx = 0.0;
        JButton closeButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CLOSE_BUTTON_LABEL.get());
        closeButton.setOpaque(false);
        buttonsPanel.add((Component)closeButton, gbc);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseSchemaPanel.this.closeClicked();
            }
        });
        buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorAndFontConstants.defaultBorderColor));
        return buttonsPanel;
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_MANAGE_SCHEMA_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.filter;
    }

    @Override
    public void closeClicked() {
        this.setSecondaryValid(this.lFilter);
        super.closeClicked();
    }

    @Override
    public void okClicked() {
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    private Component createSplitPane() {
        this.treePane = new TreePanel();
        this.lNoMatchFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_MATCHES_FOUND_LABEL.get());
        this.lNoMatchFound.setVisible(false);
        this.entryPane = new SchemaBrowserRightPanel();
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(ColorAndFontConstants.background);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        Utilities.setBorder(this.treePane, new EmptyBorder(10, 0, 10, 0));
        p.add((Component)this.treePane, gbc);
        Utilities.setBorder(this.lNoMatchFound, new EmptyBorder(15, 15, 15, 15));
        gbc.fill = 2;
        p.add((Component)this.lNoMatchFound, gbc);
        this.treeScroll = Utilities.createScrollPane(p);
        this.entryPane.addSchemaElementSelectionListener(new SchemaElementSelectionListener(){

            public void schemaElementSelected(SchemaElementSelectionEvent ev) {
                Object element = ev.getSchemaElement();
                DefaultTreeModel model = (DefaultTreeModel)BrowseSchemaPanel.this.treePane.getTree().getModel();
                Object root = model.getRoot();
                BrowseSchemaPanel.this.selectElementUnder(root, element, model);
            }
        });
        this.entryPane.addConfigurationElementCreatedListener(new ConfigurationElementCreatedListener(){

            public void elementCreated(ConfigurationElementCreatedEvent ev) {
                BrowseSchemaPanel.this.configurationElementCreated(ev);
            }
        });
        this.treePane.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                if (!BrowseSchemaPanel.this.ignoreSelectionEvents) {
                    BrowseSchemaPanel.this.ignoreSelectionEvents = true;
                    TreePath[] paths = BrowseSchemaPanel.this.treePane.getTree().getSelectionPaths();
                    if (BrowseSchemaPanel.this.entryPane.mustCheckUnsavedChanges()) {
                        BrowseSchemaPanel.this.ignoreSelectionEvents = true;
                        BrowseSchemaPanel.this.treePane.getTree().setSelectionPath(BrowseSchemaPanel.this.lastEntryTreePath);
                        switch (BrowseSchemaPanel.this.entryPane.checkUnsavedChanges()) {
                            case DO_NOT_SAVE: {
                                break;
                            }
                            case SAVE: {
                                break;
                            }
                            case CANCEL: {
                                BrowseSchemaPanel.this.ignoreSelectionEvents = false;
                                return;
                            }
                        }
                        if (paths != null) {
                            BrowseSchemaPanel.this.treePane.getTree().setSelectionPaths(paths);
                        } else {
                            BrowseSchemaPanel.this.treePane.getTree().clearSelection();
                        }
                    }
                    boolean deletableElementsSelected = false;
                    boolean nonDeletableElementsSelected = false;
                    if (paths != null) {
                        for (TreePath path : paths) {
                            Object node = path.getLastPathComponent();
                            if (node instanceof CategoryTreeNode) {
                                nonDeletableElementsSelected = true;
                                continue;
                            }
                            if (node instanceof CustomObjectClassTreeNode || node instanceof CustomAttributeTreeNode) {
                                deletableElementsSelected = true;
                                continue;
                            }
                            if (!(node instanceof SchemaElementTreeNode)) continue;
                            nonDeletableElementsSelected = true;
                        }
                    }
                    BrowseSchemaPanel.this.deleteMenuItem.setEnabled(deletableElementsSelected && !nonDeletableElementsSelected);
                    BrowseSchemaPanel.this.updateEntryPane();
                    BrowseSchemaPanel.this.ignoreSelectionEvents = false;
                }
            }
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tree root");
        for (CategoryTreeNode node : this.underRootNodes) {
            root.add(node);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        JTree tree = this.treePane.getTree();
        tree.setModel(model);
        tree.setRootVisible(false);
        tree.setVisibleRowCount(20);
        tree.expandPath(new TreePath(root));
        tree.setCellRenderer(new SchemaTreeCellRenderer());
        this.addPopupMenu();
        this.treeScroll.setPreferredSize(new Dimension(3 * this.treeScroll.getPreferredSize().width / 2, 5 * this.treeScroll.getPreferredSize().height));
        this.entryPane.displayMessage(this.NO_SCHEMA_ITEM_SELECTED);
        this.entryPane.setBorder(this.getRightPanelBorder());
        this.entryPane.setPreferredSize(new Dimension(this.treeScroll.getPreferredSize().width, this.treeScroll.getPreferredSize().height));
        JSplitPane pane = new JSplitPane(1);
        pane.setOpaque(true);
        pane.setLeftComponent(this.treeScroll);
        pane.setRightComponent(this.entryPane);
        pane.setResizeWeight(0.0);
        pane.setDividerLocation(this.treeScroll.getPreferredSize().width);
        return pane;
    }

    @Override
    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        this.treePane.setInfo(info);
        this.entryPane.setInfo(info);
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        final boolean forceScroll = this.lastSchema == null;
        Schema schema = desc.getSchema();
        boolean schemaChanged = schema != null && this.lastSchema != null ? !ServerDescriptor.areSchemasEqual(this.lastSchema, schema) : (schema == null && this.lastSchema != null ? false : this.lastSchema == null && schema != null);
        if (schemaChanged) {
            this.lastSchema = schema;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BrowseSchemaPanel.this.repopulateTree(BrowseSchemaPanel.this.treePane.getTree(), forceScroll);
                    if (BrowseSchemaPanel.this.errorPane.isVisible()) {
                        BrowseSchemaPanel.this.errorPane.setVisible(false);
                    }
                }
            });
        } else if (this.lastSchema == null) {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
            if (!this.errorPane.isVisible()) {
                this.errorPane.setVisible(true);
            }
        }
    }

    private boolean selectElementUnder(Object root, Object element, DefaultTreeModel model) {
        int n = model.getChildCount(root);
        boolean found = false;
        for (int i = 0; i < n && !found; ++i) {
            SchemaElementTreeNode schemaNode;
            Object node = model.getChild(root, i);
            if (node instanceof SchemaElementTreeNode && (schemaNode = (SchemaElementTreeNode)node).getSchemaElement().equals(element)) {
                found = true;
                TreePath newSelectionPath = new TreePath(schemaNode.getPath());
                this.treePane.getTree().setSelectionPath(newSelectionPath);
                this.treePane.getTree().scrollPathToVisible(newSelectionPath);
            }
            if (found) continue;
            found = this.selectElementUnder(node, element, model);
        }
        return found;
    }

    private void repopulateTree(JTree tree, final boolean forceScroll) {
        DefaultMutableTreeNode[] ocAndAttrs;
        if (this.lastSchema == null) {
            return;
        }
        this.ignoreSelectionEvents = true;
        final Point currentPosition = this.treeScroll.getViewport().getViewPosition();
        DefaultMutableTreeNode root = this.getRoot(tree);
        TreePath path = tree.getSelectionPath();
        DefaultMutableTreeNode lastSelectedNode = null;
        if (path != null) {
            lastSelectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        TreePath newSelectionPath = null;
        LowerCaseComparator lowerCaseComparator = new LowerCaseComparator();
        TreeSet<String> standardOcNames = new TreeSet<String>(lowerCaseComparator);
        HashMap<String, StandardObjectClassTreeNode> hmStandardOcs = new HashMap<String, StandardObjectClassTreeNode>();
        TreeSet<String> configurationOcNames = new TreeSet<String>(lowerCaseComparator);
        HashMap<String, ConfigurationObjectClassTreeNode> hmConfigurationOcs = new HashMap<String, ConfigurationObjectClassTreeNode>();
        TreeSet<String> customOcNames = new TreeSet<String>(lowerCaseComparator);
        HashMap<String, CustomObjectClassTreeNode> hmCustomOcs = new HashMap<String, CustomObjectClassTreeNode>();
        for (ObjectClass oc : this.lastSchema.getObjectClasses().values()) {
            if (!this.mustAdd(oc)) continue;
            String name = oc.getPrimaryName();
            if (Utilities.isStandard(oc)) {
                standardOcNames.add(name);
                hmStandardOcs.put(name, new StandardObjectClassTreeNode(name, oc));
                continue;
            }
            if (Utilities.isConfiguration(oc)) {
                configurationOcNames.add(name);
                hmConfigurationOcs.put(name, new ConfigurationObjectClassTreeNode(name, oc));
                continue;
            }
            customOcNames.add(name);
            hmCustomOcs.put(name, new CustomObjectClassTreeNode(name, oc));
        }
        TreeSet<String> standardAttrNames = new TreeSet<String>(lowerCaseComparator);
        HashMap<String, StandardAttributeTreeNode> hmStandardAttrs = new HashMap<String, StandardAttributeTreeNode>();
        TreeSet<String> configurationAttrNames = new TreeSet<String>(lowerCaseComparator);
        HashMap<String, ConfigurationAttributeTreeNode> hmConfigurationAttrs = new HashMap<String, ConfigurationAttributeTreeNode>();
        TreeSet<String> customAttrNames = new TreeSet<String>(lowerCaseComparator);
        HashMap<String, CustomAttributeTreeNode> hmCustomAttrs = new HashMap<String, CustomAttributeTreeNode>();
        for (AttributeType attr : this.lastSchema.getAttributeTypes().values()) {
            if (!this.mustAdd(attr)) continue;
            String name = attr.getPrimaryName();
            if (Utilities.isStandard(attr)) {
                standardAttrNames.add(name);
                hmStandardAttrs.put(name, new StandardAttributeTreeNode(name, attr));
                continue;
            }
            if (Utilities.isConfiguration(attr)) {
                configurationAttrNames.add(name);
                hmConfigurationAttrs.put(name, new ConfigurationAttributeTreeNode(name, attr));
                continue;
            }
            customAttrNames.add(name);
            hmCustomAttrs.put(name, new CustomAttributeTreeNode(name, attr));
        }
        TreeSet<String> matchingRuleNames = new TreeSet<String>(lowerCaseComparator);
        HashMap<String, MatchingRuleTreeNode> hmMatchingRules = new HashMap<String, MatchingRuleTreeNode>();
        for (MatchingRule matchingRule : this.lastSchema.getMatchingRules().values()) {
            if (!this.mustAdd(matchingRule)) continue;
            String name = matchingRule.getNameOrOID();
            matchingRuleNames.add(name);
            hmMatchingRules.put(name, new MatchingRuleTreeNode(name, matchingRule));
        }
        TreeSet<String> syntaxNames = new TreeSet<String>(lowerCaseComparator);
        HashMap<String, AttributeSyntaxTreeNode> hmSyntaxes = new HashMap<String, AttributeSyntaxTreeNode>();
        for (AttributeSyntax syntax : this.lastSchema.getSyntaxes().values()) {
            if (!this.mustAdd(syntax)) continue;
            String name = syntax.getSyntaxName();
            if (name == null) {
                name = syntax.getOID();
            }
            syntaxNames.add(name);
            hmSyntaxes.put(name, new AttributeSyntaxTreeNode(name, syntax));
        }
        ArrayList<TreeSet<String>> names = new ArrayList<TreeSet<String>>();
        names.add(standardOcNames);
        names.add(standardAttrNames);
        names.add(customOcNames);
        names.add(customAttrNames);
        names.add(configurationOcNames);
        names.add(configurationAttrNames);
        names.add(matchingRuleNames);
        names.add(syntaxNames);
        int size = 0;
        for (TreeSet treeSet : names) {
            size += treeSet.size();
        }
        ArrayList<HashMap<String, SchemaElementTreeNode>> nodes = new ArrayList<HashMap<String, SchemaElementTreeNode>>();
        nodes.add(hmStandardOcs);
        nodes.add(hmStandardAttrs);
        nodes.add(hmCustomOcs);
        nodes.add(hmCustomAttrs);
        nodes.add(hmConfigurationOcs);
        nodes.add(hmConfigurationAttrs);
        nodes.add(hmMatchingRules);
        nodes.add(hmSyntaxes);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)tree.getModel();
        String f = this.filter.getText().trim();
        boolean filterProvided = f.length() > 0;
        ArrayList<TreePath> toExpand = new ArrayList<TreePath>();
        int i = 0;
        int positionUnderRoot = 0;
        boolean rootWasEmpty = root.getChildCount() == 0;
        boolean expand = filterProvided;
        if (root.getIndex(this.objectClasses) == -1) {
            defaultTreeModel.insertNodeInto(this.objectClasses, root, positionUnderRoot);
        } else if (!expand) {
            expand = tree.isExpanded(new TreePath(this.objectClasses.getPath()));
        }
        if (expand) {
            toExpand.add(new TreePath(this.objectClasses.getPath()));
        }
        ++positionUnderRoot;
        expand = filterProvided;
        if (root.getIndex(this.attributes) == -1) {
            defaultTreeModel.insertNodeInto(this.attributes, root, positionUnderRoot);
        } else if (!expand) {
            expand = tree.isExpanded(new TreePath(this.attributes.getPath()));
        }
        if (expand) {
            toExpand.add(new TreePath(this.attributes.getPath()));
        }
        ++positionUnderRoot;
        int positionUnderAttributes = 0;
        int positionUnderObjectClass = 0;
        for (CategoryTreeNode parent : this.categoryNodes) {
            if (((HashMap)nodes.get(i)).size() == 0) {
                if (parent.getParent() != null) {
                    parent.removeAllChildren();
                    defaultTreeModel.removeNodeFromParent(parent);
                }
            } else {
                expand = false;
                if (parent == this.standardObjectClasses || parent == this.customObjectClasses || parent == this.configurationObjectClasses) {
                    if (this.objectClasses.getIndex(parent) == -1) {
                        defaultTreeModel.insertNodeInto(parent, this.objectClasses, positionUnderObjectClass);
                    } else {
                        expand = tree.isExpanded(new TreePath(parent.getPath()));
                        parent.removeAllChildren();
                    }
                    ++positionUnderObjectClass;
                } else if (parent == this.standardAttributes || parent == this.customAttributes || parent == this.configurationAttributes) {
                    if (this.attributes.getIndex(parent) == -1) {
                        defaultTreeModel.insertNodeInto(parent, this.attributes, positionUnderAttributes);
                    } else {
                        expand = tree.isExpanded(new TreePath(parent.getPath()));
                        parent.removeAllChildren();
                    }
                    ++positionUnderAttributes;
                } else {
                    if (root.getIndex(parent) == -1) {
                        defaultTreeModel.insertNodeInto(parent, root, positionUnderRoot);
                    } else {
                        expand = tree.isExpanded(new TreePath(parent.getPath()));
                        parent.removeAllChildren();
                    }
                    ++positionUnderRoot;
                }
                for (String name : (TreeSet)names.get(i)) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)((HashMap)nodes.get(i)).get(name);
                    parent.add(node);
                    if (newSelectionPath != null || lastSelectedNode == null && this.lastCreatedElement == null) continue;
                    if (this.lastCreatedElement != null) {
                        if (node instanceof CustomObjectClassTreeNode && this.lastCreatedElement instanceof ObjectClass) {
                            if (!name.equals(this.lastCreatedElement.getNameOrOID())) continue;
                            newSelectionPath = new TreePath(node.getPath());
                            this.lastCreatedElement = null;
                            continue;
                        }
                        if (!(node instanceof CustomAttributeTreeNode) || !(this.lastCreatedElement instanceof AttributeType) || !name.equals(this.lastCreatedElement.getNameOrOID())) continue;
                        newSelectionPath = new TreePath(node.getPath());
                        this.lastCreatedElement = null;
                        continue;
                    }
                    if (!name.equals(lastSelectedNode.getUserObject())) continue;
                    newSelectionPath = new TreePath(node.getPath());
                }
                defaultTreeModel.nodeStructureChanged(parent);
                if (expand || filterProvided) {
                    toExpand.add(new TreePath(parent.getPath()));
                }
            }
            ++i;
        }
        for (DefaultMutableTreeNode node : ocAndAttrs = new DefaultMutableTreeNode[]{this.objectClasses, this.attributes}) {
            if (node.getParent() == null || node.getChildCount() != 0) continue;
            defaultTreeModel.removeNodeFromParent(node);
            defaultTreeModel.nodeStructureChanged(node);
        }
        if (newSelectionPath != null) {
            tree.setSelectionPath(newSelectionPath);
            tree.scrollPathToVisible(newSelectionPath);
        }
        TreePath rootPath = new TreePath(root.getPath());
        if (rootWasEmpty || !tree.isVisible(rootPath)) {
            tree.expandPath(rootPath);
        }
        for (TreePath p : toExpand) {
            tree.expandPath(p);
        }
        this.updateEntryPane();
        this.ignoreSelectionEvents = false;
        int nElements = hmStandardOcs.size() + hmConfigurationOcs.size() + hmCustomOcs.size() + hmStandardAttrs.size() + hmConfigurationAttrs.size() + hmCustomAttrs.size() + hmMatchingRules.size() + hmSyntaxes.size();
        this.lNoMatchFound.setVisible(nElements == 0);
        this.treePane.setVisible(nElements > 0);
        if (nElements > 0) {
            this.lNumberOfElements.setText(AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_ELEMENT_NUMBER.get(nElements).toString());
            this.lNumberOfElements.setVisible(true);
        } else {
            this.lNumberOfElements.setVisible(false);
        }
        if (newSelectionPath == null && f.length() > 0) {
            for (i = 0; i < tree.getRowCount(); ++i) {
                newSelectionPath = tree.getPathForRow(i);
                Object node = newSelectionPath.getLastPathComponent();
                if (node instanceof CategoryTreeNode) continue;
                tree.setSelectionPath(newSelectionPath);
                break;
            }
        }
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (forceScroll) {
                    BrowseSchemaPanel.this.treeScroll.getViewport().setViewPosition(new Point(0, 0));
                } else {
                    BrowseSchemaPanel.this.treeScroll.getViewport().setViewPosition(currentPosition);
                }
            }
        });
    }

    private void updateEntryPane() {
        ViewPositions pos = Utilities.getViewPositions(this.entryPane);
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        TreePath path = null;
        if (paths != null && paths.length == 1) {
            path = paths[0];
        }
        this.lastEntryTreePath = path;
        if (path != null) {
            Object node = path.getLastPathComponent();
            if (node instanceof StandardObjectClassTreeNode) {
                this.entryPane.updateStandardObjectClass(((StandardObjectClassTreeNode)node).getObjectClass(), this.lastSchema);
            } else if (node instanceof ConfigurationObjectClassTreeNode) {
                this.entryPane.updateConfigurationObjectClass(((ConfigurationObjectClassTreeNode)node).getObjectClass(), this.lastSchema);
            } else if (node instanceof CustomObjectClassTreeNode) {
                ObjectClass oc = ((CustomObjectClassTreeNode)node).getObjectClass();
                this.entryPane.updateCustomObjectClass(oc, this.lastSchema);
            } else if (node instanceof StandardAttributeTreeNode) {
                this.entryPane.updateStandardAttribute(((StandardAttributeTreeNode)node).getAttribute(), this.lastSchema);
            } else if (node instanceof ConfigurationAttributeTreeNode) {
                this.entryPane.updateConfigurationAttribute(((ConfigurationAttributeTreeNode)node).getAttribute(), this.lastSchema);
            } else if (node instanceof CustomAttributeTreeNode) {
                AttributeType attr = ((CustomAttributeTreeNode)node).getAttribute();
                this.entryPane.updateCustomAttribute(attr, this.lastSchema);
            } else if (node instanceof MatchingRuleTreeNode) {
                this.entryPane.updateMatchingRule(((MatchingRuleTreeNode)node).getMatchingRule(), this.lastSchema);
            } else if (node instanceof AttributeSyntaxTreeNode) {
                this.entryPane.updateAttributeSyntax(((AttributeSyntaxTreeNode)node).getAttributeSyntax(), this.lastSchema);
            } else {
                this.entryPane.displayMessage(this.NO_SCHEMA_ITEM_SELECTED);
            }
        } else if (paths != null && paths.length > 1) {
            boolean categorySelected = false;
            int nNonCategory = 0;
            for (TreePath p : paths) {
                Object node = p.getLastPathComponent();
                if (node instanceof CategoryTreeNode) {
                    categorySelected = true;
                    continue;
                }
                ++nNonCategory;
            }
            if (nNonCategory == 0) {
                this.entryPane.displayMessage(this.NO_SCHEMA_ITEM_SELECTED);
            } else if (categorySelected) {
                this.entryPane.displayMessage(this.CATEGORY_ITEM_SELECTED);
            } else {
                this.entryPane.displayMessage(this.MULTIPLE_ITEMS_SELECTED);
            }
        } else {
            this.entryPane.displayMessage(this.NO_SCHEMA_ITEM_SELECTED);
        }
        Utilities.updateViewPositions(pos);
    }

    private void addPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASS_MENU.get());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseSchemaPanel.this.newObjectClassClicked();
            }
        });
        this.popup.add(menuItem);
        menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_ATTRIBUTE_MENU.get());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseSchemaPanel.this.newAttributeClicked();
            }
        });
        this.popup.add(menuItem);
        this.popup.add(new JSeparator());
        this.deleteMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DELETE_SCHEMA_ELEMENT_MENU.get());
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseSchemaPanel.this.deleteClicked();
            }
        });
        this.popup.add(this.deleteMenuItem);
        this.deleteMenuItem.setEnabled(false);
        this.popup.setOpaque(true);
        ((CustomTree)this.treePane.getTree()).setPopupMenu(this.popup);
    }

    private void deleteClicked() {
        Schema schema;
        ArrayList<Message> errors = new ArrayList<Message>();
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        ArrayList<ObjectClass> ocsToDelete = new ArrayList<ObjectClass>();
        ArrayList<AttributeType> attrsToDelete = new ArrayList<AttributeType>();
        if (paths != null) {
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (node instanceof CustomObjectClassTreeNode) {
                    ocsToDelete.add(((CustomObjectClassTreeNode)node).getObjectClass());
                    continue;
                }
                if (!(node instanceof CustomAttributeTreeNode)) continue;
                attrsToDelete.add(((CustomAttributeTreeNode)node).getAttribute());
            }
        }
        if ((schema = this.getInfo().getServerDescriptor().getSchema()) == null) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get());
        }
        if (errors.isEmpty()) {
            Message confirmationMessage = this.getConfirmationMessage(ocsToDelete, attrsToDelete, schema);
            LinkedHashSet<AttributeType> orderedAttributes = this.getOrderedAttributesToDelete(attrsToDelete);
            LinkedHashSet<ObjectClass> orderedObjectClasses = this.getOrderedObjectClassesToDelete(ocsToDelete);
            Message title = orderedAttributes.isEmpty() ? AdminToolMessages.INFO_CTRL_PANEL_DELETE_OBJECTCLASSES_TITLE.get() : (orderedObjectClasses.isEmpty() ? AdminToolMessages.INFO_CTRL_PANEL_DELETE_ATTRIBUTES_TITLE.get() : AdminToolMessages.INFO_CTRL_PANEL_DELETE_OBJECTCLASSES_AND_ATTRIBUTES_TITLE.get());
            ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), title, this.getInfo());
            DeleteSchemaElementsTask newTask = new DeleteSchemaElementsTask(this.getInfo(), dlg, orderedObjectClasses, orderedAttributes);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.isEmpty()) {
                ArrayList<String> allNames = new ArrayList<String>();
                if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), confirmationMessage)) {
                    this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_SCHEMA_ELEMENTS_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_SCHEMA_ELEMENTS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_SCHEMA_ELEMENTS_SUCCESSFUL.get(Utilities.getStringFromCollection(allNames, ", ")), AdminToolMessages.ERR_CTRL_PANEL_DELETING_SCHEMA_ELEMENTS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_SCHEMA_ELEMENTS_ERROR_DETAILS.get(), null, dlg);
                    dlg.setVisible(true);
                }
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    private boolean mustAddAttributeName(AttributeType attr, String attrName) {
        ArrayList<String> values = new ArrayList<String>();
        String oid = attr.getOID();
        values.add(oid);
        String name = attr.getPrimaryName();
        if (name != null) {
            values.add(name);
        }
        Iterable<String> names = attr.getNormalizedNames();
        for (String v : names) {
            values.add(v);
        }
        return this.matchFilter(values, attrName, false);
    }

    private boolean mustAddObjectClassName(ObjectClass oc, String ocName) {
        ArrayList<String> values = new ArrayList<String>();
        String oid = oc.getOID();
        values.add(oid);
        String name = oc.getPrimaryName();
        if (name != null) {
            values.add(name);
        }
        Iterable<String> names = oc.getNormalizedNames();
        for (String v : names) {
            values.add(v);
        }
        return this.matchFilter(values, ocName, false);
    }

    private boolean mustAdd(AttributeType attr) {
        boolean mustAdd = true;
        String f = this.filter.getText().trim();
        if (f.length() > 0) {
            Object filterType = this.filterAttribute.getSelectedItem();
            if (this.NAME.equals(filterType)) {
                mustAdd = this.mustAddAttributeName(attr, f);
            } else if (this.TYPE.equals(filterType)) {
                String[] elements = f.split("[ ,]");
                String text = StandardAttributePanel.getTypeValue(attr).toString().toLowerCase();
                for (int i = 0; i < elements.length && mustAdd; ++i) {
                    mustAdd = text.indexOf(elements[i].toLowerCase()) != -1;
                }
            } else {
                mustAdd = false;
            }
        }
        return mustAdd;
    }

    private boolean mustAdd(ObjectClass oc) {
        boolean mustAdd = true;
        String f = this.filter.getText().trim();
        if (f.length() > 0) {
            Object filterType = this.filterAttribute.getSelectedItem();
            if (this.NAME.equals(filterType)) {
                mustAdd = this.mustAddObjectClassName(oc, f);
            } else if (this.TYPE.equals(filterType)) {
                String[] elements = f.split("[ ,]");
                String text = StandardObjectClassPanel.getTypeValue(oc).toString().toLowerCase();
                for (int i = 0; i < elements.length && mustAdd; ++i) {
                    mustAdd = text.indexOf(elements[i].toLowerCase()) != -1;
                }
            } else if (this.REQUIRED_ATTRIBUTES.equals(filterType) || this.OPTIONAL_ATTRIBUTES.equals(filterType)) {
                String[] attrValues = f.split(" ");
                Set<AttributeType> definedAttrs = this.REQUIRED_ATTRIBUTES.equals(filterType) ? oc.getRequiredAttributeChain() : oc.getOptionalAttributeChain();
                for (String attrName : attrValues) {
                    AttributeType attr;
                    mustAdd = false;
                    Iterator<AttributeType> i$ = definedAttrs.iterator();
                    while (i$.hasNext() && !(mustAdd = this.mustAddAttributeName(attr = i$.next(), attrName))) {
                    }
                    if (mustAdd) {
                        continue;
                    }
                    break;
                }
            } else if (this.CHILD_CLASS.equals(filterType)) {
                ObjectClass o;
                mustAdd = false;
                Iterator<ObjectClass> i$ = this.lastSchema.getObjectClasses().values().iterator();
                while (!(!i$.hasNext() || this.isDescendant(oc, o = i$.next()) && (mustAdd = this.mustAddObjectClassName(o, f)))) {
                }
            } else {
                mustAdd = this.PARENT_CLASS.equals(filterType) ? this.mustAddParentObjectClassName(oc, f) : false;
            }
        }
        return mustAdd;
    }

    private boolean mustAddParentObjectClassName(ObjectClass oc, String f) {
        boolean mustAdd = false;
        Set<ObjectClass> parents = oc.getSuperiorClasses();
        for (ObjectClass parent : parents) {
            if (!this.mustAddObjectClassName(parent, f) && !this.mustAddParentObjectClassName(parent, f)) continue;
            mustAdd = true;
            break;
        }
        return mustAdd;
    }

    private boolean isDescendant(ObjectClass ocParent, ObjectClass oChild) {
        Set<ObjectClass> superiors = oChild.getSuperiorClasses();
        if (superiors == null || superiors.isEmpty()) {
            return false;
        }
        for (ObjectClass o : oChild.getSuperiorClasses()) {
            if (ocParent != o && !this.isDescendant(ocParent, o)) continue;
            return true;
        }
        return false;
    }

    private boolean mustAdd(MatchingRule matchingRule) {
        boolean mustAdd = true;
        String f = this.filter.getText().trim();
        if (f.length() > 0) {
            if (this.NAME.equals(this.filterAttribute.getSelectedItem())) {
                ArrayList<String> values = new ArrayList<String>();
                String oid = matchingRule.getOID();
                values.add(oid);
                String name = matchingRule.getName();
                if (name != null) {
                    values.add(name);
                }
                mustAdd = this.matchFilter(values, f, false);
            } else if (this.TYPE.equals(this.filterAttribute.getSelectedItem())) {
                String[] elements = f.split("[ ,]");
                String text = MatchingRulePanel.getTypeValue(matchingRule).toString().toLowerCase();
                for (int i = 0; i < elements.length && mustAdd; ++i) {
                    mustAdd = text.indexOf(elements[i].toLowerCase()) != -1;
                }
            } else {
                mustAdd = false;
            }
        }
        return mustAdd;
    }

    private boolean mustAdd(AttributeSyntax<?> syntax) {
        boolean mustAdd = true;
        String f = this.filter.getText().trim();
        if (f.length() > 0) {
            if (this.NAME.equals(this.filterAttribute.getSelectedItem())) {
                ArrayList<String> values = new ArrayList<String>();
                String oid = syntax.getOID();
                values.add(oid);
                String name = syntax.getSyntaxName();
                if (name != null) {
                    values.add(name);
                }
                mustAdd = this.matchFilter(values, f, false);
            } else {
                mustAdd = false;
            }
        }
        return mustAdd;
    }

    private boolean matchFilter(Collection<String> values, String filter, boolean exact) {
        boolean matchFilter = false;
        for (String value : values) {
            if (exact) {
                matchFilter = value.equalsIgnoreCase(filter);
            } else {
                boolean bl = matchFilter = value.toLowerCase().indexOf(filter.toLowerCase()) != -1;
            }
            if (!matchFilter) continue;
            break;
        }
        return matchFilter;
    }

    private DefaultMutableTreeNode getRoot(JTree tree) {
        return (DefaultMutableTreeNode)tree.getModel().getRoot();
    }

    private void newAttributeClicked() {
        if (this.newAttributeDialog == null) {
            NewAttributePanel panel = new NewAttributePanel(Utilities.getParentDialog(this));
            panel.setInfo(this.getInfo());
            this.newAttributeDialog = new GenericDialog(null, panel);
            Utilities.centerGoldenMean(this.newAttributeDialog, Utilities.getParentDialog(this));
            panel.addConfigurationElementCreatedListener(new ConfigurationElementCreatedListener(){

                public void elementCreated(ConfigurationElementCreatedEvent ev) {
                    BrowseSchemaPanel.this.configurationElementCreated(ev);
                }
            });
        }
        this.newAttributeDialog.setVisible(true);
    }

    private void newObjectClassClicked() {
        if (this.newObjectClassDialog == null) {
            NewObjectClassPanel panel = new NewObjectClassPanel(Utilities.getParentDialog(this));
            panel.setInfo(this.getInfo());
            this.newObjectClassDialog = new GenericDialog(null, panel);
            Utilities.centerGoldenMean(this.newObjectClassDialog, Utilities.getParentDialog(this));
            panel.addConfigurationElementCreatedListener(new ConfigurationElementCreatedListener(){

                public void elementCreated(ConfigurationElementCreatedEvent ev) {
                    BrowseSchemaPanel.this.configurationElementCreated(ev);
                }
            });
        }
        this.newObjectClassDialog.setVisible(true);
    }

    private void configurationElementCreated(ConfigurationElementCreatedEvent ev) {
        Object o = ev.getConfigurationObject();
        if (o instanceof CommonSchemaElements) {
            this.lastCreatedElement = (CommonSchemaElements)o;
        }
    }

    private LinkedHashSet<ObjectClass> getOrderedObjectClassesToDelete(Collection<ObjectClass> ocsToDelete) {
        ArrayList<ObjectClass> lOrderedOcs = new ArrayList<ObjectClass>();
        for (ObjectClass oc : ocsToDelete) {
            int index = -1;
            for (int i = 0; i < lOrderedOcs.size(); ++i) {
                if (!((ObjectClass)lOrderedOcs.get(i)).isDescendantOf(oc)) continue;
                index = i + 1;
            }
            if (index == -1) {
                lOrderedOcs.add(oc);
                continue;
            }
            lOrderedOcs.add(index, oc);
        }
        return new LinkedHashSet<ObjectClass>(lOrderedOcs);
    }

    private LinkedHashSet<AttributeType> getOrderedAttributesToDelete(Collection<AttributeType> attrsToDelete) {
        ArrayList<AttributeType> lOrderedAttributes = new ArrayList<AttributeType>();
        for (AttributeType attr : attrsToDelete) {
            int index = -1;
            for (int i = 0; i < lOrderedAttributes.size(); ++i) {
                AttributeType parent = ((AttributeType)lOrderedAttributes.get(i)).getSuperiorType();
                while (parent != null && index == -1) {
                    if (parent.equals(attr)) {
                        index = i + 1;
                        continue;
                    }
                    parent = parent.getSuperiorType();
                }
            }
            if (index == -1) {
                lOrderedAttributes.add(attr);
                continue;
            }
            lOrderedAttributes.add(index, attr);
        }
        return new LinkedHashSet<AttributeType>(lOrderedAttributes);
    }

    private Message getConfirmationMessage(Collection<ObjectClass> ocsToDelete, Collection<AttributeType> attrsToDelete, Schema schema) {
        TreeSet<String> childNames;
        ArrayList<ObjectClass> childClasses = new ArrayList<ObjectClass>();
        for (ObjectClass objectClass : ocsToDelete) {
            for (ObjectClass o : schema.getObjectClasses().values()) {
                if (!o.getSuperiorClasses().contains(objectClass)) continue;
                childClasses.add(o);
            }
            childClasses.removeAll(ocsToDelete);
        }
        ArrayList<AttributeType> childAttributes = new ArrayList<AttributeType>();
        TreeSet<String> dependentClasses = new TreeSet<String>();
        for (AttributeType attribute : attrsToDelete) {
            for (AttributeType attr : schema.getAttributeTypes().values()) {
                if (!attribute.equals(attr.getSuperiorType())) continue;
                childAttributes.add(attr);
            }
            childAttributes.removeAll(attrsToDelete);
            for (ObjectClass o : schema.getObjectClasses().values()) {
                if (o.getRequiredAttributeChain().contains(attribute)) {
                    dependentClasses.add(o.getNameOrOID());
                    continue;
                }
                if (!o.getOptionalAttributeChain().contains(attribute)) continue;
                dependentClasses.add(o.getNameOrOID());
            }
            for (ObjectClass oc : ocsToDelete) {
                dependentClasses.remove(oc.getNameOrOID());
            }
        }
        MessageBuilder mb = new MessageBuilder();
        if (!childClasses.isEmpty()) {
            childNames = new TreeSet<String>();
            for (ObjectClass oc : childClasses) {
                childNames.add(oc.getNameOrOID());
            }
            if (ocsToDelete.size() == 1) {
                mb.append(AdminToolMessages.INFO_OBJECTCLASS_IS_SUPERIOR.get(ocsToDelete.iterator().next().getNameOrOID(), Utilities.getStringFromCollection(childNames, ", ")));
            } else {
                mb.append(AdminToolMessages.INFO_OBJECTCLASSES_ARE_SUPERIOR.get(Utilities.getStringFromCollection(childNames, ", ")));
            }
            mb.append("<br>");
        }
        if (!childAttributes.isEmpty()) {
            childNames = new TreeSet();
            for (AttributeType attr : childAttributes) {
                childNames.add(attr.getNameOrOID());
            }
            if (attrsToDelete.size() == 1) {
                mb.append(AdminToolMessages.INFO_ATTRIBUTE_IS_SUPERIOR.get(attrsToDelete.iterator().next().getNameOrOID(), Utilities.getStringFromCollection(childNames, ", ")));
            } else {
                mb.append(AdminToolMessages.INFO_ATTRIBUTES_ARE_SUPERIOR.get(Utilities.getStringFromCollection(childNames, ", ")));
            }
            mb.append("<br>");
        }
        if (!dependentClasses.isEmpty()) {
            if (attrsToDelete.size() == 1) {
                mb.append(AdminToolMessages.INFO_ATTRIBUTE_WITH_DEPENDENCIES.get(attrsToDelete.iterator().next().getNameOrOID(), Utilities.getStringFromCollection(dependentClasses, ", ")));
            } else {
                mb.append(AdminToolMessages.INFO_ATTRIBUTES_WITH_DEPENDENCIES.get(Utilities.getStringFromCollection(dependentClasses, ", ")));
            }
            mb.append("<br>");
        }
        ArrayList<String> allNames = new ArrayList<String>();
        for (ObjectClass ocToDelete : ocsToDelete) {
            allNames.add(ocToDelete.getNameOrOID());
        }
        for (AttributeType attrToDelete : attrsToDelete) {
            allNames.add(attrToDelete.getNameOrOID());
        }
        Message confirmationMessage = AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_DELETE_SCHEMA_ELEMENTS_MSG.get(Utilities.getStringFromCollection(allNames, ", "));
        mb.append(confirmationMessage);
        return mb.toMessage();
    }

    protected class SchemaTreeCellRenderer
    extends TreeCellRenderer {
        private static final long serialVersionUID = -3390568254259441766L;

        protected SchemaTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            this.setIcon(this.getIcon(value));
            return this;
        }

        private ImageIcon getIcon(Object value) {
            ImageIcon icon = (ImageIcon)BrowseSchemaPanel.this.hmImages.get(value.getClass());
            if (icon == null) {
                icon = (ImageIcon)BrowseSchemaPanel.this.hmCategoryImages.get(value);
            }
            return icon;
        }
    }
}

