/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.BrowseActionListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ConfirmInitializeAndImportDialog;
import org.opends.guitools.controlpanel.ui.InclusionExclusionPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.ImportLDIF;
import org.opends.server.tools.dsreplication.ReplicationCliException;
import org.opends.server.tools.dsreplication.ReplicationCliMain;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportLDIFPanel
extends InclusionExclusionPanel {
    private static final long serialVersionUID = 1143246529610229229L;
    private JComboBox backends;
    private JTextField file;
    private JCheckBox dataCompressed;
    private JRadioButton overwrite;
    private JRadioButton append;
    private JCheckBox replaceEntries;
    private JCheckBox rejectNotSchemaCompliant;
    private JCheckBox doDNValidationAfter;
    private JCheckBox writeRejects;
    private JCheckBox writeSkips;
    private JTextField threads;
    private JTextField rejectsFile;
    private JTextField skipsFile;
    private JCheckBox overwriteRejectsFile;
    private JCheckBox overwriteSkipsFile;
    private JButton bBrowse;
    private JButton rejectsBrowse;
    private JButton skipsBrowse;
    private JLabel lBackend;
    private JLabel lNoBackendsFound;
    private JLabel lFile;
    private JLabel lImportType;
    private JLabel lSchemaValidation;
    private JLabel lDNValidation;
    private JLabel lThreads;
    private JLabel lRejectsFile;
    private JLabel lSkipsFile;
    private JLabel lRemoteFileHelp;
    private JLabel lRemoteRejectsHelp;
    private JLabel lRemoteSkipsHelp;
    private DocumentListener documentListener;

    public ImportLDIFPanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_IMPORT_LDIF_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.file;
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.documentListener.changedUpdate(null);
        }
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.lBackend = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKEND_LABEL.get());
        this.add((Component)this.lBackend, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.backends = Utilities.createComboBox();
        this.backends.setModel(new DefaultComboBoxModel<String>(new String[0]));
        gbc.gridwidth = 2;
        this.add((Component)this.backends, gbc);
        this.lNoBackendsFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_BACKENDS_FOUND_LABEL.get());
        this.add((Component)this.lNoBackendsFound, gbc);
        this.lNoBackendsFound.setVisible(false);
        gbc.insets.top = 10;
        this.lBackend.setLabelFor(this.backends);
        this.lNoBackendsFound.setLabelFor(this.lBackend);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        this.lFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_FILE_TO_IMPORT_LABEL.get());
        this.add((Component)this.lFile, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        this.file = Utilities.createTextField();
        this.lFile.setLabelFor(this.file);
        this.documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent ev) {
                String text = ImportLDIFPanel.this.file.getText().trim();
                ImportLDIFPanel.this.setEnabledOK(text != null && text.length() > 0 && !ImportLDIFPanel.this.errorPane.isVisible());
            }

            public void removeUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }

            public void insertUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }
        };
        this.file.getDocument().addDocumentListener(this.documentListener);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.file, gbc);
        this.bBrowse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.bBrowse.addActionListener(new BrowseActionListener(this.file, BrowseActionListener.BrowseType.OPEN_LDIF_FILE, this));
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.bBrowse.setOpaque(false);
        this.add((Component)this.bBrowse, gbc);
        this.lRemoteFileHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_REMOTE_SERVER_PATH.get());
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        ++gbc.gridy;
        this.add((Component)this.lRemoteFileHelp, gbc);
        this.lRemoteFileHelp.setLabelFor(this.file);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.insets.left = 30;
        gbc.insets.top = 5;
        gbc.gridwidth = 2;
        this.dataCompressed = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_DATA_IN_FILE_COMPRESSED.get());
        this.dataCompressed.setOpaque(false);
        this.add((Component)this.dataCompressed, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        this.lImportType = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_TYPE_LABEL.get());
        this.add((Component)this.lImportType, gbc);
        this.overwrite = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_OVERWRITE_LABEL.get());
        this.overwrite.setSelected(true);
        this.lImportType.setLabelFor(this.overwrite);
        this.append = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_APPEND_LABEL.get());
        ButtonGroup group = new ButtonGroup();
        group.add(this.overwrite);
        group.add(this.append);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.overwrite, gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        this.add((Component)this.append, gbc);
        this.append.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ImportLDIFPanel.this.replaceEntries.setEnabled(ImportLDIFPanel.this.append.isSelected());
            }
        });
        this.replaceEntries = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_REPLACE_ENTRIES.get());
        this.replaceEntries.setOpaque(false);
        this.replaceEntries.setEnabled(false);
        gbc.insets.left = 30;
        ++gbc.gridy;
        this.add((Component)this.replaceEntries, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        this.lSchemaValidation = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_VALIDATION_LABEL.get());
        this.add((Component)this.lSchemaValidation, gbc);
        gbc.gridx = 1;
        this.rejectNotSchemaCompliant = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_REJECT_NOT_SCHEMA_COMPLIANT_LABEL.get());
        this.rejectNotSchemaCompliant.setSelected(true);
        gbc.insets.left = 10;
        this.add((Component)this.rejectNotSchemaCompliant, gbc);
        this.lSchemaValidation.setLabelFor(this.rejectNotSchemaCompliant);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        this.lDNValidation = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DN_VALIDATION_LABEL.get());
        this.add((Component)this.lDNValidation, gbc);
        gbc.gridx = 1;
        this.doDNValidationAfter = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_DO_DN_VALIDATION_LATER_LABEL.get());
        this.doDNValidationAfter.setSelected(false);
        gbc.insets.left = 10;
        this.add((Component)this.doDNValidationAfter, gbc);
        this.lDNValidation.setLabelFor(this.doDNValidationAfter);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        this.lThreads = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_THREADS_LABEL.get());
        this.add((Component)this.lThreads, gbc);
        gbc.gridx = 1;
        this.threads = Utilities.createShortTextField();
        gbc.gridwidth = 2;
        gbc.fill = 0;
        this.threads.setToolTipText(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_THREADS_TOOLTIP.get().toString());
        gbc.insets.left = 10;
        this.add((Component)this.threads, gbc);
        this.lThreads.setLabelFor(this.threads);
        gbc.insets.top = 3;
        ++gbc.gridy;
        this.add((Component)Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_THREADS_HELP.get()), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        this.lRejectsFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_REJECTS_FILE_LABEL.get());
        this.add((Component)this.lRejectsFile, gbc);
        gbc.gridx = 1;
        this.writeRejects = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_WRITE_REJECTS_FILE_LABEL.get());
        this.writeRejects.setSelected(false);
        gbc.insets.left = 10;
        this.add((Component)this.writeRejects, gbc);
        this.lRejectsFile.setLabelFor(this.writeRejects);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.insets.left = 30;
        gbc.insets.top = 5;
        this.rejectsFile = Utilities.createTextField();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.rejectsFile, gbc);
        this.rejectsBrowse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.rejectsBrowse.addActionListener(new BrowseActionListener(this.rejectsFile, BrowseActionListener.BrowseType.CREATE_GENERIC_FILE, this));
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = 10;
        this.rejectsBrowse.setOpaque(false);
        this.add((Component)this.rejectsBrowse, gbc);
        this.lRemoteRejectsHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_REMOTE_SERVER_PATH.get());
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        ++gbc.gridy;
        this.add((Component)this.lRemoteRejectsHelp, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.insets.left = 30;
        gbc.gridwidth = 2;
        this.overwriteRejectsFile = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_OVERWRITE_REJECTS_FILE_LABEL.get());
        this.overwriteRejectsFile.setOpaque(false);
        this.add((Component)this.overwriteRejectsFile, gbc);
        this.lRemoteRejectsHelp.setLabelFor(this.overwriteRejectsFile);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ImportLDIFPanel.this.rejectsFile.setEnabled(ImportLDIFPanel.this.writeRejects.isSelected());
                ImportLDIFPanel.this.rejectsBrowse.setEnabled(ImportLDIFPanel.this.writeRejects.isSelected());
                ImportLDIFPanel.this.overwriteRejectsFile.setEnabled(ImportLDIFPanel.this.writeRejects.isSelected());
            }
        };
        this.writeRejects.addChangeListener(changeListener);
        this.writeRejects.setSelected(false);
        changeListener.stateChanged(null);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        this.lSkipsFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_SKIPS_FILE_LABEL.get());
        this.add((Component)this.lSkipsFile, gbc);
        gbc.gridx = 1;
        this.writeSkips = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_WRITE_SKIPS_FILE_LABEL.get());
        this.writeSkips.setSelected(false);
        gbc.insets.left = 10;
        this.add((Component)this.writeSkips, gbc);
        this.lSkipsFile.setLabelFor(this.writeSkips);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.insets.left = 30;
        gbc.insets.top = 5;
        this.skipsFile = Utilities.createTextField();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.skipsFile, gbc);
        this.skipsBrowse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.skipsBrowse.addActionListener(new BrowseActionListener(this.skipsFile, BrowseActionListener.BrowseType.CREATE_GENERIC_FILE, this));
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = 10;
        this.skipsBrowse.setOpaque(false);
        this.add((Component)this.skipsBrowse, gbc);
        this.lRemoteSkipsHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_REMOTE_SERVER_PATH.get());
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        ++gbc.gridy;
        this.add((Component)this.lRemoteSkipsHelp, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.insets.left = 30;
        gbc.gridwidth = 2;
        this.overwriteSkipsFile = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_OVERWRITE_SKIPS_FILE_LABEL.get());
        this.overwriteSkipsFile.setOpaque(false);
        this.add((Component)this.overwriteSkipsFile, gbc);
        this.lRemoteSkipsHelp.setLabelFor(this.overwriteSkipsFile);
        changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ImportLDIFPanel.this.skipsFile.setEnabled(ImportLDIFPanel.this.writeSkips.isSelected());
                ImportLDIFPanel.this.skipsBrowse.setEnabled(ImportLDIFPanel.this.writeSkips.isSelected());
                ImportLDIFPanel.this.overwriteSkipsFile.setEnabled(ImportLDIFPanel.this.writeSkips.isSelected());
            }
        };
        this.writeSkips.addChangeListener(changeListener);
        this.writeSkips.setSelected(false);
        changeListener.stateChanged(null);
        changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                if (ev.getSource() == ImportLDIFPanel.this.overwriteSkipsFile) {
                    ImportLDIFPanel.this.overwriteRejectsFile.setSelected(ImportLDIFPanel.this.overwriteSkipsFile.isSelected());
                }
                if (ev.getSource() == ImportLDIFPanel.this.overwriteRejectsFile) {
                    ImportLDIFPanel.this.overwriteSkipsFile.setSelected(ImportLDIFPanel.this.overwriteRejectsFile.isSelected());
                }
            }
        };
        this.overwriteRejectsFile.addChangeListener(changeListener);
        this.overwriteSkipsFile.addChangeListener(changeListener);
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        this.add(this.createDataExclusionOptions(new JLabel[0], new Component[0]), gbc);
        ++gbc.gridy;
        gbc.insets.top = 15;
        this.add(this.createDataInclusionOptions(new JLabel[0], new Component[0]), gbc);
        this.addBottomGlue(gbc);
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        this.updateSimpleBackendComboBoxModel(this.backends, this.lNoBackendsFound, desc);
        this.updateErrorPaneAndOKButtonIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_IMPORT.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportLDIFPanel.this.lRemoteFileHelp.setVisible(!ImportLDIFPanel.this.isLocal());
                ImportLDIFPanel.this.bBrowse.setVisible(ImportLDIFPanel.this.isLocal());
                ImportLDIFPanel.this.rejectsBrowse.setVisible(ImportLDIFPanel.this.isLocal());
                ImportLDIFPanel.this.skipsBrowse.setVisible(ImportLDIFPanel.this.isLocal());
                ImportLDIFPanel.this.lRemoteRejectsHelp.setVisible(!ImportLDIFPanel.this.isLocal());
                ImportLDIFPanel.this.lRemoteSkipsHelp.setVisible(!ImportLDIFPanel.this.isLocal());
            }
        });
    }

    @Override
    protected void checkOKButtonEnable() {
        this.documentListener.changedUpdate(null);
    }

    @Override
    public void okClicked() {
        String skipPath;
        String ldifPath;
        this.setPrimaryValid(this.lBackend);
        this.setPrimaryValid(this.lFile);
        this.setPrimaryValid(this.lRejectsFile);
        this.setPrimaryValid(this.lSkipsFile);
        this.setPrimaryValid(this.lThreads);
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        String backendName = (String)this.backends.getSelectedItem();
        if (backendName == null) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BACKEND_SELECTED.get());
            this.setPrimaryInvalid(this.lBackend);
        }
        if ((ldifPath = this.file.getText()) == null || ldifPath.trim().equals("")) {
            errors.add(QuickSetupMessages.INFO_NO_LDIF_PATH.get());
            this.setPrimaryInvalid(this.lFile);
        } else if (this.isLocal() && !Utils.fileExists(ldifPath)) {
            errors.add(QuickSetupMessages.INFO_LDIF_FILE_DOES_NOT_EXIST.get());
            this.setPrimaryInvalid(this.lFile);
        }
        String sThread = this.threads.getText().trim();
        if (sThread.length() > 0) {
            try {
                int threads = Integer.parseInt(sThread);
                if (threads < 1) {
                    errors.add(AdminToolMessages.ERR_IMPORT_THREAD_NUMBER_INVALID.get());
                    this.setPrimaryInvalid(this.lThreads);
                }
            }
            catch (Throwable t) {
                errors.add(AdminToolMessages.ERR_IMPORT_THREAD_NUMBER_INVALID.get());
                this.setPrimaryInvalid(this.lThreads);
            }
        }
        if (this.writeRejects.isSelected()) {
            String rejectPath = this.rejectsFile.getText();
            if (rejectPath == null || rejectPath.trim().equals("")) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_REJECTS_FILE_REQUIRED.get());
                this.setPrimaryInvalid(this.lRejectsFile);
            } else if (this.writeSkips.isSelected() && new File(rejectPath).equals(new File(this.skipsFile.getText()))) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_REJECTS_AND_SKIPS_MUST_BE_DIFFERENT.get());
                this.setPrimaryInvalid(this.lRejectsFile);
                this.setPrimaryInvalid(this.lSkipsFile);
            }
        }
        if (this.writeSkips.isSelected() && ((skipPath = this.skipsFile.getText()) == null || skipPath.trim().equals(""))) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_SKIPS_FILE_REQUIRED.get());
            this.setPrimaryInvalid(this.lSkipsFile);
        }
        this.updateIncludeExclude(errors, backendName);
        if (errors.isEmpty()) {
            ProgressDialog progressDialog = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
            ImportTask newTask = new ImportTask(this.getInfo(), progressDialog);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            boolean confirmed = true;
            boolean initializeAll = false;
            if (errors.isEmpty()) {
                boolean canInitialize;
                Set<DN> replicatedBaseDNs = this.getReplicatedBaseDNs();
                boolean bl = canInitialize = !replicatedBaseDNs.isEmpty() && this.isServerRunning();
                if (this.overwrite.isSelected() && !canInitialize) {
                    confirmed = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_IMPORT_LDIF_DETAILS.get(backendName));
                } else if (!this.overwrite.isSelected() && canInitialize) {
                    ArrayList<String> dns = new ArrayList<String>();
                    for (DN dn : replicatedBaseDNs) {
                        dns.add(dn.toString());
                    }
                    initializeAll = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_INITIALIZE_ALL_DETAILS.get(Utilities.getStringFromCollection(dns, "<br>")));
                } else if (this.overwrite.isSelected() && canInitialize) {
                    ArrayList<String> dns = new ArrayList<String>();
                    for (DN dn : replicatedBaseDNs) {
                        dns.add(dn.toString());
                    }
                    ConfirmInitializeAndImportDialog dlg = new ConfirmInitializeAndImportDialog((Component)Utilities.getParentDialog(this), this.getInfo());
                    dlg.setMessage(AdminToolMessages.INFO_CTRL_PANEL_CONFIRM_INITIALIZE_TITLE.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_INITIALIZE_ALL_AND_OVERWRITE_DETAILS.get(backendName, Utilities.getStringFromCollection(dns, "<br>")));
                    dlg.setModal(true);
                    dlg.setVisible(true);
                    ConfirmInitializeAndImportDialog.Result result = dlg.getResult();
                    switch (result) {
                        case CANCEL: {
                            confirmed = false;
                            break;
                        }
                        case INITIALIZE_ALL: {
                            confirmed = true;
                            initializeAll = true;
                            break;
                        }
                        case IMPORT_ONLY: {
                            confirmed = true;
                            initializeAll = false;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected result: " + (Object)((Object)result));
                        }
                    }
                }
            }
            if (errors.isEmpty() && confirmed) {
                newTask.setInitializeAll(initializeAll);
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_IMPORTING_LDIF_SUMMARY.get(this.backends.getSelectedItem().toString()), AdminToolMessages.INFO_CTRL_PANEL_IMPORTING_LDIF_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_IMPORTING_LDIF_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_IMPORTING_LDIF_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_IMPORTING_LDIF_ERROR_DETAILS, progressDialog);
                progressDialog.setVisible(true);
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    @Override
    public void cancelClicked() {
        this.setPrimaryValid(this.lBackend);
        this.setPrimaryValid(this.lFile);
        this.setPrimaryValid(this.lImportType);
        this.setPrimaryValid(this.lSchemaValidation);
        this.setPrimaryValid(this.lDNValidation);
        this.setPrimaryValid(this.lThreads);
        this.setPrimaryValid(this.lRejectsFile);
        this.setPrimaryValid(this.lSkipsFile);
        super.cancelClicked();
    }

    private Set<DN> getReplicatedBaseDNs() {
        TreeSet<DN> baseDNs = new TreeSet<DN>();
        String backendID = (String)this.backends.getSelectedItem();
        if (backendID != null) {
            for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                if (!backendID.equalsIgnoreCase(backend.getBackendID())) continue;
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    if (baseDN.getReplicaID() == -1) continue;
                    baseDNs.add(baseDN.getDn());
                }
            }
        }
        return baseDNs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImportTask
    extends InclusionExclusionPanel.InclusionExclusionTask {
        private Set<String> backendSet;
        private String fileName;
        private boolean initializeAll;
        private Set<DN> replicatedBaseDNs;

        public ImportTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(ImportLDIFPanel.this, info, dlg);
            this.backendSet = new HashSet<String>();
            this.backendSet.add((String)ImportLDIFPanel.this.backends.getSelectedItem());
            this.fileName = ImportLDIFPanel.this.file.getText();
            this.replicatedBaseDNs = ImportLDIFPanel.this.getReplicatedBaseDNs();
        }

        private void setInitializeAll(boolean initializeAll) {
            this.initializeAll = initializeAll;
        }

        @Override
        public Task.Type getType() {
            return Task.Type.IMPORT_LDIF;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_IMPORT_TASK_DESCRIPTION.get(this.fileName, this.backendSet.iterator().next());
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        @Override
        protected ArrayList<String> getCommandLineArguments() {
            String sThread;
            ArrayList<String> args = new ArrayList<String>();
            args.add("--ldifFile");
            args.add(this.fileName);
            args.add("--backendID");
            args.add((String)ImportLDIFPanel.this.backends.getSelectedItem());
            if (ImportLDIFPanel.this.dataCompressed.isSelected()) {
                args.add("--isCompressed");
            }
            if (ImportLDIFPanel.this.overwrite.isSelected()) {
                args.add("--clearBackend");
            }
            if (ImportLDIFPanel.this.append.isSelected()) {
                args.add("--append");
                if (ImportLDIFPanel.this.replaceEntries.isSelected()) {
                    args.add("--replaceExisting");
                }
            }
            if (!ImportLDIFPanel.this.rejectNotSchemaCompliant.isSelected()) {
                args.add("--skipSchemaValidation");
            }
            if (ImportLDIFPanel.this.doDNValidationAfter.isSelected()) {
                args.add("--skipDNValidation");
            }
            if ((sThread = ImportLDIFPanel.this.threads.getText().trim()).length() > 0) {
                args.add("--threadCount");
                args.add(sThread);
            }
            if (ImportLDIFPanel.this.writeRejects.isSelected()) {
                args.add("--rejectFile");
                args.add(ImportLDIFPanel.this.rejectsFile.getText());
            }
            if (ImportLDIFPanel.this.writeSkips.isSelected()) {
                args.add("--skipFile");
                args.add(ImportLDIFPanel.this.skipsFile.getText());
            }
            if ((ImportLDIFPanel.this.writeRejects.isSelected() || ImportLDIFPanel.this.writeSkips.isSelected()) && ImportLDIFPanel.this.overwriteRejectsFile.isSelected()) {
                args.add("--overwrite");
            }
            args.addAll(super.getCommandLineArguments());
            if (this.isServerRunning()) {
                args.addAll(this.getConfigCommandLineArguments());
            }
            args.add(this.getNoPropertiesFileArgument());
            return args;
        }

        @Override
        protected String getCommandLinePath() {
            return this.getCommandLinePath("import-ldif");
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                List arguments = this.getCommandLineArguments();
                String[] args = new String[((ArrayList)arguments).size()];
                ((ArrayList)arguments).toArray(args);
                if (this.isServerRunning()) {
                    this.returnCode = ImportLDIF.mainImportLDIF(args, false, this.outPrintStream, this.errorPrintStream);
                    if (this.returnCode == 0 && this.initializeAll) {
                        this.initializeAll();
                    }
                } else {
                    this.returnCode = this.executeCommandLine(this.getCommandLinePath(), args);
                }
                if (this.returnCode != 0) {
                    this.state = Task.State.FINISHED_WITH_ERROR;
                } else {
                    for (String backend : this.getBackends()) {
                        this.getInfo().unregisterModifiedIndexesInBackend(backend);
                    }
                    this.state = Task.State.FINISHED_SUCCESSFULLY;
                }
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
            HashSet<BackendDescriptor> backends = new HashSet<BackendDescriptor>();
            block3: for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                for (String backendID : this.getBackends()) {
                    if (!backendID.equalsIgnoreCase(backend.getBackendID())) continue;
                    backends.add(backend);
                    continue block3;
                }
            }
            if (!backends.isEmpty()) {
                this.getInfo().backendPopulated(backends);
            }
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        private void initializeAll() throws ReplicationCliException {
            ReplicationCliMain repl = new ReplicationCliMain(this.outPrintStream, (PrintStream)this.errorPrintStream, System.in);
            this.getProgressDialog().appendProgressHtml(UIFactory.HTML_SEPARATOR + "<br><br>");
            String cmd = this.getCommandLineToInitializeAll();
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_INITIALIZE_ALL.get().toString() + "<br><b>" + cmd + "</b><br><br>", ColorAndFontConstants.progressFont));
            for (DN baseDN : this.replicatedBaseDNs) {
                Message msg = QuickSetupMessages.INFO_PROGRESS_INITIALIZING_SUFFIX.get(baseDN.toString(), ConnectionUtils.getHostPort(this.getInfo().getDirContext()));
                this.getProgressDialog().appendProgressHtml(Utilities.applyFont(msg.toString() + "<br>", ColorAndFontConstants.progressFont));
                repl.initializeAllSuffix(baseDN.toString(), this.getInfo().getDirContext(), true);
            }
        }

        private String getCommandLineToInitializeAll() {
            String cmdLineName = this.getCommandLinePath("dsreplication");
            ArrayList<String> args = new ArrayList<String>();
            args.add("initialize-all");
            args.add("--hostName");
            args.add(this.getInfo().getServerDescriptor().getHostname());
            args.add("--port");
            args.add(String.valueOf(ConnectionUtils.getPort(this.getInfo().getDirContext())));
            for (DN baseDN : this.replicatedBaseDNs) {
                args.add("--baseDN");
                args.add(baseDN.toString());
            }
            args.add("--adminUID");
            args.add("admin");
            args.add("--adminPassword");
            args.add("********");
            args.add("--trustAll");
            args.add("--no-prompt");
            return Task.getEquivalentCommandLine(cmdLineName, args);
        }
    }
}

