/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ScheduleType;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.NumericLimitedSizeDocumentFilter;
import org.opends.guitools.controlpanel.ui.components.TimeDocumentFilter;
import org.opends.guitools.controlpanel.ui.renderer.NoLeftInsetCategoryComboBoxRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.backends.task.RecurringTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskToSchedulePanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 6855081932432566784L;
    private String taskName;
    private JComboBox scheduleType;
    private JTextField time;
    private JTextField day;
    private JComboBox month;
    private JComboBox year;
    private JLabel lTime;
    private JLabel lDay;
    private JLabel lMonth;
    private JLabel lYear;
    private JLabel lDailyTime;
    private JTextField dailyTime;
    private JLabel lWeeklyTime;
    private JLabel lWeeklyDays;
    private JTextField weeklyTime;
    private JCheckBox sunday = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_SUNDAY.get());
    private JCheckBox monday = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_MONDAY.get());
    private JCheckBox tuesday = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TUESDAY.get());
    private JCheckBox wednesday = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_WEDNESDAY.get());
    private JCheckBox thursday = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_THURSDAY.get());
    private JCheckBox friday = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_FRIDAY.get());
    private JCheckBox saturday = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_SATURDAY.get());
    JCheckBox[] weekDays = new JCheckBox[]{this.sunday, this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday};
    private JLabel lMonthlyTime;
    private JLabel lMonthlyDays;
    private JTextField monthlyTime;
    private JCheckBox[] monthDays = new JCheckBox[31];
    private JLabel lCronMinute;
    private JLabel lCronHour;
    private JLabel lCronWeekDay;
    private JLabel lCronMonthDay;
    private JLabel lCronMonth;
    private JTextField cronMinute;
    private JTextField cronHour;
    private JTextField cronWeekDay;
    private JTextField cronMonthDay;
    private JTextField cronMonth;
    private Component launchLaterPanel;
    private Component dailyPanel;
    private Component weeklyPanel;
    private Component monthlyPanel;
    private Component cronPanel;
    private Message LAUNCH_NOW = AdminToolMessages.INFO_CTRL_PANEL_LAUNCH_NOW.get();
    private Message LAUNCH_LATER = AdminToolMessages.INFO_CTRL_PANEL_LAUNCH_LATER.get();
    private Message LAUNCH_DAILY = AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_DAILY.get();
    private Message LAUNCH_WEEKLY = AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_WEEKLY.get();
    private Message LAUNCH_MONTHLY = AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_MONTHLY.get();
    private Message CRON = AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_CRON.get();
    private ScheduleType schedule;

    public TaskToSchedulePanel(String taskName) {
        this.taskName = taskName;
        this.createLayout();
    }

    private void createLayout() {
        Component[] comps;
        GridBagConstraints gbc = new GridBagConstraints();
        JEditorPane explanation = Utilities.makeHtmlPane(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_SUMMARY.get(this.taskName).toString(), ColorAndFontConstants.defaultFont);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        this.add((Component)explanation, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        this.scheduleType = Utilities.createComboBox();
        this.scheduleType.setModel(new DefaultComboBoxModel());
        ArrayList<Object> newElements = new ArrayList<Object>();
        newElements.add(new CategorizedComboBoxElement(this.LAUNCH_NOW, CategorizedComboBoxElement.Type.REGULAR));
        newElements.add("----------");
        newElements.add(new CategorizedComboBoxElement(this.LAUNCH_LATER, CategorizedComboBoxElement.Type.REGULAR));
        newElements.add("----------");
        newElements.add(new CategorizedComboBoxElement(this.LAUNCH_DAILY, CategorizedComboBoxElement.Type.REGULAR));
        newElements.add(new CategorizedComboBoxElement(this.LAUNCH_WEEKLY, CategorizedComboBoxElement.Type.REGULAR));
        newElements.add(new CategorizedComboBoxElement(this.LAUNCH_MONTHLY, CategorizedComboBoxElement.Type.REGULAR));
        newElements.add(new CategorizedComboBoxElement(this.CRON, CategorizedComboBoxElement.Type.REGULAR));
        this.updateComboBoxModel(newElements, (DefaultComboBoxModel)this.scheduleType.getModel());
        this.scheduleType.setRenderer(new NoLeftInsetCategoryComboBoxRenderer(this.scheduleType));
        this.scheduleType.addItemListener(new StatusGenericPanel.IgnoreItemListener(this.scheduleType));
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.scheduleType, gbc);
        this.launchLaterPanel = this.createLaunchLaterPanel();
        this.dailyPanel = this.createDailyPanel();
        this.weeklyPanel = this.createWeeklyPanel();
        this.monthlyPanel = this.createMonthlyPanel();
        this.cronPanel = this.createCronPanel();
        this.scheduleType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                Object element = TaskToSchedulePanel.this.scheduleType.getSelectedItem();
                boolean launchLaterVisible = false;
                boolean launchDailyVisible = false;
                boolean launchWeeklyVisible = false;
                boolean launchMonthlyVisible = false;
                boolean cronVisible = false;
                if (element != null) {
                    if (element instanceof CategorizedComboBoxElement) {
                        element = ((CategorizedComboBoxElement)element).getValue();
                    }
                    launchLaterVisible = element == TaskToSchedulePanel.this.LAUNCH_LATER;
                    launchDailyVisible = element == TaskToSchedulePanel.this.LAUNCH_DAILY;
                    launchWeeklyVisible = element == TaskToSchedulePanel.this.LAUNCH_WEEKLY;
                    launchMonthlyVisible = element == TaskToSchedulePanel.this.LAUNCH_MONTHLY;
                    cronVisible = element == TaskToSchedulePanel.this.CRON;
                }
                TaskToSchedulePanel.this.launchLaterPanel.setVisible(launchLaterVisible);
                TaskToSchedulePanel.this.dailyPanel.setVisible(launchDailyVisible);
                TaskToSchedulePanel.this.weeklyPanel.setVisible(launchWeeklyVisible);
                TaskToSchedulePanel.this.monthlyPanel.setVisible(launchMonthlyVisible);
                TaskToSchedulePanel.this.cronPanel.setVisible(cronVisible);
            }
        });
        this.launchLaterPanel.setVisible(false);
        this.dailyPanel.setVisible(false);
        this.weeklyPanel.setVisible(false);
        this.monthlyPanel.setVisible(false);
        this.cronPanel.setVisible(false);
        int width = 0;
        int height = 0;
        for (Component comp : comps = new Component[]{this.launchLaterPanel, this.dailyPanel, this.weeklyPanel, this.monthlyPanel, this.cronPanel}) {
            width = Math.max(width, comp.getPreferredSize().width);
            height = Math.max(height, comp.getPreferredSize().height);
        }
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 30;
        this.add(this.launchLaterPanel, gbc);
        this.add(this.dailyPanel, gbc);
        this.add(this.weeklyPanel, gbc);
        this.add(this.monthlyPanel, gbc);
        this.add(this.cronPanel, gbc);
        this.add(Box.createRigidArea(new Dimension(width, height)), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gbc);
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.schedule = null;
            this.setPrimaryValid(this.lTime);
            this.setPrimaryValid(this.lDay);
            this.setPrimaryValid(this.lMonth);
            this.setPrimaryValid(this.lYear);
            this.setPrimaryValid(this.lWeeklyTime);
            this.setPrimaryValid(this.lWeeklyDays);
            this.setPrimaryValid(this.lMonthlyTime);
            this.setPrimaryValid(this.lMonthlyDays);
            this.setPrimaryValid(this.lCronMinute);
            this.setPrimaryValid(this.lCronHour);
            this.setPrimaryValid(this.lCronMonthDay);
            this.setPrimaryValid(this.lCronMonth);
            this.setPrimaryValid(this.lCronWeekDay);
        }
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TITLE.get(this.taskName);
    }

    @Override
    public void okClicked() {
        this.schedule = null;
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        this.updateErrorMessages(errorMessages);
        if (errorMessages.size() > 0) {
            this.displayErrorDialog(errorMessages);
        } else {
            this.schedule = this.createSchedule();
            Utilities.getParentDialog(this).setVisible(false);
        }
    }

    private void updateErrorMessages(Collection<Message> errorMessages) {
        Object type = ((CategorizedComboBoxElement)this.scheduleType.getSelectedItem()).getValue();
        if (type == this.LAUNCH_LATER) {
            this.updateLaunchLaterErrorMessages(errorMessages);
        } else if (type == this.LAUNCH_DAILY) {
            this.updateLaunchDailyErrorMessages(errorMessages);
        } else if (type == this.LAUNCH_WEEKLY) {
            this.updateLaunchWeeklyErrorMessages(errorMessages);
        } else if (type == this.LAUNCH_MONTHLY) {
            this.updateLaunchMonthlyErrorMessages(errorMessages);
        } else if (type == this.CRON) {
            this.updateCronErrorMessages(errorMessages);
        }
    }

    private void updateLaunchLaterErrorMessages(Collection<Message> errorMessages) {
        this.setPrimaryValid(this.lTime);
        this.setPrimaryValid(this.lDay);
        this.setPrimaryValid(this.lMonth);
        this.setPrimaryValid(this.lYear);
        int previousErrorNumber = errorMessages.size();
        int y = Integer.parseInt(this.year.getSelectedItem().toString());
        int d = -1;
        int m = this.month.getSelectedIndex();
        int[] h = new int[]{-1};
        int[] min = new int[]{-1};
        this.checkTime(this.time, this.lTime, h, min, errorMessages);
        try {
            d = Integer.parseInt(this.day.getText().trim());
            if (d < 0 || d > 31) {
                errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_DAY.get());
                this.setPrimaryInvalid(this.lDay);
            }
        }
        catch (Exception ex) {
            errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_DAY.get());
            this.setPrimaryInvalid(this.lDay);
        }
        if (errorMessages.size() == previousErrorNumber) {
            GregorianCalendar calendar = new GregorianCalendar(y, m, d, h[0], min[0]);
            Date date = calendar.getTime();
            if (calendar.get(2) != m) {
                errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_DAY_IN_MONTH.get(d, this.month.getSelectedItem().toString()));
                this.setPrimaryInvalid(this.lDay);
                this.setPrimaryInvalid(this.lMonth);
            } else if (date.before(new Date())) {
                errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_DATE_ALREADY_PASSED.get());
                this.setPrimaryInvalid(this.lTime);
                this.setPrimaryInvalid(this.lDay);
                this.setPrimaryInvalid(this.lMonth);
                this.setPrimaryInvalid(this.lYear);
            }
        }
    }

    private void updateLaunchDailyErrorMessages(Collection<Message> errorMessages) {
        this.setPrimaryValid(this.lDailyTime);
        int[] h = new int[]{-1};
        int[] min = new int[]{-1};
        this.checkTime(this.dailyTime, this.lDailyTime, h, min, errorMessages);
    }

    private void updateLaunchWeeklyErrorMessages(Collection<Message> errorMessages) {
        this.setPrimaryValid(this.lWeeklyTime);
        this.setPrimaryValid(this.lWeeklyDays);
        int[] h = new int[]{-1};
        int[] min = new int[]{-1};
        this.checkTime(this.weeklyTime, this.lWeeklyTime, h, min, errorMessages);
        boolean oneSelected = false;
        for (JCheckBox cb : this.weekDays) {
            if (!cb.isSelected()) continue;
            oneSelected = true;
            break;
        }
        if (!oneSelected) {
            errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_NO_WEEK_DAY_SELECTED.get());
            this.setPrimaryInvalid(this.lWeeklyDays);
        }
    }

    private void updateLaunchMonthlyErrorMessages(Collection<Message> errorMessages) {
        this.setPrimaryValid(this.lMonthlyTime);
        this.setPrimaryValid(this.lMonthlyDays);
        int[] h = new int[]{-1};
        int[] min = new int[]{-1};
        this.checkTime(this.monthlyTime, this.lMonthlyTime, h, min, errorMessages);
        boolean oneSelected = false;
        for (JCheckBox cb : this.monthDays) {
            if (!cb.isSelected()) continue;
            oneSelected = true;
            break;
        }
        if (!oneSelected) {
            errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_NO_MONTH_DAY_SELECTED.get());
            this.setPrimaryInvalid(this.lMonthlyDays);
        }
    }

    private void updateCronErrorMessages(Collection<Message> errorMessages) {
        this.setPrimaryValid(this.lCronMinute);
        this.setPrimaryValid(this.lCronHour);
        this.setPrimaryValid(this.lCronMonthDay);
        this.setPrimaryValid(this.lCronMonth);
        this.setPrimaryValid(this.lCronWeekDay);
        String minute = this.cronMinute.getText().trim();
        String hour = this.cronHour.getText().trim();
        String monthDay = this.cronMonthDay.getText().trim();
        String month = this.cronMonth.getText().trim();
        String weekDay = this.cronWeekDay.getText().trim();
        this.updateCronErrorMessages(minute, this.lCronMinute, AdminToolMessages.ERR_CTRL_PANEL_NO_CRON_MINUTE_PROVIDED.get(), AdminToolMessages.ERR_CTRL_PANEL_NOT_VALID_CRON_MINUTE_PROVIDED.get(), 0, 59, errorMessages);
        this.updateCronErrorMessages(hour, this.lCronHour, AdminToolMessages.ERR_CTRL_PANEL_NO_CRON_HOUR_PROVIDED.get(), AdminToolMessages.ERR_CTRL_PANEL_NOT_VALID_CRON_HOUR_PROVIDED.get(), 0, 23, errorMessages);
        this.updateCronErrorMessages(weekDay, this.lCronWeekDay, AdminToolMessages.ERR_CTRL_PANEL_NO_CRON_WEEK_DAY_PROVIDED.get(), AdminToolMessages.ERR_CTRL_PANEL_NOT_VALID_CRON_WEEK_DAY_PROVIDED.get(), 0, 6, errorMessages);
        this.updateCronErrorMessages(monthDay, this.lCronMonthDay, AdminToolMessages.ERR_CTRL_PANEL_NO_CRON_MONTH_DAY_PROVIDED.get(), AdminToolMessages.ERR_CTRL_PANEL_NOT_VALID_CRON_MONTH_DAY_PROVIDED.get(), 1, 31, errorMessages);
        this.updateCronErrorMessages(month, this.lCronMonth, AdminToolMessages.ERR_CTRL_PANEL_NO_CRON_MONTH_PROVIDED.get(), AdminToolMessages.ERR_CTRL_PANEL_NOT_VALID_CRON_MONTH_PROVIDED.get(), 1, 12, errorMessages);
    }

    private void updateCronErrorMessages(String value, JLabel label, Message errorIfEmpty, Message contentError, int minValue, int maxValue, Collection<Message> errorMessages) {
        if (value.length() == 0) {
            errorMessages.add(errorIfEmpty);
            this.setPrimaryInvalid(label);
        } else {
            try {
                RecurringTask.parseTaskTabField(value, minValue, maxValue);
            }
            catch (Exception ex) {
                errorMessages.add(contentError);
                this.setPrimaryInvalid(label);
            }
        }
    }

    private ScheduleType createSchedule() {
        ScheduleType schedule;
        Object type = ((CategorizedComboBoxElement)this.scheduleType.getSelectedItem()).getValue();
        if (type == this.LAUNCH_NOW) {
            schedule = ScheduleType.createLaunchNow();
        } else if (type == this.LAUNCH_LATER) {
            int y = Integer.parseInt(this.year.getSelectedItem().toString());
            int d = Integer.parseInt(this.day.getText().trim());
            int m = this.month.getSelectedIndex();
            String sTime = this.time.getText().trim();
            int index = sTime.indexOf(58);
            int h = Integer.parseInt(sTime.substring(0, index).trim());
            int min = Integer.parseInt(sTime.substring(index + 1).trim());
            GregorianCalendar calendar = new GregorianCalendar(y, m, d, h, min);
            schedule = ScheduleType.createLaunchLater(calendar.getTime());
        } else if (type == this.LAUNCH_DAILY) {
            String sTime = this.dailyTime.getText().trim();
            int index = sTime.indexOf(58);
            int h = Integer.parseInt(sTime.substring(0, index).trim());
            int m = Integer.parseInt(sTime.substring(index + 1).trim());
            String cron = m + " " + h + " * * *";
            schedule = ScheduleType.createCron(cron);
        } else if (type == this.LAUNCH_WEEKLY) {
            String sTime = this.weeklyTime.getText().trim();
            int index = sTime.indexOf(58);
            int h = Integer.parseInt(sTime.substring(0, index).trim());
            int m = Integer.parseInt(sTime.substring(index + 1).trim());
            StringBuilder sb = new StringBuilder();
            sb.append(m + " " + h + " * * ");
            boolean oneDayAdded = false;
            for (int i = 0; i < this.weekDays.length; ++i) {
                if (!this.weekDays[i].isSelected()) continue;
                if (oneDayAdded) {
                    sb.append(',');
                }
                sb.append(i);
                oneDayAdded = true;
            }
            schedule = ScheduleType.createCron(sb.toString());
        } else if (type == this.LAUNCH_MONTHLY) {
            String sTime = this.monthlyTime.getText().trim();
            int index = sTime.indexOf(58);
            int h = Integer.parseInt(sTime.substring(0, index).trim());
            int m = Integer.parseInt(sTime.substring(index + 1).trim());
            StringBuilder sb = new StringBuilder();
            sb.append(m + " " + h + " ");
            boolean oneDayAdded = false;
            for (int i = 0; i < this.monthDays.length; ++i) {
                if (!this.monthDays[i].isSelected()) continue;
                if (oneDayAdded) {
                    sb.append(',');
                }
                sb.append(i + 1);
                oneDayAdded = true;
            }
            sb.append(" * *");
            schedule = ScheduleType.createCron(sb.toString());
        } else if (type == this.CRON) {
            String cron = this.cronMinute.getText().trim() + " " + this.cronHour.getText().trim() + " " + this.cronMonthDay.getText().trim() + " " + this.cronMonth.getText().trim() + " " + this.cronWeekDay.getText().trim();
            schedule = ScheduleType.createCron(cron);
        } else {
            throw new RuntimeException("Unknown schedule type: " + type);
        }
        return schedule;
    }

    private void checkTime(JTextField time, JLabel lTime, int[] h, int[] m, Collection<Message> errorMessages) {
        String sTime = time.getText().trim();
        int index = sTime.indexOf(58);
        try {
            h[0] = Integer.parseInt(sTime.substring(0, index).trim());
            m[0] = Integer.parseInt(sTime.substring(index + 1).trim());
            if (h[0] < 0 || h[0] > 23) {
                errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_HOUR.get());
                this.setPrimaryInvalid(lTime);
            }
            if (m[0] < 0 || m[0] > 59) {
                errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_MINUTE.get());
                this.setPrimaryInvalid(lTime);
            }
        }
        catch (Exception ex) {
            errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_TIME.get());
            this.setPrimaryInvalid(lTime);
        }
    }

    public boolean isCanceled() {
        return this.schedule == null;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.scheduleType;
    }

    public ScheduleType getSchedule() {
        return this.schedule;
    }

    private Component createLaunchLaterPanel() {
        Message[] monthMessages;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        int currentDay = calendar.get(5);
        int currentMonth = calendar.get(2);
        this.time = Utilities.createShortTextField();
        PlainDocument plainTextDocument = new PlainDocument();
        this.time.setDocument(plainTextDocument);
        String sHour = currentHour >= 10 ? String.valueOf(currentHour) : "0" + currentHour;
        String sMinute = currentMinute >= 10 ? String.valueOf(currentMinute) : "0" + currentMinute;
        this.time.setText(sHour + ":" + sMinute);
        plainTextDocument.setDocumentFilter(new TimeDocumentFilter(this.time));
        this.day = Utilities.createShortTextField();
        this.day.setColumns(4);
        plainTextDocument = new PlainDocument();
        this.day.setDocument(plainTextDocument);
        this.day.setText(String.valueOf(currentDay));
        plainTextDocument.setDocumentFilter(new NumericLimitedSizeDocumentFilter(this.day, 2));
        this.month = Utilities.createComboBox();
        this.year = Utilities.createComboBox();
        int[][] maxMin = new int[][]{{currentYear, currentYear + 5}};
        JComboBox[] numericBoxes = new JComboBox[]{this.year};
        int[] currentValues = new int[]{currentYear};
        for (int i = 0; i < maxMin.length; ++i) {
            int min = maxMin[i][0];
            int max = maxMin[i][1];
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            int selectedIndex = 0;
            int index = 0;
            for (int j = min; j <= max; ++j) {
                String s = j < 10 ? "0" + j : String.valueOf(j);
                model.addElement(s);
                if (j == currentValues[i]) {
                    selectedIndex = index;
                }
                ++index;
            }
            numericBoxes[i].setModel(model);
            if (selectedIndex == 0) continue;
            numericBoxes[i].setSelectedIndex(selectedIndex);
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        this.month.setModel(model);
        for (Message msg : monthMessages = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_JANUARY.get(), AdminToolMessages.INFO_CTRL_PANEL_FEBRUARY.get(), AdminToolMessages.INFO_CTRL_PANEL_MARCH.get(), AdminToolMessages.INFO_CTRL_PANEL_APRIL.get(), AdminToolMessages.INFO_CTRL_PANEL_MAY.get(), AdminToolMessages.INFO_CTRL_PANEL_JUNE.get(), AdminToolMessages.INFO_CTRL_PANEL_JULY.get(), AdminToolMessages.INFO_CTRL_PANEL_AUGUST.get(), AdminToolMessages.INFO_CTRL_PANEL_SEPTEMBER.get(), AdminToolMessages.INFO_CTRL_PANEL_OCTOBER.get(), AdminToolMessages.INFO_CTRL_PANEL_NOVEMBER.get(), AdminToolMessages.INFO_CTRL_PANEL_DECEMBER.get()}) {
            model.addElement(msg.toString());
        }
        this.month.setSelectedIndex(currentMonth);
        this.lTime = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TIME.get());
        this.lDay = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_DAY.get());
        this.lMonth = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_MONTH.get());
        this.lYear = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_YEAR.get());
        gbc.gridy = 0;
        JLabel[] labels = new JLabel[]{this.lTime, this.lDay, this.lMonth, this.lYear};
        JComponent[] comps = new JComponent[]{this.time, this.day, this.month, this.year};
        Message[] inlineHelp = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TIME_TOOLTIP.get(), null, null, null};
        gbc.gridwidth = 1;
        gbc.fill = 2;
        for (int i = 0; i < labels.length; ++i) {
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            panel.add((Component)labels[i], gbc);
            gbc.gridx = 1;
            gbc.insets.left = 10;
            panel.add((Component)comps[i], gbc);
            gbc.gridx = 2;
            gbc.weightx = 1.0;
            gbc.insets.left = 0;
            panel.add(Box.createHorizontalGlue(), gbc);
            if (inlineHelp[i] != null) {
                gbc.gridwidth = 2;
                gbc.insets.top = 3;
                gbc.insets.left = 10;
                gbc.gridx = 1;
                ++gbc.gridy;
                panel.add((Component)Utilities.createInlineHelpLabel(inlineHelp[i]), gbc);
            }
            gbc.insets.top = 10;
            ++gbc.gridy;
        }
        gbc.insets.top = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel.add(Box.createVerticalGlue(), gbc);
        return panel;
    }

    private Component createDailyPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.lDailyTime = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TIME.get());
        this.dailyTime = Utilities.createShortTextField();
        PlainDocument plainTextDocument = new PlainDocument();
        this.dailyTime.setDocument(plainTextDocument);
        this.dailyTime.setColumns(4);
        this.dailyTime.setText("00:00");
        plainTextDocument.setDocumentFilter(new TimeDocumentFilter(this.dailyTime));
        panel.add((Component)this.lDailyTime, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        gbc.fill = 0;
        panel.add((Component)this.dailyTime, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        gbc.fill = 2;
        panel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        panel.add((Component)Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TIME_TOOLTIP.get()), gbc);
        return panel;
    }

    private Component createWeeklyPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.lWeeklyTime = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TIME.get());
        this.weeklyTime = Utilities.createShortTextField();
        PlainDocument plainTextDocument = new PlainDocument();
        this.weeklyTime.setDocument(plainTextDocument);
        this.weeklyTime.setColumns(4);
        this.weeklyTime.setText("00:00");
        plainTextDocument.setDocumentFilter(new TimeDocumentFilter(this.weeklyTime));
        this.lWeeklyDays = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DAYS.get());
        for (JCheckBox cb : this.weekDays) {
            cb.setFont(ColorAndFontConstants.inlineHelpFont);
        }
        this.sunday.setSelected(true);
        this.wednesday.setSelected(true);
        gbc.anchor = 17;
        panel.add((Component)this.lWeeklyTime, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        gbc.gridwidth = this.weekDays.length;
        gbc.fill = 0;
        panel.add((Component)this.weeklyTime, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        panel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = this.weekDays.length + 1;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        panel.add((Component)Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TIME_TOOLTIP.get()), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.weightx = 1.0;
        panel.add((Component)this.lWeeklyDays, gbc);
        gbc.insets.left = 10;
        gbc.gridwidth = 1;
        for (JCheckBox cb : this.weekDays) {
            ++gbc.gridx;
            panel.add((Component)cb, gbc);
        }
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        ++gbc.gridx;
        panel.add(Box.createHorizontalGlue(), gbc);
        return panel;
    }

    private Component createMonthlyPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.lMonthlyTime = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TIME.get());
        this.monthlyTime = Utilities.createShortTextField();
        PlainDocument plainTextDocument = new PlainDocument();
        this.monthlyTime.setDocument(plainTextDocument);
        this.monthlyTime.setColumns(4);
        this.monthlyTime.setText("00:00");
        plainTextDocument.setDocumentFilter(new TimeDocumentFilter(this.monthlyTime));
        this.lMonthlyDays = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DAYS.get());
        gbc.anchor = 17;
        panel.add((Component)this.lMonthlyTime, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        gbc.fill = 0;
        gbc.gridwidth = 7;
        panel.add((Component)this.monthlyTime, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        panel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 8;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        panel.add((Component)Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_TIME_TOOLTIP.get()), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        panel.add((Component)this.lMonthlyDays, gbc);
        gbc.insets.left = 10;
        gbc.gridwidth = 1;
        for (int i = 0; i < this.monthDays.length; ++i) {
            this.monthDays[i] = Utilities.createCheckBox(Message.raw(String.valueOf(i + 1), new Object[0]));
            this.monthDays[i].setFont(ColorAndFontConstants.inlineHelpFont);
            int x = i % 7;
            if (x == 0 && i != 0) {
                ++gbc.gridy;
                gbc.insets.top = 5;
            }
            gbc.insets.left = x != 0 ? 5 : 10;
            gbc.gridx = x + 1;
            panel.add((Component)this.monthDays[i], gbc);
        }
        this.monthDays[0].setSelected(true);
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        ++gbc.gridx;
        panel.add(Box.createHorizontalGlue(), gbc);
        return panel;
    }

    private Component createCronPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        JEditorPane explanation = Utilities.makeHtmlPane(AdminToolMessages.INFO_CTRL_PANEL_CRON_HELP.get().toString(), ColorAndFontConstants.inlineHelpFont);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        panel.add((Component)explanation, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        this.lCronMinute = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_CRON_MINUTE.get());
        this.lCronHour = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_CRON_HOUR.get());
        this.lCronWeekDay = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_CRON_WEEK_DAY.get());
        this.lCronMonthDay = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_CRON_MONTH_DAY.get());
        this.lCronMonth = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_CRON_MONTH.get());
        this.cronMinute = Utilities.createShortTextField();
        this.cronMinute.setText("*");
        this.cronHour = Utilities.createShortTextField();
        this.cronHour.setText("*");
        this.cronWeekDay = Utilities.createShortTextField();
        this.cronWeekDay.setText("*");
        this.cronMonthDay = Utilities.createShortTextField();
        this.cronMonthDay.setText("*");
        this.cronMonth = Utilities.createShortTextField();
        this.cronMonth.setText("*");
        JLabel[] labels = new JLabel[]{this.lCronMinute, this.lCronHour, this.lCronWeekDay, this.lCronMonthDay, this.lCronMonth};
        Component[] comps = new Component[]{this.cronMinute, this.cronHour, this.cronWeekDay, this.cronMonthDay, this.cronMonth};
        Message[] help = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_CRON_MINUTE_HELP.get(), AdminToolMessages.INFO_CTRL_PANEL_CRON_HOUR_HELP.get(), AdminToolMessages.INFO_CTRL_PANEL_CRON_WEEK_DAY_HELP.get(), AdminToolMessages.INFO_CTRL_PANEL_CRON_MONTH_DAY_HELP.get(), AdminToolMessages.INFO_CTRL_PANEL_CRON_MONTH_HELP.get()};
        gbc.gridwidth = 1;
        gbc.fill = 2;
        for (int i = 0; i < labels.length; ++i) {
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.insets.left = 0;
            panel.add((Component)labels[i], gbc);
            gbc.gridx = 1;
            gbc.insets.left = 10;
            panel.add(comps[i], gbc);
            gbc.gridx = 2;
            gbc.weightx = 1.0;
            gbc.insets.left = 0;
            panel.add(Box.createHorizontalGlue(), gbc);
            if (help[i] != null) {
                gbc.insets.top = 3;
                gbc.insets.left = 10;
                ++gbc.gridy;
                gbc.gridx = 1;
                panel.add((Component)Utilities.createInlineHelpLabel(help[i]), gbc);
            }
            gbc.insets.top = 10;
            ++gbc.gridy;
        }
        gbc.insets.top = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel.add(Box.createVerticalGlue(), gbc);
        return panel;
    }

    public static void main(String[] args) {
        while (true) {
            TaskToSchedulePanel p = new TaskToSchedulePanel("TEST TASK");
            GenericDialog dlg = new GenericDialog(Utilities.createFrame(), p);
            dlg.setModal(true);
            dlg.setVisible(true);
        }
    }
}

