/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.nodes;

import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.opends.guitools.controlpanel.browser.BasicNodeError;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.RDN;

public class BasicNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 5441658731908509872L;
    private String localDn;
    private String localRdn;
    private String localRdnWithAttributeName;
    private LDAPURL remoteUrl;
    private String remoteRdn;
    private String remoteRdnWithAttributeName;
    private boolean isLeaf;
    private boolean refreshNeededOnExpansion = true;
    private boolean obsolete;
    private BasicNodeError error;
    private String[] referral;
    private int numSubOrdinates;
    private boolean hasSubOrdinates;
    private String displayName;
    private Icon icon;
    private int fontStyle;
    private boolean sizeLimitReached = false;
    private String[] objectClassValues;

    public BasicNode(String dn) {
        this.localDn = dn;
        this.localRdn = BasicNode.extractRDN(this.localDn);
        this.localRdnWithAttributeName = BasicNode.extractRDN(this.localDn, true);
        this.isLeaf = true;
        this.refreshNeededOnExpansion = true;
        this.numSubOrdinates = -1;
        this.hasSubOrdinates = false;
        this.displayName = "";
    }

    public String getDN() {
        return this.localDn;
    }

    public String getRDN() {
        return this.localRdn;
    }

    public String getRDNWithAttributeName() {
        return this.localRdnWithAttributeName;
    }

    public LDAPURL getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(LDAPURL url) {
        this.remoteUrl = url;
        if (this.remoteUrl != null) {
            this.remoteRdn = BasicNode.extractRDN(this.remoteUrl.getRawBaseDN());
            this.remoteRdnWithAttributeName = BasicNode.extractRDN(this.remoteUrl.getRawBaseDN(), true);
        } else {
            this.remoteRdn = null;
            this.remoteRdnWithAttributeName = null;
        }
    }

    public void setRemoteUrl(String url) {
        try {
            this.remoteUrl = url == null ? null : LDAPURL.decode(url, false);
            if (this.remoteUrl == null) {
                this.remoteRdn = null;
                this.remoteRdnWithAttributeName = null;
            } else {
                this.remoteRdn = BasicNode.extractRDN(this.remoteUrl.getRawBaseDN());
                this.remoteRdnWithAttributeName = BasicNode.extractRDN(this.remoteUrl.getRawBaseDN(), true);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("The provided url: " + url + " is not valid:" + t, t);
        }
    }

    public String getRemoteRDN() {
        return this.remoteRdn;
    }

    public String getRemoteRDNWithAttributeName() {
        return this.remoteRdnWithAttributeName;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isRefreshNeededOnExpansion() {
        return this.refreshNeededOnExpansion;
    }

    public void setRefreshNeededOnExpansion(boolean refreshNeededOnExpansion) {
        this.refreshNeededOnExpansion = refreshNeededOnExpansion;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }

    public BasicNodeError getError() {
        return this.error;
    }

    public void setError(BasicNodeError error) {
        this.error = error;
    }

    public int getNumSubOrdinates() {
        return this.numSubOrdinates;
    }

    public void setNumSubOrdinates(int number) {
        this.numSubOrdinates = number;
    }

    public boolean hasSubOrdinates() {
        return this.hasSubOrdinates;
    }

    public void setHasSubOrdinates(boolean hasSubOrdinates) {
        this.hasSubOrdinates = hasSubOrdinates;
    }

    public String[] getReferral() {
        return this.referral;
    }

    public void setReferral(String[] referral) {
        this.referral = referral;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int style) {
        this.fontStyle = style;
    }

    public String[] getObjectClassValues() {
        return this.objectClassValues;
    }

    public void setObjectClassValues(String[] objectClassValues) {
        this.objectClassValues = objectClassValues;
    }

    public static String extractRDN(String dn, boolean showAttributeName) {
        String result;
        if (dn == null) {
            result = null;
        } else {
            try {
                DN dnObj = DN.decode(dn);
                if (dnObj.getNumComponents() >= 1) {
                    RDN rdn = dnObj.getRDN();
                    result = showAttributeName ? rdn.toString() : rdn.getAttributeValue(0).getValue().toString();
                } else {
                    result = "";
                }
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("The provided argument is not a valid dn: " + t, t);
            }
        }
        return result;
    }

    public static String extractRDN(String dn) {
        return BasicNode.extractRDN(dn, false);
    }

    public boolean isSizeLimitReached() {
        return this.sizeLimitReached;
    }

    public void setSizeLimitReached(boolean sizeLimitReached) {
        this.sizeLimitReached = sizeLimitReached;
    }
}

