/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.event.EntryReadErrorEvent;
import org.opends.guitools.controlpanel.event.EntryReadEvent;
import org.opends.guitools.controlpanel.event.EntryReadListener;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPEntryReader
extends BackgroundTask<CustomSearchResult> {
    private String dn;
    private InitialLdapContext ctx;
    private Set<EntryReadListener> listeners = new HashSet<EntryReadListener>();
    private boolean isOver;
    private boolean notifyListeners;

    public LDAPEntryReader(String dn, InitialLdapContext ctx) {
        this.dn = dn;
        this.ctx = ctx;
        this.notifyListeners = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomSearchResult processBackgroundTask() throws Throwable {
        this.isOver = false;
        NamingEnumeration<SearchResult> en = null;
        try {
            SearchControls controls = new SearchControls();
            controls.setCountLimit(1L);
            String[] attrs = new String[]{"*", "+"};
            controls.setReturningAttributes(attrs);
            controls.setSearchScope(0);
            String filter = "(|(objectclass=*)(objectclass=ldapsubentry))";
            en = this.ctx.search(Utilities.getJNDIName(this.dn), "(|(objectclass=*)(objectclass=ldapsubentry))", controls);
            SearchResult sr = en.next();
            CustomSearchResult customSearchResult = new CustomSearchResult(sr, this.dn);
            return customSearchResult;
        }
        finally {
            if (this.isInterrupted()) {
                this.isOver = true;
            }
            if (en != null) {
                en.close();
            }
        }
    }

    @Override
    public void backgroundTaskCompleted(CustomSearchResult sr, Throwable throwable) {
        if (!this.isInterrupted() && this.isNotifyListeners()) {
            if (throwable == null) {
                this.notifyListeners(sr);
            } else {
                this.notifyListeners(throwable);
            }
        }
        this.isOver = true;
    }

    public boolean isNotifyListeners() {
        return this.notifyListeners;
    }

    public void setNotifyListeners(boolean notifyListeners) {
        this.notifyListeners = notifyListeners;
    }

    public boolean isOver() {
        return this.isOver;
    }

    private void notifyListeners(CustomSearchResult sr) {
        EntryReadEvent ev = new EntryReadEvent(this, sr);
        for (EntryReadListener listener : this.listeners) {
            listener.entryRead(ev);
        }
    }

    private void notifyListeners(Throwable t) {
        EntryReadErrorEvent ev = new EntryReadErrorEvent(this, this.dn, t);
        for (EntryReadListener listener : this.listeners) {
            listener.entryReadError(ev);
        }
    }

    public void addEntryReadListener(EntryReadListener listener) {
        this.listeners.add(listener);
    }

    public void removeEntryReadListener(EntryReadListener listener) {
        this.listeners.remove(listener);
    }
}

