/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteReplicationPortsPanel
extends QuickSetupStepPanel
implements Comparator<ServerDescriptor> {
    private static final long serialVersionUID = -3742350600617826375L;
    private Component lastFocusComponent;
    private HashMap<String, JLabel> hmLabels = new HashMap();
    private HashMap<String, JTextComponent> hmFields = new HashMap();
    private HashMap<String, JCheckBox> hmCbs = new HashMap();
    private JScrollPane scroll;
    private JPanel fieldsPanel;
    private TreeSet<ServerDescriptor> orderedServers = new TreeSet<ServerDescriptor>(this);
    private String serverToConnectDisplay = null;

    public RemoteReplicationPortsPanel(GuiApplication application) {
        super(application);
    }

    @Override
    public Object getFieldValue(FieldName fieldName) {
        HashMap<String, String> value = null;
        if (fieldName == FieldName.REMOTE_REPLICATION_PORT) {
            HashMap<String, String> hm = new HashMap<String, String>();
            for (String id : this.hmFields.keySet()) {
                hm.put(id, this.hmFields.get(id).getText());
            }
            value = hm;
        } else if (fieldName == FieldName.REMOTE_REPLICATION_SECURE) {
            HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
            for (String id : this.hmCbs.keySet()) {
                hm.put(id, this.hmCbs.get(id).isSelected());
            }
            value = hm;
        }
        return value;
    }

    @Override
    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        if (fieldName == FieldName.REMOTE_REPLICATION_PORT) {
            for (String id : this.hmLabels.keySet()) {
                UIFactory.setTextStyle(this.hmLabels.get(id), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
            }
            if (invalid) {
                for (String id : this.hmLabels.keySet()) {
                    String sPort = this.hmFields.get(id).getText();
                    boolean isValid = false;
                    try {
                        int replicationPort = Integer.parseInt(sPort);
                        if (replicationPort >= 1 && replicationPort <= 65535) {
                            isValid = true;
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (isValid) continue;
                    UIFactory.setTextStyle(this.hmLabels.get(id), UIFactory.TextStyle.SECONDARY_FIELD_INVALID);
                }
            }
        }
    }

    @Override
    protected boolean requiresScroll() {
        return false;
    }

    @Override
    public int compare(ServerDescriptor desc1, ServerDescriptor desc2) {
        return desc1.getHostPort(true).compareTo(desc2.getHostPort(true));
    }

    @Override
    protected Component createInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.fieldsPanel = new JPanel(new GridBagLayout());
        this.fieldsPanel.setOpaque(false);
        this.scroll = UIFactory.createBorderLessScrollBar(this.fieldsPanel);
        panel.add((Component)this.scroll, gbc);
        return panel;
    }

    @Override
    protected Message getInstructions() {
        return QuickSetupMessages.INFO_REMOTE_REPLICATION_PORT_INSTRUCTIONS.get();
    }

    @Override
    protected Message getTitle() {
        return QuickSetupMessages.INFO_REMOTE_REPLICATION_PORT_TITLE.get();
    }

    @Override
    public void beginDisplay(UserData data) {
        TreeSet<ServerDescriptor> array = this.orderServers(data.getRemoteWithNoReplicationPort().keySet());
        AuthenticationData authData = data.getReplicationOptions().getAuthenticationData();
        String newServerDisplay = authData != null ? authData.getHostName() + ":" + authData.getPort() : "";
        if (!array.equals(this.orderedServers) || !newServerDisplay.equals(this.serverToConnectDisplay)) {
            this.serverToConnectDisplay = newServerDisplay;
            FocusListener l = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    RemoteReplicationPortsPanel.this.lastFocusComponent = e.getComponent();
                }

                public void focusLost(FocusEvent e) {
                }
            };
            this.lastFocusComponent = null;
            HashMap<String, String> hmOldValues = new HashMap<String, String>();
            for (String id : this.hmFields.keySet()) {
                hmOldValues.put(id, this.hmFields.get(id).getText());
            }
            HashMap<String, Boolean> hmOldSecureValues = new HashMap<String, Boolean>();
            for (String id : this.hmCbs.keySet()) {
                hmOldSecureValues.put(id, this.hmCbs.get(id).isSelected());
            }
            this.orderedServers.clear();
            this.orderedServers.addAll(array);
            this.hmFields.clear();
            this.hmCbs.clear();
            this.hmLabels.clear();
            for (ServerDescriptor server : this.orderedServers) {
                String serverDisplay = server.getHostPort(false).equalsIgnoreCase(this.serverToConnectDisplay) ? this.serverToConnectDisplay : server.getHostPort(true);
                LabelFieldDescriptor desc = new LabelFieldDescriptor(Message.raw(serverDisplay, new Object[0]), QuickSetupMessages.INFO_REPLICATION_PORT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 5);
                AuthenticationData auth = data.getRemoteWithNoReplicationPort().get(server);
                JTextComponent field = UIFactory.makeJTextComponent(desc, String.valueOf(auth.getPort()));
                String oldValue = (String)hmOldValues.get(server.getId());
                if (oldValue != null) {
                    field.setText(oldValue);
                }
                JLabel label = UIFactory.makeJLabel(desc);
                this.hmFields.put(server.getId(), field);
                label.setLabelFor(field);
                field.addFocusListener(l);
                if (this.lastFocusComponent == null) {
                    this.lastFocusComponent = field;
                }
                this.hmLabels.put(server.getId(), label);
                JCheckBox cb = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_SECURE_REPLICATION_LABEL.get(), QuickSetupMessages.INFO_SECURE_REPLICATION_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
                cb.setSelected(auth.useSecureConnection());
                Boolean oldSecureValue = (Boolean)hmOldSecureValues.get(server.getId());
                if (oldSecureValue != null) {
                    cb.setSelected(oldSecureValue);
                }
                this.hmCbs.put(server.getId(), cb);
            }
            this.populateFieldsPanel();
        }
    }

    @Override
    public void endDisplay() {
        if (this.lastFocusComponent != null) {
            this.lastFocusComponent.requestFocusInWindow();
        }
    }

    private void populateFieldsPanel() {
        this.fieldsPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        boolean first = true;
        for (ServerDescriptor server : this.orderedServers) {
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            if (!first) {
                gbc.insets.top = 5;
            }
            gbc.gridwidth = 4;
            this.fieldsPanel.add((Component)this.hmLabels.get(server.getId()), gbc);
            gbc.insets.left = 10;
            --gbc.gridwidth;
            this.fieldsPanel.add((Component)this.hmFields.get(server.getId()), gbc);
            gbc.insets.left = 5;
            gbc.gridwidth = -1;
            this.fieldsPanel.add((Component)this.hmCbs.get(server.getId()), gbc);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            this.fieldsPanel.add(Box.createHorizontalGlue(), gbc);
            first = false;
        }
        this.addVerticalGlue(this.fieldsPanel);
    }

    private TreeSet<ServerDescriptor> orderServers(Set<ServerDescriptor> servers) {
        TreeSet<ServerDescriptor> ordered = new TreeSet<ServerDescriptor>(this);
        ordered.addAll(servers);
        return ordered;
    }
}

